/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.color;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.openrndr.color.ColorLCHUVa;
import org.openrndr.color.ColorRGBa;
import org.openrndr.color.ColorXYZa;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 -2\u00020\u0001:\u0001-B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\bH\u00c6\u0003J;\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001J\u000e\u0010\u001f\u001a\u00020\u00002\u0006\u0010 \u001a\u00020\u0003J\u000e\u0010!\u001a\u00020\u00002\u0006\u0010 \u001a\u00020\u0003J\u000e\u0010\"\u001a\u00020\u00002\u0006\u0010 \u001a\u00020\u0003J\u000e\u0010#\u001a\u00020\u00002\u0006\u0010$\u001a\u00020\u0003J\u000e\u0010%\u001a\u00020\u00002\u0006\u0010$\u001a\u00020\u0003J\u000e\u0010&\u001a\u00020\u00002\u0006\u0010$\u001a\u00020\u0003J\u0006\u0010'\u001a\u00020(J\u0006\u0010)\u001a\u00020*J\t\u0010+\u001a\u00020,H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000bR\u0011\u0010\u0011\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006."}, d2={"Lorg/openrndr/color/ColorLSHUVa;", "", "l", "", "s", "h", "alpha", "ref", "Lorg/openrndr/color/ColorXYZa;", "(DDDDLorg/openrndr/color/ColorXYZa;)V", "getAlpha", "()D", "getH", "getL", "getRef", "()Lorg/openrndr/color/ColorXYZa;", "getS", "saturated", "getSaturated", "()Lorg/openrndr/color/ColorLSHUVa;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "", "scaleHue", "scale", "scaleLuminosity", "scaleSaturation", "shiftHue", "shift", "shiftLuminosity", "shiftSaturation", "toLCHUVa", "Lorg/openrndr/color/ColorLCHUVa;", "toRGBa", "Lorg/openrndr/color/ColorRGBa;", "toString", "", "Companion", "openrndr-color"})
public final class ColorLSHUVa {
    private final double l;
    private final double s;
    private final double h;
    private final double alpha;
    @NotNull
    private final ColorXYZa ref;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final ColorLCHUVa toLCHUVa() {
        double maxC = ColorLCHUVa.Companion.findMaxChroma(this.l, this.h, this.ref);
        return new ColorLCHUVa(this.l, this.s * maxC, this.h, this.alpha, this.ref);
    }

    @NotNull
    public final ColorRGBa toRGBa() {
        return this.toLCHUVa().toRGBa();
    }

    @NotNull
    public final ColorLSHUVa scaleHue(double scale) {
        return ColorLSHUVa.copy$default(this, 0.0, 0.0, this.h * scale, 0.0, null, 27, null);
    }

    @NotNull
    public final ColorLSHUVa shiftHue(double shift) {
        return ColorLSHUVa.copy$default(this, 0.0, 0.0, this.h + shift, 0.0, null, 27, null);
    }

    @NotNull
    public final ColorLSHUVa scaleSaturation(double scale) {
        return ColorLSHUVa.copy$default(this, 0.0, this.s * scale, 0.0, 0.0, null, 29, null);
    }

    @NotNull
    public final ColorLSHUVa shiftSaturation(double shift) {
        return ColorLSHUVa.copy$default(this, 0.0, this.s + shift, 0.0, 0.0, null, 29, null);
    }

    @NotNull
    public final ColorLSHUVa scaleLuminosity(double scale) {
        return ColorLSHUVa.copy$default(this, this.l * scale, 0.0, 0.0, 0.0, null, 30, null);
    }

    @NotNull
    public final ColorLSHUVa shiftLuminosity(double shift) {
        return ColorLSHUVa.copy$default(this, this.l + shift, 0.0, 0.0, 0.0, null, 30, null);
    }

    @NotNull
    public final ColorLSHUVa getSaturated() {
        return ColorLSHUVa.copy$default(this, 0.0, RangesKt.coerceIn(this.s, 0.0, 1.0), 0.0, 0.0, null, 29, null);
    }

    public final double getL() {
        return this.l;
    }

    public final double getS() {
        return this.s;
    }

    public final double getH() {
        return this.h;
    }

    public final double getAlpha() {
        return this.alpha;
    }

    @NotNull
    public final ColorXYZa getRef() {
        return this.ref;
    }

    public ColorLSHUVa(double l, double s, double h, double alpha, @NotNull ColorXYZa ref) {
        Intrinsics.checkParameterIsNotNull(ref, "ref");
        this.l = l;
        this.s = s;
        this.h = h;
        this.alpha = alpha;
        this.ref = ref;
    }

    public /* synthetic */ ColorLSHUVa(double d, double d2, double d3, double d4, ColorXYZa colorXYZa, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 8) != 0) {
            d4 = 1.0;
        }
        if ((n2 & 0x10) != 0) {
            colorXYZa = ColorXYZa.Companion.getNEUTRAL();
        }
        this(d, d2, d3, d4, colorXYZa);
    }

    public final double component1() {
        return this.l;
    }

    public final double component2() {
        return this.s;
    }

    public final double component3() {
        return this.h;
    }

    public final double component4() {
        return this.alpha;
    }

    @NotNull
    public final ColorXYZa component5() {
        return this.ref;
    }

    @NotNull
    public final ColorLSHUVa copy(double l, double s, double h, double alpha, @NotNull ColorXYZa ref) {
        Intrinsics.checkParameterIsNotNull(ref, "ref");
        return new ColorLSHUVa(l, s, h, alpha, ref);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ ColorLSHUVa copy$default(ColorLSHUVa colorLSHUVa, double d, double d2, double d3, double d4, ColorXYZa colorXYZa, int n2, Object object) {
        if ((n2 & 1) != 0) {
            d = colorLSHUVa.l;
        }
        if ((n2 & 2) != 0) {
            d2 = colorLSHUVa.s;
        }
        if ((n2 & 4) != 0) {
            d3 = colorLSHUVa.h;
        }
        if ((n2 & 8) != 0) {
            d4 = colorLSHUVa.alpha;
        }
        if ((n2 & 0x10) != 0) {
            colorXYZa = colorLSHUVa.ref;
        }
        return colorLSHUVa.copy(d, d2, d3, d4, colorXYZa);
    }

    public String toString() {
        return "ColorLSHUVa(l=" + this.l + ", s=" + this.s + ", h=" + this.h + ", alpha=" + this.alpha + ", ref=" + this.ref + ")";
    }

    public int hashCode() {
        ColorXYZa colorXYZa = this.ref;
        return (((Double.hashCode(this.l) * 31 + Double.hashCode(this.s)) * 31 + Double.hashCode(this.h)) * 31 + Double.hashCode(this.alpha)) * 31 + (colorXYZa != null ? ((Object)colorXYZa).hashCode() : 0);
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof ColorLSHUVa)) break block3;
                ColorLSHUVa colorLSHUVa = (ColorLSHUVa)object;
                if (Double.compare(this.l, colorLSHUVa.l) != 0 || Double.compare(this.s, colorLSHUVa.s) != 0 || Double.compare(this.h, colorLSHUVa.h) != 0 || Double.compare(this.alpha, colorLSHUVa.alpha) != 0 || !Intrinsics.areEqual(this.ref, colorLSHUVa.ref)) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/openrndr/color/ColorLSHUVa$Companion;", "", "()V", "fromLCHUVa", "Lorg/openrndr/color/ColorLSHUVa;", "lcha", "Lorg/openrndr/color/ColorLCHUVa;", "openrndr-color"})
    public static final class Companion {
        @NotNull
        public final ColorLSHUVa fromLCHUVa(@NotNull ColorLCHUVa lcha) {
            Intrinsics.checkParameterIsNotNull(lcha, "lcha");
            double maxC = ColorLCHUVa.Companion.findMaxChroma(lcha.getL(), lcha.getH(), lcha.getRef());
            return new ColorLSHUVa(lcha.getL(), lcha.getC() / maxC, lcha.getH(), lcha.getAlpha(), lcha.getRef());
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

