/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.color;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.openrndr.color.ColorHSLa$Companion$WhenMappings;
import org.openrndr.color.ColorHSLaKt;
import org.openrndr.color.ColorHSVa;
import org.openrndr.color.ColorLABa;
import org.openrndr.color.ColorLCHABa;
import org.openrndr.color.ColorLCHUVa;
import org.openrndr.color.ColorLUVa;
import org.openrndr.color.ColorRGBa;
import org.openrndr.color.ColorXSLa;
import org.openrndr.color.ColorXYZa;
import org.openrndr.color.Linearity;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0087\b\u0018\u0000 52\u00020\u0001:\u00015B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J1\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\u000e\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u0003J\u000e\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u0003J\u000e\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u0003J\u000e\u0010\u001f\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u0003J\u000e\u0010 \u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u0003J\u000e\u0010!\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u0003J\u0006\u0010\"\u001a\u00020#J\u0010\u0010$\u001a\u00020%2\b\b\u0002\u0010&\u001a\u00020'J\u0010\u0010(\u001a\u00020)2\b\b\u0002\u0010&\u001a\u00020'J\u0010\u0010*\u001a\u00020+2\b\b\u0002\u0010&\u001a\u00020'J\u0010\u0010,\u001a\u00020-2\b\b\u0002\u0010&\u001a\u00020'J\u0006\u0010.\u001a\u00020/J\b\u00100\u001a\u000201H\u0016J\u0006\u00102\u001a\u000203J\u0006\u00104\u001a\u00020'R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\tR\u0011\u0010\r\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u00066"}, d2={"Lorg/openrndr/color/ColorHSLa;", "", "h", "", "s", "l", "a", "(DDDD)V", "getA", "()D", "getH", "getL", "getS", "unit", "getUnit", "()Lorg/openrndr/color/ColorHSLa;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "scaleHue", "shift", "scaleSaturation", "scale", "scaleValue", "shiftHue", "shiftSaturation", "shiftValue", "toHSVa", "Lorg/openrndr/color/ColorHSVa;", "toLABa", "Lorg/openrndr/color/ColorLABa;", "ref", "Lorg/openrndr/color/ColorXYZa;", "toLCHABa", "Lorg/openrndr/color/ColorLCHABa;", "toLCHUVa", "Lorg/openrndr/color/ColorLCHUVa;", "toLUVa", "Lorg/openrndr/color/ColorLUVa;", "toRGBa", "Lorg/openrndr/color/ColorRGBa;", "toString", "", "toXSLa", "Lorg/openrndr/color/ColorXSLa;", "toXYZa", "Companion", "openrndr-color"})
public final class ColorHSLa {
    private final double h;
    private final double s;
    private final double l;
    private final double a;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String toString() {
        return "ColorHSL{h=" + this.h + ", s=" + this.s + ", l=" + this.l + '}';
    }

    @NotNull
    public final ColorHSLa scaleHue(double shift) {
        return ColorHSLa.copy$default(this, this.h + shift, 0.0, 0.0, 0.0, 14, null);
    }

    @NotNull
    public final ColorHSLa shiftHue(double shift) {
        return ColorHSLa.copy$default(this, this.h + shift, 0.0, 0.0, 0.0, 14, null);
    }

    @NotNull
    public final ColorHSLa scaleSaturation(double scale) {
        return ColorHSLa.copy$default(this, 0.0, this.s * scale, 0.0, 0.0, 13, null);
    }

    @NotNull
    public final ColorHSLa shiftSaturation(double shift) {
        return ColorHSLa.copy$default(this, 0.0, this.s + shift, 0.0, 0.0, 13, null);
    }

    @NotNull
    public final ColorHSLa shiftValue(double shift) {
        return ColorHSLa.copy$default(this, 0.0, 0.0, this.l + shift, 0.0, 11, null);
    }

    @NotNull
    public final ColorHSLa scaleValue(double scale) {
        return ColorHSLa.copy$default(this, 0.0, 0.0, this.l * scale, 0.0, 11, null);
    }

    @NotNull
    public final ColorHSLa getUnit() {
        return ColorHSLa.copy$default(this, (this.h % (double)360 + (double)360) % (double)360, 0.0, 0.0, 0.0, 14, null);
    }

    @NotNull
    public final ColorRGBa toRGBa() {
        ColorRGBa colorRGBa;
        if (this.s == 0.0) {
            colorRGBa = new ColorRGBa(this.l, this.l, this.l, this.a, null, 16, null);
        } else {
            double q = this.l < 0.5 ? this.l * (1.0 + this.s) : this.l + this.s - this.l * this.s;
            double p = (double)2 * this.l - q;
            double r = ColorHSLaKt.hue2rgb(p, q, this.h / 360.0 + 0.3333333333333333);
            double g = ColorHSLaKt.hue2rgb(p, q, this.h / 360.0);
            double b = ColorHSLaKt.hue2rgb(p, q, this.h / 360.0 - 0.3333333333333333);
            colorRGBa = new ColorRGBa(r, g, b, this.a, Linearity.SRGB);
        }
        return colorRGBa;
    }

    @NotNull
    public final ColorHSVa toHSVa() {
        return this.toRGBa().toHSVa();
    }

    @NotNull
    public final ColorXYZa toXYZa() {
        return this.toRGBa().toXYZa();
    }

    @NotNull
    public final ColorLABa toLABa(@NotNull ColorXYZa ref) {
        Intrinsics.checkParameterIsNotNull(ref, "ref");
        return this.toRGBa().toXYZa().toLABa(ref);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ ColorLABa toLABa$default(ColorHSLa colorHSLa, ColorXYZa colorXYZa, int n2, Object object) {
        if ((n2 & 1) != 0) {
            colorXYZa = ColorXYZa.Companion.getNEUTRAL();
        }
        return colorHSLa.toLABa(colorXYZa);
    }

    @NotNull
    public final ColorLUVa toLUVa(@NotNull ColorXYZa ref) {
        Intrinsics.checkParameterIsNotNull(ref, "ref");
        return this.toRGBa().toXYZa().toLUVa(ref);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ ColorLUVa toLUVa$default(ColorHSLa colorHSLa, ColorXYZa colorXYZa, int n2, Object object) {
        if ((n2 & 1) != 0) {
            colorXYZa = ColorXYZa.Companion.getNEUTRAL();
        }
        return colorHSLa.toLUVa(colorXYZa);
    }

    @NotNull
    public final ColorLCHABa toLCHABa(@NotNull ColorXYZa ref) {
        Intrinsics.checkParameterIsNotNull(ref, "ref");
        return this.toLABa(ref).toLCHABa();
    }

    @NotNull
    public static /* bridge */ /* synthetic */ ColorLCHABa toLCHABa$default(ColorHSLa colorHSLa, ColorXYZa colorXYZa, int n2, Object object) {
        if ((n2 & 1) != 0) {
            colorXYZa = ColorXYZa.Companion.getNEUTRAL();
        }
        return colorHSLa.toLCHABa(colorXYZa);
    }

    @NotNull
    public final ColorLCHUVa toLCHUVa(@NotNull ColorXYZa ref) {
        Intrinsics.checkParameterIsNotNull(ref, "ref");
        return this.toLUVa(ref).toLCHUVa();
    }

    @NotNull
    public static /* bridge */ /* synthetic */ ColorLCHUVa toLCHUVa$default(ColorHSLa colorHSLa, ColorXYZa colorXYZa, int n2, Object object) {
        if ((n2 & 1) != 0) {
            colorXYZa = ColorXYZa.Companion.getNEUTRAL();
        }
        return colorHSLa.toLCHUVa(colorXYZa);
    }

    @NotNull
    public final ColorXSLa toXSLa() {
        return ColorXSLa.Companion.fromHSLa(this);
    }

    public final double getH() {
        return this.h;
    }

    public final double getS() {
        return this.s;
    }

    public final double getL() {
        return this.l;
    }

    public final double getA() {
        return this.a;
    }

    public ColorHSLa(double h, double s, double l, double a) {
        this.h = h;
        this.s = s;
        this.l = l;
        this.a = a;
    }

    public /* synthetic */ ColorHSLa(double d, double d2, double d3, double d4, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 8) != 0) {
            d4 = 1.0;
        }
        this(d, d2, d3, d4);
    }

    public final double component1() {
        return this.h;
    }

    public final double component2() {
        return this.s;
    }

    public final double component3() {
        return this.l;
    }

    public final double component4() {
        return this.a;
    }

    @NotNull
    public final ColorHSLa copy(double h, double s, double l, double a) {
        return new ColorHSLa(h, s, l, a);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ ColorHSLa copy$default(ColorHSLa colorHSLa, double d, double d2, double d3, double d4, int n2, Object object) {
        if ((n2 & 1) != 0) {
            d = colorHSLa.h;
        }
        if ((n2 & 2) != 0) {
            d2 = colorHSLa.s;
        }
        if ((n2 & 4) != 0) {
            d3 = colorHSLa.l;
        }
        if ((n2 & 8) != 0) {
            d4 = colorHSLa.a;
        }
        return colorHSLa.copy(d, d2, d3, d4);
    }

    public int hashCode() {
        return ((Double.hashCode(this.h) * 31 + Double.hashCode(this.s)) * 31 + Double.hashCode(this.l)) * 31 + Double.hashCode(this.a);
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof ColorHSLa)) break block3;
                ColorHSLa colorHSLa = (ColorHSLa)object;
                if (Double.compare(this.h, colorHSLa.h) != 0 || Double.compare(this.s, colorHSLa.s) != 0 || Double.compare(this.l, colorHSLa.l) != 0 || Double.compare(this.a, colorHSLa.a) != 0) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/openrndr/color/ColorHSLa$Companion;", "", "()V", "fromRGBa", "Lorg/openrndr/color/ColorHSLa;", "rgb", "Lorg/openrndr/color/ColorRGBa;", "openrndr-color"})
    public static final class Companion {
        @NotNull
        public final ColorHSLa fromRGBa(@NotNull ColorRGBa rgb) {
            double h;
            double s;
            double max;
            ColorRGBa.Component maxArg;
            double min;
            Intrinsics.checkParameterIsNotNull(rgb, "rgb");
            double d = rgb.getR() <= rgb.getB() && rgb.getR() <= rgb.getG() ? rgb.getR() : (rgb.getG() <= rgb.getB() && rgb.getG() <= rgb.getR() ? rgb.getG() : (min = rgb.getB() <= rgb.getR() && rgb.getB() <= rgb.getG() ? rgb.getB() : 0.0));
            if (rgb.getR() >= rgb.getB() && rgb.getR() >= rgb.getG()) {
                maxArg = ColorRGBa.Component.R;
                max = rgb.getR();
            } else if (rgb.getG() >= rgb.getB() && rgb.getG() >= rgb.getR()) {
                maxArg = ColorRGBa.Component.G;
                max = rgb.getG();
            } else {
                maxArg = ColorRGBa.Component.B;
                max = rgb.getB();
            }
            double l = (max + min) / 2.0;
            if (max == min) {
                h = s = 0.0;
            } else {
                double d2;
                double d3 = max - min;
                s = l > 0.5 ? d3 / (2.0 - max - min) : d3 / (max + min);
                switch (ColorHSLa$Companion$WhenMappings.$EnumSwitchMapping$0[maxArg.ordinal()]) {
                    case 1: {
                        d2 = 60.0 * ((rgb.getG() - rgb.getB()) / d3 + (double)(rgb.getG() < rgb.getB() ? 6 : 0));
                        break;
                    }
                    case 2: {
                        d2 = 60.0 * ((rgb.getB() - rgb.getR()) / d3 + 2.0);
                        break;
                    }
                    case 3: {
                        d2 = 60.0 * ((rgb.getR() - rgb.getG()) / d3 + 4.0);
                        break;
                    }
                    case 4: {
                        d2 = 0.0;
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                h = d2;
            }
            return new ColorHSLa(h, s, l, rgb.getA());
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

