/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class ARBSamplerObjects {
    public static final int GL_SAMPLER_BINDING = 35097;

    protected ARBSamplerObjects() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLCapabilities caps) {
        return Checks.checkFunctions(caps.glGenSamplers, caps.glDeleteSamplers, caps.glIsSampler, caps.glBindSampler, caps.glSamplerParameteri, caps.glSamplerParameterf, caps.glSamplerParameteriv, caps.glSamplerParameterfv, caps.glSamplerParameterIiv, caps.glSamplerParameterIuiv, caps.glGetSamplerParameteriv, caps.glGetSamplerParameterfv, caps.glGetSamplerParameterIiv, caps.glGetSamplerParameterIuiv);
    }

    public static native void nglGenSamplers(int var0, long var1);

    public static void glGenSamplers(@NativeType(value="GLuint *") IntBuffer samplers) {
        ARBSamplerObjects.nglGenSamplers(samplers.remaining(), MemoryUtil.memAddress(samplers));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="void")
    public static int glGenSamplers() {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer samplers = stack.callocInt(1);
            ARBSamplerObjects.nglGenSamplers(1, MemoryUtil.memAddress(samplers));
            int n2 = samplers.get(0);
            return n2;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglDeleteSamplers(int var0, long var1);

    public static void glDeleteSamplers(@NativeType(value="const GLuint *") IntBuffer samplers) {
        ARBSamplerObjects.nglDeleteSamplers(samplers.remaining(), MemoryUtil.memAddress(samplers));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glDeleteSamplers(@NativeType(value="const GLuint *") int sampler) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer samplers = stack.ints(sampler);
            ARBSamplerObjects.nglDeleteSamplers(1, MemoryUtil.memAddress(samplers));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="GLboolean")
    public static native boolean glIsSampler(@NativeType(value="GLuint") int var0);

    public static native void glBindSampler(@NativeType(value="GLuint") int var0, @NativeType(value="GLuint") int var1);

    public static native void glSamplerParameteri(@NativeType(value="GLuint") int var0, @NativeType(value="GLenum") int var1, @NativeType(value="GLint") int var2);

    public static native void glSamplerParameterf(@NativeType(value="GLuint") int var0, @NativeType(value="GLenum") int var1, @NativeType(value="GLfloat") float var2);

    public static native void nglSamplerParameteriv(int var0, int var1, long var2);

    public static void glSamplerParameteriv(@NativeType(value="GLuint") int sampler, @NativeType(value="GLenum") int pname, @NativeType(value="const GLint *") IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)params, 1);
        }
        ARBSamplerObjects.nglSamplerParameteriv(sampler, pname, MemoryUtil.memAddress(params));
    }

    public static native void nglSamplerParameterfv(int var0, int var1, long var2);

    public static void glSamplerParameterfv(@NativeType(value="GLuint") int sampler, @NativeType(value="GLenum") int pname, @NativeType(value="const GLfloat *") FloatBuffer params) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)params, 1);
        }
        ARBSamplerObjects.nglSamplerParameterfv(sampler, pname, MemoryUtil.memAddress(params));
    }

    public static native void nglSamplerParameterIiv(int var0, int var1, long var2);

    public static void glSamplerParameterIiv(@NativeType(value="GLuint") int sampler, @NativeType(value="GLenum") int pname, @NativeType(value="const GLint *") IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)params, 1);
        }
        ARBSamplerObjects.nglSamplerParameterIiv(sampler, pname, MemoryUtil.memAddress(params));
    }

    public static native void nglSamplerParameterIuiv(int var0, int var1, long var2);

    public static void glSamplerParameterIuiv(@NativeType(value="GLuint") int sampler, @NativeType(value="GLenum") int pname, @NativeType(value="const GLuint *") IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)params, 1);
        }
        ARBSamplerObjects.nglSamplerParameterIuiv(sampler, pname, MemoryUtil.memAddress(params));
    }

    public static native void nglGetSamplerParameteriv(int var0, int var1, long var2);

    public static void glGetSamplerParameteriv(@NativeType(value="GLuint") int sampler, @NativeType(value="GLenum") int pname, @NativeType(value="GLint *") IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)params, 1);
        }
        ARBSamplerObjects.nglGetSamplerParameteriv(sampler, pname, MemoryUtil.memAddress(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="void")
    public static int glGetSamplerParameteri(@NativeType(value="GLuint") int sampler, @NativeType(value="GLenum") int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer params = stack.callocInt(1);
            ARBSamplerObjects.nglGetSamplerParameteriv(sampler, pname, MemoryUtil.memAddress(params));
            int n2 = params.get(0);
            return n2;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGetSamplerParameterfv(int var0, int var1, long var2);

    public static void glGetSamplerParameterfv(@NativeType(value="GLuint") int sampler, @NativeType(value="GLenum") int pname, @NativeType(value="GLfloat *") FloatBuffer params) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)params, 1);
        }
        ARBSamplerObjects.nglGetSamplerParameterfv(sampler, pname, MemoryUtil.memAddress(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="void")
    public static float glGetSamplerParameterf(@NativeType(value="GLuint") int sampler, @NativeType(value="GLenum") int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            FloatBuffer params = stack.callocFloat(1);
            ARBSamplerObjects.nglGetSamplerParameterfv(sampler, pname, MemoryUtil.memAddress(params));
            float f = params.get(0);
            return f;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGetSamplerParameterIiv(int var0, int var1, long var2);

    public static void glGetSamplerParameterIiv(@NativeType(value="GLuint") int sampler, @NativeType(value="GLenum") int pname, @NativeType(value="GLint *") IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)params, 1);
        }
        ARBSamplerObjects.nglGetSamplerParameterIiv(sampler, pname, MemoryUtil.memAddress(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="void")
    public static int glGetSamplerParameterIi(@NativeType(value="GLuint") int sampler, @NativeType(value="GLenum") int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer params = stack.callocInt(1);
            ARBSamplerObjects.nglGetSamplerParameterIiv(sampler, pname, MemoryUtil.memAddress(params));
            int n2 = params.get(0);
            return n2;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGetSamplerParameterIuiv(int var0, int var1, long var2);

    public static void glGetSamplerParameterIuiv(@NativeType(value="GLuint") int sampler, @NativeType(value="GLenum") int pname, @NativeType(value="GLuint *") IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)params, 1);
        }
        ARBSamplerObjects.nglGetSamplerParameterIuiv(sampler, pname, MemoryUtil.memAddress(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="void")
    public static int glGetSamplerParameterIui(@NativeType(value="GLuint") int sampler, @NativeType(value="GLenum") int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer params = stack.callocInt(1);
            ARBSamplerObjects.nglGetSamplerParameterIuiv(sampler, pname, MemoryUtil.memAddress(params));
            int n2 = params.get(0);
            return n2;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void glGenSamplers(@NativeType(value="GLuint *") int[] samplers) {
        long __functionAddress = GL.getICD().glGenSamplers;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, samplers.length, samplers);
    }

    public static void glDeleteSamplers(@NativeType(value="const GLuint *") int[] samplers) {
        long __functionAddress = GL.getICD().glDeleteSamplers;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, samplers.length, samplers);
    }

    public static void glSamplerParameteriv(@NativeType(value="GLuint") int sampler, @NativeType(value="GLenum") int pname, @NativeType(value="const GLint *") int[] params) {
        long __functionAddress = GL.getICD().glSamplerParameteriv;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(params, 1);
        }
        JNI.callPV(__functionAddress, sampler, pname, params);
    }

    public static void glSamplerParameterfv(@NativeType(value="GLuint") int sampler, @NativeType(value="GLenum") int pname, @NativeType(value="const GLfloat *") float[] params) {
        long __functionAddress = GL.getICD().glSamplerParameterfv;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(params, 1);
        }
        JNI.callPV(__functionAddress, sampler, pname, params);
    }

    public static void glSamplerParameterIiv(@NativeType(value="GLuint") int sampler, @NativeType(value="GLenum") int pname, @NativeType(value="const GLint *") int[] params) {
        long __functionAddress = GL.getICD().glSamplerParameterIiv;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(params, 1);
        }
        JNI.callPV(__functionAddress, sampler, pname, params);
    }

    public static void glSamplerParameterIuiv(@NativeType(value="GLuint") int sampler, @NativeType(value="GLenum") int pname, @NativeType(value="const GLuint *") int[] params) {
        long __functionAddress = GL.getICD().glSamplerParameterIuiv;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(params, 1);
        }
        JNI.callPV(__functionAddress, sampler, pname, params);
    }

    public static void glGetSamplerParameteriv(@NativeType(value="GLuint") int sampler, @NativeType(value="GLenum") int pname, @NativeType(value="GLint *") int[] params) {
        long __functionAddress = GL.getICD().glGetSamplerParameteriv;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(params, 1);
        }
        JNI.callPV(__functionAddress, sampler, pname, params);
    }

    public static void glGetSamplerParameterfv(@NativeType(value="GLuint") int sampler, @NativeType(value="GLenum") int pname, @NativeType(value="GLfloat *") float[] params) {
        long __functionAddress = GL.getICD().glGetSamplerParameterfv;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(params, 1);
        }
        JNI.callPV(__functionAddress, sampler, pname, params);
    }

    public static void glGetSamplerParameterIiv(@NativeType(value="GLuint") int sampler, @NativeType(value="GLenum") int pname, @NativeType(value="GLint *") int[] params) {
        long __functionAddress = GL.getICD().glGetSamplerParameterIiv;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(params, 1);
        }
        JNI.callPV(__functionAddress, sampler, pname, params);
    }

    public static void glGetSamplerParameterIuiv(@NativeType(value="GLuint") int sampler, @NativeType(value="GLenum") int pname, @NativeType(value="GLuint *") int[] params) {
        long __functionAddress = GL.getICD().glGetSamplerParameterIuiv;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(params, 1);
        }
        JNI.callPV(__functionAddress, sampler, pname, params);
    }

    static {
        GL.initialize();
    }
}

