/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.glfw;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import javax.annotation.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.vulkan.VkAllocationCallbacks;
import org.lwjgl.vulkan.VkInstance;
import org.lwjgl.vulkan.VkPhysicalDevice;

public class GLFWVulkan {
    protected GLFWVulkan() {
        throw new UnsupportedOperationException();
    }

    @NativeType(value="int")
    public static boolean glfwVulkanSupported() {
        long __functionAddress = Functions.VulkanSupported;
        return JNI.invokeI(__functionAddress) != 0;
    }

    public static long nglfwGetRequiredInstanceExtensions(long count) {
        long __functionAddress = Functions.GetRequiredInstanceExtensions;
        return JNI.invokePP(__functionAddress, count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    @NativeType(value="const char **")
    public static PointerBuffer glfwGetRequiredInstanceExtensions() {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        IntBuffer count = stack.callocInt(1);
        try {
            long __result = GLFWVulkan.nglfwGetRequiredInstanceExtensions(MemoryUtil.memAddress(count));
            PointerBuffer pointerBuffer = MemoryUtil.memPointerBufferSafe(__result, count.get(0));
            return pointerBuffer;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nglfwGetInstanceProcAddress(long instance, long procname) {
        long __functionAddress = Functions.GetInstanceProcAddress;
        return JNI.invokePPP(__functionAddress, instance, procname);
    }

    @NativeType(value="GLFWvkproc *")
    public static long glfwGetInstanceProcAddress(@Nullable VkInstance instance, @NativeType(value="const char *") ByteBuffer procname) {
        if (Checks.CHECKS) {
            Checks.checkNT1(procname);
        }
        return GLFWVulkan.nglfwGetInstanceProcAddress(MemoryUtil.memAddressSafe((Pointer)instance), MemoryUtil.memAddress(procname));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="GLFWvkproc *")
    public static long glfwGetInstanceProcAddress(@Nullable VkInstance instance, @NativeType(value="const char *") CharSequence procname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer procnameEncoded = stack.ASCII(procname);
            long l = GLFWVulkan.nglfwGetInstanceProcAddress(MemoryUtil.memAddressSafe((Pointer)instance), MemoryUtil.memAddress(procnameEncoded));
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="int")
    public static boolean glfwGetPhysicalDevicePresentationSupport(VkInstance instance, VkPhysicalDevice device, @NativeType(value="uint32_t") int queuefamily) {
        long __functionAddress = Functions.GetPhysicalDevicePresentationSupport;
        return JNI.invokePPI(__functionAddress, instance.address(), device.address(), queuefamily) != 0;
    }

    public static int nglfwCreateWindowSurface(long instance, long window, long allocator, long surface) {
        long __functionAddress = Functions.CreateWindowSurface;
        if (Checks.CHECKS) {
            Checks.check(window);
            if (allocator != 0L) {
                VkAllocationCallbacks.validate((long)allocator);
            }
        }
        return JNI.invokePPPPI(__functionAddress, instance, window, allocator, surface);
    }

    @NativeType(value="VkResult")
    public static int glfwCreateWindowSurface(VkInstance instance, @NativeType(value="GLFWwindow *") long window, @Nullable @NativeType(value="const VkAllocationCallbacks *") VkAllocationCallbacks allocator, @NativeType(value="VkSurfaceKHR *") LongBuffer surface) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)surface, 1);
        }
        return GLFWVulkan.nglfwCreateWindowSurface(instance.address(), window, MemoryUtil.memAddressSafe((Pointer)allocator), MemoryUtil.memAddress(surface));
    }

    @NativeType(value="VkResult")
    public static int glfwCreateWindowSurface(VkInstance instance, @NativeType(value="GLFWwindow *") long window, @Nullable @NativeType(value="const VkAllocationCallbacks *") VkAllocationCallbacks allocator, @NativeType(value="VkSurfaceKHR *") long[] surface) {
        long __functionAddress = Functions.CreateWindowSurface;
        if (Checks.CHECKS) {
            Checks.check(window);
            Checks.check(surface, 1);
            if (allocator != null) {
                VkAllocationCallbacks.validate((long)allocator.address());
            }
        }
        return JNI.invokePPPPI(__functionAddress, instance.address(), window, MemoryUtil.memAddressSafe((Pointer)allocator), surface);
    }

    public static final class Functions {
        public static final long VulkanSupported = APIUtil.apiGetFunctionAddress(GLFW.getLibrary(), "glfwVulkanSupported");
        public static final long GetRequiredInstanceExtensions = APIUtil.apiGetFunctionAddress(GLFW.getLibrary(), "glfwGetRequiredInstanceExtensions");
        public static final long GetInstanceProcAddress = APIUtil.apiGetFunctionAddress(GLFW.getLibrary(), "glfwGetInstanceProcAddress");
        public static final long GetPhysicalDevicePresentationSupport = APIUtil.apiGetFunctionAddress(GLFW.getLibrary(), "glfwGetPhysicalDevicePresentationSupport");
        public static final long CreateWindowSurface = APIUtil.apiGetFunctionAddress(GLFW.getLibrary(), "glfwCreateWindowSurface");

        private Functions() {
        }
    }
}

