/*
 * Decompiled with CFR 0.152.
 */
package lzma.sdk.lzma;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import lzma.sdk.ICodeProgress;
import lzma.sdk.lz.BinTree;
import lzma.sdk.lzma.Base;
import lzma.sdk.rangecoder.BitTreeEncoder;

public class Encoder {
    public static final int EMatchFinderTypeBT2 = 0;
    public static final int EMatchFinderTypeBT4 = 1;
    static final int kIfinityPrice = 0xFFFFFFF;
    static byte[] g_FastPos = new byte[2048];
    int _state = Base.stateInit();
    byte _previousByte;
    int[] _repDistances = new int[4];
    static final int kDefaultDictionaryLogSize = 22;
    static final int kNumFastBytesDefault = 32;
    static final int kNumOpts = 4096;
    Optimal[] _optimum = new Optimal[4096];
    BinTree _matchFinder = null;
    lzma.sdk.rangecoder.Encoder _rangeEncoder = new lzma.sdk.rangecoder.Encoder();
    short[] _isMatch = new short[192];
    short[] _isRep = new short[12];
    short[] _isRepG0 = new short[12];
    short[] _isRepG1 = new short[12];
    short[] _isRepG2 = new short[12];
    short[] _isRep0Long = new short[192];
    BitTreeEncoder[] _posSlotEncoder = new BitTreeEncoder[4];
    short[] _posEncoders = new short[114];
    BitTreeEncoder _posAlignEncoder = new BitTreeEncoder(4);
    LenPriceTableEncoder _lenEncoder = new LenPriceTableEncoder();
    LenPriceTableEncoder _repMatchLenEncoder = new LenPriceTableEncoder();
    LiteralEncoder _literalEncoder = new LiteralEncoder();
    int[] _matchDistances = new int[548];
    int _numFastBytes = 32;
    int _longestMatchLength;
    int _numDistancePairs;
    int _additionalOffset;
    int _optimumEndIndex;
    int _optimumCurrentIndex;
    boolean _longestMatchWasFound;
    int[] _posSlotPrices = new int[256];
    int[] _distancesPrices = new int[512];
    int[] _alignPrices = new int[16];
    int _alignPriceCount;
    int _distTableSize = 44;
    int _posStateBits = 2;
    int _posStateMask = 3;
    int _numLiteralPosStateBits = 0;
    int _numLiteralContextBits = 3;
    int _dictionarySize = 0x400000;
    int _dictionarySizePrev = -1;
    int _numFastBytesPrev = -1;
    long nowPos64;
    boolean _finished;
    InputStream _inStream;
    int _matchFinderType = 1;
    boolean _writeEndMark = false;
    boolean _needReleaseMFStream = false;
    int[] reps = new int[4];
    int[] repLens = new int[4];
    int backRes;
    long[] processedInSize = new long[1];
    long[] processedOutSize = new long[1];
    boolean[] finished = new boolean[1];
    public static final int kPropSize = 5;
    byte[] properties = new byte[5];
    int[] tempPrices = new int[128];
    int _matchPriceCount;

    static int getPosSlot(int pos) {
        if (pos < 2048) {
            return g_FastPos[pos];
        }
        if (pos < 0x200000) {
            return g_FastPos[pos >> 10] + 20;
        }
        return g_FastPos[pos >> 20] + 40;
    }

    static int getPosSlot2(int pos) {
        if (pos < 131072) {
            return g_FastPos[pos >> 6] + 12;
        }
        if (pos < 0x8000000) {
            return g_FastPos[pos >> 16] + 32;
        }
        return g_FastPos[pos >> 26] + 52;
    }

    void baseInit() {
        this._state = Base.stateInit();
        this._previousByte = 0;
        for (int i = 0; i < 4; ++i) {
            this._repDistances[i] = 0;
        }
    }

    void create() {
        if (this._matchFinder == null) {
            BinTree bt;
            int numHashBytes = 4;
            if (this._matchFinderType == 0) {
                numHashBytes = 2;
            }
            this._matchFinder = bt = new BinTree(numHashBytes);
        }
        this._literalEncoder.create(this._numLiteralPosStateBits, this._numLiteralContextBits);
        if (this._dictionarySize == this._dictionarySizePrev && this._numFastBytesPrev == this._numFastBytes) {
            return;
        }
        this._matchFinder.create(this._dictionarySize, 4096, this._numFastBytes, 274);
        this._dictionarySizePrev = this._dictionarySize;
        this._numFastBytesPrev = this._numFastBytes;
    }

    public Encoder() {
        int i;
        for (i = 0; i < 4096; ++i) {
            this._optimum[i] = new Optimal();
        }
        for (i = 0; i < 4; ++i) {
            this._posSlotEncoder[i] = new BitTreeEncoder(6);
        }
    }

    void init() {
        this.baseInit();
        this._rangeEncoder.init();
        lzma.sdk.rangecoder.Encoder.initBitModels(this._isMatch);
        lzma.sdk.rangecoder.Encoder.initBitModels(this._isRep0Long);
        lzma.sdk.rangecoder.Encoder.initBitModels(this._isRep);
        lzma.sdk.rangecoder.Encoder.initBitModels(this._isRepG0);
        lzma.sdk.rangecoder.Encoder.initBitModels(this._isRepG1);
        lzma.sdk.rangecoder.Encoder.initBitModels(this._isRepG2);
        lzma.sdk.rangecoder.Encoder.initBitModels(this._posEncoders);
        this._literalEncoder.init();
        for (int i = 0; i < 4; ++i) {
            this._posSlotEncoder[i].init();
        }
        this._lenEncoder.init(1 << this._posStateBits);
        this._repMatchLenEncoder.init(1 << this._posStateBits);
        this._posAlignEncoder.init();
        this._longestMatchWasFound = false;
        this._optimumEndIndex = 0;
        this._optimumCurrentIndex = 0;
        this._additionalOffset = 0;
    }

    int readMatchDistances() throws IOException {
        int lenRes = 0;
        this._numDistancePairs = this._matchFinder.getMatches(this._matchDistances);
        if (this._numDistancePairs > 0 && (lenRes = this._matchDistances[this._numDistancePairs - 2]) == this._numFastBytes) {
            lenRes += this._matchFinder.getMatchLen(lenRes - 1, this._matchDistances[this._numDistancePairs - 1], 273 - lenRes);
        }
        ++this._additionalOffset;
        return lenRes;
    }

    void movePos(int num) throws IOException {
        if (num > 0) {
            this._matchFinder.skip(num);
            this._additionalOffset += num;
        }
    }

    int getRepLen1Price(int state, int posState) {
        return lzma.sdk.rangecoder.Encoder.getPrice0(this._isRepG0[state]) + lzma.sdk.rangecoder.Encoder.getPrice0(this._isRep0Long[(state << 4) + posState]);
    }

    int getPureRepPrice(int repIndex, int state, int posState) {
        int price;
        if (repIndex == 0) {
            price = lzma.sdk.rangecoder.Encoder.getPrice0(this._isRepG0[state]);
            price += lzma.sdk.rangecoder.Encoder.getPrice1(this._isRep0Long[(state << 4) + posState]);
        } else {
            price = lzma.sdk.rangecoder.Encoder.getPrice1(this._isRepG0[state]);
            if (repIndex == 1) {
                price += lzma.sdk.rangecoder.Encoder.getPrice0(this._isRepG1[state]);
            } else {
                price += lzma.sdk.rangecoder.Encoder.getPrice1(this._isRepG1[state]);
                price += lzma.sdk.rangecoder.Encoder.getPrice(this._isRepG2[state], repIndex - 2);
            }
        }
        return price;
    }

    int getRepPrice(int repIndex, int len, int state, int posState) {
        int price = this._repMatchLenEncoder.getPrice(len - 2, posState);
        return price + this.getPureRepPrice(repIndex, state, posState);
    }

    int getPosLenPrice(int pos, int len, int posState) {
        int lenToPosState = Base.getLenToPosState(len);
        int price = pos < 128 ? this._distancesPrices[lenToPosState * 128 + pos] : this._posSlotPrices[(lenToPosState << 6) + Encoder.getPosSlot2(pos)] + this._alignPrices[pos & 0xF];
        return price + this._lenEncoder.getPrice(len - 2, posState);
    }

    int backward(int cur) {
        int posPrev;
        this._optimumEndIndex = cur;
        int posMem = this._optimum[cur].PosPrev;
        int backMem = this._optimum[cur].BackPrev;
        do {
            if (this._optimum[cur].Prev1IsChar) {
                this._optimum[posMem].makeAsChar();
                this._optimum[posMem].PosPrev = posMem - 1;
                if (this._optimum[cur].Prev2) {
                    this._optimum[posMem - 1].Prev1IsChar = false;
                    this._optimum[posMem - 1].PosPrev = this._optimum[cur].PosPrev2;
                    this._optimum[posMem - 1].BackPrev = this._optimum[cur].BackPrev2;
                }
            }
            posPrev = posMem;
            int backCur = backMem;
            backMem = this._optimum[posPrev].BackPrev;
            posMem = this._optimum[posPrev].PosPrev;
            this._optimum[posPrev].BackPrev = backCur;
            this._optimum[posPrev].PosPrev = cur;
        } while ((cur = posPrev) > 0);
        this.backRes = this._optimum[0].BackPrev;
        this._optimumCurrentIndex = this._optimum[0].PosPrev;
        return this._optimumCurrentIndex;
    }

    /*
     * Unable to fully structure code
     */
    int getOptimum(int position) throws IOException {
        if (this._optimumEndIndex != this._optimumCurrentIndex) {
            lenRes = this._optimum[this._optimumCurrentIndex].PosPrev - this._optimumCurrentIndex;
            this.backRes = this._optimum[this._optimumCurrentIndex].BackPrev;
            this._optimumCurrentIndex = this._optimum[this._optimumCurrentIndex].PosPrev;
            return lenRes;
        }
        this._optimumEndIndex = 0;
        this._optimumCurrentIndex = 0;
        if (!this._longestMatchWasFound) {
            lenMain = this.readMatchDistances();
        } else {
            lenMain = this._longestMatchLength;
            this._longestMatchWasFound = false;
        }
        numDistancePairs = this._numDistancePairs;
        numAvailableBytes = this._matchFinder.getNumAvailableBytes() + 1;
        if (numAvailableBytes < 2) {
            this.backRes = -1;
            return 1;
        }
        if (numAvailableBytes > 273) {
            numAvailableBytes = 273;
        }
        repMaxIndex = 0;
        for (i = 0; i < 4; ++i) {
            this.reps[i] = this._repDistances[i];
            this.repLens[i] = this._matchFinder.getMatchLen(-1, this.reps[i], 273);
            if (this.repLens[i] <= this.repLens[repMaxIndex]) continue;
            repMaxIndex = i;
        }
        if (this.repLens[repMaxIndex] >= this._numFastBytes) {
            this.backRes = repMaxIndex;
            lenRes = this.repLens[repMaxIndex];
            this.movePos(lenRes - 1);
            return lenRes;
        }
        if (lenMain >= this._numFastBytes) {
            this.backRes = this._matchDistances[numDistancePairs - 1] + 4;
            this.movePos(lenMain - 1);
            return lenMain;
        }
        currentByte = this._matchFinder.getIndexByte(-1);
        matchByte = this._matchFinder.getIndexByte(0 - this._repDistances[0] - 1 - 1);
        if (lenMain < 2 && currentByte != matchByte && this.repLens[repMaxIndex] < 2) {
            this.backRes = -1;
            return 1;
        }
        this._optimum[0].State = this._state;
        posState = position & this._posStateMask;
        this._optimum[1].Price = lzma.sdk.rangecoder.Encoder.getPrice0(this._isMatch[(this._state << 4) + posState]) + this._literalEncoder.getSubCoder(position, this._previousByte).getPrice(Base.stateIsCharState(this._state) == false, matchByte, currentByte);
        this._optimum[1].makeAsChar();
        matchPrice = lzma.sdk.rangecoder.Encoder.getPrice1(this._isMatch[(this._state << 4) + posState]);
        repMatchPrice = matchPrice + lzma.sdk.rangecoder.Encoder.getPrice1(this._isRep[this._state]);
        if (matchByte == currentByte && (shortRepPrice = repMatchPrice + this.getRepLen1Price(this._state, posState)) < this._optimum[1].Price) {
            this._optimum[1].Price = shortRepPrice;
            this._optimum[1].makeAsShortRep();
        }
        v0 = lenEnd = lenMain >= this.repLens[repMaxIndex] ? lenMain : this.repLens[repMaxIndex];
        if (lenEnd < 2) {
            this.backRes = this._optimum[1].BackPrev;
            return 1;
        }
        this._optimum[1].PosPrev = 0;
        this._optimum[0].Backs0 = this.reps[0];
        this._optimum[0].Backs1 = this.reps[1];
        this._optimum[0].Backs2 = this.reps[2];
        this._optimum[0].Backs3 = this.reps[3];
        len = lenEnd;
        do {
            this._optimum[len--].Price = 0xFFFFFFF;
        } while (len >= 2);
        for (i = 0; i < 4; ++i) {
            repLen = this.repLens[i];
            if (repLen < 2) continue;
            price = repMatchPrice + this.getPureRepPrice(i, this._state, posState);
            do {
                curAndLenPrice = price + this._repMatchLenEncoder.getPrice(repLen - 2, posState);
                optimum = this._optimum[repLen];
                if (curAndLenPrice >= optimum.Price) continue;
                optimum.Price = curAndLenPrice;
                optimum.PosPrev = 0;
                optimum.BackPrev = i;
                optimum.Prev1IsChar = false;
            } while (--repLen >= 2);
        }
        normalMatchPrice = matchPrice + lzma.sdk.rangecoder.Encoder.getPrice0(this._isRep[this._state]);
        v1 = len = this.repLens[0] >= 2 ? this.repLens[0] + 1 : 2;
        if (len <= lenMain) {
            offs = 0;
            while (len > this._matchDistances[offs]) {
                offs += 2;
            }
            while (true) {
                distance = this._matchDistances[offs + 1];
                curAndLenPrice = normalMatchPrice + this.getPosLenPrice(distance, len, posState);
                optimum = this._optimum[len];
                if (curAndLenPrice < optimum.Price) {
                    optimum.Price = curAndLenPrice;
                    optimum.PosPrev = 0;
                    optimum.BackPrev = distance + 4;
                    optimum.Prev1IsChar = false;
                }
                if (len == this._matchDistances[offs] && (offs += 2) == numDistancePairs) break;
                ++len;
            }
        }
        cur = 0;
        block6: while (true) {
            if (++cur == lenEnd) {
                return this.backward(cur);
            }
            newLen = this.readMatchDistances();
            numDistancePairs = this._numDistancePairs;
            if (newLen >= this._numFastBytes) {
                this._longestMatchLength = newLen;
                this._longestMatchWasFound = true;
                return this.backward(cur);
            }
            ++position;
            posPrev = this._optimum[cur].PosPrev;
            if (this._optimum[cur].Prev1IsChar) {
                --posPrev;
                if (this._optimum[cur].Prev2) {
                    state = this._optimum[this._optimum[cur].PosPrev2].State;
                    state = this._optimum[cur].BackPrev2 < 4 ? Base.stateUpdateRep(state) : Base.stateUpdateMatch(state);
                } else {
                    state = this._optimum[posPrev].State;
                }
                state = Base.stateUpdateChar(state);
            } else {
                state = this._optimum[posPrev].State;
            }
            if (posPrev == cur - 1) {
                state = this._optimum[cur].isShortRep() ? Base.stateUpdateShortRep(state) : Base.stateUpdateChar(state);
            } else {
                if (this._optimum[cur].Prev1IsChar && this._optimum[cur].Prev2) {
                    posPrev = this._optimum[cur].PosPrev2;
                    pos = this._optimum[cur].BackPrev2;
                    state = Base.stateUpdateRep(state);
                } else {
                    pos = this._optimum[cur].BackPrev;
                    state = pos < 4 ? Base.stateUpdateRep(state) : Base.stateUpdateMatch(state);
                }
                opt = this._optimum[posPrev];
                if (pos < 4) {
                    if (pos == 0) {
                        this.reps[0] = opt.Backs0;
                        this.reps[1] = opt.Backs1;
                        this.reps[2] = opt.Backs2;
                        this.reps[3] = opt.Backs3;
                    } else if (pos == 1) {
                        this.reps[0] = opt.Backs1;
                        this.reps[1] = opt.Backs0;
                        this.reps[2] = opt.Backs2;
                        this.reps[3] = opt.Backs3;
                    } else if (pos == 2) {
                        this.reps[0] = opt.Backs2;
                        this.reps[1] = opt.Backs0;
                        this.reps[2] = opt.Backs1;
                        this.reps[3] = opt.Backs3;
                    } else {
                        this.reps[0] = opt.Backs3;
                        this.reps[1] = opt.Backs0;
                        this.reps[2] = opt.Backs1;
                        this.reps[3] = opt.Backs2;
                    }
                } else {
                    this.reps[0] = pos - 4;
                    this.reps[1] = opt.Backs0;
                    this.reps[2] = opt.Backs1;
                    this.reps[3] = opt.Backs2;
                }
            }
            this._optimum[cur].State = state;
            this._optimum[cur].Backs0 = this.reps[0];
            this._optimum[cur].Backs1 = this.reps[1];
            this._optimum[cur].Backs2 = this.reps[2];
            this._optimum[cur].Backs3 = this.reps[3];
            curPrice = this._optimum[cur].Price;
            currentByte = this._matchFinder.getIndexByte(-1);
            matchByte = this._matchFinder.getIndexByte(0 - this.reps[0] - 1 - 1);
            posState = position & this._posStateMask;
            curAnd1Price = curPrice + lzma.sdk.rangecoder.Encoder.getPrice0(this._isMatch[(state << 4) + posState]) + this._literalEncoder.getSubCoder(position, this._matchFinder.getIndexByte(-2)).getPrice(Base.stateIsCharState(state) == false, matchByte, currentByte);
            nextOptimum = this._optimum[cur + 1];
            nextIsChar = false;
            if (curAnd1Price < nextOptimum.Price) {
                nextOptimum.Price = curAnd1Price;
                nextOptimum.PosPrev = cur;
                nextOptimum.makeAsChar();
                nextIsChar = true;
            }
            matchPrice = curPrice + lzma.sdk.rangecoder.Encoder.getPrice1(this._isMatch[(state << 4) + posState]);
            repMatchPrice = matchPrice + lzma.sdk.rangecoder.Encoder.getPrice1(this._isRep[state]);
            if (matchByte == currentByte && (nextOptimum.PosPrev >= cur || nextOptimum.BackPrev != 0) && (shortRepPrice = repMatchPrice + this.getRepLen1Price(state, posState)) <= nextOptimum.Price) {
                nextOptimum.Price = shortRepPrice;
                nextOptimum.PosPrev = cur;
                nextOptimum.makeAsShortRep();
                nextIsChar = true;
            }
            numAvailableBytesFull = this._matchFinder.getNumAvailableBytes() + 1;
            numAvailableBytes = numAvailableBytesFull = Math.min(4095 - cur, numAvailableBytesFull);
            if (numAvailableBytes < 2) continue;
            if (numAvailableBytes > this._numFastBytes) {
                numAvailableBytes = this._numFastBytes;
            }
            if (!nextIsChar && matchByte != currentByte && (lenTest2 = this._matchFinder.getMatchLen(0, this.reps[0], t = Math.min(numAvailableBytesFull - 1, this._numFastBytes))) >= 2) {
                state2 = Base.stateUpdateChar(state);
                posStateNext = position + 1 & this._posStateMask;
                nextRepMatchPrice = curAnd1Price + lzma.sdk.rangecoder.Encoder.getPrice1(this._isMatch[(state2 << 4) + posStateNext]) + lzma.sdk.rangecoder.Encoder.getPrice1(this._isRep[state2]);
                offset = cur + 1 + lenTest2;
                while (lenEnd < offset) {
                    this._optimum[++lenEnd].Price = 0xFFFFFFF;
                }
                curAndLenPrice = nextRepMatchPrice + this.getRepPrice(0, lenTest2, state2, posStateNext);
                optimum = this._optimum[offset];
                if (curAndLenPrice < optimum.Price) {
                    optimum.Price = curAndLenPrice;
                    optimum.PosPrev = cur + 1;
                    optimum.BackPrev = 0;
                    optimum.Prev1IsChar = true;
                    optimum.Prev2 = false;
                }
            }
            startLen = 2;
            for (repIndex = 0; repIndex < 4; ++repIndex) {
                lenTest = this._matchFinder.getMatchLen(-1, this.reps[repIndex], numAvailableBytes);
                if (lenTest < 2) continue;
                lenTestTemp = lenTest;
                while (true) {
                    if (lenEnd < cur + lenTest) {
                        this._optimum[++lenEnd].Price = 0xFFFFFFF;
                        continue;
                    }
                    curAndLenPrice = repMatchPrice + this.getRepPrice(repIndex, lenTest, state, posState);
                    optimum = this._optimum[cur + lenTest];
                    if (curAndLenPrice < optimum.Price) {
                        optimum.Price = curAndLenPrice;
                        optimum.PosPrev = cur;
                        optimum.BackPrev = repIndex;
                        optimum.Prev1IsChar = false;
                    }
                    if (--lenTest < 2) break;
                }
                lenTest = lenTestTemp;
                if (repIndex == 0) {
                    startLen = lenTest + 1;
                }
                if (lenTest >= numAvailableBytesFull || (lenTest2 = this._matchFinder.getMatchLen(lenTest, this.reps[repIndex], t = Math.min(numAvailableBytesFull - 1 - lenTest, this._numFastBytes))) < 2) continue;
                state2 = Base.stateUpdateRep(state);
                posStateNext = position + lenTest & this._posStateMask;
                curAndLenCharPrice = repMatchPrice + this.getRepPrice(repIndex, lenTest, state, posState) + lzma.sdk.rangecoder.Encoder.getPrice0(this._isMatch[(state2 << 4) + posStateNext]) + this._literalEncoder.getSubCoder(position + lenTest, this._matchFinder.getIndexByte(lenTest - 1 - 1)).getPrice(true, this._matchFinder.getIndexByte(lenTest - 1 - (this.reps[repIndex] + 1)), this._matchFinder.getIndexByte(lenTest - 1));
                state2 = Base.stateUpdateChar(state2);
                posStateNext = position + lenTest + 1 & this._posStateMask;
                nextMatchPrice = curAndLenCharPrice + lzma.sdk.rangecoder.Encoder.getPrice1(this._isMatch[(state2 << 4) + posStateNext]);
                nextRepMatchPrice = nextMatchPrice + lzma.sdk.rangecoder.Encoder.getPrice1(this._isRep[state2]);
                offset = lenTest + 1 + lenTest2;
                while (lenEnd < cur + offset) {
                    this._optimum[++lenEnd].Price = 0xFFFFFFF;
                }
                curAndLenPrice = nextRepMatchPrice + this.getRepPrice(0, lenTest2, state2, posStateNext);
                optimum = this._optimum[cur + offset];
                if (curAndLenPrice >= optimum.Price) continue;
                optimum.Price = curAndLenPrice;
                optimum.PosPrev = cur + lenTest + 1;
                optimum.BackPrev = 0;
                optimum.Prev1IsChar = true;
                optimum.Prev2 = true;
                optimum.PosPrev2 = cur;
                optimum.BackPrev2 = repIndex;
            }
            if (newLen > numAvailableBytes) {
                newLen = numAvailableBytes;
                numDistancePairs = 0;
                while (newLen > this._matchDistances[numDistancePairs]) {
                    numDistancePairs += 2;
                }
                this._matchDistances[numDistancePairs] = newLen;
                numDistancePairs += 2;
            }
            if (newLen < startLen) continue;
            normalMatchPrice = matchPrice + lzma.sdk.rangecoder.Encoder.getPrice0(this._isRep[state]);
            while (lenEnd < cur + newLen) {
                this._optimum[++lenEnd].Price = 0xFFFFFFF;
            }
            offs = 0;
            while (startLen > this._matchDistances[offs]) {
                offs += 2;
            }
            lenTest = startLen;
            while (true) {
                curBack = this._matchDistances[offs + 1];
                curAndLenPrice = normalMatchPrice + this.getPosLenPrice(curBack, lenTest, posState);
                optimum = this._optimum[cur + lenTest];
                if (curAndLenPrice < optimum.Price) {
                    optimum.Price = curAndLenPrice;
                    optimum.PosPrev = cur;
                    optimum.BackPrev = curBack + 4;
                    optimum.Prev1IsChar = false;
                }
                if (lenTest == this._matchDistances[offs]) {
                    if (lenTest < numAvailableBytesFull && (lenTest2 = this._matchFinder.getMatchLen(lenTest, curBack, t = Math.min(numAvailableBytesFull - 1 - lenTest, this._numFastBytes))) >= 2) {
                        state2 = Base.stateUpdateMatch(state);
                        posStateNext = position + lenTest & this._posStateMask;
                        curAndLenCharPrice = curAndLenPrice + lzma.sdk.rangecoder.Encoder.getPrice0(this._isMatch[(state2 << 4) + posStateNext]) + this._literalEncoder.getSubCoder(position + lenTest, this._matchFinder.getIndexByte(lenTest - 1 - 1)).getPrice(true, this._matchFinder.getIndexByte(lenTest - (curBack + 1) - 1), this._matchFinder.getIndexByte(lenTest - 1));
                        state2 = Base.stateUpdateChar(state2);
                        posStateNext = position + lenTest + 1 & this._posStateMask;
                        nextMatchPrice = curAndLenCharPrice + lzma.sdk.rangecoder.Encoder.getPrice1(this._isMatch[(state2 << 4) + posStateNext]);
                        nextRepMatchPrice = nextMatchPrice + lzma.sdk.rangecoder.Encoder.getPrice1(this._isRep[state2]);
                        offset = lenTest + 1 + lenTest2;
                        while (lenEnd < cur + offset) {
                            this._optimum[++lenEnd].Price = 0xFFFFFFF;
                        }
                        curAndLenPrice = nextRepMatchPrice + this.getRepPrice(0, lenTest2, state2, posStateNext);
                        optimum = this._optimum[cur + offset];
                        if (curAndLenPrice < optimum.Price) {
                            optimum.Price = curAndLenPrice;
                            optimum.PosPrev = cur + lenTest + 1;
                            optimum.BackPrev = 0;
                            optimum.Prev1IsChar = true;
                            optimum.Prev2 = true;
                            optimum.PosPrev2 = cur;
                            optimum.BackPrev2 = curBack + 4;
                        }
                    }
                    if ((offs += 2) != numDistancePairs) ** break;
                    continue block6;
                }
                ++lenTest;
            }
            break;
        }
    }

    void writeEndMarker(int posState) throws IOException {
        if (!this._writeEndMark) {
            return;
        }
        this._rangeEncoder.encode(this._isMatch, (this._state << 4) + posState, 1);
        this._rangeEncoder.encode(this._isRep, this._state, 0);
        this._state = Base.stateUpdateMatch(this._state);
        int len = 2;
        this._lenEncoder.encode(this._rangeEncoder, len - 2, posState);
        int posSlot = 63;
        int lenToPosState = Base.getLenToPosState(len);
        this._posSlotEncoder[lenToPosState].encode(this._rangeEncoder, posSlot);
        int footerBits = 30;
        int posReduced = (1 << footerBits) - 1;
        this._rangeEncoder.encodeDirectBits(posReduced >> 4, footerBits - 4);
        this._posAlignEncoder.reverseEncode(this._rangeEncoder, posReduced & 0xF);
    }

    void flush(int nowPos) throws IOException {
        this.releaseMFStream();
        this.writeEndMarker(nowPos & this._posStateMask);
        this._rangeEncoder.flushData();
        this._rangeEncoder.flushStream();
    }

    public void codeOneBlock(long[] inSize, long[] outSize, boolean[] finished) throws IOException {
        inSize[0] = 0L;
        outSize[0] = 0L;
        finished[0] = true;
        if (this._inStream != null) {
            this._matchFinder.setStream(this._inStream);
            this._matchFinder.init();
            this._needReleaseMFStream = true;
            this._inStream = null;
        }
        if (this._finished) {
            return;
        }
        this._finished = true;
        long progressPosValuePrev = this.nowPos64;
        if (this.nowPos64 == 0L) {
            if (this._matchFinder.getNumAvailableBytes() == 0) {
                this.flush((int)this.nowPos64);
                return;
            }
            this.readMatchDistances();
            int posState = (int)this.nowPos64 & this._posStateMask;
            this._rangeEncoder.encode(this._isMatch, (this._state << 4) + posState, 0);
            this._state = Base.stateUpdateChar(this._state);
            byte curByte = this._matchFinder.getIndexByte(0 - this._additionalOffset);
            this._literalEncoder.getSubCoder((int)this.nowPos64, this._previousByte).encode(this._rangeEncoder, curByte);
            this._previousByte = curByte;
            --this._additionalOffset;
            ++this.nowPos64;
        }
        if (this._matchFinder.getNumAvailableBytes() == 0) {
            this.flush((int)this.nowPos64);
            return;
        }
        while (true) {
            int len = this.getOptimum((int)this.nowPos64);
            int pos = this.backRes;
            int posState = (int)this.nowPos64 & this._posStateMask;
            int complexState = (this._state << 4) + posState;
            if (len == 1 && pos == -1) {
                this._rangeEncoder.encode(this._isMatch, complexState, 0);
                byte curByte = this._matchFinder.getIndexByte(0 - this._additionalOffset);
                LiteralEncoder.Encoder2 subCoder = this._literalEncoder.getSubCoder((int)this.nowPos64, this._previousByte);
                if (!Base.stateIsCharState(this._state)) {
                    byte matchByte = this._matchFinder.getIndexByte(0 - this._repDistances[0] - 1 - this._additionalOffset);
                    subCoder.encodeMatched(this._rangeEncoder, matchByte, curByte);
                } else {
                    subCoder.encode(this._rangeEncoder, curByte);
                }
                this._previousByte = curByte;
                this._state = Base.stateUpdateChar(this._state);
            } else {
                this._rangeEncoder.encode(this._isMatch, complexState, 1);
                if (pos < 4) {
                    this._rangeEncoder.encode(this._isRep, this._state, 1);
                    if (pos == 0) {
                        this._rangeEncoder.encode(this._isRepG0, this._state, 0);
                        if (len == 1) {
                            this._rangeEncoder.encode(this._isRep0Long, complexState, 0);
                        } else {
                            this._rangeEncoder.encode(this._isRep0Long, complexState, 1);
                        }
                    } else {
                        this._rangeEncoder.encode(this._isRepG0, this._state, 1);
                        if (pos == 1) {
                            this._rangeEncoder.encode(this._isRepG1, this._state, 0);
                        } else {
                            this._rangeEncoder.encode(this._isRepG1, this._state, 1);
                            this._rangeEncoder.encode(this._isRepG2, this._state, pos - 2);
                        }
                    }
                    if (len == 1) {
                        this._state = Base.stateUpdateShortRep(this._state);
                    } else {
                        this._repMatchLenEncoder.encode(this._rangeEncoder, len - 2, posState);
                        this._state = Base.stateUpdateRep(this._state);
                    }
                    int distance = this._repDistances[pos];
                    if (pos != 0) {
                        for (int i = pos; i >= 1; --i) {
                            this._repDistances[i] = this._repDistances[i - 1];
                        }
                        this._repDistances[0] = distance;
                    }
                } else {
                    this._rangeEncoder.encode(this._isRep, this._state, 0);
                    this._state = Base.stateUpdateMatch(this._state);
                    this._lenEncoder.encode(this._rangeEncoder, len - 2, posState);
                    int posSlot = Encoder.getPosSlot(pos -= 4);
                    int lenToPosState = Base.getLenToPosState(len);
                    this._posSlotEncoder[lenToPosState].encode(this._rangeEncoder, posSlot);
                    if (posSlot >= 4) {
                        int footerBits = (posSlot >> 1) - 1;
                        int baseVal = (2 | posSlot & 1) << footerBits;
                        int posReduced = pos - baseVal;
                        if (posSlot < 14) {
                            BitTreeEncoder.reverseEncode(this._posEncoders, baseVal - posSlot - 1, this._rangeEncoder, footerBits, posReduced);
                        } else {
                            this._rangeEncoder.encodeDirectBits(posReduced >> 4, footerBits - 4);
                            this._posAlignEncoder.reverseEncode(this._rangeEncoder, posReduced & 0xF);
                            ++this._alignPriceCount;
                        }
                    }
                    int distance = pos;
                    for (int i = 3; i >= 1; --i) {
                        this._repDistances[i] = this._repDistances[i - 1];
                    }
                    this._repDistances[0] = distance;
                    ++this._matchPriceCount;
                }
                this._previousByte = this._matchFinder.getIndexByte(len - 1 - this._additionalOffset);
            }
            this._additionalOffset -= len;
            this.nowPos64 += (long)len;
            if (this._additionalOffset != 0) continue;
            if (this._matchPriceCount >= 128) {
                this.fillDistancesPrices();
            }
            if (this._alignPriceCount >= 16) {
                this.fillAlignPrices();
            }
            inSize[0] = this.nowPos64;
            outSize[0] = this._rangeEncoder.getProcessedSizeAdd();
            if (this._matchFinder.getNumAvailableBytes() == 0) {
                this.flush((int)this.nowPos64);
                return;
            }
            if (this.nowPos64 - progressPosValuePrev >= 4096L) break;
        }
        this._finished = false;
        finished[0] = false;
    }

    void releaseMFStream() {
        if (this._matchFinder != null && this._needReleaseMFStream) {
            this._matchFinder.releaseStream();
            this._needReleaseMFStream = false;
        }
    }

    void setOutStream(OutputStream outStream) {
        this._rangeEncoder.setStream(outStream);
    }

    void releaseOutStream() {
        this._rangeEncoder.releaseStream();
    }

    void releaseStreams() {
        this.releaseMFStream();
        this.releaseOutStream();
    }

    void setStreams(InputStream inStream, OutputStream outStream) {
        this._inStream = inStream;
        this._finished = false;
        this.create();
        this.setOutStream(outStream);
        this.init();
        this.fillDistancesPrices();
        this.fillAlignPrices();
        this._lenEncoder.setTableSize(this._numFastBytes + 1 - 2);
        this._lenEncoder.updateTables(1 << this._posStateBits);
        this._repMatchLenEncoder.setTableSize(this._numFastBytes + 1 - 2);
        this._repMatchLenEncoder.updateTables(1 << this._posStateBits);
        this.nowPos64 = 0L;
    }

    public void code(InputStream inStream, OutputStream outStream, long inSize, long outSize, ICodeProgress progress) throws IOException {
        this._needReleaseMFStream = false;
        try {
            this.setStreams(inStream, outStream);
            while (true) {
                this.codeOneBlock(this.processedInSize, this.processedOutSize, this.finished);
                if (this.finished[0]) {
                    return;
                }
                if (progress == null) continue;
                progress.setProgress(this.processedInSize[0], this.processedOutSize[0]);
            }
        }
        finally {
            this.releaseStreams();
        }
    }

    public void writeCoderProperties(OutputStream outStream) throws IOException {
        this.properties[0] = (byte)((this._posStateBits * 5 + this._numLiteralPosStateBits) * 9 + this._numLiteralContextBits);
        for (int i = 0; i < 4; ++i) {
            this.properties[1 + i] = (byte)(this._dictionarySize >> 8 * i);
        }
        outStream.write(this.properties, 0, 5);
    }

    void fillDistancesPrices() {
        int posSlot;
        for (int i = 4; i < 128; ++i) {
            posSlot = Encoder.getPosSlot(i);
            int footerBits = (posSlot >> 1) - 1;
            int baseVal = (2 | posSlot & 1) << footerBits;
            this.tempPrices[i] = BitTreeEncoder.reverseGetPrice(this._posEncoders, baseVal - posSlot - 1, footerBits, i - baseVal);
        }
        for (int lenToPosState = 0; lenToPosState < 4; ++lenToPosState) {
            int i;
            BitTreeEncoder encoder = this._posSlotEncoder[lenToPosState];
            int st = lenToPosState << 6;
            for (posSlot = 0; posSlot < this._distTableSize; ++posSlot) {
                this._posSlotPrices[st + posSlot] = encoder.getPrice(posSlot);
            }
            for (posSlot = 14; posSlot < this._distTableSize; ++posSlot) {
                int n2 = st + posSlot;
                this._posSlotPrices[n2] = this._posSlotPrices[n2] + ((posSlot >> 1) - 1 - 4 << 6);
            }
            int st2 = lenToPosState * 128;
            for (i = 0; i < 4; ++i) {
                this._distancesPrices[st2 + i] = this._posSlotPrices[st + i];
            }
            while (i < 128) {
                this._distancesPrices[st2 + i] = this._posSlotPrices[st + Encoder.getPosSlot(i)] + this.tempPrices[i];
                ++i;
            }
        }
        this._matchPriceCount = 0;
    }

    void fillAlignPrices() {
        for (int i = 0; i < 16; ++i) {
            this._alignPrices[i] = this._posAlignEncoder.reverseGetPrice(i);
        }
        this._alignPriceCount = 0;
    }

    public boolean setAlgorithm(int algorithm) {
        return true;
    }

    public boolean setDictionarySize(int dictionarySize) {
        int kDicLogSizeMaxCompress = 29;
        if (dictionarySize < 1 || dictionarySize > 1 << kDicLogSizeMaxCompress) {
            return false;
        }
        this._dictionarySize = dictionarySize;
        int dicLogSize = 0;
        while (dictionarySize > 1 << dicLogSize) {
            ++dicLogSize;
        }
        this._distTableSize = dicLogSize * 2;
        return true;
    }

    public boolean setNumFastBytes(int numFastBytes) {
        if (numFastBytes < 5 || numFastBytes > 273) {
            return false;
        }
        this._numFastBytes = numFastBytes;
        return true;
    }

    public boolean setMatchFinder(int matchFinderIndex) {
        if (matchFinderIndex < 0 || matchFinderIndex > 2) {
            return false;
        }
        int matchFinderIndexPrev = this._matchFinderType;
        this._matchFinderType = matchFinderIndex;
        if (this._matchFinder != null && matchFinderIndexPrev != this._matchFinderType) {
            this._dictionarySizePrev = -1;
            this._matchFinder = null;
        }
        return true;
    }

    public boolean setLcLpPb(int lc, int lp, int pb) {
        if (lp < 0 || lp > 4 || lc < 0 || lc > 8 || pb < 0 || pb > 4) {
            return false;
        }
        this._numLiteralPosStateBits = lp;
        this._numLiteralContextBits = lc;
        this._posStateBits = pb;
        this._posStateMask = (1 << this._posStateBits) - 1;
        return true;
    }

    public void setEndMarkerMode(boolean endMarkerMode) {
        this._writeEndMark = endMarkerMode;
    }

    static {
        int kFastSlots = 22;
        int c = 2;
        Encoder.g_FastPos[0] = 0;
        Encoder.g_FastPos[1] = 1;
        for (int slotFast = 2; slotFast < kFastSlots; ++slotFast) {
            int k = 1 << (slotFast >> 1) - 1;
            int j = 0;
            while (j < k) {
                Encoder.g_FastPos[c] = (byte)slotFast;
                ++j;
                ++c;
            }
        }
    }

    class Optimal {
        public int State;
        public boolean Prev1IsChar;
        public boolean Prev2;
        public int PosPrev2;
        public int BackPrev2;
        public int Price;
        public int PosPrev;
        public int BackPrev;
        public int Backs0;
        public int Backs1;
        public int Backs2;
        public int Backs3;

        Optimal() {
        }

        public void makeAsChar() {
            this.BackPrev = -1;
            this.Prev1IsChar = false;
        }

        public void makeAsShortRep() {
            this.BackPrev = 0;
            this.Prev1IsChar = false;
        }

        public boolean isShortRep() {
            return this.BackPrev == 0;
        }
    }

    class LenPriceTableEncoder
    extends LenEncoder {
        int[] _prices;
        int _tableSize;
        int[] _counters;

        LenPriceTableEncoder() {
            this._prices = new int[4352];
            this._counters = new int[16];
        }

        public void setTableSize(int tableSize) {
            this._tableSize = tableSize;
        }

        public int getPrice(int symbol, int posState) {
            return this._prices[posState * 272 + symbol];
        }

        void updateTable(int posState) {
            this.setPrices(posState, this._tableSize, this._prices, posState * 272);
            this._counters[posState] = this._tableSize;
        }

        public void updateTables(int numPosStates) {
            for (int posState = 0; posState < numPosStates; ++posState) {
                this.updateTable(posState);
            }
        }

        @Override
        public void encode(lzma.sdk.rangecoder.Encoder rangeEncoder, int symbol, int posState) throws IOException {
            super.encode(rangeEncoder, symbol, posState);
            int n2 = posState;
            this._counters[n2] = this._counters[n2] - 1;
            if (this._counters[n2] == 0) {
                this.updateTable(posState);
            }
        }
    }

    class LenEncoder {
        short[] _choice = new short[2];
        BitTreeEncoder[] _lowCoder = new BitTreeEncoder[16];
        BitTreeEncoder[] _midCoder = new BitTreeEncoder[16];
        BitTreeEncoder _highCoder = new BitTreeEncoder(8);

        public LenEncoder() {
            for (int posState = 0; posState < 16; ++posState) {
                this._lowCoder[posState] = new BitTreeEncoder(3);
                this._midCoder[posState] = new BitTreeEncoder(3);
            }
        }

        public void init(int numPosStates) {
            lzma.sdk.rangecoder.Encoder.initBitModels(this._choice);
            for (int posState = 0; posState < numPosStates; ++posState) {
                this._lowCoder[posState].init();
                this._midCoder[posState].init();
            }
            this._highCoder.init();
        }

        public void encode(lzma.sdk.rangecoder.Encoder rangeEncoder, int symbol, int posState) throws IOException {
            if (symbol < 8) {
                rangeEncoder.encode(this._choice, 0, 0);
                this._lowCoder[posState].encode(rangeEncoder, symbol);
            } else {
                rangeEncoder.encode(this._choice, 0, 1);
                if ((symbol -= 8) < 8) {
                    rangeEncoder.encode(this._choice, 1, 0);
                    this._midCoder[posState].encode(rangeEncoder, symbol);
                } else {
                    rangeEncoder.encode(this._choice, 1, 1);
                    this._highCoder.encode(rangeEncoder, symbol - 8);
                }
            }
        }

        public void setPrices(int posState, int numSymbols, int[] prices, int st) {
            int i;
            int a0 = lzma.sdk.rangecoder.Encoder.getPrice0(this._choice[0]);
            int a1 = lzma.sdk.rangecoder.Encoder.getPrice1(this._choice[0]);
            int b0 = a1 + lzma.sdk.rangecoder.Encoder.getPrice0(this._choice[1]);
            int b1 = a1 + lzma.sdk.rangecoder.Encoder.getPrice1(this._choice[1]);
            for (i = 0; i < 8; ++i) {
                if (i >= numSymbols) {
                    return;
                }
                prices[st + i] = a0 + this._lowCoder[posState].getPrice(i);
            }
            while (i < 16) {
                if (i >= numSymbols) {
                    return;
                }
                prices[st + i] = b0 + this._midCoder[posState].getPrice(i - 8);
                ++i;
            }
            while (i < numSymbols) {
                prices[st + i] = b1 + this._highCoder.getPrice(i - 8 - 8);
                ++i;
            }
        }
    }

    class LiteralEncoder {
        Encoder2[] m_Coders;
        int m_NumPrevBits;
        int m_NumPosBits;
        int m_PosMask;

        LiteralEncoder() {
        }

        public void create(int numPosBits, int numPrevBits) {
            if (this.m_Coders != null && this.m_NumPrevBits == numPrevBits && this.m_NumPosBits == numPosBits) {
                return;
            }
            this.m_NumPosBits = numPosBits;
            this.m_PosMask = (1 << numPosBits) - 1;
            this.m_NumPrevBits = numPrevBits;
            int numStates = 1 << this.m_NumPrevBits + this.m_NumPosBits;
            this.m_Coders = new Encoder2[numStates];
            for (int i = 0; i < numStates; ++i) {
                this.m_Coders[i] = new Encoder2();
            }
        }

        public void init() {
            int numStates = 1 << this.m_NumPrevBits + this.m_NumPosBits;
            for (int i = 0; i < numStates; ++i) {
                this.m_Coders[i].init();
            }
        }

        public Encoder2 getSubCoder(int pos, byte prevByte) {
            return this.m_Coders[((pos & this.m_PosMask) << this.m_NumPrevBits) + ((prevByte & 0xFF) >>> 8 - this.m_NumPrevBits)];
        }

        class Encoder2 {
            short[] m_Encoders = new short[768];

            Encoder2() {
            }

            public void init() {
                lzma.sdk.rangecoder.Encoder.initBitModels(this.m_Encoders);
            }

            public void encode(lzma.sdk.rangecoder.Encoder rangeEncoder, byte symbol) throws IOException {
                int context = 1;
                for (int i = 7; i >= 0; --i) {
                    int bit = symbol >> i & 1;
                    rangeEncoder.encode(this.m_Encoders, context, bit);
                    context = context << 1 | bit;
                }
            }

            public void encodeMatched(lzma.sdk.rangecoder.Encoder rangeEncoder, byte matchByte, byte symbol) throws IOException {
                int context = 1;
                boolean same = true;
                for (int i = 7; i >= 0; --i) {
                    int bit = symbol >> i & 1;
                    int state = context;
                    if (same) {
                        int matchBit = matchByte >> i & 1;
                        state += 1 + matchBit << 8;
                        same = matchBit == bit;
                    }
                    rangeEncoder.encode(this.m_Encoders, state, bit);
                    context = context << 1 | bit;
                }
            }

            public int getPrice(boolean matchMode, byte matchByte, byte symbol) {
                int i;
                int price = 0;
                int context = 1;
                if (matchMode) {
                    for (i = 7; i >= 0; --i) {
                        int matchBit = matchByte >> i & 1;
                        int bit = symbol >> i & 1;
                        price += lzma.sdk.rangecoder.Encoder.getPrice(this.m_Encoders[(1 + matchBit << 8) + context], bit);
                        context = context << 1 | bit;
                        if (matchBit == bit) continue;
                        --i;
                        break;
                    }
                }
                while (i >= 0) {
                    int bit = symbol >> i & 1;
                    price += lzma.sdk.rangecoder.Encoder.getPrice(this.m_Encoders[context], bit);
                    context = context << 1 | bit;
                    --i;
                }
                return price;
            }
        }
    }
}

