/*
 * Decompiled with CFR 0.152.
 */
package jouvieje.bass;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import jouvieje.bass.BassJNI;
import jouvieje.bass.callbacks.BPMBEATPROC;
import jouvieje.bass.callbacks.BPMPROC;
import jouvieje.bass.callbacks.BPMPROCESSPROC;
import jouvieje.bass.callbacks.CallbackManager;
import jouvieje.bass.callbacks.DOWNLOADPROC;
import jouvieje.bass.callbacks.DSPPROC;
import jouvieje.bass.callbacks.ENCODECLIENTPROC;
import jouvieje.bass.callbacks.ENCODENOTIFYPROC;
import jouvieje.bass.callbacks.ENCODEPROC;
import jouvieje.bass.callbacks.MIDIINPROC;
import jouvieje.bass.callbacks.RECORDPROC;
import jouvieje.bass.callbacks.STREAMPROC;
import jouvieje.bass.callbacks.SYNCPROC;
import jouvieje.bass.enumerations.STREAMPROC_SPECIAL;
import jouvieje.bass.exceptions.NonDirectBufferException;
import jouvieje.bass.structures.BASS_3DVECTOR;
import jouvieje.bass.structures.BASS_CHANNELINFO;
import jouvieje.bass.structures.BASS_DEVICEINFO;
import jouvieje.bass.structures.BASS_FILEPROCS;
import jouvieje.bass.structures.BASS_INFO;
import jouvieje.bass.structures.BASS_MIDI_DEVICEINFO;
import jouvieje.bass.structures.BASS_MIDI_EVENT;
import jouvieje.bass.structures.BASS_MIDI_FONT;
import jouvieje.bass.structures.BASS_MIDI_FONTINFO;
import jouvieje.bass.structures.BASS_MIXER_NODE;
import jouvieje.bass.structures.BASS_PLUGININFO;
import jouvieje.bass.structures.BASS_RECORDINFO;
import jouvieje.bass.structures.HCHANNEL;
import jouvieje.bass.structures.HDSP;
import jouvieje.bass.structures.HENCODE;
import jouvieje.bass.structures.HFX;
import jouvieje.bass.structures.HMUSIC;
import jouvieje.bass.structures.HPLUGIN;
import jouvieje.bass.structures.HRECORD;
import jouvieje.bass.structures.HSAMPLE;
import jouvieje.bass.structures.HSOUNDFONT;
import jouvieje.bass.structures.HSTREAM;
import jouvieje.bass.structures.HSYNC;
import jouvieje.bass.utils.BufferUtils;
import jouvieje.bass.utils.Pointer;

public class Bass
extends Pointer {
    private Bass() {
    }

    public static boolean BASS_SetConfig(int option, int value) {
        boolean javaResult = BassJNI.Bass_BASS_SetConfig(option, value);
        return javaResult;
    }

    public static int BASS_GetConfig(int option) {
        int javaResult = BassJNI.Bass_BASS_GetConfig(option);
        return javaResult;
    }

    public static boolean BASS_SetConfigPtr(int option, Pointer value) {
        boolean javaResult = BassJNI.Bass_BASS_SetConfigPtr(option, Pointer.getPointer(value));
        return javaResult;
    }

    public static Pointer BASS_GetConfigPtr(int option) {
        long javaResult = BassJNI.Bass_BASS_GetConfigPtr(option);
        return javaResult == 0L ? null : Pointer.newPointer(javaResult);
    }

    public static int BASS_GetVersion() {
        int javaResult = BassJNI.Bass_BASS_GetVersion();
        return javaResult;
    }

    public static int BASS_ErrorGetCode() {
        int javaResult = BassJNI.Bass_BASS_ErrorGetCode();
        return javaResult;
    }

    public static boolean BASS_GetDeviceInfo(int device, BASS_DEVICEINFO info) {
        boolean javaResult = BassJNI.Bass_BASS_GetDeviceInfo(device, Pointer.getPointer(info));
        return javaResult;
    }

    public static boolean BASS_Init(int device, int freq, int flags, Pointer win, Pointer dsguid) {
        boolean javaResult = BassJNI.Bass_BASS_Init(device, freq, flags, Pointer.getPointer(win), Pointer.getPointer(dsguid));
        return javaResult;
    }

    public static boolean BASS_SetDevice(int device) {
        boolean javaResult = BassJNI.Bass_BASS_SetDevice(device);
        return javaResult;
    }

    public static int BASS_GetDevice() {
        int javaResult = BassJNI.Bass_BASS_GetDevice();
        return javaResult;
    }

    public static boolean BASS_Free() {
        boolean javaResult = BassJNI.Bass_BASS_Free();
        return javaResult;
    }

    public static boolean BASS_GetInfo(BASS_INFO info) {
        boolean javaResult = BassJNI.Bass_BASS_GetInfo(Pointer.getPointer(info));
        return javaResult;
    }

    public static boolean BASS_Update(int length) {
        boolean javaResult = BassJNI.Bass_BASS_Update(length);
        return javaResult;
    }

    public static float BASS_GetCPU() {
        float javaResult = BassJNI.Bass_BASS_GetCPU();
        return javaResult;
    }

    public static boolean BASS_Start() {
        boolean javaResult = BassJNI.Bass_BASS_Start();
        return javaResult;
    }

    public static boolean BASS_Stop() {
        boolean javaResult = BassJNI.Bass_BASS_Stop();
        return javaResult;
    }

    public static boolean BASS_Pause() {
        boolean javaResult = BassJNI.Bass_BASS_Pause();
        return javaResult;
    }

    public static boolean BASS_SetVolume(float volume) {
        boolean javaResult = BassJNI.Bass_BASS_SetVolume(volume);
        return javaResult;
    }

    public static float BASS_GetVolume() {
        float javaResult = BassJNI.Bass_BASS_GetVolume();
        return javaResult;
    }

    public static HPLUGIN BASS_PluginLoad(String file, int flags) {
        long javaResult = BassJNI.Bass_BASS_PluginLoad(file == null ? null : file.getBytes(), flags);
        return javaResult == 0L ? null : HPLUGIN.asHPLUGIN(Pointer.newPointer(javaResult));
    }

    public static boolean BASS_PluginFree(HPLUGIN handle) {
        boolean javaResult = BassJNI.Bass_BASS_PluginFree(Pointer.getPointer(handle));
        return javaResult;
    }

    public static BASS_PLUGININFO BASS_PluginGetInfo(HPLUGIN handle) {
        long javaResult = BassJNI.Bass_BASS_PluginGetInfo(Pointer.getPointer(handle));
        return javaResult == 0L ? null : BASS_PLUGININFO.asBASS_PLUGININFO(Pointer.newPointer(javaResult));
    }

    public static boolean BASS_Set3DFactors(float distf, float rollf, float doppf) {
        boolean javaResult = BassJNI.Bass_BASS_Set3DFactors(distf, rollf, doppf);
        return javaResult;
    }

    public static boolean BASS_Get3DFactors(FloatBuffer distf, FloatBuffer rollf, FloatBuffer doppf) {
        if (distf != null && !distf.isDirect()) {
            throw new NonDirectBufferException();
        }
        if (rollf != null && !rollf.isDirect()) {
            throw new NonDirectBufferException();
        }
        if (doppf != null && !doppf.isDirect()) {
            throw new NonDirectBufferException();
        }
        boolean javaResult = BassJNI.Bass_BASS_Get3DFactors(distf, BufferUtils.getPositionInBytes(distf), rollf, BufferUtils.getPositionInBytes(rollf), doppf, BufferUtils.getPositionInBytes(doppf));
        return javaResult;
    }

    public static boolean BASS_Set3DPosition(BASS_3DVECTOR pos, BASS_3DVECTOR vel, BASS_3DVECTOR front, BASS_3DVECTOR top) {
        boolean javaResult = BassJNI.Bass_BASS_Set3DPosition(Pointer.getPointer(pos), Pointer.getPointer(vel), Pointer.getPointer(front), Pointer.getPointer(top));
        return javaResult;
    }

    public static boolean BASS_Get3DPosition(BASS_3DVECTOR pos, BASS_3DVECTOR vel, BASS_3DVECTOR front, BASS_3DVECTOR top) {
        boolean javaResult = BassJNI.Bass_BASS_Get3DPosition(Pointer.getPointer(pos), Pointer.getPointer(vel), Pointer.getPointer(front), Pointer.getPointer(top));
        return javaResult;
    }

    public static void BASS_Apply3D() {
        BassJNI.Bass_BASS_Apply3D();
    }

    public static HMUSIC BASS_MusicLoad(boolean mem, Pointer file, long offset, int length, int flags, int freq) {
        long javaResult = BassJNI.Bass_BASS_MusicLoad(mem, Pointer.getPointer(file), offset, length, flags, freq);
        return javaResult == 0L ? null : HMUSIC.asHMUSIC(Pointer.newPointer(javaResult));
    }

    public static HMUSIC BASS_MusicLoad(boolean mem, String file, long offset, int length, int flags, int freq) {
        long javaResult = BassJNI.Bass_BASS_MusicLoad(mem, file == null ? null : file.getBytes(), offset, length, flags, freq);
        return javaResult == 0L ? null : HMUSIC.asHMUSIC(Pointer.newPointer(javaResult));
    }

    public static boolean BASS_MusicFree(HMUSIC handle) {
        boolean javaResult = BassJNI.Bass_BASS_MusicFree(Pointer.getPointer(handle));
        return javaResult;
    }

    public static HSAMPLE BASS_SampleLoad(boolean mem, Pointer file, long offset, int length, int max, int flags) {
        long javaResult = BassJNI.Bass_BASS_SampleLoad(mem, Pointer.getPointer(file), offset, length, max, flags);
        return javaResult == 0L ? null : HSAMPLE.asHSAMPLE(Pointer.newPointer(javaResult));
    }

    public static HSAMPLE BASS_SampleLoad(boolean mem, String file, long offset, int length, int max, int flags) {
        long javaResult = BassJNI.Bass_BASS_SampleLoad(mem, file == null ? null : file.getBytes(), offset, length, max, flags);
        return javaResult == 0L ? null : HSAMPLE.asHSAMPLE(Pointer.newPointer(javaResult));
    }

    public static HSAMPLE BASS_SampleCreate(int length, int freq, int chans, int max, int flags) {
        long javaResult = BassJNI.Bass_BASS_SampleCreate(length, freq, chans, max, flags);
        return javaResult == 0L ? null : HSAMPLE.asHSAMPLE(Pointer.newPointer(javaResult));
    }

    public static boolean BASS_SampleFree(HSAMPLE handle) {
        boolean javaResult = BassJNI.Bass_BASS_SampleFree(Pointer.getPointer(handle));
        return javaResult;
    }

    public static boolean BASS_SampleSetData(HSAMPLE handle, Pointer buffer) {
        boolean javaResult = BassJNI.Bass_BASS_SampleSetData(Pointer.getPointer(handle), Pointer.getPointer(buffer));
        return javaResult;
    }

    public static boolean BASS_SampleGetData(HSAMPLE handle, Pointer buffer) {
        boolean javaResult = BassJNI.Bass_BASS_SampleGetData(Pointer.getPointer(handle), Pointer.getPointer(buffer));
        return javaResult;
    }

    public static boolean BASS_SampleGetInfo(HSAMPLE handle, IntBuffer info) {
        if (info != null && !info.isDirect()) {
            throw new NonDirectBufferException();
        }
        boolean javaResult = BassJNI.Bass_BASS_SampleGetInfo(Pointer.getPointer(handle), info, BufferUtils.getPositionInBytes(info));
        return javaResult;
    }

    public static boolean BASS_SampleSetInfo(HSAMPLE handle, IntBuffer info) {
        if (info != null && !info.isDirect()) {
            throw new NonDirectBufferException();
        }
        boolean javaResult = BassJNI.Bass_BASS_SampleSetInfo(Pointer.getPointer(handle), info, BufferUtils.getPositionInBytes(info));
        return javaResult;
    }

    public static HCHANNEL BASS_SampleGetChannel(HSAMPLE handle, boolean onlynew) {
        long javaResult = BassJNI.Bass_BASS_SampleGetChannel(Pointer.getPointer(handle), onlynew);
        return javaResult == 0L ? null : HCHANNEL.asHCHANNEL(Pointer.newPointer(javaResult));
    }

    public static int BASS_SampleGetChannels(HSAMPLE handle, HCHANNEL[] channels) {
        int javaResult = BassJNI.Bass_BASS_SampleGetChannels(Pointer.getPointer(handle), Pointer.getPointer(channels[0]));
        return javaResult;
    }

    public static boolean BASS_SampleStop(HSAMPLE handle) {
        boolean javaResult = BassJNI.Bass_BASS_SampleStop(Pointer.getPointer(handle));
        return javaResult;
    }

    public static HSTREAM BASS_StreamCreate(int freq, int chans, int flags, STREAMPROC proc, Pointer user) {
        CallbackManager.addTmpCallback(15, proc);
        long javaResult = BassJNI.Bass_BASS_StreamCreate(freq, chans, flags, proc != null, Pointer.getPointer(user));
        CallbackManager.addCallback(15, proc, javaResult);
        CallbackManager.addOwner(proc == null ? 0L : javaResult, javaResult);
        return javaResult == 0L ? null : HSTREAM.asHSTREAM(Pointer.newPointer(javaResult));
    }

    public static HSTREAM BASS_StreamCreate(int freq, int chans, int flags, STREAMPROC_SPECIAL proc, Pointer user) {
        long javaResult = BassJNI.Bass_BASS_StreamCreate(freq, chans, flags, proc.asInt(), Pointer.getPointer(user));
        return javaResult == 0L ? null : HSTREAM.asHSTREAM(Pointer.newPointer(javaResult));
    }

    public static HSTREAM BASS_StreamCreateFile(boolean mem, ByteBuffer file, long offset, long length, int flags) {
        if (file != null && !file.isDirect()) {
            throw new NonDirectBufferException();
        }
        long javaResult = BassJNI.Bass_BASS_StreamCreateFile(mem, file, BufferUtils.getPositionInBytes(file), offset, length, flags);
        return javaResult == 0L ? null : HSTREAM.asHSTREAM(Pointer.newPointer(javaResult));
    }

    public static HSTREAM BASS_StreamCreateFile(boolean mem, String file, long offset, long length, int flags) {
        long javaResult = BassJNI.Bass_BASS_StreamCreateFile(mem, file == null ? null : file.getBytes(), offset, length, flags);
        return javaResult == 0L ? null : HSTREAM.asHSTREAM(Pointer.newPointer(javaResult));
    }

    public static HSTREAM BASS_StreamCreateURL(String url, int offset, int flags, DOWNLOADPROC proc, Pointer user) {
        CallbackManager.addCallback(3, proc, 0L);
        long javaResult = BassJNI.Bass_BASS_StreamCreateURL(url == null ? null : url.getBytes(), offset, flags, proc != null, Pointer.getPointer(user));
        return javaResult == 0L ? null : HSTREAM.asHSTREAM(Pointer.newPointer(javaResult));
    }

    public static HSTREAM BASS_StreamCreateFileUser(int system, int flags, BASS_FILEPROCS proc, Pointer user) {
        long javaResult = BassJNI.Bass_BASS_StreamCreateFileUser(system, flags, Pointer.getPointer(proc), Pointer.getPointer(user));
        return javaResult == 0L ? null : HSTREAM.asHSTREAM(Pointer.newPointer(javaResult));
    }

    public static boolean BASS_StreamFree(HSTREAM handle) {
        boolean javaResult = BassJNI.Bass_BASS_StreamFree(Pointer.getPointer(handle));
        return javaResult;
    }

    public static long BASS_StreamGetFilePosition(HSTREAM handle, int mode) {
        long javaResult = BassJNI.Bass_BASS_StreamGetFilePosition(Pointer.getPointer(handle), mode);
        return javaResult;
    }

    public static int BASS_StreamPutData(HSTREAM handle, ByteBuffer buffer, int length) {
        if (buffer != null && !buffer.isDirect()) {
            throw new NonDirectBufferException();
        }
        int javaResult = BassJNI.Bass_BASS_StreamPutData(Pointer.getPointer(handle), buffer, BufferUtils.getPositionInBytes(buffer), length);
        return javaResult;
    }

    public static int BASS_StreamPutFileData(HSTREAM handle, Pointer buffer, int length) {
        int javaResult = BassJNI.Bass_BASS_StreamPutFileData(Pointer.getPointer(handle), Pointer.getPointer(buffer), length);
        return javaResult;
    }

    public static boolean BASS_RecordGetDeviceInfo(int device, BASS_DEVICEINFO info) {
        boolean javaResult = BassJNI.Bass_BASS_RecordGetDeviceInfo(device, Pointer.getPointer(info));
        return javaResult;
    }

    public static boolean BASS_RecordInit(int device) {
        boolean javaResult = BassJNI.Bass_BASS_RecordInit(device);
        return javaResult;
    }

    public static boolean BASS_RecordSetDevice(int device) {
        boolean javaResult = BassJNI.Bass_BASS_RecordSetDevice(device);
        return javaResult;
    }

    public static int BASS_RecordGetDevice() {
        int javaResult = BassJNI.Bass_BASS_RecordGetDevice();
        return javaResult;
    }

    public static boolean BASS_RecordFree() {
        boolean javaResult = BassJNI.Bass_BASS_RecordFree();
        return javaResult;
    }

    public static boolean BASS_RecordGetInfo(BASS_RECORDINFO info) {
        boolean javaResult = BassJNI.Bass_BASS_RecordGetInfo(Pointer.getPointer(info));
        return javaResult;
    }

    public static String BASS_RecordGetInputName(int input) {
        String javaResult = BassJNI.Bass_BASS_RecordGetInputName(input);
        return javaResult;
    }

    public static boolean BASS_RecordSetInput(int input, int flags, float volume) {
        boolean javaResult = BassJNI.Bass_BASS_RecordSetInput(input, flags, volume);
        return javaResult;
    }

    public static int BASS_RecordGetInput(int input, FloatBuffer volume) {
        if (volume != null && !volume.isDirect()) {
            throw new NonDirectBufferException();
        }
        int javaResult = BassJNI.Bass_BASS_RecordGetInput(input, volume, BufferUtils.getPositionInBytes(volume));
        return javaResult;
    }

    public static HRECORD BASS_RecordStart(int freq, int chans, int flags, RECORDPROC proc, Pointer user) {
        CallbackManager.addTmpCallback(14, proc);
        long javaResult = BassJNI.Bass_BASS_RecordStart(freq, chans, flags, proc != null, Pointer.getPointer(user));
        CallbackManager.addCallback(14, proc, javaResult);
        CallbackManager.addOwner(proc == null ? 0L : javaResult, javaResult);
        return javaResult == 0L ? null : HRECORD.asHRECORD(Pointer.newPointer(javaResult));
    }

    public static double BASS_ChannelBytes2Seconds(int handle, long pos) {
        double javaResult = BassJNI.Bass_BASS_ChannelBytes2Seconds(handle, pos);
        return javaResult;
    }

    public static long BASS_ChannelSeconds2Bytes(int handle, double pos) {
        long javaResult = BassJNI.Bass_BASS_ChannelSeconds2Bytes(handle, pos);
        return javaResult;
    }

    public static int BASS_ChannelGetDevice(int handle) {
        int javaResult = BassJNI.Bass_BASS_ChannelGetDevice(handle);
        return javaResult;
    }

    public static boolean BASS_ChannelSetDevice(int handle, int device) {
        boolean javaResult = BassJNI.Bass_BASS_ChannelSetDevice(handle, device);
        return javaResult;
    }

    public static int BASS_ChannelIsActive(int handle) {
        int javaResult = BassJNI.Bass_BASS_ChannelIsActive(handle);
        return javaResult;
    }

    public static boolean BASS_ChannelGetInfo(int handle, BASS_CHANNELINFO info) {
        boolean javaResult = BassJNI.Bass_BASS_ChannelGetInfo(handle, Pointer.getPointer(info));
        return javaResult;
    }

    public static Pointer BASS_ChannelGetTags(int handle, int tags) {
        long javaResult = BassJNI.Bass_BASS_ChannelGetTags(handle, tags);
        return javaResult == 0L ? null : Pointer.newPointer(javaResult);
    }

    public static int BASS_ChannelFlags(int handle, int flags, int mask) {
        int javaResult = BassJNI.Bass_BASS_ChannelFlags(handle, flags, mask);
        return javaResult;
    }

    public static boolean BASS_ChannelUpdate(int handle, int length) {
        boolean javaResult = BassJNI.Bass_BASS_ChannelUpdate(handle, length);
        return javaResult;
    }

    public static boolean BASS_ChannelLock(int handle, boolean lock) {
        boolean javaResult = BassJNI.Bass_BASS_ChannelLock(handle, lock);
        return javaResult;
    }

    public static boolean BASS_ChannelPlay(int handle, boolean restart) {
        boolean javaResult = BassJNI.Bass_BASS_ChannelPlay(handle, restart);
        return javaResult;
    }

    public static boolean BASS_ChannelStop(int handle) {
        boolean javaResult = BassJNI.Bass_BASS_ChannelStop(handle);
        return javaResult;
    }

    public static boolean BASS_ChannelPause(int handle) {
        boolean javaResult = BassJNI.Bass_BASS_ChannelPause(handle);
        return javaResult;
    }

    public static boolean BASS_ChannelSetAttribute(int handle, int attrib, float value) {
        boolean javaResult = BassJNI.Bass_BASS_ChannelSetAttribute(handle, attrib, value);
        return javaResult;
    }

    public static boolean BASS_ChannelGetAttribute(int handle, int attrib, FloatBuffer value) {
        if (value != null && !value.isDirect()) {
            throw new NonDirectBufferException();
        }
        boolean javaResult = BassJNI.Bass_BASS_ChannelGetAttribute(handle, attrib, value, BufferUtils.getPositionInBytes(value));
        return javaResult;
    }

    public static boolean BASS_ChannelSlideAttribute(int handle, int attrib, float value, int time) {
        boolean javaResult = BassJNI.Bass_BASS_ChannelSlideAttribute(handle, attrib, value, time);
        return javaResult;
    }

    public static boolean BASS_ChannelIsSliding(int handle, int attrib) {
        boolean javaResult = BassJNI.Bass_BASS_ChannelIsSliding(handle, attrib);
        return javaResult;
    }

    public static boolean BASS_ChannelSet3DAttributes(int handle, int mode, float min, float max, int iangle, int oangle, float outvol) {
        boolean javaResult = BassJNI.Bass_BASS_ChannelSet3DAttributes(handle, mode, min, max, iangle, oangle, outvol);
        return javaResult;
    }

    public static boolean BASS_ChannelGet3DAttributes(int handle, IntBuffer mode, FloatBuffer min, FloatBuffer max, IntBuffer iangle, IntBuffer oangle, FloatBuffer outvol) {
        if (mode != null && !mode.isDirect()) {
            throw new NonDirectBufferException();
        }
        if (min != null && !min.isDirect()) {
            throw new NonDirectBufferException();
        }
        if (max != null && !max.isDirect()) {
            throw new NonDirectBufferException();
        }
        if (iangle != null && !iangle.isDirect()) {
            throw new NonDirectBufferException();
        }
        if (oangle != null && !oangle.isDirect()) {
            throw new NonDirectBufferException();
        }
        if (outvol != null && !outvol.isDirect()) {
            throw new NonDirectBufferException();
        }
        boolean javaResult = BassJNI.Bass_BASS_ChannelGet3DAttributes(handle, mode, BufferUtils.getPositionInBytes(mode), min, BufferUtils.getPositionInBytes(min), max, BufferUtils.getPositionInBytes(max), iangle, BufferUtils.getPositionInBytes(iangle), oangle, BufferUtils.getPositionInBytes(oangle), outvol, BufferUtils.getPositionInBytes(outvol));
        return javaResult;
    }

    public static boolean BASS_ChannelSet3DPosition(int handle, BASS_3DVECTOR pos, BASS_3DVECTOR orient, BASS_3DVECTOR vel) {
        boolean javaResult = BassJNI.Bass_BASS_ChannelSet3DPosition(handle, Pointer.getPointer(pos), Pointer.getPointer(orient), Pointer.getPointer(vel));
        return javaResult;
    }

    public static boolean BASS_ChannelGet3DPosition(int handle, BASS_3DVECTOR pos, BASS_3DVECTOR orient, BASS_3DVECTOR vel) {
        boolean javaResult = BassJNI.Bass_BASS_ChannelGet3DPosition(handle, Pointer.getPointer(pos), Pointer.getPointer(orient), Pointer.getPointer(vel));
        return javaResult;
    }

    public static long BASS_ChannelGetLength(int handle, int mode) {
        long javaResult = BassJNI.Bass_BASS_ChannelGetLength(handle, mode);
        return javaResult;
    }

    public static boolean BASS_ChannelSetPosition(int handle, long pos, int mode) {
        boolean javaResult = BassJNI.Bass_BASS_ChannelSetPosition(handle, pos, mode);
        return javaResult;
    }

    public static long BASS_ChannelGetPosition(int handle, int mode) {
        long javaResult = BassJNI.Bass_BASS_ChannelGetPosition(handle, mode);
        return javaResult;
    }

    public static int BASS_ChannelGetLevel(int handle) {
        int javaResult = BassJNI.Bass_BASS_ChannelGetLevel(handle);
        return javaResult;
    }

    public static int BASS_ChannelGetData(int handle, ByteBuffer buffer, int length) {
        if (buffer != null && !buffer.isDirect()) {
            throw new NonDirectBufferException();
        }
        int javaResult = BassJNI.Bass_BASS_ChannelGetData(handle, buffer, BufferUtils.getPositionInBytes(buffer), length);
        return javaResult;
    }

    public static HSYNC BASS_ChannelSetSync(int handle, int type, long param, SYNCPROC proc, Pointer user) {
        CallbackManager.addTmpCallback(16, proc);
        long javaResult = BassJNI.Bass_BASS_ChannelSetSync(handle, type, param, proc != null, Pointer.getPointer(user));
        CallbackManager.addCallback(16, proc, javaResult);
        CallbackManager.addOwner(proc == null ? 0L : javaResult, javaResult);
        return javaResult == 0L ? null : HSYNC.asHSYNC(Pointer.newPointer(javaResult));
    }

    public static boolean BASS_ChannelRemoveSync(int handle, HSYNC sync) {
        boolean javaResult = BassJNI.Bass_BASS_ChannelRemoveSync(handle, Pointer.getPointer(sync));
        return javaResult;
    }

    public static HDSP BASS_ChannelSetDSP(int handle, DSPPROC proc, Pointer user, int priority) {
        CallbackManager.addTmpCallback(4, proc);
        long javaResult = BassJNI.Bass_BASS_ChannelSetDSP(handle, proc != null, Pointer.getPointer(user), priority);
        CallbackManager.addCallback(4, proc, javaResult);
        CallbackManager.addOwner(proc == null ? 0L : javaResult, javaResult);
        return javaResult == 0L ? null : HDSP.asHDSP(Pointer.newPointer(javaResult));
    }

    public static boolean BASS_ChannelRemoveDSP(int handle, HDSP dsp) {
        long dspPointer;
        boolean javaResult = BassJNI.Bass_BASS_ChannelRemoveDSP(handle, Pointer.getPointer(dsp));
        if (dsp != null && (dspPointer = dsp.asLong()) != 0L) {
            CallbackManager.addOwner(0L, dspPointer);
        }
        return javaResult;
    }

    public static boolean BASS_ChannelSetLink(int handle, int chan) {
        boolean javaResult = BassJNI.Bass_BASS_ChannelSetLink(handle, chan);
        return javaResult;
    }

    public static boolean BASS_ChannelRemoveLink(int handle, int chan) {
        boolean javaResult = BassJNI.Bass_BASS_ChannelRemoveLink(handle, chan);
        return javaResult;
    }

    public static HFX BASS_ChannelSetFX(int handle, int type, int priority) {
        long javaResult = BassJNI.Bass_BASS_ChannelSetFX(handle, type, priority);
        return javaResult == 0L ? null : HFX.asHFX(Pointer.newPointer(javaResult));
    }

    public static boolean BASS_ChannelRemoveFX(int handle, HFX fx) {
        boolean javaResult = BassJNI.Bass_BASS_ChannelRemoveFX(handle, Pointer.getPointer(fx));
        return javaResult;
    }

    public static boolean BASS_FXSetParameters(HFX handle, Pointer params) {
        boolean javaResult = BassJNI.Bass_BASS_FXSetParameters(Pointer.getPointer(handle), Pointer.getPointer(params));
        return javaResult;
    }

    public static boolean BASS_FXGetParameters(HFX handle, Pointer params) {
        boolean javaResult = BassJNI.Bass_BASS_FXGetParameters(Pointer.getPointer(handle), Pointer.getPointer(params));
        return javaResult;
    }

    public static boolean BASS_FXReset(HFX handle) {
        boolean javaResult = BassJNI.Bass_BASS_FXReset(Pointer.getPointer(handle));
        return javaResult;
    }

    public static int BASS_Encode_GetVersion() {
        int javaResult = BassJNI.Bass_BASS_Encode_GetVersion();
        return javaResult;
    }

    public static HENCODE BASS_Encode_Start(int handle, String cmdline, int flags, ENCODEPROC proc, Pointer user) {
        CallbackManager.addTmpCallback(7, proc);
        long javaResult = BassJNI.Bass_BASS_Encode_Start(handle, cmdline == null ? null : cmdline.getBytes(), flags, proc != null, Pointer.getPointer(user));
        CallbackManager.addCallback(7, proc, javaResult);
        CallbackManager.addOwner(proc == null ? 0L : javaResult, javaResult);
        return javaResult == 0L ? null : HENCODE.asHENCODE(Pointer.newPointer(javaResult));
    }

    public static HENCODE BASS_Encode_StartLimit(int handle, String cmdline, int flags, ENCODEPROC proc, Pointer user, int limit) {
        CallbackManager.addTmpCallback(7, proc);
        long javaResult = BassJNI.Bass_BASS_Encode_StartLimit(handle, cmdline == null ? null : cmdline.getBytes(), flags, proc != null, Pointer.getPointer(user), limit);
        CallbackManager.addCallback(7, proc, javaResult);
        CallbackManager.addOwner(proc == null ? 0L : javaResult, javaResult);
        return javaResult == 0L ? null : HENCODE.asHENCODE(Pointer.newPointer(javaResult));
    }

    public static boolean BASS_Encode_AddChunk(HENCODE handle, String id, Pointer buffer, int length) {
        boolean javaResult = BassJNI.Bass_BASS_Encode_AddChunk(Pointer.getPointer(handle), id == null ? null : id.getBytes(), Pointer.getPointer(buffer), length);
        return javaResult;
    }

    public static int BASS_Encode_IsActive(int handle) {
        int javaResult = BassJNI.Bass_BASS_Encode_IsActive(handle);
        return javaResult;
    }

    public static boolean BASS_Encode_Stop(int handle) {
        boolean javaResult = BassJNI.Bass_BASS_Encode_Stop(handle);
        return javaResult;
    }

    public static boolean BASS_Encode_StopEx(int handle, boolean queue) {
        boolean javaResult = BassJNI.Bass_BASS_Encode_StopEx(handle, queue);
        return javaResult;
    }

    public static boolean BASS_Encode_SetPaused(int handle, boolean paused) {
        boolean javaResult = BassJNI.Bass_BASS_Encode_SetPaused(handle, paused);
        return javaResult;
    }

    public static boolean BASS_Encode_Write(int handle, Pointer buffer, int length) {
        boolean javaResult = BassJNI.Bass_BASS_Encode_Write(handle, Pointer.getPointer(buffer), length);
        return javaResult;
    }

    public static boolean BASS_Encode_SetNotify(int handle, ENCODENOTIFYPROC proc, Pointer user) {
        CallbackManager.addCallback(6, proc, handle);
        boolean javaResult = BassJNI.Bass_BASS_Encode_SetNotify(handle, proc != null, Pointer.getPointer(user));
        return javaResult;
    }

    public static long BASS_Encode_GetCount(int handle, int count) {
        long javaResult = BassJNI.Bass_BASS_Encode_GetCount(handle, count);
        return javaResult;
    }

    public static boolean BASS_Encode_SetChannel(int handle, int channel) {
        boolean javaResult = BassJNI.Bass_BASS_Encode_SetChannel(handle, channel);
        return javaResult;
    }

    public static int BASS_Encode_GetChannel(HENCODE handle) {
        int javaResult = BassJNI.Bass_BASS_Encode_GetChannel(Pointer.getPointer(handle));
        return javaResult;
    }

    public static boolean BASS_Encode_CastInit(HENCODE handle, String server, String pass, String content, String name, String url, String genre, String desc, String headers, int bitrate, boolean pub) {
        boolean javaResult = BassJNI.Bass_BASS_Encode_CastInit(Pointer.getPointer(handle), server == null ? null : server.getBytes(), pass == null ? null : pass.getBytes(), content == null ? null : content.getBytes(), name == null ? null : name.getBytes(), url == null ? null : url.getBytes(), genre == null ? null : genre.getBytes(), desc == null ? null : desc.getBytes(), headers == null ? null : headers.getBytes(), bitrate, pub);
        return javaResult;
    }

    public static boolean BASS_Encode_CastSetTitle(HENCODE handle, String title, String url) {
        boolean javaResult = BassJNI.Bass_BASS_Encode_CastSetTitle(Pointer.getPointer(handle), title == null ? null : title.getBytes(), url == null ? null : url.getBytes());
        return javaResult;
    }

    public static String BASS_Encode_CastGetStats(HENCODE handle, int type, String pass) {
        String javaResult = BassJNI.Bass_BASS_Encode_CastGetStats(Pointer.getPointer(handle), type, pass == null ? null : pass.getBytes());
        return javaResult;
    }

    public static int BASS_Encode_ServerInit(HENCODE handle, String port, int buffer, int burst, int flags, ENCODECLIENTPROC proc, Pointer user) {
        int javaResult = BassJNI.Bass_BASS_Encode_ServerInit(Pointer.getPointer(handle), port == null ? null : port.getBytes(), buffer, burst, flags, proc != null, Pointer.getPointer(user));
        return javaResult;
    }

    public static boolean BASS_Encode_ServerKick(HENCODE handle, String client) {
        boolean javaResult = BassJNI.Bass_BASS_Encode_ServerKick(Pointer.getPointer(handle), client == null ? null : client.getBytes());
        return javaResult;
    }

    public static HSTREAM BASS_FLAC_StreamCreateFile(boolean mem, Pointer file, long offset, long length, int flags) {
        long javaResult = BassJNI.Bass_BASS_FLAC_StreamCreateFile(mem, Pointer.getPointer(file), offset, length, flags);
        return javaResult == 0L ? null : HSTREAM.asHSTREAM(Pointer.newPointer(javaResult));
    }

    public static HSTREAM BASS_FLAC_StreamCreateURL(String url, int offset, int flags, DOWNLOADPROC proc, Pointer user) {
        CallbackManager.addCallback(3, proc, 0L);
        long javaResult = BassJNI.Bass_BASS_FLAC_StreamCreateURL(url == null ? null : url.getBytes(), offset, flags, proc != null, Pointer.getPointer(user));
        return javaResult == 0L ? null : HSTREAM.asHSTREAM(Pointer.newPointer(javaResult));
    }

    public static HSTREAM BASS_FLAC_StreamCreateFileUser(int system, int flags, BASS_FILEPROCS procs, Pointer user) {
        long javaResult = BassJNI.Bass_BASS_FLAC_StreamCreateFileUser(system, flags, Pointer.getPointer(procs), Pointer.getPointer(user));
        return javaResult == 0L ? null : HSTREAM.asHSTREAM(Pointer.newPointer(javaResult));
    }

    public static HSTREAM BASS_MIDI_StreamCreate(int channels, int flags, int freq) {
        long javaResult = BassJNI.Bass_BASS_MIDI_StreamCreate(channels, flags, freq);
        return javaResult == 0L ? null : HSTREAM.asHSTREAM(Pointer.newPointer(javaResult));
    }

    public static HSTREAM BASS_MIDI_StreamCreateFile(boolean mem, Pointer file, long offset, long length, int flags, int freq) {
        long javaResult = BassJNI.Bass_BASS_MIDI_StreamCreateFile(mem, Pointer.getPointer(file), offset, length, flags, freq);
        return javaResult == 0L ? null : HSTREAM.asHSTREAM(Pointer.newPointer(javaResult));
    }

    public static HSTREAM BASS_MIDI_StreamCreateURL(String url, int offset, int flags, DOWNLOADPROC proc, Pointer user, int freq) {
        CallbackManager.addCallback(3, proc, 0L);
        long javaResult = BassJNI.Bass_BASS_MIDI_StreamCreateURL(url == null ? null : url.getBytes(), offset, flags, proc != null, Pointer.getPointer(user), freq);
        return javaResult == 0L ? null : HSTREAM.asHSTREAM(Pointer.newPointer(javaResult));
    }

    public static HSTREAM BASS_MIDI_StreamCreateFileUser(int system, int flags, BASS_FILEPROCS procs, Pointer user, int freq) {
        long javaResult = BassJNI.Bass_BASS_MIDI_StreamCreateFileUser(system, flags, Pointer.getPointer(procs), Pointer.getPointer(user), freq);
        return javaResult == 0L ? null : HSTREAM.asHSTREAM(Pointer.newPointer(javaResult));
    }

    public static boolean BASS_MIDI_StreamGetMark(HSTREAM handle, int type, int index, IntBuffer mark) {
        if (mark != null && !mark.isDirect()) {
            throw new NonDirectBufferException();
        }
        boolean javaResult = BassJNI.Bass_BASS_MIDI_StreamGetMark(Pointer.getPointer(handle), type, index, mark, BufferUtils.getPositionInBytes(mark));
        return javaResult;
    }

    public static boolean BASS_MIDI_StreamSetFonts(HSTREAM handle, BASS_MIDI_FONT fonts, int count) {
        boolean javaResult = BassJNI.Bass_BASS_MIDI_StreamSetFonts(Pointer.getPointer(handle), Pointer.getPointer(fonts), count);
        return javaResult;
    }

    public static int BASS_MIDI_StreamGetFonts(HSTREAM handle, BASS_MIDI_FONT fonts, int count) {
        int javaResult = BassJNI.Bass_BASS_MIDI_StreamGetFonts(Pointer.getPointer(handle), Pointer.getPointer(fonts), count);
        return javaResult;
    }

    public static boolean BASS_MIDI_StreamLoadSamples(HSTREAM handle) {
        boolean javaResult = BassJNI.Bass_BASS_MIDI_StreamLoadSamples(Pointer.getPointer(handle));
        return javaResult;
    }

    public static boolean BASS_MIDI_StreamEvent(HSTREAM handle, int chan, int event, int param) {
        boolean javaResult = BassJNI.Bass_BASS_MIDI_StreamEvent(Pointer.getPointer(handle), chan, event, param);
        return javaResult;
    }

    public static int BASS_MIDI_StreamEvents(HSTREAM handle, int mode, Pointer events, int length) {
        int javaResult = BassJNI.Bass_BASS_MIDI_StreamEvents(Pointer.getPointer(handle), mode, Pointer.getPointer(events), length);
        return javaResult;
    }

    public static int BASS_MIDI_StreamGetEvent(HSTREAM handle, int chan, int event) {
        int javaResult = BassJNI.Bass_BASS_MIDI_StreamGetEvent(Pointer.getPointer(handle), chan, event);
        return javaResult;
    }

    public static int BASS_MIDI_StreamGetEvents(HSTREAM handle, int track, int filter2, BASS_MIDI_EVENT events) {
        int javaResult = BassJNI.Bass_BASS_MIDI_StreamGetEvents(Pointer.getPointer(handle), track, filter2, Pointer.getPointer(events));
        return javaResult;
    }

    public static HSTREAM BASS_MIDI_StreamGetChannel(HSTREAM handle, int chan) {
        long javaResult = BassJNI.Bass_BASS_MIDI_StreamGetChannel(Pointer.getPointer(handle), chan);
        return javaResult == 0L ? null : HSTREAM.asHSTREAM(Pointer.newPointer(javaResult));
    }

    public static HSOUNDFONT BASS_MIDI_FontInit(Pointer file, int flags) {
        long javaResult = BassJNI.Bass_BASS_MIDI_FontInit(Pointer.getPointer(file), flags);
        return javaResult == 0L ? null : HSOUNDFONT.asHSOUNDFONT(Pointer.newPointer(javaResult));
    }

    public static boolean BASS_MIDI_FontFree(HSOUNDFONT handle) {
        boolean javaResult = BassJNI.Bass_BASS_MIDI_FontFree(Pointer.getPointer(handle));
        return javaResult;
    }

    public static boolean BASS_MIDI_FontGetInfo(HSOUNDFONT handle, BASS_MIDI_FONTINFO info) {
        boolean javaResult = BassJNI.Bass_BASS_MIDI_FontGetInfo(Pointer.getPointer(handle), Pointer.getPointer(info));
        return javaResult;
    }

    public static String BASS_MIDI_FontGetPreset(HSOUNDFONT handle, int preset, int bank) {
        String javaResult = BassJNI.Bass_BASS_MIDI_FontGetPreset(Pointer.getPointer(handle), preset, bank);
        return javaResult;
    }

    public static boolean BASS_MIDI_FontLoad(HSOUNDFONT handle, int preset, int bank) {
        boolean javaResult = BassJNI.Bass_BASS_MIDI_FontLoad(Pointer.getPointer(handle), preset, bank);
        return javaResult;
    }

    public static boolean BASS_MIDI_FontCompact(HSOUNDFONT handle) {
        boolean javaResult = BassJNI.Bass_BASS_MIDI_FontCompact(Pointer.getPointer(handle));
        return javaResult;
    }

    public static boolean BASS_MIDI_FontPack(HSOUNDFONT handle, Pointer outfile, Pointer encoder, int flags) {
        boolean javaResult = BassJNI.Bass_BASS_MIDI_FontPack(Pointer.getPointer(handle), Pointer.getPointer(outfile), Pointer.getPointer(encoder), flags);
        return javaResult;
    }

    public static boolean BASS_MIDI_FontUnpack(HSOUNDFONT handle, Pointer outfile, int flags) {
        boolean javaResult = BassJNI.Bass_BASS_MIDI_FontUnpack(Pointer.getPointer(handle), Pointer.getPointer(outfile), flags);
        return javaResult;
    }

    public static boolean BASS_MIDI_FontSetVolume(HSOUNDFONT handle, float volume) {
        boolean javaResult = BassJNI.Bass_BASS_MIDI_FontSetVolume(Pointer.getPointer(handle), volume);
        return javaResult;
    }

    public static float BASS_MIDI_FontGetVolume(HSOUNDFONT handle) {
        float javaResult = BassJNI.Bass_BASS_MIDI_FontGetVolume(Pointer.getPointer(handle));
        return javaResult;
    }

    public static boolean BASS_MIDI_InGetDeviceInfo(int device, BASS_MIDI_DEVICEINFO info) {
        boolean javaResult = BassJNI.Bass_BASS_MIDI_InGetDeviceInfo(device, Pointer.getPointer(info));
        return javaResult;
    }

    public static boolean BASS_MIDI_InInit(int device, MIDIINPROC proc, Pointer user) {
        boolean javaResult = BassJNI.Bass_BASS_MIDI_InInit(device, proc != null, Pointer.getPointer(user));
        return javaResult;
    }

    public static boolean BASS_MIDI_InFree(int device) {
        boolean javaResult = BassJNI.Bass_BASS_MIDI_InFree(device);
        return javaResult;
    }

    public static boolean BASS_MIDI_InStart(int device) {
        boolean javaResult = BassJNI.Bass_BASS_MIDI_InStart(device);
        return javaResult;
    }

    public static boolean BASS_MIDI_InStop(int device) {
        boolean javaResult = BassJNI.Bass_BASS_MIDI_InStop(device);
        return javaResult;
    }

    public static int BASS_Mixer_GetVersion() {
        int javaResult = BassJNI.Bass_BASS_Mixer_GetVersion();
        return javaResult;
    }

    public static HSTREAM BASS_Mixer_StreamCreate(int freq, int chans, int flags) {
        long javaResult = BassJNI.Bass_BASS_Mixer_StreamCreate(freq, chans, flags);
        return javaResult == 0L ? null : HSTREAM.asHSTREAM(Pointer.newPointer(javaResult));
    }

    public static boolean BASS_Mixer_StreamAddChannel(HSTREAM handle, int channel, int flags) {
        boolean javaResult = BassJNI.Bass_BASS_Mixer_StreamAddChannel(Pointer.getPointer(handle), channel, flags);
        return javaResult;
    }

    public static boolean BASS_Mixer_StreamAddChannelEx(HSTREAM handle, int channel, int flags, long start, long length) {
        boolean javaResult = BassJNI.Bass_BASS_Mixer_StreamAddChannelEx(Pointer.getPointer(handle), channel, flags, start, length);
        return javaResult;
    }

    public static HSTREAM BASS_Mixer_ChannelGetMixer(int handle) {
        long javaResult = BassJNI.Bass_BASS_Mixer_ChannelGetMixer(handle);
        return javaResult == 0L ? null : HSTREAM.asHSTREAM(Pointer.newPointer(javaResult));
    }

    public static int BASS_Mixer_ChannelFlags(int handle, int flags, int mask) {
        int javaResult = BassJNI.Bass_BASS_Mixer_ChannelFlags(handle, flags, mask);
        return javaResult;
    }

    public static boolean BASS_Mixer_ChannelRemove(int handle) {
        boolean javaResult = BassJNI.Bass_BASS_Mixer_ChannelRemove(handle);
        return javaResult;
    }

    public static boolean BASS_Mixer_ChannelSetPosition(int handle, long pos, int mode) {
        boolean javaResult = BassJNI.Bass_BASS_Mixer_ChannelSetPosition(handle, pos, mode);
        return javaResult;
    }

    public static long BASS_Mixer_ChannelGetPosition(int handle, int mode) {
        long javaResult = BassJNI.Bass_BASS_Mixer_ChannelGetPosition(handle, mode);
        return javaResult;
    }

    public static long BASS_Mixer_ChannelGetPositionEx(int channel, int mode, int delay) {
        long javaResult = BassJNI.Bass_BASS_Mixer_ChannelGetPositionEx(channel, mode, delay);
        return javaResult;
    }

    public static int BASS_Mixer_ChannelGetLevel(int handle) {
        int javaResult = BassJNI.Bass_BASS_Mixer_ChannelGetLevel(handle);
        return javaResult;
    }

    public static int BASS_Mixer_ChannelGetData(int handle, Pointer buffer, int length) {
        int javaResult = BassJNI.Bass_BASS_Mixer_ChannelGetData(handle, Pointer.getPointer(buffer), length);
        return javaResult;
    }

    public static HSYNC BASS_Mixer_ChannelSetSync(int handle, int type, long param, SYNCPROC proc, Pointer user) {
        CallbackManager.addTmpCallback(16, proc);
        long javaResult = BassJNI.Bass_BASS_Mixer_ChannelSetSync(handle, type, param, proc != null, Pointer.getPointer(user));
        CallbackManager.addCallback(16, proc, javaResult);
        CallbackManager.addOwner(proc == null ? 0L : javaResult, javaResult);
        return javaResult == 0L ? null : HSYNC.asHSYNC(Pointer.newPointer(javaResult));
    }

    public static boolean BASS_Mixer_ChannelRemoveSync(int channel, HSYNC sync) {
        boolean javaResult = BassJNI.Bass_BASS_Mixer_ChannelRemoveSync(channel, Pointer.getPointer(sync));
        return javaResult;
    }

    public static boolean BASS_Mixer_ChannelSetMatrix(int handle, FloatBuffer matrix) {
        if (matrix != null && !matrix.isDirect()) {
            throw new NonDirectBufferException();
        }
        boolean javaResult = BassJNI.Bass_BASS_Mixer_ChannelSetMatrix(handle, matrix, BufferUtils.getPositionInBytes(matrix));
        return javaResult;
    }

    public static boolean BASS_Mixer_ChannelGetMatrix(int handle, FloatBuffer matrix) {
        if (matrix != null && !matrix.isDirect()) {
            throw new NonDirectBufferException();
        }
        boolean javaResult = BassJNI.Bass_BASS_Mixer_ChannelGetMatrix(handle, matrix, BufferUtils.getPositionInBytes(matrix));
        return javaResult;
    }

    public static boolean BASS_Mixer_ChannelSetEnvelope(int handle, int type, BASS_MIXER_NODE nodes, int count) {
        boolean javaResult = BassJNI.Bass_BASS_Mixer_ChannelSetEnvelope(handle, type, Pointer.getPointer(nodes), count);
        return javaResult;
    }

    public static boolean BASS_Mixer_ChannelSetEnvelopePos(int handle, int type, long pos) {
        boolean javaResult = BassJNI.Bass_BASS_Mixer_ChannelSetEnvelopePos(handle, type, pos);
        return javaResult;
    }

    public static long BASS_Mixer_ChannelGetEnvelopePos(int handle, int type, FloatBuffer value) {
        if (value != null && !value.isDirect()) {
            throw new NonDirectBufferException();
        }
        long javaResult = BassJNI.Bass_BASS_Mixer_ChannelGetEnvelopePos(handle, type, value, BufferUtils.getPositionInBytes(value));
        return javaResult;
    }

    public static HSTREAM BASS_Split_StreamCreate(int channel, int flags, IntBuffer chanmap) {
        if (chanmap != null && !chanmap.isDirect()) {
            throw new NonDirectBufferException();
        }
        long javaResult = BassJNI.Bass_BASS_Split_StreamCreate(channel, flags, chanmap, BufferUtils.getPositionInBytes(chanmap));
        return javaResult == 0L ? null : HSTREAM.asHSTREAM(Pointer.newPointer(javaResult));
    }

    public static int BASS_Split_StreamGetSource(HSTREAM handle) {
        int javaResult = BassJNI.Bass_BASS_Split_StreamGetSource(Pointer.getPointer(handle));
        return javaResult;
    }

    public static int BASS_Split_StreamGetSplits(int handle, HSTREAM[] splits, int count) {
        int javaResult = BassJNI.Bass_BASS_Split_StreamGetSplits(handle, Pointer.getPointer(splits[0]), count);
        return javaResult;
    }

    public static boolean BASS_Split_StreamReset(int handle) {
        boolean javaResult = BassJNI.Bass_BASS_Split_StreamReset(handle);
        return javaResult;
    }

    public static boolean BASS_Split_StreamResetEx(int handle, int offset) {
        boolean javaResult = BassJNI.Bass_BASS_Split_StreamResetEx(handle, offset);
        return javaResult;
    }

    public static int BASS_Split_StreamGetAvailable(int handle) {
        int javaResult = BassJNI.Bass_BASS_Split_StreamGetAvailable(handle);
        return javaResult;
    }

    public static HSTREAM BASS_WV_StreamCreateFile(boolean mem, Pointer file, long offset, long length, int flags) {
        long javaResult = BassJNI.Bass_BASS_WV_StreamCreateFile(mem, Pointer.getPointer(file), offset, length, flags);
        return javaResult == 0L ? null : HSTREAM.asHSTREAM(Pointer.newPointer(javaResult));
    }

    public static HSTREAM BASS_WV_StreamCreateFileUser(int system, int flags, BASS_FILEPROCS procs, Pointer user) {
        long javaResult = BassJNI.Bass_BASS_WV_StreamCreateFileUser(system, flags, Pointer.getPointer(procs), Pointer.getPointer(user));
        return javaResult == 0L ? null : HSTREAM.asHSTREAM(Pointer.newPointer(javaResult));
    }

    public static HSTREAM BASS_AAC_StreamCreateFile(boolean mem, Pointer file, long offset, long length, int flags) {
        long javaResult = BassJNI.Bass_BASS_AAC_StreamCreateFile(mem, Pointer.getPointer(file), offset, length, flags);
        return javaResult == 0L ? null : HSTREAM.asHSTREAM(Pointer.newPointer(javaResult));
    }

    public static HSTREAM BASS_AAC_StreamCreateURL(String url, int offset, int flags, DOWNLOADPROC proc, Pointer user) {
        CallbackManager.addCallback(3, proc, 0L);
        long javaResult = BassJNI.Bass_BASS_AAC_StreamCreateURL(url == null ? null : url.getBytes(), offset, flags, proc != null, Pointer.getPointer(user));
        return javaResult == 0L ? null : HSTREAM.asHSTREAM(Pointer.newPointer(javaResult));
    }

    public static HSTREAM BASS_AAC_StreamCreateFileUser(int system, int flags, BASS_FILEPROCS procs, Pointer user) {
        long javaResult = BassJNI.Bass_BASS_AAC_StreamCreateFileUser(system, flags, Pointer.getPointer(procs), Pointer.getPointer(user));
        return javaResult == 0L ? null : HSTREAM.asHSTREAM(Pointer.newPointer(javaResult));
    }

    public static HSTREAM BASS_MP4_StreamCreateFile(boolean mem, Pointer file, long offset, long length, int flags) {
        long javaResult = BassJNI.Bass_BASS_MP4_StreamCreateFile(mem, Pointer.getPointer(file), offset, length, flags);
        return javaResult == 0L ? null : HSTREAM.asHSTREAM(Pointer.newPointer(javaResult));
    }

    public static HSTREAM BASS_MP4_StreamCreateFileUser(int system, int flags, BASS_FILEPROCS procs, Pointer user) {
        long javaResult = BassJNI.Bass_BASS_MP4_StreamCreateFileUser(system, flags, Pointer.getPointer(procs), Pointer.getPointer(user));
        return javaResult == 0L ? null : HSTREAM.asHSTREAM(Pointer.newPointer(javaResult));
    }

    public static HSTREAM BASS_AC3_StreamCreateFile(boolean mem, Pointer file, long offset, long length, int flags) {
        long javaResult = BassJNI.Bass_BASS_AC3_StreamCreateFile(mem, Pointer.getPointer(file), offset, length, flags);
        return javaResult == 0L ? null : HSTREAM.asHSTREAM(Pointer.newPointer(javaResult));
    }

    public static HSTREAM BASS_AC3_StreamCreateURL(String url, int offset, int flags, DOWNLOADPROC proc, Pointer user) {
        CallbackManager.addCallback(3, proc, 0L);
        long javaResult = BassJNI.Bass_BASS_AC3_StreamCreateURL(url == null ? null : url.getBytes(), offset, flags, proc != null, Pointer.getPointer(user));
        return javaResult == 0L ? null : HSTREAM.asHSTREAM(Pointer.newPointer(javaResult));
    }

    public static HSTREAM BASS_AC3_StreamCreateFileUser(int system, int flags, BASS_FILEPROCS procs, Pointer user) {
        long javaResult = BassJNI.Bass_BASS_AC3_StreamCreateFileUser(system, flags, Pointer.getPointer(procs), Pointer.getPointer(user));
        return javaResult == 0L ? null : HSTREAM.asHSTREAM(Pointer.newPointer(javaResult));
    }

    public static HSTREAM BASS_ALAC_StreamCreateFile(boolean mem, Pointer file, long offset, long length, int flags) {
        long javaResult = BassJNI.Bass_BASS_ALAC_StreamCreateFile(mem, Pointer.getPointer(file), offset, length, flags);
        return javaResult == 0L ? null : HSTREAM.asHSTREAM(Pointer.newPointer(javaResult));
    }

    public static HSTREAM BASS_ALAC_StreamCreateFileUser(int system, int flags, BASS_FILEPROCS procs, Pointer user) {
        long javaResult = BassJNI.Bass_BASS_ALAC_StreamCreateFileUser(system, flags, Pointer.getPointer(procs), Pointer.getPointer(user));
        return javaResult == 0L ? null : HSTREAM.asHSTREAM(Pointer.newPointer(javaResult));
    }

    public static int BASS_FX_GetVersion() {
        int javaResult = BassJNI.Bass_BASS_FX_GetVersion();
        return javaResult;
    }

    public static HSTREAM BASS_FX_TempoCreate(int chan, int flags) {
        long javaResult = BassJNI.Bass_BASS_FX_TempoCreate(chan, flags);
        return javaResult == 0L ? null : HSTREAM.asHSTREAM(Pointer.newPointer(javaResult));
    }

    public static int BASS_FX_TempoGetSource(HSTREAM chan) {
        int javaResult = BassJNI.Bass_BASS_FX_TempoGetSource(Pointer.getPointer(chan));
        return javaResult;
    }

    public static float BASS_FX_TempoGetRateRatio(HSTREAM chan) {
        float javaResult = BassJNI.Bass_BASS_FX_TempoGetRateRatio(Pointer.getPointer(chan));
        return javaResult;
    }

    public static HSTREAM BASS_FX_ReverseCreate(int chan, float dec_block, int flags) {
        long javaResult = BassJNI.Bass_BASS_FX_ReverseCreate(chan, dec_block, flags);
        return javaResult == 0L ? null : HSTREAM.asHSTREAM(Pointer.newPointer(javaResult));
    }

    public static int BASS_FX_ReverseGetSource(HSTREAM chan) {
        int javaResult = BassJNI.Bass_BASS_FX_ReverseGetSource(Pointer.getPointer(chan));
        return javaResult;
    }

    public static float BASS_FX_BPM_DecodeGet(int chan, double startSec, double endSec, int minMaxBPM, int flags, BPMPROCESSPROC proc) {
        CallbackManager.addCallback(2, proc, chan);
        float javaResult = BassJNI.Bass_BASS_FX_BPM_DecodeGet(chan, startSec, endSec, minMaxBPM, flags, proc != null);
        return javaResult;
    }

    public static boolean BASS_FX_BPM_CallbackSet(int handle, BPMPROC proc, double period, int minMaxBPM, int flags, Pointer user) {
        CallbackManager.addCallback(1, proc, handle);
        boolean javaResult = BassJNI.Bass_BASS_FX_BPM_CallbackSet(handle, proc != null, period, minMaxBPM, flags, Pointer.getPointer(user));
        return javaResult;
    }

    public static boolean BASS_FX_BPM_CallbackReset(int handle) {
        boolean javaResult = BassJNI.Bass_BASS_FX_BPM_CallbackReset(handle);
        return javaResult;
    }

    public static float BASS_FX_BPM_Translate(int handle, float val2tran, int trans) {
        float javaResult = BassJNI.Bass_BASS_FX_BPM_Translate(handle, val2tran, trans);
        return javaResult;
    }

    public static boolean BASS_FX_BPM_Free(int handle) {
        boolean javaResult = BassJNI.Bass_BASS_FX_BPM_Free(handle);
        return javaResult;
    }

    public static boolean BASS_FX_BPM_BeatCallbackSet(int handle, BPMBEATPROC proc, Pointer user) {
        CallbackManager.addCallback(0, proc, handle);
        boolean javaResult = BassJNI.Bass_BASS_FX_BPM_BeatCallbackSet(handle, proc != null, Pointer.getPointer(user));
        return javaResult;
    }

    public static boolean BASS_FX_BPM_BeatCallbackReset(int handle) {
        boolean javaResult = BassJNI.Bass_BASS_FX_BPM_BeatCallbackReset(handle);
        return javaResult;
    }

    public static boolean BASS_FX_BPM_BeatDecodeGet(int chan, double startSec, double endSec, int flags, BPMBEATPROC proc, Pointer user) {
        CallbackManager.addCallback(0, proc, chan);
        boolean javaResult = BassJNI.Bass_BASS_FX_BPM_BeatDecodeGet(chan, startSec, endSec, flags, proc != null, Pointer.getPointer(user));
        return javaResult;
    }

    public static boolean BASS_FX_BPM_BeatSetParameters(int handle, float bandwidth, float centerfreq, float beat_rtime) {
        boolean javaResult = BassJNI.Bass_BASS_FX_BPM_BeatSetParameters(handle, bandwidth, centerfreq, beat_rtime);
        return javaResult;
    }

    public static boolean BASS_FX_BPM_BeatGetParameters(int handle, FloatBuffer bandwidth, FloatBuffer centerfreq, FloatBuffer beat_rtime) {
        if (bandwidth != null && !bandwidth.isDirect()) {
            throw new NonDirectBufferException();
        }
        if (centerfreq != null && !centerfreq.isDirect()) {
            throw new NonDirectBufferException();
        }
        if (beat_rtime != null && !beat_rtime.isDirect()) {
            throw new NonDirectBufferException();
        }
        boolean javaResult = BassJNI.Bass_BASS_FX_BPM_BeatGetParameters(handle, bandwidth, BufferUtils.getPositionInBytes(bandwidth), centerfreq, BufferUtils.getPositionInBytes(centerfreq), beat_rtime, BufferUtils.getPositionInBytes(beat_rtime));
        return javaResult;
    }

    public static boolean BASS_FX_BPM_BeatFree(int handle) {
        boolean javaResult = BassJNI.Bass_BASS_FX_BPM_BeatFree(handle);
        return javaResult;
    }

    public static HSTREAM BASS_MPC_StreamCreateFile(boolean mem, Pointer file, long offset, long length, int flags) {
        long javaResult = BassJNI.Bass_BASS_MPC_StreamCreateFile(mem, Pointer.getPointer(file), offset, length, flags);
        return javaResult == 0L ? null : HSTREAM.asHSTREAM(Pointer.newPointer(javaResult));
    }

    public static HSTREAM BASS_MPC_StreamCreateURL(String url, int offset, int flags, DOWNLOADPROC proc, Pointer user) {
        CallbackManager.addCallback(3, proc, 0L);
        long javaResult = BassJNI.Bass_BASS_MPC_StreamCreateURL(url == null ? null : url.getBytes(), offset, flags, proc != null, Pointer.getPointer(user));
        return javaResult == 0L ? null : HSTREAM.asHSTREAM(Pointer.newPointer(javaResult));
    }

    public static HSTREAM BASS_MPC_StreamCreateFileUser(int system, int flags, BASS_FILEPROCS proc, Pointer user) {
        long javaResult = BassJNI.Bass_BASS_MPC_StreamCreateFileUser(system, flags, Pointer.getPointer(proc), Pointer.getPointer(user));
        return javaResult == 0L ? null : HSTREAM.asHSTREAM(Pointer.newPointer(javaResult));
    }

    public static HSTREAM BASS_SPX_StreamCreateFile(boolean mem, Pointer file, long offset, long length, int flags) {
        long javaResult = BassJNI.Bass_BASS_SPX_StreamCreateFile(mem, Pointer.getPointer(file), offset, length, flags);
        return javaResult == 0L ? null : HSTREAM.asHSTREAM(Pointer.newPointer(javaResult));
    }
}

