#version 330 core

#define MAX_LIGHTS 4

in vec2 texCoord;
in vec4 vertexFragColor;
in vec3 normal;
in vec3 eye;
in vec4 shadowPosition;

out vec4 fragColor;
uniform sampler2D texture0; // diffuse
uniform sampler2D texture1; // ambient / depth
uniform sampler2D texture2; // specular
uniform sampler2D texture3; // normal
uniform sampler2DShadow shadow10; // shadow
uniform vec4 color = vec4(1,1,1,1);
uniform float time = 0.0f;

void main(void)
{
    fragColor = color;

    fragColor *= texture(texture0, texCoord);

    fragColor.rgb *= clamp((tan(time*1000.0)+1.0)/2.0,0.0,1.0)*0.5+0.5;

    fragColor = clamp(fragColor, vec4(0,0,0,0), vec4(1,1,1,1));
} 
