'                      T
'    R   (c) 2004 by Saga-Games
'        A
'        C   Visit www.saga-games.de.ms
'      K
' E
'1.0 R
'
'A MIDI-Tracker/Player for QBasic, QB, PDS and VB-DOS!

'$DYNAMIC
DEFINT A-Z

DECLARE FUNCTION GetInput$ (Mes$, Valid$, Example$, MaxLen%)
DECLARE FUNCTION NoteName$ (Nmbr%)
DECLARE SUB AddPattern ()
DECLARE SUB ChangePal (Dark%)
DECLARE SUB DoMessage ()
DECLARE SUB GetEditKeys ()
DECLARE SUB InitMessage (Text$)
DECLARE SUB InitScreen ()
DECLARE SUB MidiInit ()
DECLARE SUB MidiInstrument (Kanal%, Instrument%)
DECLARE SUB MidiNote (Note%, Volume%, Kanal%)
DECLARE SUB MidiReset ()
DECLARE SUB LoadTrack (File$)
DECLARE SUB PlayRow ()
DECLARE SUB SaveTrack (File$, Channels%)
DECLARE SUB ShowPatt ()

ON ERROR GOTO AbortProgramme:

CONST NORMAL = 0
CONST EFFECTS = 1

DIM SHARED Pattern(0 TO 0, 0 TO 63, 0 TO 15) AS INTEGER   'Pattern for notes
DIM SHARED Effect(0 TO 0, 0 TO 63, 0 TO 15) AS STRING * 2 'Pattern for effects

DIM SHARED TempPattern(0 TO 63, 0 TO 15) AS INTEGER    'Temporary (CTRL+C)
DIM SHARED TempEffect(0 TO 63, 0 TO 15) AS STRING * 2  'Dito

DIM SHARED ID AS STRING * 15 'File ID MUST be "MidiTracker 1.0"
DIM SHARED Songname AS STRING * 80, Copyright AS STRING * 40 'Name and Copyright

DIM SHARED MaxPatterns AS INTEGER 'How many patterns?

DIM SHARED UsePattern AS INTEGER, UseRow AS INTEGER, UseChannel AS INTEGER 'Needed in the player and tracker
DIM SHARED RestartPattern  AS INTEGER, CurrentDelay AS SINGLE 'Dito
DIM SHARED CurrentVolume(0 TO 15) AS INTEGER, CurrentInstrument(0 TO 15) AS INTEGER 'Dito
DIM SHARED InitDelay AS INTEGER
DIM SHARED MidiPort% 'Dito

DIM SHARED Editmode AS INTEGER                          'Only for the tracker
DIM SHARED MIDIplaying AS INTEGER, DoInput AS INTEGER   'Dito
DIM SHARED QUIT AS INTEGER                              'Dito

DIM SHARED FileASCIIz AS STRING, StandardASCIIz AS STRING  'Only for GetInput
DIM SHARED FadeMessage$, FadeX, FadeDone, FadeDir  'Only for DoMessage/InitMessage

FOR ASCII = 32 TO 254
  IF ASCII > 32 THEN FileASCIIz = FileASCIIz + CHR$(ASCII)
  StandardASCIIz = StandardASCIIz + CHR$(ASCII)
NEXT

IF LEN(ENVIRON$("BLASTER")) THEN
 FOR Length% = 1 TO LEN(ENVIRON$("BLASTER"))
  IF MID$(ENVIRON$("BLASTER"), Length%, 1) = "P" THEN MidiPort% = VAL("&H" + MID$(ENVIRON$("BLASTER"), Length% + 1, 3))
 NEXT
END IF

IF NOT MidiPort% THEN MidiPort% = &H330

MidiInit
MidiReset

ID = "MidiTracker 1.0"
Songname = "No title"
Copyright = "(C) 2004 by Saga-Games"
MaxPatterns = 0
MIDIplaying = 0
Editmode = NORMAL

InitScreen

CurrentDelay = .1
FOR Chan = 0 TO 15
  CurrentVolume(Chan) = 127
  CurrentInstrument(Chan) = 0
  MidiInstrument Chan, CurrentInstrument(Chan)
NEXT

FOR Patt = 0 TO MaxPatterns
  FOR MakeRow = 0 TO 63
    FOR Ch = 0 TO 15
      Pattern(Patt, MakeRow, Ch) = 128
      Effect(Patt, MakeRow, Ch) = STRING$(2, 0)
    NEXT
  NEXT
NEXT
Effect(0, 0, 0) = CHR$(3) + CHR$(1)
COLOR 15, 0
UseChannel = 0
InitDelay = 1
ShowPatt
DO
  DoMessage
  GOSUB TitelWechsel
  GetEditKeys
  IF TIMER > EditDel! + .5 THEN
    EditDel! = TIMER
    FOR XChan% = 0 TO 15
      FOR XNote% = 1 TO 127
        MidiNote XNote%, 0, XChan%
      NEXT
    NEXT
  END IF
LOOP UNTIL QUIT

FOR XChan% = 0 TO 15
  FOR XNote% = 1 TO 127
    MidiNote XNote%, 0, XChan%
  NEXT
NEXT
MidiReset

COLOR 7, 0: CLS
Message$ = " MIDI Tracker 1.0   --  (c) 2004 by Saga-Games  --  Visit www.saga-games.de.ms"
Fast = 0
FOR W = 1 TO LEN(Message$) + 20
  IF W < 81 THEN COLOR 8: LOCATE 1, W: PRINT MID$(Message$, W, 1)
  IF W - 1 > 0 AND W < 81 THEN COLOR 7: LOCATE 1, W - 1: PRINT MID$(Message$, W - 1, 1)
  IF W - 2 > 0 AND W < 81 THEN COLOR 15: LOCATE 1, W - 2: PRINT MID$(Message$, W - 2, 1)
  IF Fast = 0 THEN S! = TIMER: DO: LOOP UNTIL TIMER <> S!
  A$ = INKEY$: IF LEN(A$) THEN Fast = 1
NEXT
ChangePal 2
SYSTEM

TitelWechsel:
IF FadeDone = 0 THEN RETURN
Tl = Tl + 1
IF Tl > 4 AND Editmode = 0 THEN Tl = 1
IF Tl > 7 AND Editmode = 1 THEN Tl = 1

X = CSRLIN: Y = POS(0)
LOCATE 9, 1: COLOR 15, 0
PRINT SPACE$(80): LOCATE 9, 1
IF Editmode = 0 THEN
  SELECT CASE Tl
    CASE 1: InitMessage "Note screen instructions:  ABCDEFG = Set note"
    CASE 2: InitMessage "Note screen instructions:  0...9 = Set octave"
    CASE 3: InitMessage "Note screen instructions:  # = Higher note"
    CASE 4: InitMessage "Note screen instructions:  ENTER = Play"
  END SELECT
ELSEIF Editmode = 1 THEN
  SELECT CASE Tl
    CASE 1: InitMessage "Effect screen instructions:  I = Set instrument"
    CASE 2: InitMessage "Effect screen instructions:  V = Set volume for this and the next notes"
    CASE 3: InitMessage "Effect screen instructions:  P = Set delay        1 = 1 ms        10 = 1 sec"
    CASE 4: InitMessage "Effect screen instructions:  R = Set restart pattern"
    CASE 5: InitMessage "Effect screen instructions:  J = Jump to pattern x"
    CASE 6: InitMessage "Effect screen instructions:  C = Stop the music on this channel"
    CASE 7: InitMessage "Effect screen instructions:  B = Break pattern"
  END SELECT
END IF
LOCATE X, Y
COLOR 8, 0
RETURN

AbortProgramme:
COLOR 7, 0: CLS : PRINT "An error occured. Its number is:"; ERR
SLEEP
SYSTEM

REM $STATIC
SUB AddPattern
  OPEN "~TEMP~.MT_" FOR BINARY AS #1
  FOR Patt = 0 TO MaxPatterns
    Track$ = ""
    FOR MakeRow = 0 TO 63
      FOR Ch = 0 TO 15
        Track$ = Track$ + CHR$(Pattern(Patt, MakeRow, Ch)) + Effect(Patt, MakeRow, Ch)
      NEXT
    NEXT
    PUT #1, , Track$
  NEXT
  SEEK #1, 1
  MaxPatterns = MaxPatterns + 1
  REDIM Pattern(MaxPatterns, 0 TO 63, 0 TO 15) AS INTEGER
  REDIM Effect(MaxPatterns, 0 TO 63, 0 TO 15)  AS STRING * 2
  FOR Patt = 0 TO MaxPatterns - 1
    Track$ = SPACE$(3072): GET #1, , Track$
    TempPos = -2
    FOR MakeRow = 0 TO 63
      FOR Ch = 0 TO 15
        TempPos = TempPos + 3
        Pattern(Patt, MakeRow, Ch) = ASC(MID$(Track$, TempPos, 1))
        Effect(Patt, MakeRow, Ch) = MID$(Track$, TempPos + 1, 2)
      NEXT
    NEXT
  NEXT
  CLOSE #1
  KILL "~TEMP~.MT_"
  FOR MakeRow = 0 TO 63
    FOR Ch = 0 TO 15
      Pattern(MaxPatterns, MakeRow, Ch) = 128
      Effect(MaxPatterns, MakeRow, Ch) = STRING$(2, 0)
    NEXT
  NEXT
END SUB

SUB ChangePal (Dark)
IF Dark = 1 THEN
  FOR P = 0 TO 63
    OUT &H3C7, P: R = INP(&H3C9): G = INP(&H3C9): B = INP(&H3C9)
    R = R / 2: G = G / 2: B = B / 2
    OUT &H3C8, P: OUT &H3C9, R: OUT &H3C9, G: OUT &H3C9, B
  NEXT
ELSEIF Dark = 0 THEN
  OUT &H3C8, 0: OUT &H3C9, 0: OUT &H3C9, 0: OUT &H3C9, 0
  OUT &H3C8, 1: OUT &H3C9, 21: OUT &H3C9, 21: OUT &H3C9, 42
  OUT &H3C8, 2: OUT &H3C9, 21: OUT &H3C9, 42: OUT &H3C9, 21
  OUT &H3C8, 3: OUT &H3C9, 21: OUT &H3C9, 42: OUT &H3C9, 42
  OUT &H3C8, 4: OUT &H3C9, 42: OUT &H3C9, 21: OUT &H3C9, 21
  OUT &H3C8, 5: OUT &H3C9, 42: OUT &H3C9, 21: OUT &H3C9, 42
  OUT &H3C8, 20: OUT &H3C9, 42: OUT &H3C9, 42: OUT &H3C9, 42
  OUT &H3C8, 7: OUT &H3C9, 31: OUT &H3C9, 31: OUT &H3C9, 31
  OUT &H3C8, 56: OUT &H3C9, 16: OUT &H3C9, 16: OUT &H3C9, 16
  OUT &H3C8, 57: OUT &H3C9, 0: OUT &H3C9, 0: OUT &H3C9, 63
  OUT &H3C8, 58: OUT &H3C9, 0: OUT &H3C9, 63: OUT &H3C9, 0
  OUT &H3C8, 59: OUT &H3C9, 0: OUT &H3C9, 63: OUT &H3C9, 63
  OUT &H3C8, 60: OUT &H3C9, 63: OUT &H3C9, 0: OUT &H3C9, 0
  OUT &H3C8, 61: OUT &H3C9, 63: OUT &H3C9, 0: OUT &H3C9, 63
  OUT &H3C8, 62: OUT &H3C9, 63: OUT &H3C9, 63: OUT &H3C9, 0
  OUT &H3C8, 63: OUT &H3C9, 63: OUT &H3C9, 63: OUT &H3C9, 63
ELSEIF Dark = 2 THEN
  OUT &H3C8, 0: OUT &H3C9, 0: OUT &H3C9, 0: OUT &H3C9, 0
  OUT &H3C8, 1: OUT &H3C9, 0: OUT &H3C9, 0: OUT &H3C9, 42
  OUT &H3C8, 2: OUT &H3C9, 0: OUT &H3C9, 42: OUT &H3C9, 0
  OUT &H3C8, 3: OUT &H3C9, 0: OUT &H3C9, 42: OUT &H3C9, 42
  OUT &H3C8, 4: OUT &H3C9, 42: OUT &H3C9, 0: OUT &H3C9, 0
  OUT &H3C8, 5: OUT &H3C9, 42: OUT &H3C9, 0: OUT &H3C9, 42
  OUT &H3C8, 20: OUT &H3C9, 48: OUT &H3C9, 21: OUT &H3C9, 0
  OUT &H3C8, 7: OUT &H3C9, 42: OUT &H3C9, 42: OUT &H3C9, 42
  OUT &H3C8, 56: OUT &H3C9, 31: OUT &H3C9, 31: OUT &H3C9, 31
  OUT &H3C8, 57: OUT &H3C9, 42: OUT &H3C9, 42: OUT &H3C9, 63
  OUT &H3C8, 58: OUT &H3C9, 42: OUT &H3C9, 63: OUT &H3C9, 42
  OUT &H3C8, 59: OUT &H3C9, 42: OUT &H3C9, 63: OUT &H3C9, 63
  OUT &H3C8, 60: OUT &H3C9, 63: OUT &H3C9, 42: OUT &H3C9, 42
  OUT &H3C8, 61: OUT &H3C9, 63: OUT &H3C9, 42: OUT &H3C9, 63
  OUT &H3C8, 62: OUT &H3C9, 63: OUT &H3C9, 63: OUT &H3C9, 42
  OUT &H3C8, 63: OUT &H3C9, 63: OUT &H3C9, 63: OUT &H3C9, 63
END IF
END SUB

SUB DoMessage STATIC
IF TIMER <> S! AND FadeDone = 0 THEN
  IF FadeDir = 0 THEN FadeX = FadeX + 1 ELSE FadeX = FadeX - 1
  IF FadeX + 1 > 0 AND FadeX + 1 < 81 THEN COLOR 0, 0: LOCATE 9, FadeX + 1: PRINT MID$(FadeMessage$, FadeX + 1, 1)
  IF FadeX > 0 AND FadeX < 81 THEN COLOR 8, 0: LOCATE 9, FadeX: PRINT MID$(FadeMessage$, FadeX, 1)
  IF FadeX - 1 > 0 AND FadeX - 1 < 81 THEN COLOR 7, 0: LOCATE 9, FadeX - 1: PRINT MID$(FadeMessage$, FadeX - 1, 1)
  FOR White = 2 TO 10
    IF FadeX - White > 0 AND FadeX - White < 81 THEN COLOR 15, 0: LOCATE 9, FadeX - White: PRINT MID$(FadeMessage$, FadeX - White, 1)
  NEXT
  IF FadeX - 11 > 0 AND FadeX - 11 < 81 THEN COLOR 7, 0: LOCATE 9, FadeX - 11: PRINT MID$(FadeMessage$, FadeX - 11, 1)
  IF FadeX - 12 > 0 AND FadeX - 12 < 81 THEN COLOR 8, 0: LOCATE 9, FadeX - 12: PRINT MID$(FadeMessage$, FadeX - 12, 1)
  IF FadeX - 13 > 0 AND FadeX - 13 < 81 THEN COLOR 0, 0: LOCATE 9, FadeX - 13: PRINT MID$(FadeMessage$, FadeX - 13, 1)
  S! = TIMER
  IF FadeX = LEN(FadeMessage$) THEN FadeDir = 1
  IF FadeX < -5 THEN FadeDone = 1
END IF
END SUB

SUB GetEditKeys
  STATIC LastFile$
  A$ = UCASE$(INKEY$)
  IF A$ = "*" THEN Editmode = Editmode + 1: IF Editmode = 2 THEN Editmode = NORMAL
  IF A$ = CHR$(3) THEN
    FOR Patt = 0 TO 63
      FOR Ch = 0 TO 15
        TempPattern(Patt, Ch) = Pattern(UsePattern, Patt, Ch)
        TempEffect(Patt, Ch) = Effect(UsePattern, Patt, Ch)
      NEXT
    NEXT
  ELSEIF A$ = CHR$(13) THEN
    MIDIplaying = 1
    UseRow = 0
    FOR Ch = 0 TO 15
      CurrentInstrument(Ch) = 0
      CurrentVolume(Ch) = 127
    NEXT
    FadeDone = 1
    InitMessage RTRIM$(Songname)
    ChangePal 1
    CurrentDelay = InitDelay / 10
    DO
      DoMessage
      IF FadeDone <> 0 THEN
        IF RTRIM$(FadeMessage$) = RTRIM$(Copyright) THEN InitMessage RTRIM$(Songname)
        IF RTRIM$(FadeMessage$) = RTRIM$(Songname) THEN InitMessage RTRIM$(Copyright)
      END IF
      A$ = INKEY$
      IF A$ = "*" THEN Editmode = Editmode + 1: IF Editmode = 2 THEN Editmode = 0
      PlayRow
      COLOR 15, 1: LOCATE 24, 2: PRINT "Delay:"; CurrentDelay;
      COLOR , 0
    LOOP UNTIL A$ = CHR$(13)
    ChangePal 0
    MIDIplaying = 0
    FadeDone = 1
  ELSEIF A$ = CHR$(14) THEN
    YN$ = GetInput("Clear everything?", "YN", "N", 1)
    IF YN$ = "Y" THEN
      Songname = "No Name"
      Copyright = "(C) 2004 by Saga-Games"
      MaxPatterns = 0

      CurrentDelay = .1
      FOR Chan = 0 TO 15
        CurrentVolume(Chan) = 127
        CurrentInstrument(Chan) = 0
        MidiInstrument Chan, CurrentInstrument(Chan)
      NEXT

      FOR MakeRow = 0 TO 63
        FOR Ch = 0 TO 15
          Pattern(0, MakeRow, Ch) = 128
          Effect(0, MakeRow, Ch) = STRING$(2, 0)
        NEXT
      NEXT
      Effect(0, 0, 0) = CHR$(3) + CHR$(1)
      UsePattern = 0: UseRow = 0: UseChannel = 0
      DO
        Init$ = GetInput("Init delay:", "0123456789", "1", 3)
        InitDelay = VAL(Init$)
      LOOP UNTIL InitDelay
    END IF
  ELSEIF A$ = CHR$(22) THEN
    FOR Patt = 0 TO 63
      FOR Ch = 0 TO 15
        Pattern(UsePattern, Patt, Ch) = TempPattern(Patt, Ch)
        Effect(UsePattern, Patt, Ch) = TempEffect(Patt, Ch)
      NEXT
    NEXT
  ELSEIF A$ = CHR$(27) THEN
    YN$ = GetInput("Are you sure you want to quit? All data will be lost.", "YN", "N", 1)
    IF YN$ = "Y" THEN QUIT = -1
  ELSEIF A$ = "L" THEN
    File$ = GetInput("File to load:", FileASCIIz, LastFile$, 8)
    COLOR 8, 0
    IF File$ > "" THEN LoadTrack File$
    LastFile$ = File$
  ELSEIF A$ = "S" THEN
    File$ = GetInput("File to save:", FileASCIIz, LastFile$, 8)
    IF File$ > "" THEN
       Songname = GetInput("Songtitle:", StandardASCIIz, RTRIM$(Songname), 80)
       Copyright = GetInput("Copyright:", StandardASCIIz, RTRIM$(Copyright), 40)
       MaxChannels = VAL(GetInput("Save channels 0 to", "0123456789", "15", 2))
       DO
         Init$ = GetInput("Init delay:", "0123456789", LTRIM$(STR$(InitDelay)), 3)
         InitDelay = VAL(Init$)
       LOOP UNTIL InitDelay
       COLOR 8, 0
       SaveTrack File$, MaxChannels
       LastFile$ = File$
    END IF
    COLOR 8, 0
  END IF
  IF A$ = CHR$(0) + CHR$(72) THEN UseRow = UseRow - 1: IF UseRow < 0 THEN UseRow = 0
  IF A$ = CHR$(0) + CHR$(73) THEN UseRow = 0
  IF A$ = CHR$(0) + CHR$(75) THEN UseChannel = UseChannel - 1: IF UseChannel < 0 THEN UseChannel = 0
  IF A$ = CHR$(0) + CHR$(77) THEN UseChannel = UseChannel + 1: IF UseChannel > 15 THEN UseChannel = 15
  IF A$ = CHR$(0) + CHR$(79) AND MaxPatterns > 0 THEN MaxPatterns = MaxPatterns - 1
  IF A$ = CHR$(0) + CHR$(80) THEN UseRow = UseRow + 1: IF UseRow > 63 THEN UseRow = 63
  IF A$ = CHR$(0) + CHR$(81) THEN UseRow = 63
  IF A$ = CHR$(0) + CHR$(82) THEN AddPattern
  IF A$ = CHR$(0) + CHR$(83) THEN Pattern(UsePattern, UseRow, UseChannel) = 128: Effect(UsePattern, UseRow, UseChannel) = STRING$(2, 0)
  IF A$ = "+" THEN UsePattern = UsePattern + 1: IF UsePattern > MaxPatterns THEN UsePattern = MaxPatterns
  IF A$ = "-" THEN UsePattern = UsePattern - 1: IF UsePattern < 0 THEN UsePattern = 0

  IF Editmode = NORMAL THEN
    IF A$ = "#" AND Pattern(UsePattern, UseRow, UseChannel) < 127 THEN Pattern(UsePattern, UseRow, UseChannel) = Pattern(UsePattern, UseRow, UseChannel) + 1: MidiNote Pattern(UsePattern, UseRow, UseChannel), CurrentVolume(UseChannel), UseChannel
    IF A$ = "C" THEN Pattern(UsePattern, UseRow, UseChannel) = 48: MidiNote Pattern(UsePattern, UseRow, UseChannel), CurrentVolume(UseChannel), UseChannel
    IF A$ = "D" THEN Pattern(UsePattern, UseRow, UseChannel) = 50: MidiNote Pattern(UsePattern, UseRow, UseChannel), CurrentVolume(UseChannel), UseChannel
    IF A$ = "E" THEN Pattern(UsePattern, UseRow, UseChannel) = 52: MidiNote Pattern(UsePattern, UseRow, UseChannel), CurrentVolume(UseChannel), UseChannel
    IF A$ = "F" THEN Pattern(UsePattern, UseRow, UseChannel) = 53: MidiNote Pattern(UsePattern, UseRow, UseChannel), CurrentVolume(UseChannel), UseChannel
    IF A$ = "G" THEN Pattern(UsePattern, UseRow, UseChannel) = 55: MidiNote Pattern(UsePattern, UseRow, UseChannel), CurrentVolume(UseChannel), UseChannel
    IF A$ = "A" THEN Pattern(UsePattern, UseRow, UseChannel) = 57: MidiNote Pattern(UsePattern, UseRow, UseChannel), CurrentVolume(UseChannel), UseChannel
    IF A$ = "B" THEN Pattern(UsePattern, UseRow, UseChannel) = 59: MidiNote Pattern(UsePattern, UseRow, UseChannel), CurrentVolume(UseChannel), UseChannel
    IF A$ >= "0" AND A$ <= "9" THEN
      Octave = (Pattern(UsePattern, UseRow, UseChannel) - (Pattern(UsePattern, UseRow, UseChannel) MOD 12)) / 12
      ToDo = VAL(A$)
      IF ToDo < Octave THEN
        DO
          Pattern(UsePattern, UseRow, UseChannel) = Pattern(UsePattern, UseRow, UseChannel) - 12
          Octave = (Pattern(UsePattern, UseRow, UseChannel) - (Pattern(UsePattern, UseRow, UseChannel) MOD 12)) / 12
        LOOP UNTIL ToDo = Octave
      ELSEIF ToDo > Octave THEN
        DO
          Pattern(UsePattern, UseRow, UseChannel) = Pattern(UsePattern, UseRow, UseChannel) + 12
          Octave = (Pattern(UsePattern, UseRow, UseChannel) - (Pattern(UsePattern, UseRow, UseChannel) MOD 12)) / 12
        LOOP UNTIL ToDo = Octave
      END IF
      MidiNote Pattern(UsePattern, UseRow, UseChannel), CurrentVolume(UseChannel), UseChannel
    END IF
  ELSE
    IF A$ = "I" THEN
      IF LEFT$(Effect(UsePattern, UseRow, UseChannel), 1) = CHR$(1) THEN Vorlage = ASC(RIGHT$(Effect(UsePattern, UseRow, UseChannel), 1)) ELSE Vorlage = 0
      Temp$ = GetInput("New instrument (0 to 127):", "0123456789", LTRIM$(STR$(Vorlage)), 3)
      NewIns = VAL(Temp$)
      IF Temp$ > "" AND NewIns < 128 THEN
        CurrentInstrument(UseChannel) = NewIns
        Effect(UsePattern, UseRow, UseChannel) = CHR$(1) + CHR$(NewIns)
        MidiInstrument UseChannel, CurrentInstrument(UseChannel)
      END IF
    ELSEIF A$ = "V" THEN
      IF LEFT$(Effect(UsePattern, UseRow, UseChannel), 1) = CHR$(2) THEN Vorlage = ASC(RIGHT$(Effect(UsePattern, UseRow, UseChannel), 1)) ELSE Vorlage = 127
      Temp$ = GetInput("Set volume to (0 to 127):", "0123456789", LTRIM$(STR$(Vorlage)), 3)
      NewVol = VAL(Temp$)
      IF Temp$ > "" AND NewVol < 128 THEN
        CurrentVolume(UseChannel) = NewVol
        Effect(UsePattern, UseRow, UseChannel) = CHR$(2) + CHR$(NewVol)
      END IF
    ELSEIF A$ = "P" THEN
      IF LEFT$(Effect(UsePattern, UseRow, UseChannel), 1) = CHR$(3) THEN Vorlage = ASC(RIGHT$(Effect(UsePattern, UseRow, UseChannel), 1)) ELSE Vorlage = 1
      Temp$ = GetInput("Set delay to (1 = 1ms, 10 = 1 sec):", "0123456789", LTRIM$(STR$(Vorlage)), 3)
      NewDel = VAL(Temp$)
      IF Temp$ > "" AND NewDel > 0 THEN
        CurrentDelay = NewDel / 10
        Effect(UsePattern, UseRow, UseChannel) = CHR$(3) + CHR$(NewDel)
      END IF
    ELSEIF A$ = "R" THEN
      Effect(UsePattern, UseRow, UseChannel) = CHR$(4) + "-"
    ELSEIF A$ = "J" THEN
      IF LEFT$(Effect(UsePattern, UseRow, UseChannel), 1) = CHR$(5) THEN Vorlage = ASC(RIGHT$(Effect(UsePattern, UseRow, UseChannel), 1)) ELSE Vorlage = 0
      Temp$ = GetInput("Jump to pattern", "0123456789", LTRIM$(STR$(Vorlage)), 3)
      NewJmp = VAL(Temp$)
      IF Temp$ > "" AND NewJmp <= MaxPatterns THEN Effect(UsePattern, UseRow, UseChannel) = CHR$(5) + CHR$(NewJmp) ELSE Temp$ = GetInput("Invalid pattern! Hit ENTER to continue.", "", "", 0)
    ELSEIF A$ = "C" THEN
      Effect(UsePattern, UseRow, UseChannel) = CHR$(6) + "-"
    ELSEIF A$ = "B" THEN
      Effect(UsePattern, UseRow, UseChannel) = CHR$(7) + "-"
    END IF
  END IF
  IF A$ <> "" THEN ShowPatt
END SUB

FUNCTION GetInput$ (Mes$, Valid$, Example$, MaxLen)
DoInput = 1
COLOR 15, 0
LOCATE 9, 1: PRINT SPACE$(80)
LOCATE 9, 1: PRINT Mes$; " ";
START = POS(0)
LOCATE , , 1
In$ = Example$
Valid$ = UCASE$(Valid$)
PRINT In$;
DO
 A$ = INKEY$
 IF A$ = CHR$(8) AND LEN(In$) > 0 THEN
   In$ = LEFT$(In$, LEN(In$) - 1)
   LOCATE 9, START + LEN(In$): PRINT " ";
   LOCATE 9, START + LEN(In$)
 END IF
 IF A$ <> "" AND MaxLen > 1 THEN
   IF INSTR(Valid$, UCASE$(A$)) AND LEN(In$) < MaxLen AND POS(0) < 80 THEN In$ = In$ + A$: LOCATE 9, START: PRINT In$;
 ELSEIF A$ <> "" AND MaxLen = 1 THEN
   IF INSTR(Valid$, UCASE$(A$)) THEN In$ = UCASE$(A$): LOCATE 9, START: PRINT In$;
 END IF
LOOP UNTIL A$ = CHR$(13)
LOCATE , , 0
LOCATE 9, 1: PRINT SPACE$(80)
DoInput = 0
FadeX = 0
GetInput$ = In$
END FUNCTION

SUB InitMessage (Text$)
  IF FadeDone = 0 THEN EXIT SUB
  LOCATE 9, 1: COLOR , 0: PRINT SPACE$(80)
  FadeMessage$ = Text$ + SPACE$(15)
  FadeX = 0
  FadeDone = 0
  FadeDir = 0
END SUB

SUB InitScreen
SCREEN 0: WIDTH 80, 25: COLOR 0, 1: CLS

PALETTE
ChangePal 0

COLOR 15, 1
LOCATE 1, 24: PRINT "T"
LOCATE 2, 2: PRINT "    R"
LOCATE 3, 2: PRINT "        A"
LOCATE 4, 2: PRINT "        C"
LOCATE 5, 2: PRINT "      K"
LOCATE 6, 2: PRINT " E"
LOCATE 7, 2: PRINT "1.0 R"

COLOR 15, 0
LOCATE 2, 28: PRINT " +/-    Change pattern      L       Load Song     "
LOCATE 3, 28: PRINT " *      Change viewmode     S       Save Song     "
LOCATE 4, 28: PRINT " INS    Insert pattern      CTRL+C  Copy Pattern  "
LOCATE 5, 28: PRINT " DEL    Delete note/effect  CTRL+V  Paste Pattern "
LOCATE 6, 28: PRINT " ENTER  Play                END     Delete last   "
LOCATE 7, 28: PRINT " CTRL+N New Song                    pattern       "
FOR X = 2 TO 7
  COLOR 7, 0
  FOR Y = 36 TO 53
    LOCATE X, Y: PRINT CHR$(SCREEN(X, Y));
  NEXT
  FOR Y = 65 TO 77
    LOCATE X, Y: PRINT CHR$(SCREEN(X, Y));
  NEXT
  COLOR 8: LOCATE X, 55: PRINT ""
NEXT

COLOR 8, 0
FOR X = 12 TO 22
  FOR Y = 5 TO 75 STEP 5
    LOCATE X, Y: PRINT ""
  NEXT
  LOCATE X, 80: PRINT " "
NEXT
COLOR 15, 1: LOCATE 8, 1: PRINT "Messages:"
COLOR 0: LOCATE 25, 58: PRINT "(c) 2004 by Saga-Games";
FadeDone = 1
InitMessage "Welcome to the MIDI Tracker 1.0!"
END SUB

SUB LoadTrack (File$)
OPEN File$ + ".MTR" FOR BINARY AS #1
  IF LOF(1) = 0 THEN CLOSE #1: KILL File$ + ".MTR": EXIT SUB
  GET #1, , ID$: IF ID$ <> "MidiTracker 1.0" THEN CLOSE #1: EXIT SUB
  GET #1, , Songname: GET #1, , Copyright
  GET #1, , MaxPatterns
  GET #1, , Channel
  GET #1, , InitDelay
  REDIM Pattern(0 TO MaxPatterns, 0 TO 63, 0 TO 15) AS INTEGER
  REDIM Effect(0 TO MaxPatterns, 0 TO 63, 0 TO 15)  AS STRING * 2
  FOR Patt = 0 TO MaxPatterns
    Lenght = (Channel + 1) * 64 * 3
    Track$ = SPACE$(Lenght): GET #1, , Track$
    TempPos = -2
    FOR MakeRow = 0 TO 63
      FOR Ch = 0 TO Channel
        TempPos = TempPos + 3
        Pattern(Patt, MakeRow, Ch) = ASC(MID$(Track$, TempPos, 1))
        Effect(Patt, MakeRow, Ch) = MID$(Track$, TempPos + 1, 2)
      NEXT
      FOR Ch = Channel + 1 TO 15
        Pattern(Patt, MakeRow, Ch) = 128
        Effect(Patt, MakeRow, Ch) = CHR$(0)
      NEXT
    NEXT
  NEXT
  FOR Ch = 0 TO 15
    CurrentInstrument(Ch) = 0
    CurrentVolume(Ch) = 127
    MidiInstrument Ch, 0
  NEXT
  UsePattern = 0: UseRow = 0: UseChannel = 0: RestartPattern = 0
  CurrentDelay = InitDelay / 10
CLOSE #1
END SUB

SUB MidiInit
 FOR Temp = 255 TO 0 STEP -1
  OUT MidiPort% + 1, Temp + 2
 NEXT Temp
END SUB

SUB MidiInstrument (Kanal%, Instrument%)
 OUT MidiPort%, &HC0 + Kanal%
 OUT MidiPort%, Instrument%
END SUB

SUB MidiNote (Note%, Volume%, Kanal%)
 IF Note% = 128 THEN EXIT SUB
 OUT MidiPort%, &H90 + Kanal%
 OUT MidiPort%, Note%
 OUT MidiPort%, Volume%
END SUB

SUB MidiReset
 OUT (MidiPort%), &HFF
END SUB

FUNCTION NoteName$ (Nmbr%)

 Notes = Nmbr% MOD 12
 SELECT CASE Notes
  CASE 0: Temp$ = "C"
  CASE 1: Temp$ = "C#"
  CASE 2: Temp$ = "D"
  CASE 3: Temp$ = "D#"
  CASE 4: Temp$ = "E"
  CASE 5: Temp$ = "F"
  CASE 6: Temp$ = "F#"
  CASE 7: Temp$ = "G"
  CASE 8: Temp$ = "G#"
  CASE 9: Temp$ = "A"
  CASE 10: Temp$ = "A#"
  CASE 11: Temp$ = "B"
 END SELECT
 Octave = (Nmbr% - Notes) / 12
 NoteName$ = Temp$ + LTRIM$(STR$(Octave))
 IF Nmbr% = 128 THEN NoteName$ = "----"
END FUNCTION

SUB PlayRow
STATIC PlayTmr!
 
  IF TIMER > PlayTmr! + CurrentDelay OR TIMER < PlayTmr! THEN

ChangePattern:
  ShowPatt
  FOR Ch = 0 TO 15
    SELECT CASE ASC(LEFT$(Effect(UsePattern, UseRow, Ch), 1))
      CASE 1
        CurrentInstrument(Ch) = ASC(RIGHT$(Effect(UsePattern, UseRow, Ch), 1))
        MidiInstrument Ch, CurrentInstrument(Ch)
      CASE 2
        CurrentVolume(Ch) = ASC(RIGHT$(Effect(UsePattern, UseRow, Ch), 1))
      CASE 3
        CurrentDelay = ASC(RIGHT$(Effect(UsePattern, UseRow, Ch), 1)) / 10
      CASE 4
        RestartPattern = UsePattern
      CASE 5
        OrigPatt = UsePattern
        UsePattern = ASC(RIGHT$(Effect(UsePattern, UseRow, Ch), 1))
        IF UsePattern > MaxPatterns THEN UsePattern = OrigPatt: DoJumping = 0 ELSE DoJumping = 1
      CASE 6
        FOR XNote% = 1 TO 127
          MidiNote XNote%, 0, Ch
        NEXT
      CASE 7
        DoBreak = 1
    END SELECT
    MidiNote Pattern(UsePattern, UseRow, Ch), CurrentVolume(Ch), Ch
  NEXT
  IF DoJumping = 1 THEN UseRow = 0: EXIT SUB
  IF DoBreak = 1 THEN
    UsePattern = UsePattern + 1: UseRow = 0
    IF UsePattern > MaxPatterns THEN UsePattern = RestartPattern: EXIT SUB ELSE EXIT SUB
  END IF
  UseRow = UseRow + 1
  IF UseRow > 63 THEN
    UseRow = 0: UsePattern = UsePattern + 1
    IF UsePattern > MaxPatterns THEN UsePattern = RestartPattern
  END IF

  PlayTmr! = TIMER
  END IF
END SUB

SUB SaveTrack (File$, Channels)
ID = "MidiTracker 1.0"
OPEN File$ + ".MTR" FOR OUTPUT AS #1: CLOSE #1
OPEN File$ + ".MTR" FOR BINARY AS #1
  PUT #1, , ID
  PUT #1, , Songname
  PUT #1, , Copyright
  PUT #1, , MaxPatterns
  PUT #1, , Channels
  PUT #1, , InitDelay

  FOR Patt = 0 TO MaxPatterns
    Track$ = ""
    FOR SaveRow = 0 TO 63
      FOR Ch = 0 TO Channels
        Track$ = Track$ + CHR$(Pattern(Patt, SaveRow, Ch)) + Effect(Patt, SaveRow, Ch)
      NEXT
    NEXT
    PUT #1, , Track$
  NEXT
CLOSE #1
END SUB

SUB ShowPatt
Z = 11
FOR ShowRow = UseRow - 5 TO UseRow + 5
  Z = Z + 1
  FOR Ch = 0 TO 15
    COLOR 15, 1: LOCATE 11, Ch * 5 + 1
    Cur$ = LTRIM$(STR$(CurrentInstrument(Ch)))
    IF LEN(Cur$) = 1 THEN Cur$ = "0" + Cur$
    IF LEN(Cur$) = 2 THEN Cur$ = "0" + Cur$
    IF Ch <> 9 THEN PRINT " "; Cur$;  ELSE PRINT "DRUM";
    LOCATE Z, Ch * 5 + 1
    IF ShowRow >= 0 AND ShowRow <= 63 THEN
      COLOR 8, 0: LOCATE Z, Ch * 5 + 1: PRINT "----"
      IF ShowRow = UseRow THEN
        IF Ch = UseChannel THEN COLOR 15 ELSE COLOR 7
      ELSE
        COLOR 8
      END IF
      LOCATE Z, Ch * 5 + 1: PRINT "    "; : LOCATE Z, Ch * 5 + 1
      IF Editmode = NORMAL THEN
        PRINT NoteName$(Pattern(UsePattern, ShowRow, Ch));
      ELSE
        IF ASC(LEFT$(Effect(UsePattern, ShowRow, Ch), 1)) > 0 THEN PRINT "    "
        LOCATE Z, Ch * 5 + 1
        SELECT CASE ASC(LEFT$(Effect(UsePattern, ShowRow, Ch), 1))
          CASE 0
            PRINT "----";
          CASE 1
            PRINT "I"; LTRIM$(STR$(ASC(RIGHT$(Effect(UsePattern, ShowRow, Ch), 1))));
          CASE 2
            PRINT "V"; LTRIM$(STR$(ASC(RIGHT$(Effect(UsePattern, ShowRow, Ch), 1))));
          CASE 3
            PRINT "P"; LTRIM$(STR$(ASC(RIGHT$(Effect(UsePattern, ShowRow, Ch), 1))));
          CASE 4
            PRINT "RES";
          CASE 5
            PRINT "JMP"; LTRIM$(STR$(ASC(RIGHT$(Effect(UsePattern, ShowRow, Ch), 1))));
          CASE 6
            PRINT "CLR";
          CASE 7
            PRINT "BRK"; CHR$(26);
        END SELECT
      END IF
    ELSE
      COLOR 8, 0: LOCATE Z, Ch * 5 + 1: PRINT "    ";
    END IF
  NEXT
NEXT
COLOR 15, 1: LOCATE 24, 2: PRINT "Delay:"; CurrentDelay, "Pattern"; UsePattern; "/"; MaxPatterns;
Row$ = LTRIM$(STR$(UseRow)): IF LEN(Row$) = 1 THEN Row$ = "0" + Row$
PRINT "     Row: "; Row$;
PRINT "          Viewmode: ";
IF Editmode = NORMAL THEN PRINT "Notes    ";  ELSE PRINT "Effects    ";
COLOR , 0
END SUB

