uniform sampler2D texture;
uniform float time = 1.0;
uniform float speedX = 1.0;
uniform float speedY = 1.0;
uniform float video = 0.0;

void main()
{
	vec2 uv = gl_TexCoord[0].xy;
    
    float y = mod(-time / 4., 1.9) - 0.4;
    float str = -pow((uv.y - y) * 10., 2.) + .8;
    uv.x -= clamp(str * .02, 0., 1.);
    gl_FragColor = texture2D(texture, uv); 
    
    float colorAdd = pow(1. - pow(abs(uv.y - y), .3), 3.);
    gl_FragColor.r += colorAdd * .25;
    gl_FragColor.b += colorAdd * 0.5;
}