/* eslint-disable require-jsdoc*/
/* eslint-disable no-undef*/
(function libraryWrapper(window) {
  function defineLibrary() {
    const ColorListFiltersLib = {};
    const ConnectionType = FilterLib.ConnectionType;

    ColorListFiltersLib.RandomColorListFilter = class RandomColorListFilter extends FilterLib.Filter {
      constructor() {
        super('RandomColorList', 0, 1, ConnectionType.ColorArray, 1);
        this.mFragSourceFile = undefined;
        this.mVertSourceFile = undefined;
        this.mIsTriggerFilter = true;
        this.setColors();
      }
      triggerFilter(trigger) {
        if (trigger) this.setColors();
      }
      setColors() {
        const colorlistcount = 2 + Math.floor(8.0 * this.mScalars[0]);
        this.mColorlistOutput = [];
        for (let i = 0; i < colorlistcount; i++) {
          this.mColorlistOutput.push(Math.random());
          this.mColorlistOutput.push(Math.random());
          this.mColorlistOutput.push(Math.random());
          this.mColorlistOutput.push(1.0);
        }
      }
    };

    ColorListFiltersLib.MedianCutColorListFilter = class MedianCutColorListFilter extends FilterLib.Filter {
      constructor() {
        // under construction xxx bug not finished
        super('MedianCutColorList', 1, 1, ConnectionType.ColorArray, 1);
        this.mFragSourceFile = undefined;
        this.mVertSourceFile = undefined;
        // this.setColors();
        this.mTrigger = false;
        this.updateInProgress = false;
        this.mIsTriggerFilter = true;
        this.mIsSizeFilter = true;
        this.mIsStartFilter = true;
      }
      triggerFilter(trigger, gl) {
        if (this.mTrigger === trigger) return;
        this.mTrigger = trigger;
        if (trigger === false) return;
        if (this.updateInProgress) return;
        this.updateInProgress = true;
       // Log.e(TAG,"Triggered ");
        this.getColors(gl);
      }

      setColors(colorList) {
        if (colorList === undefined) {
          const colorlistcount = 2 + Math.floor(8.0 * this.mScalars[0]);
          this.mColorlistOutput = [];
          for (let i = 0; i < colorlistcount; i++) {
            this.mColorlistOutput.push(Math.random());
            this.mColorlistOutput.push(Math.random());
            this.mColorlistOutput.push(Math.random());
            this.mColorlistOutput.push(1.0);
          }
        } else {
          for (let i = 0; i < colorList.length / 4; i++) {
            const offset = i * 4;
            this.mColorlistOutput[offset + 0] = colorList[offset] / 255.0;
            this.mColorlistOutput[offset + 1] = colorList[offset + 1] / 255.0;
            this.mColorlistOutput[offset + 2] = colorList[offset + 2] / 255.0;
            this.mColorlistOutput[offset + 3] = 1.0;
          }
          this.textureUpdate = false;
          this.updateInProgress = false;
        }
      }

      getColors(gl) {
        const b = new Uint8Array(4 * this.mWidth * this.mHeight);
        gl.readPixels(0, 0, this.mWidth, this.mHeight, gl.RGBA, gl.UNSIGNED_BYTE, b);
        const t = 1 + Math.floor(this.mScalars[0] * 4);
        const colormax = Math.floor(t * t);
        console.log(`width ${this.mWidth} height ${this.mHeight}`);
        const getcolors = MedianCutLib.getColors(b, this.mHeight * this.mWidth, colormax);
        this.setColors(getcolors, colormax);
        this.textureUpdate = true;
      }
    };

    ColorListFiltersLib.FaceDetectFilter = class FaceDetectFilter extends FilterLib.Filter {
      constructor() {
        // under construction xxx bug not finished
        super('FaceDetect', 1, 1, ConnectionType.ColorArray);
        this.mFragSourceFile = 'mpgrayscalefrag';
        this.mVertSourceFile = 'mpemptytvert';
        // this.setColors();
        this.mTrigger = false;
        this.updateInProgress = false;
        this.canvas = document.createElement('canvas');
        this.upsidedowncanvas = document.createElement('canvas');
        this.numfaces = 0;
        this.faces = [0, 0, 0, 0,
          0, 0, 0, 0,
          0, 0, 0, 0,
          0, 0, 0, 0,
          0, 0, 0, 0];
        this.counter = 0;
        this.mIsTriggerFilter = true;
        this.mIsSizeFilter = true;
        this.mIsStartFilter = true;
        this.mIsSpecialRenderer = true;
      }
      setSize(w, h) {
        if (this.mWidth !== w || this.mHeight !== h) {
          this.canvas.width = w;
          this.canvas.height = h;
          this.upsidedowncanvas.width = w;
          this.upsidedowncanvas.height = h;
          this.mWidth = w;
          this.mHeight = h;
          console.log(`canvas changed ${w} ${h}`);
        }
      }

      triggerFilter(trigger, gl) {
        if (this.mTrigger === trigger) return;
        this.mTrigger = trigger;
        if (trigger === false) return;
        if (this.updateInProgress) return;
        this.updateInProgress = true;
       // Log.e(TAG,"Triggered ");
        this.getColors(gl);
        // this.mColorListCount = 1;
        this.mColorlistOutput = this.faces;
      }

      poll(gl) {
        const w = this.canvas.width;
        const h = this.canvas.height;

        console.log(`this.canvas ${w} ${h}`);
        // const canvas = document.createElement('canvas');
        // canvas.width = w;
        // canvas.height = h;
        // const ctx = canvas.getContext('2d');
        // ctx.drawImage(this.canvas, 0, 0, w, h);
        console.log(`cascade ${cascade}`);
        const comp = ccv.detect_objects({ canvas: this.canvas,
          cascade,
          interval: 5,
          min_neighbors: 1 });
    /* draw detected area */
    /*
        localCanvas.width = this.canvas.width;
        localCanvas.height = this.canvas.height;

        const ctx2 = localCanvas.getContext('2d');
        ctx2.lineWidth = 2;
        ctx2.lineJoin = 'round';
        ctx2.clearRect(0, 0, localCanvas.width, localCanvas.height);
        ctx2.drawImage(this.canvas, 0, 0, localCanvas.width, localCanvas.height);
        */
        let x_offset = 0,
          y_offset = 0,
          x_scale = 1,
          y_scale = 1;
        if (this.canvas.width * this.canvas.height > this.canvas.width * this.canvas.height) {
          x_offset = (this.canvas.width - this.canvas.height *
                  this.canvas.width / this.canvas.height) / 2;
        } else {
          y_offset = (this.canvas.height - this.canvas.width *
                  this.canvas.height / this.canvas.width) / 2;
        }
        x_scale = (this.canvas.width - x_offset * 2) / this.canvas.width;
        y_scale = (this.canvas.height - y_offset * 2) / this.canvas.height;

        for (let i = 0; i < comp.length; i++) {
          console.log(comp[i]);
          const x = comp[i].x * x_scale + x_offset;
          const y = comp[i].y * y_scale + y_offset;
          const width = comp[i].width * x_scale;
          const height = comp[i].height * y_scale;

          let opacity = 0.1;
          if (comp[i].confidence > 0) {
            opacity += comp[i].confidence / 10;
            if (opacity > 1.0) opacity = 1.0;
          }

      // ctx2.strokeStyle = "rgba(255,0,0," + opacity * 255 + ")";
/*
          ctx2.lineWidth = opacity * 10;
          ctx2.strokeStyle = 'rgb(255,0,0)';
          // ctx2.strokeRect(comp[i].x, comp[i].y, comp[i].width, comp[i].height);
          ctx2.beginPath();
          ctx2.ellipse(x + (width / 2), y + (height / 2), width / 2, height / 2, 0, 0, Math.PI * 2);
          ctx2.stroke();
          */
          const o0 = i * 8;
          this.coordinates[o0] = (((x) / this.canvas.width) - 0.5) * 2;
          this.coordinates[o0 + 1] = (1 - ((y) / this.canvas.height) - 0.5) * 2;
          this.coordinates[o0 + 2] = (((x + (width)) / this.canvas.width) - 0.5) * 2;
          this.coordinates[o0 + 3] = (1 - ((y) / this.canvas.height) - 0.5) * 2;
          this.coordinates[o0 + 4] = (((x + (width)) / this.canvas.width) - 0.5) * 2;
          this.coordinates[o0 + 5] = (1 - ((y + (height)) / this.canvas.height) - 0.5) * 2;
          this.coordinates[o0 + 6] = (((x) / this.canvas.width) - 0.5) * 2;
          this.coordinates[o0 + 7] = (1 - ((y + (height)) / this.canvas.height) - 0.5) * 2;

          const o1 = i * 4;
          this.faces[o1] = x / this.canvas.width;
          this.faces[o1 + 1] = 1.0 - ((y + height) / this.canvas.height);
          this.faces[o1 + 2] = width / this.canvas.width;
          this.faces[o1 + 3] = (height / this.canvas.height);
        }

        if (comp.length > 0) {
          this.numfaces = comp.length;
          this.updateCoordinates(gl);
          this.mColorlistOutput = [];
          console.log(`feces${comp.length}`);
          for (let i = 0; i < comp.length; i++) {
            console.log(comp[i]);
            // const list = [];
            const o = i * 4;
            this.mColorlistOutput.push(this.faces[o]);
            this.mColorlistOutput.push(this.faces[o + 1]);
            this.mColorlistOutput.push(this.faces[o + 2]);
            this.mColorlistOutput.push(this.faces[o + 3]);
            // this.mColorlistOutput.push(list);
          }
        }
        // setTimeout(poll, 1000);
      }

      getColors(gl) {
        if (this.mWidth !== undefined) {
          const b = new Uint8Array(4 * this.mWidth * this.mHeight);
          console.log('get colors');
          gl.readPixels(0, 0, this.mWidth, this.mHeight, gl.RGBA, gl.UNSIGNED_BYTE, b);
          console.log(`width ${this.mWidth} height ${this.mHeight}`);
          const ctx = this.upsidedowncanvas.getContext('2d');

          ctx.putImageData(new ImageData(new Uint8ClampedArray(b), this.mWidth, this.mHeight), 0, 0);
          const ctx2 = this.canvas.getContext('2d');
          ctx2.scale(1, -1);
          ctx2.drawImage(this.upsidedowncanvas, 0, 0, this.mWidth, this.mHeight * -1);
          this.poll(gl);
        }
        this.textureUpdate = false;
        this.updateInProgress = false;
      }

      render(gl) {
        this.counter++;
        if (this.counter > 10) {
          this.counter = 0;
          this.getColors(gl);
        }
        // console.log('Rendel');
        // gl.useProgram(this.mProgram);
        // gl.bindBuffer(gl.ARRAY_BUFFER, this.vbuffer);
        // gl.enableVertexAttribArray(this.mProgram.position);
        // gl.vertexAttribPointer(this.mProgram.position, 2, gl.FLOAT, false, 4 * 2, this.vbuffer);

        // gl.uniform1i(this.mProgram.uOn, 1);
        // console.log(`faces ${this.numfaces}`);
        // for (let i = 0; i < this.numfaces; i++) { gl.drawArrays(gl.TRIANGLE_FAN, 4 * i, 4); }
      }

      startFilter(gl, p) {
        console.log('Startfilter');
        // p.texCoordinate = gl.getAttribLocation(program, 'texCoordinate');
        // gl.useProgram(p);
        // p.uFaceCount = gl.getUniformLocation(p, 'uFaceCount');
        // p.uFaces = gl.getUniformLocation(p, 'uFaces');
        const program = ShaderLib.makeProgram(gl, 'mpvoidvert',
        'mpblackfrag');
        gl.useProgram(program);
        program.position = gl.getAttribLocation(program, 'position');
        // program.texCoordinate = gl.getAttribLocation(program, 'texCoordinate');
        program.uOn = gl.getUniformLocation(program, 'uOn');
        // program.uFaceCount = gl.getUniformLocation(program, 'uFaceCount');
        // program.uFaces = gl.getUniformLocation(program, 'uFaces');
        this.mProgram = program;

        const vbuffer = gl.createBuffer();
        this.coordinates = [0, 0, 0, 0, 0, 0, 0,
          0, 0, 0, 0, 0, 0, 0, 0,
          0, 0, 0, 0, 0, 0, 0, 0,
          0, 0, 0, 0, 0, 0, 0, 0];

        gl.bindBuffer(gl.ARRAY_BUFFER, vbuffer);
        gl.bufferData(gl.ARRAY_BUFFER, new Float32Array(this.coordinates), gl.STATIC_DRAW);
        this.vbuffer = vbuffer;
        this.counter = 0;
        this.mWidth = 100;
        this.mHeight = 100;
      }

/*
      isSetUniformsFilter() {
        return true;
      }

      setUniforms(gl, program) {
        gl.useProgram(program);
        gl.uniform1i(program.uFaceCount, this.numfaces);
        gl.uniform4fv(program.uFaces, this.faces);
      }
*/

      updateCoordinates(gl) {
  // this.vbuffer.position(0);
  // this.vbuffer.put(this.coordinates);
  // this.vbuffer.position(0);
        gl.bindBuffer(gl.ARRAY_BUFFER, this.vbuffer);
        gl.bufferData(gl.ARRAY_BUFFER, new Float32Array(this.coordinates), gl.STATIC_DRAW);
      }

};

    ColorListFiltersLib.PastelColorListFilter = class PastelColorListFilter extends FilterLib.Filter {
      constructor() {
        super('PastelColorList', 0, 1, ConnectionType.ColorArray, 1);
        this.mFragSourceFile = undefined;
        this.mVertSourceFile = undefined;
        this.mIsTriggerFilter = true;
        this.setColors();
      }

      triggerFilter(trigger) {
        if (trigger) this.setColors();
      }

      setColors() {
        const colorlistcount = 2 + Math.floor(8.0 * this.mScalars[0]);
        this.mColorlistOutput = [];
        for (let i = 0; i < colorlistcount; i++) {
          this.mColorlistOutput.push((Math.random() / 3.0) + 0.5);
          this.mColorlistOutput.push((Math.random() / 3.0) + 0.5);
          this.mColorlistOutput.push((Math.random() / 3.0) + 0.5);
          this.mColorlistOutput.push(1.0);
        }
      }
    };

    ColorListFiltersLib.RGBYColorListFilter = class RGBYColorListFilter extends FilterLib.Filter {
      constructor() {
        super('RGBYColorList', 0, 1, ConnectionType.ColorArray);
        this.mFragSourceFile = undefined;
        this.mVertSourceFile = undefined;
        this.setColors();
      }

      setColors() {
        this.mColorlistOutput = [];
        this.mColorlistOutput.push(1.0);
        this.mColorlistOutput.push(0.0);
        this.mColorlistOutput.push(0.0);
        this.mColorlistOutput.push(1.0);

        this.mColorlistOutput.push(0.0);
        this.mColorlistOutput.push(1.0);
        this.mColorlistOutput.push(0.0);
        this.mColorlistOutput.push(1.0);

        this.mColorlistOutput.push(0.0);
        this.mColorlistOutput.push(0.0);
        this.mColorlistOutput.push(1.0);
        this.mColorlistOutput.push(1.0);

        this.mColorlistOutput.push(1.0);
        this.mColorlistOutput.push(1.0);
        this.mColorlistOutput.push(0.0);
        this.mColorlistOutput.push(1.0);
      }
    };

    ColorListFiltersLib.FingerporiColorListFilter = class FingerporiColorListFilter extends FilterLib.Filter {
      constructor() {
        super('FingerporiColorList', 0, 1, ConnectionType.ColorArray);
        this.mFragSourceFile = undefined;
        this.mVertSourceFile = undefined;
        this.setColors();
      }

      setColors() {
        const fingerporicolors = [
          10, 5, 2,
          195, 130, 100,
          94, 114, 111,
          234, 224, 186,
          54, 40, 31,
          212, 199, 161,
          159, 136, 90,
          220, 238, 248,
          29, 28, 30,
          190, 183, 150,
          117, 140, 136,
          195, 224, 239,
          107, 66, 53,
          189, 205, 218,
          159, 180, 177,
          253, 252, 252,
          17, 17, 20,
          195, 167, 134,
          128, 118, 101,
          250, 234, 180,
          64, 71, 69,
          239, 208, 166,
          157, 150, 144,
          249, 250, 250,
          31, 37, 39,
          214, 183, 145,
          126, 175, 187,
          236, 237, 236,
          108, 92, 83,
          229, 211, 197,
          160, 203, 234,
          254, 255, 255
        ];
        this.mColorlistOutput = [];
        for (let i = 0; i < fingerporicolors.length / 3; i++) {
          const index = i * 3;
          this.mColorlistOutput.push(fingerporicolors[index] / 255.0);
          this.mColorlistOutput.push(fingerporicolors[index + 1] / 255.0);
          this.mColorlistOutput.push(fingerporicolors[index + 2] / 255.0);
          this.mColorlistOutput.push(1.0);
        }
      }
    };


    ColorListFiltersLib.WumoColorListFilter = class WumoColorListFilter extends FilterLib.Filter {
      constructor() {
        super('WumoColorList', 0, 1, ConnectionType.ColorArray);
        this.mFragSourceFile = undefined;
        this.mVertSourceFile = undefined;
        this.setColors();
      }

      setColors() {
        const palette = [
          /*
          33, 29, 28,
          245, 195, 150,
          162, 197, 178,
          253, 254, 251,
          96, 101, 124,
          245, 248, 237,
          222, 208, 183,
          0, 0, 0,
          121, 80, 69,
          237, 240, 239,
          204, 201, 198,
          0, 0, 0,
          174, 144, 138,
          252, 249, 233,
          223, 236, 231,
          0, 0, 0,
          62, 70, 63,
          245, 229, 205,
          190, 203, 200,
          0, 0, 0,
          129, 145, 150,
          242, 248, 253,
          221, 223, 234,
          0, 0, 0,
          154, 132, 79,
          250, 239, 220,
          205, 228, 226,
          0, 0, 0,
          178, 170, 162,
          253, 252, 242,
          223, 240, 252,
          255, 255, 255
          */

          0, 0, 0,
          11, 7, 9,
          0, 0, 0,
          41, 46, 55,
          0, 0, 1,
          19, 21, 29,
          3, 2, 5,
          62, 82, 110,
          0, 0, 0,
          18, 14, 16,
          0, 0, 0,
          71, 59, 56,
          0, 0, 0,
          38, 31, 31,
          6, 7, 11,
          147, 142, 143,
          0, 0, 0,
          12, 13, 17,
          0, 0, 0,
          46, 58, 69,
          0, 0, 1,
          19, 30, 47,
          3, 2, 9,
          93, 120, 145,
          0, 0, 0,
          33, 21, 18,
          2, 1, 2,
          93, 82, 76,
          1, 0, 1,
          37, 37, 45,
          4, 22, 45,
          208, 212, 217
        ];
        this.mColorlistOutput = [];
        for (let i = 0; i < palette.length / 3; i++) {
          const index = i * 3;
          this.mColorlistOutput.push(palette[index] / 255.0);
          this.mColorlistOutput.push(palette[index + 1] / 255.0);
          this.mColorlistOutput.push(palette[index + 2] / 255.0);
          this.mColorlistOutput.push(1.0);
        }
      }
    };

    ColorListFiltersLib.C64ColorListFilter = class C64ColorListFilter extends FilterLib.Filter {
      constructor() {
        super('C64ColorList', 0, 1, ConnectionType.ColorArray);
        this.mFragSourceFile = undefined;
        this.mVertSourceFile = undefined;
        this.setColors();
      }

      setColors() {
        const c64colors = [
          0, 0, 0,
          255, 255, 255,
          136, 0, 0,
          170, 255, 238,
          204, 68, 204,
          0, 204, 85,
          0, 0, 170,
          238, 238, 119,
          221, 136, 85,
          102, 68, 0,
          255, 119, 119,
          51, 51, 51,
          119, 119, 119,
          170, 255, 102,
          0, 136, 255,
          187, 187, 187];
        this.mColorlistOutput = [];
        for (let i = 0; i < c64colors.length / 3; i++) {
          const index = i * 3;
          this.mColorlistOutput.push(c64colors[index] / 255.0);
          this.mColorlistOutput.push(c64colors[index + 1] / 255.0);
          this.mColorlistOutput.push(c64colors[index + 2] / 255.0);
          this.mColorlistOutput.push(1.0);
        }
      }
    };

    ColorListFiltersLib.NESColorListFilter = class NESColorListFilter extends FilterLib.Filter {
      constructor() {
        super('NESColorList', 0, 1, ConnectionType.ColorArray);
        this.mFragSourceFile = undefined;
        this.mVertSourceFile = undefined;
        this.setColors();
      }

      setColors() {
        const c64colors = [
          124, 124, 124,
          0, 0, 252,
          0, 0, 188,
          68, 40, 188,
          148, 0, 132,
          168, 0, 32,
          168, 16, 0,
          136, 20, 0,
          80, 48, 0,
          0, 120, 0,
          0, 104, 0,
          0, 88, 0,
          0, 64, 88,
          0, 0, 0,
          0, 0, 0,
          0, 0, 0,
          188, 188, 188,
          0, 120, 248,
          0, 88, 248,
          104, 68, 252,
          216, 0, 204,
          228, 0, 88,
          248, 56, 0,
          228, 92, 16,
          172, 124, 0];
        this.mColorlistOutput = [];
        for (let i = 0; i < c64colors.length / 3; i++) {
          const index = i * 3;
          this.mColorlistOutput.push(c64colors[index] / 255.0);
          this.mColorlistOutput.push(c64colors[index + 1] / 255.0);
          this.mColorlistOutput.push(c64colors[index + 2] / 255.0);
          this.mColorlistOutput.push(1.0);
        }
      }
    };

    ColorListFiltersLib.ShiftColorListFilter = class ShiftColorListFilter extends FilterLib.Filter {
      constructor() {
        super('ShiftColorList', 0, 1, ConnectionType.ColorArray, 0, 0, 1);
        this.mFragSourceFile = undefined;
        this.mVertSourceFile = undefined;
        this.mIsCalculateFilter = true;
        // this.isOnOffFilter = true;
      }

      calculate() {
        this.mColorlistOutput = [];
        if (this.mColorLists[0].length / 4 > 0) {
          for (let i = 0; i < 4; i++) {
            const lastColor = Math.floor((this.mColorLists[0].length / 4 - 1) * 4);
            this.mColorlistOutput.push(this.mColorLists[0][lastColor + i]);
          }
          for (let i = 0; i < this.mColorLists[0].length - 4; i++) {
            this.mColorlistOutput.push(this.mColorLists[0][i]);
          }
        }
      }
    };

    return ColorListFiltersLib;
  }
  if (typeof (ColorListFiltersLib) === 'undefined') window.ColorListFiltersLib = defineLibrary(); // eslint-disable-line no-param-reassign, no-undef
  else console.log('Library already defined.'); // eslint-disable-line no-console
}(window)); // eslint-disable-line no-undef
