import processing.core.*; 
import processing.data.*; 
import processing.event.*; 
import processing.opengl.*; 

import moonlander.library.*; 
import ddf.minim.spi.*; 
import ddf.minim.signals.*; 
import ddf.minim.*; 
import ddf.minim.analysis.*; 
import ddf.minim.ugens.*; 
import ddf.minim.effects.*; 

import java.util.HashMap; 
import java.util.ArrayList; 
import java.io.File; 
import java.io.BufferedReader; 
import java.io.PrintWriter; 
import java.io.InputStream; 
import java.io.OutputStream; 
import java.io.IOException; 

public class Processing_Demobase extends PApplet {



/* 
 * Code for starting a demo project
 *
 * Nothing extra except standard libraries
 * bundled with Processing 
 */

// Minim is needed for the music playback.







int CANVAS_WIDTH = 1920;
int CANVAS_HEIGHT = 1080;

int speed = height / 55;
int star_amount = 0;
PImage img, img2;
PFont font;
float x;
float y;
float hack;

// You can skip backwards/forwards in your demo by using the 
// arrow keys; this controls how many milliseconds you skip
// with one keypress.
int SONG_SKIP_MILLISECONDS = 2000;

Moonlander moonlander;

Star[] stars;

Spaceship spaceship;

Fish fish;

CollidingObject heart;

public void settings() {
  // Set up the drawing area size and renderer (P2D / P3D).
  size(CANVAS_WIDTH, CANVAS_HEIGHT, P2D);
}
 
public void setup() {
  noCursor();
  frameRate(60);
  font = createFont("Comfortaa-Regular.ttf", 60);
  textFont(font);
  textAlign(CENTER);
  img = loadImage("background3.png");
  fish = new Fish();
  fish.img = loadImage("fish.png");
  heart = new CollidingObject(((width /  2) - 65), height + 100, 130, 130);
  heart.img = loadImage("data/heart.png");
  y = height + 10;
  spaceship = new Spaceship();
  spaceship.img = loadImage("data/spaceship.png");
  
  spaceship.img.resize(130,130);

  // Your setup code
  stars = new Star[width / 8];
  
  for(int i = 0; i < stars.length; i++) {
    if (i % 5 == 0) {
      stars[i] = new Star(3);
    } else {
      stars[i] = new Star(PApplet.parseInt(random(1, 3)));
    }
  }

  moonlander = Moonlander.initWithSoundtrack(this, "./data/spacetravel.wav", 120, 8);
  moonlander.start();
  
}

public void drawType(float x) {
  fill(200);
  textSize(60);
  text("Fish n Ships", x, 550);
}

public void drawScript(float x) {
  fill(210);
  textSize(30);
  text("In a far-far-away universe",x,500);
  text("At 12 pm",x,550);
  text("Our fish is hungry",x,600);
}
 

/*
 * Processing's drawing method
 */
public void draw() {
  moonlander.update();
  background(9, 56, 90);
  image(img, 0, y);
  int display_gradient = moonlander.getIntValue("display_gradient");
  int scene = moonlander.getIntValue("scene");
  //int display_fish = moonlander.getIntValue("display_fish");
  //if (display_gradient == 1) {
  //if (y >= (height / 2 - 4500)) {
  //  y -= 1; 
  //  }
  //if (display_fish == 1) {
    //image(img2,spaceship.x-100, 2*height/3); 
    //}
  //if (display_fish == 2) {
    //image(img2,width/2-80, 2*height/3); 
    //}
  //}
  int red = moonlander.getIntValue("red");
  int green = moonlander.getIntValue("green");
  int blue = moonlander.getIntValue("blue");
  double row = moonlander.getCurrentRow();
  for(int i = 0; i < stars.length; i++) {
    stars[i].color_r = red;
    stars[i].color_g = green;
    stars[i].color_b = blue;
    stars[i].display();
  }
  
  image(spaceship.img, spaceship.x, spaceship.y);
  image(fish.img, fish.x, fish.y);
  
  //if (spaceship.y < ((height / 2) - 65)) {
   if (row > 50 & row < 150) {
     textAlign(CENTER);
     drawType(width*0.5f);
   }
   if (row > 150 & row < 250) {
     textAlign(CENTER);
     drawScript(width*0.5f);
   }
  if (scene == 1) {
    spaceship.move_horizontally();
    fish.move_horizontally();
    spaceship.y += .3f;
    fish.y += .3f;
  } else if (scene == 4) {
    if (!heart.collided) {
      
      heart.x = spaceship.x;
      heart.draw_and_move();
    }
    if (heart.isColliding(spaceship)) {
      speed += .5f;
      heart.onCollision();
      for(int i = 0; i < stars.length; i++) {
        stars[i].color_r = red;
        stars[i].color_g = green;
        stars[i].color_b = blue;
        stars[i].display();
      }
      image(spaceship.img, spaceship.x, spaceship.y);
      image(fish.img, fish.x, fish.y);
    }
  } else if (scene == 2) {
    background(255, 111, 111);
    image(img, 0, y);
    for(int i = 0; i < stars.length; i++) {
        stars[i].color_r = red;
        stars[i].color_g = green;
        stars[i].color_b = blue;
        stars[i].display();
    }
    y -= 2;
    image(spaceship.img, spaceship.x, spaceship.y);
    image(fish.img, fish.x, fish.y);
    spaceship.move_horizontally();
    fish.follow(spaceship);
    hack = y + 10;
  } else if (scene == 5) {
    y = lerp(y, hack, 0.05f);
  } else if (scene == 6) {
    spaceship.move_away();
    fish.move_away();
  } else if (scene == 7) {
    textAlign(CENTER);
    fill(200);
    textSize(60);
    text("Happy Ending", width * 0.5f, height / 2);
  } else if (scene == 8) {
    textAlign(CENTER);
    fill(200);
    textSize(60);
    text("Fish n Ships", width * 0.5f, height / 2);
  } else if (scene == 9) {
    textAlign(CENTER);
    fill(200);
    textSize(60);
    text("Graffathon 2018", width * 0.5f, height / 2);
  } else if (scene == 10) {
    textAlign(CENTER);
    fill(200);
    textSize(60);
    text("Titi/Yuyu/sivuosa/Jari", width * 0.5f, height / 2);
  } else if (scene == 11) {
    exit();
  }
}

class Star {
  int layer;
  float size;
  int x;
  int y;
  int color_r;
  int color_g;
  int color_b;
  
  Star(int layer) {
    this.layer = layer;
    this.size = (PApplet.parseInt(random(1, 4) * layer));
    this.x = PApplet.parseInt(random(5, width));
    this.y = PApplet.parseInt(random(0, height));
    this.color_r = 255;
    this.color_g = 247;
    this.color_b = 93;
  }
  
  public void display() {
    pushStyle();
    
    //Setup the style
    stroke(this.color_r, this.color_g, this.color_b);
    strokeWeight(this.size);
    
    int y = this.y - (speed * this.layer);
    
    if (y < -10) y = height + 10;
    
    this.y = y;
    
    point(this.x, y);
    popStyle();
  }
}

class CollidingObject {
  PImage img;
  float x;
  float y;
  float size_x;
  float size_y;
  boolean collided;
  
  CollidingObject(float x, float y, float size_x, float size_y) {
    this.img = new PImage();
    this.x = x;
    this.y = y;
    this.size_x = size_x;
    this.size_y = size_y;
    this.collided = false;
  }
  
  public void draw_and_move() {
    image(this.img, this.x, this.y);
    this.y = this.y - 3;
  }
  
  public boolean isColliding(Spaceship s) {
    if ((this.x >= s.x && this.x <= (s.x + 70)) && (this.y >= s.y && this.y <= (s.y + 70))) {
      return true;
    }
    return false;
  }
  
  public void onCollision() {
    image(this.img, -100, -100);
    background(255, 111, 111);
    this.collided = true;
  }
}

class Spaceship {
  PImage img;
  float x;
  float y;
  float direction;
  float destination;
  
  Spaceship() {
    this.img = new PImage();
    this.x = ((CANVAS_WIDTH / 2) - 65);
    this.y = -100;
    this.direction = -1;
    this.destination = ((CANVAS_WIDTH / 2) - 400);
  }
  
  public void move_horizontally() {
    if (this.x <= (this.destination + 15) && this.direction == -1) {
      this.direction = 1;
      this.destination = ((CANVAS_WIDTH / 2) + 400);
    } else if (this.x >= (this.destination - 15) && this.direction == 1) {
      this.direction = -1;
      this.destination = ((CANVAS_WIDTH / 2) - 400);
    }
    
    this.x = lerp(this.x, this.destination, 0.05f);
  }
  
  public boolean is_colliding(CollidingObject co) {
    return true;
  }
  
  public void move_away() {
    this.y = lerp(this.y, height + 500, 0.05f);
  }
}

class Fish {
  PImage img;
  float x;
  float y;
  float direction;
  float destination;
  
  Fish() {
    this.img = new PImage();
    this.x = ((CANVAS_WIDTH / 2) - 319.5f);
    this.y = -1500;
    this.direction = -1;
    this.destination = ((CANVAS_WIDTH / 2) - 600);
  }
  
  public void move_horizontally() {
    if (this.x <= (this.destination + 15) && this.direction == -1) {
      this.direction = 1;
      this.destination = ((CANVAS_WIDTH / 2) + 600);
    } else if (this.x >= (this.destination - 15) && this.direction == 1) {
      this.direction = -1;
      this.destination = ((CANVAS_WIDTH / 2) - 600);
    }
    
    this.x = lerp(this.x, this.destination, 0.05f);
  }
  
  public void follow(Spaceship s) {
    this.direction = s.direction;
    this.destination = s.destination;
    
    this.x = lerp(this.x, this.destination, 0.05f);
  }
  
  public void move_away() {
    this.y = lerp(this.y, height + 500, 0.05f);
  }
}
  static public void main(String[] passedArgs) {
    String[] appletArgs = new String[] { "Processing_Demobase" };
    if (passedArgs != null) {
      PApplet.main(concat(appletArgs, passedArgs));
    } else {
      PApplet.main(appletArgs);
    }
  }
}
