/*
 * Decompiled with CFR 0.152.
 */
import moonlander.library.Moonlander;
import processing.core.PApplet;
import processing.core.PGraphics;
import processing.core.PImage;
import processing.core.PVector;

public class demo
extends PApplet {
    Moonlander moonlander;
    int fuchsia = this.color(254, 127, 250);
    int teal = this.color(123, 241, 246);
    int paleBlue = this.color(160, 191, 239);
    PImage hourglass;
    PGraphics[] graphics;
    String name = "dangling pointer.";
    String space = "                                                                  ";
    String credits = "Music: 'Rhinoceros' by Kevin MacLeod (CC BY 3.0) " + this.space + "Greetings to: all fuksipallerot and n:th year students of Gurula " + this.space + "Team Gurula";
    PVector[] mousePointerCoords = this.initMousePointerCoords();
    PImage blurredText;
    boolean firstFrame = true;

    public void settings() {
        this.fullScreen("processing.opengl.PGraphics3D");
    }

    public void setup() {
        this.moonlander = Moonlander.initWithSoundtrack((PApplet)this, (String)"Rhinoceros-clip.mp3", (int)126, (int)8);
        this.moonlander.start();
        this.frameRate(60.0f);
        this.noiseSeed(1337L);
        this.hourglass = this.loadImage("hourglass.png");
        this.graphics = new PGraphics[6];
        int i = 0;
        while (i < 6) {
            this.graphics[i] = this.createGraphics(100, 100);
            ++i;
        }
        this.noCursor();
    }

    public PVector[] initMousePointerCoords() {
        PVector[] ret;
        PVector[] pVectorArray = ret = new PVector[]{new PVector(0.0f, 0.0f), new PVector(100.0f, 105.0f), new PVector(55.0f, 105.0f), new PVector(72.0f, 145.0f), new PVector(52.0f, 155.0f), new PVector(34.0f, 113.0f), new PVector(0.0f, 140.0f)};
        int n = ret.length;
        int n2 = 0;
        while (n2 < n) {
            PVector v = pVectorArray[n2];
            v.sub(50.0f, 70.0f);
            v.mult(0.007142857f);
            ++n2;
        }
        return ret;
    }

    public void mousePointers(float size, int count, float r) {
        this.pushStyle();
        this.noStroke();
        int i = 0;
        while (i < count) {
            this.pushMatrix();
            if (i % 3 == 0) {
                this.fill(255.0f, 255.0f, 255.0f);
            } else if (i % 3 == 1) {
                this.fill(this.teal);
            } else {
                this.fill(this.fuchsia);
            }
            this.translate(0.0f, 0.0f, 2.0f * r * ((float)i / Math.max(1.0f, (float)count - 1.0f) - 0.5f));
            this.scale(size);
            this.beginShape();
            PVector[] pVectorArray = this.mousePointerCoords;
            int n = this.mousePointerCoords.length;
            int n2 = 0;
            while (n2 < n) {
                PVector v = pVectorArray[n2];
                this.vertex(v.x, v.y);
                ++n2;
            }
            this.endShape();
            this.popMatrix();
            ++i;
        }
        this.popStyle();
    }

    public void mousePointer3D(float size, float r) {
        int n;
        this.pushStyle();
        this.noStroke();
        this.fill(220.0f, 220.0f, 220.0f);
        int i = -1;
        while (i <= 1) {
            this.pushMatrix();
            this.translate(0.0f, 0.0f, r * (float)i);
            this.scale(size);
            this.beginShape();
            PVector[] pVectorArray = this.mousePointerCoords;
            n = this.mousePointerCoords.length;
            int n2 = 0;
            while (n2 < n) {
                PVector v = pVectorArray[n2];
                this.vertex(v.x, v.y);
                ++n2;
            }
            this.endShape();
            this.popMatrix();
            i += 2;
        }
        this.pushMatrix();
        this.scale(size);
        PVector prev = this.mousePointerCoords[this.mousePointerCoords.length - 1];
        int idx = 0;
        PVector[] pVectorArray = this.mousePointerCoords;
        int n3 = this.mousePointerCoords.length;
        n = 0;
        while (n < n3) {
            PVector cur = pVectorArray[n];
            float darken = 0.8f;
            if (idx % 2 == 0) {
                this.fill(this.red(this.teal) * darken, this.green(this.teal) * darken, this.blue(this.teal) * darken);
            } else {
                this.fill(this.red(this.fuchsia) * darken, this.green(this.fuchsia) * darken, this.blue(this.fuchsia) * darken);
            }
            this.beginShape();
            float u = r / Math.max(size, 1.0f);
            this.vertex(prev.x, prev.y, u);
            this.vertex(cur.x, cur.y, u);
            this.vertex(cur.x, cur.y, -u);
            this.vertex(prev.x, prev.y, -u);
            this.endShape();
            prev = cur;
            ++idx;
            ++n;
        }
        this.popMatrix();
        this.popStyle();
    }

    public void flyingPointerEffect() {
        float movement = (float)this.moonlander.getValue("flyingPointerMovement");
        float depth = (float)this.moonlander.getValue("flyingPointerDepth");
        float size = (float)this.moonlander.getValue("flyingPointerSize");
        int type = this.moonlander.getIntValue("flyingPointerType");
        float light = (float)this.moonlander.getValue("flyingPointerLightIntensity");
        float count = (float)this.moonlander.getValue("flyingPointerCount");
        float blowup = (float)this.moonlander.getValue("flyingPointerBlowUp");
        float t = 0.2f * (float)this.moonlander.getCurrentTime();
        this.pointLight(255.0f * light, 255.0f * light, 255.0f * light, -1000.0f, -1000.0f, 1000.0f);
        this.ambientLight(255.0f * (1.0f - light), 255.0f * (1.0f - light), 255.0f * (1.0f - light));
        int i = 1;
        while ((double)i <= Math.ceil(count)) {
            float t2 = t - (float)(100 * i);
            this.pushMatrix();
            float x = movement * 600.0f;
            this.translate(2.0f * x * (this.noise(t2, 0.0f) - 0.5f), 2.0f * x * (this.noise(t2, 1.0f) - 0.5f), 2.0f * x * (this.noise(t2, 2.0f) - 0.5f));
            this.translate(0.0f, 0.0f, blowup);
            float y = movement * 5.0f;
            this.rotateY(y * this.noise(t2, 3.0f));
            this.rotateX(y * this.noise(t2, 4.0f));
            this.rotateZ(y * this.noise(t2, 4.0f));
            float d = depth * 0.5f * (1.0f - demo.cos((float)((float)Math.PI * 2 * (0.125f * (float)this.moonlander.getCurrentRow()))));
            float coef = 1.0f;
            if ((float)i > count) {
                coef = 1.0f - ((float)i - count);
            }
            if (type == 0) {
                this.mousePointers(coef * size, 7, coef * d);
            } else {
                this.mousePointer3D(coef * size, coef * d);
            }
            this.popMatrix();
            ++i;
        }
    }

    public void boxTunnelEffect() {
        this.pushStyle();
        this.pushMatrix();
        this.noStroke();
        float time = (float)this.moonlander.getCurrentTime();
        float beat = (float)this.moonlander.getCurrentRow() / 8.0f + 0.9f;
        float ambient = 0.8f;
        this.ambientLight(255.0f * (1.0f - ambient), 255.0f * (1.0f - ambient), 255.0f * (1.0f - ambient));
        this.lightFalloff(1.0f, 0.0f, 1.0E-5f);
        float light_beet = beat % 6.0f;
        this.pointLight(this.red(this.teal), this.green(this.teal), this.blue(this.teal), 0.0f, 0.0f, 2000.0f - 80.0f * light_beet * light_beet);
        light_beet = (beat + 3.0f) % 6.0f;
        this.pointLight(this.red(this.teal), this.green(this.teal), this.blue(this.teal), 0.0f, 0.0f, 2000.0f - 80.0f * light_beet * light_beet);
        float fadeout = (float)this.moonlander.getValue("tunnel_out") * 60.0f;
        this.background(0);
        float diameter = 270.0f;
        float jaggyness = 100.0f;
        float boxes_per_ring = 15.0f;
        float boxsize = (float)Math.PI * diameter / boxes_per_ring;
        float depth = 100.0f;
        float zStart = 1200.0f;
        float tunnel_spiral = (float)this.moonlander.getValue("tunnel_spiral");
        float d = 0.0f;
        while (d < depth) {
            float pulse = demo.pow((float)((1.0f + demo.sin((float)(beat * 2.0f + (float)Math.PI * 6 * d / 100.0f))) / 2.0f), (float)1.5f);
            this.rotateZ((float)Math.PI * 2 * this.noise(d) / 100.0f);
            float ring_z = zStart + -d * boxsize;
            float i = 0.0f;
            while (i < boxes_per_ring) {
                this.pushMatrix();
                this.rotateZ(0.62831855f * this.noise(d, time));
                this.translate(0.0f, 0.0f, ring_z);
                this.rotateZ((float)Math.PI * 2 / boxes_per_ring * i);
                float c = this.noise(d / depth * 4.0f + time, 0.5f - i / boxes_per_ring);
                float mdist = (i + d + (float)demo.floor((float)(time * 5.0f))) % boxes_per_ring;
                mdist = demo.min((float)mdist, (float)(boxes_per_ring - mdist));
                if (tunnel_spiral * 100.0f > d && mdist < 3.0f) {
                    float n = this.noise(d / depth + 0.1f * mdist);
                    this.fill(this.red(this.fuchsia) * n, this.green(this.fuchsia) * n, this.blue(this.fuchsia) * n);
                } else {
                    this.fill(255.0f * c, 255.0f * c, 255.0f * c);
                }
                float box_d = diameter + jaggyness / 2.0f - jaggyness * this.noise(i + d + time);
                this.translate(0.0f, (box_d -= pulse * diameter / 3.0f) / 2.0f * (fadeout / 100.0f * (d + 2.0f) + 1.0f), this.noise(d / depth) * 30.0f);
                this.box((float)Math.PI * box_d / boxes_per_ring);
                this.popMatrix();
                i += 1.0f;
            }
            d += 1.0f;
        }
        this.popMatrix();
        this.popStyle();
        this.pushMatrix();
        this.pushStyle();
        float tunnel_cursor = (float)this.moonlander.getValue("tunnel_cursor");
        if (tunnel_cursor > 0.0f) {
            this.translate(0.0f, 0.0f, 910.0f - 2000.0f * tunnel_cursor);
            this.pointLight(255.0f, 255.0f, 255.0f, 0.0f, 0.0f, -50.0f);
            this.rotateX(1.4398967f);
            this.rotateY(-0.2617994f);
            this.rotateY(tunnel_cursor * 2.0f * (float)Math.PI * 5.0f);
            this.translate(0.0f, 0.0f, 50.0f);
            this.mousePointer3D(60.0f, 5.0f);
        }
        this.popMatrix();
        this.popStyle();
    }

    public static float cubicPulse(float c, float w, float x) {
        if ((x = demo.abs((float)(x - c))) > w) {
            return 0.0f;
        }
        return 1.0f - (x /= w) * x * (3.0f - 2.0f * x);
    }

    public static float planeDist(PVector a, PVector b, PVector c, PVector p) {
        PVector normal = PVector.sub((PVector)b, (PVector)a).cross(PVector.sub((PVector)c, (PVector)a));
        normal.normalize();
        PVector d = PVector.sub((PVector)p, (PVector)a);
        return d.dot(normal);
    }

    public void cubeEffect() {
        this.pushStyle();
        this.pushMatrix();
        this.directionalLight(255.0f, 255.0f, 255.0f, 1.0f, 1.0f, -1.0f);
        this.ambientLight(200.0f, 200.0f, 200.0f);
        float content = (float)this.moonlander.getValue("cubeContent");
        float arrowSize = (float)this.moonlander.getValue("cubeArrowSize");
        float arrowBling = (float)this.moonlander.getValue("cubeArrowBling");
        float plasmaCoef = (float)this.moonlander.getValue("cubePlasmaCoef");
        float t = (float)this.moonlander.getCurrentTime();
        this.rotateX(t);
        this.rotateY(1.3f * t);
        boolean[] visible = new boolean[6];
        int i = 0;
        while (i < 6) {
            this.pushMatrix();
            if (i == 1) {
                this.rotateX(1.5707964f);
            }
            if (i == 2) {
                this.rotateX((float)Math.PI);
            }
            if (i == 3) {
                this.rotateX(-1.5707964f);
            }
            if (i == 4) {
                this.rotateY(1.5707964f);
            }
            if (i == 5) {
                this.rotateY(-1.5707964f);
            }
            if (this.screenZ(0.0f, 0.0f, 0.0f) > this.screenZ(0.0f, 0.0f, 1.0f)) {
                visible[i] = true;
            }
            this.popMatrix();
            ++i;
        }
        float meas = (float)this.moonlander.getCurrentRow() / 8.0f + 0.5f;
        float measInt = (float)Math.floor(meas);
        float measFrac = meas - measInt;
        if (content < 1.0f) {
            int i2 = 0;
            while (i2 < 6) {
                PGraphics g = this.graphics[i2];
                g.beginDraw();
                g.background(100.0f * (1.0f + Math.min(content, 0.0f)));
                g.imageMode(3);
                g.translate(0.5f * (float)g.width, 0.5f * (float)g.height);
                g.rotate(1.5707964f * (measInt + measFrac * measFrac * (3.0f - 2.0f * measFrac)));
                g.image(this.hourglass, 0.0f, 0.0f, 0.4f * (float)g.width, 0.4f * (float)g.width);
                g.endDraw();
                ++i2;
            }
        }
        if (content > 0.0f) {
            PVector[][] polygons = new PVector[5][];
            int[][][] nArrayArray = new int[3][][];
            int[][] nArrayArray2 = new int[3][];
            int[] nArray = new int[2];
            nArray[1] = 1;
            nArrayArray2[0] = nArray;
            nArrayArray2[1] = new int[]{5, 6};
            int[] nArray2 = new int[2];
            nArray2[0] = 6;
            nArrayArray2[2] = nArray2;
            nArrayArray[0] = nArrayArray2;
            int[][] nArrayArray3 = new int[3][];
            int[] nArray3 = new int[2];
            nArray3[1] = 1;
            nArrayArray3[0] = nArray3;
            nArrayArray3[1] = new int[]{1, 2};
            int[] nArray4 = new int[2];
            nArray4[0] = 6;
            nArrayArray3[2] = nArray4;
            nArrayArray[1] = nArrayArray3;
            int[][] nArrayArray4 = new int[5][];
            int[] nArray5 = new int[2];
            nArray5[1] = 1;
            nArrayArray4[0] = nArray5;
            int[] nArray6 = new int[2];
            nArray6[0] = 6;
            nArrayArray4[1] = nArray6;
            nArrayArray4[2] = new int[]{2, 3};
            nArrayArray4[3] = new int[]{3, 4};
            nArrayArray4[4] = new int[]{4, 5};
            nArrayArray[2] = nArrayArray4;
            int[][][] triangulation = nArrayArray;
            if (arrowSize > 0.0f) {
                int polyi = 0;
                while (polyi < polygons.length) {
                    PVector axis = new PVector(this.noise(polyi, 2.1f, 0.5f) - 0.5f, this.noise(polyi, 13.2f, 0.5f) - 0.5f, this.noise(polyi, -5.7f, 0.5f) - 0.5f);
                    axis.normalize();
                    PVector rot1 = axis.cross(new PVector(1.0f, 0.0f, 0.0f));
                    rot1.normalize();
                    PVector rot2 = axis.cross(rot1);
                    rot2.normalize();
                    float myt = 2.0f * t * this.noise(polyi, 1.18f);
                    PVector base = PVector.add((PVector)PVector.mult((PVector)rot1, (float)demo.cos((float)myt)), (PVector)PVector.mult((PVector)rot2, (float)demo.sin((float)myt)));
                    base = PVector.add((PVector)base, (PVector)PVector.mult((PVector)axis, (float)this.noise(polyi, 0.4f)));
                    base.normalize();
                    PVector[] poly = new PVector[this.mousePointerCoords.length];
                    polygons[polyi] = poly;
                    PVector e1 = base.cross(new PVector(1.0f, 0.0f, 0.0f));
                    e1.setMag(arrowSize);
                    PVector e2 = base.cross(e1);
                    e2.setMag(arrowSize);
                    int i3 = 0;
                    while (i3 < poly.length) {
                        poly[i3] = PVector.add((PVector)base, (PVector)PVector.add((PVector)PVector.mult((PVector)e1, (float)this.mousePointerCoords[i3].x), (PVector)PVector.mult((PVector)e2, (float)this.mousePointerCoords[i3].y)));
                        poly[i3].normalize();
                        ++i3;
                    }
                    ++polyi;
                }
            }
            t *= 0.6f;
            int i4 = 0;
            while (i4 < 6) {
                PGraphics g = this.graphics[i4];
                g.beginDraw();
                if (visible[i4]) {
                    g.loadPixels();
                    int x = 0;
                    while (x < g.width) {
                        int y = 0;
                        while (y < g.height) {
                            float A = (float)x / (float)g.width;
                            float B = (float)y / (float)g.width;
                            float u = A;
                            float v = B;
                            float w = 0.0f;
                            if (i4 == 1) {
                                u = A;
                                v = 0.0f;
                                w = 1.0f - B;
                            }
                            if (i4 == 2) {
                                u = A;
                                v = 1.0f - B;
                                w = 1.0f;
                            }
                            if (i4 == 3) {
                                u = A;
                                v = 1.0f;
                                w = B;
                            }
                            if (i4 == 4) {
                                u = 1.0f;
                                v = B;
                                w = A;
                            }
                            if (i4 == 5) {
                                u = 0.0f;
                                v = B;
                                w = 1.0f - A;
                            }
                            PVector spherePos = new PVector(u - 0.5f, v - 0.5f, w - 0.5f);
                            spherePos.normalize();
                            float t2 = 0.5f * (t - 37.0f) + 37.0f;
                            float h = 0.41f * demo.cos((float)(1.35f * u + 1.54f * v - 0.39f * w - 1.21f * t2)) - 0.75f * demo.sin((float)(1.53f * u + 1.15f * v + 0.37f * w + 1.51f * t2)) - 0.32f * demo.cos((float)(-0.75f * u + v + w + 3.5f * t2)) + 0.72f * t2;
                            float val = (h *= 10.0f) - (float)demo.floor((float)h);
                            val = demo.cubicPulse(0.5f, 0.2f, val);
                            val *= plasmaCoef;
                            PVector origin = new PVector(0.0f, 0.0f, 0.0f);
                            if (arrowSize > 0.0f) {
                                float dist = -1.0f;
                                int polyi = 0;
                                while (polyi < polygons.length) {
                                    if (!(polygons[polyi][0].dot(spherePos) < 0.0f)) {
                                        int trg = 0;
                                        while (trg < triangulation.length) {
                                            float mydist = 1.0f;
                                            int pair = 0;
                                            while (pair < triangulation[trg].length) {
                                                int i0 = triangulation[trg][pair][0];
                                                PVector p0 = polygons[polyi][i0];
                                                int i1 = triangulation[trg][pair][1];
                                                PVector p1 = polygons[polyi][i1];
                                                if ((mydist = Math.min(mydist, demo.planeDist(origin, p0, p1, spherePos))) < -0.1f) break;
                                                ++pair;
                                            }
                                            dist = Math.max(dist, mydist);
                                            ++trg;
                                        }
                                    }
                                    ++polyi;
                                }
                                if ((dist /= Math.max(plasmaCoef, 0.4f)) > -0.1f) {
                                    if (dist < 0.0f) {
                                        val = dist > -0.05f ? 1.0f - Math.abs(dist + 0.05f) / 0.05f : Math.max(val, 1.0f - Math.abs(dist + 0.05f) / 0.05f);
                                        val *= Math.min(plasmaCoef * 7.0f, 1.0f);
                                    } else {
                                        val = Math.min(1.0f + (dist - (0.1f + 0.05f * demo.sin((float)((float)Math.PI * 2 * meas)))) / 0.05f, 1.0f);
                                        val *= arrowBling * plasmaCoef;
                                    }
                                }
                            }
                            int c = this.hsvToRgb(this.hue(this.fuchsia) / 255.0f, this.saturation(this.fuchsia) / 255.0f, val);
                            g.pixels[x + y * g.width] = content == 1.0f ? c : this.alphaBlend(c, g.pixels[x + y * g.width], content);
                            ++y;
                        }
                        ++x;
                    }
                    g.updatePixels();
                }
                g.endDraw();
                ++i4;
            }
        }
        this.imageMode(3);
        int i5 = 0;
        while (i5 < 6) {
            this.pushMatrix();
            if (i5 == 1) {
                this.rotateX(1.5707964f);
            }
            if (i5 == 2) {
                this.rotateX((float)Math.PI);
            }
            if (i5 == 3) {
                this.rotateX(-1.5707964f);
            }
            if (i5 == 4) {
                this.rotateY(1.5707964f);
            }
            if (i5 == 5) {
                this.rotateY(-1.5707964f);
            }
            this.translate(0.0f, 0.0f, 285.0f);
            this.image((PImage)this.graphics[i5], 0.0f, 0.0f, 570.0f, 570.0f);
            this.popMatrix();
            ++i5;
        }
        this.popMatrix();
        this.popStyle();
    }

    public int hsvToRgb(double h, double s, double v) {
        int i = (int)(h * 6.0);
        double f = h * 6.0 - (double)i;
        double p = v * (1.0 - s);
        double q = v * (1.0 - f * s);
        double t = v * (1.0 - (1.0 - f) * s);
        double r = 0.0;
        double g = 0.0;
        double b = 0.0;
        switch (i % 6) {
            case 0: {
                r = v;
                g = t;
                b = p;
                break;
            }
            case 1: {
                r = q;
                g = v;
                b = p;
                break;
            }
            case 2: {
                r = p;
                g = v;
                b = t;
                break;
            }
            case 3: {
                r = p;
                g = q;
                b = v;
                break;
            }
            case 4: {
                r = t;
                g = p;
                b = v;
                break;
            }
            case 5: {
                r = v;
                g = p;
                b = q;
            }
        }
        return this.color(Math.round(r * 255.0), Math.round(g * 255.0), Math.round(b * 255.0));
    }

    public PImage colorWheel(double cwDelta, double fadeout, int w, int h) {
        PImage img = this.createImage(w, h, 1);
        img.loadPixels();
        int midX = img.width / 2;
        int midY = img.height / 2;
        int radius = midX;
        int halfRadius = radius / 2;
        int y = 0;
        while (y < img.height) {
            int x = 0;
            while (x < img.width) {
                double d = Math.sqrt(Math.pow(x - midX, 2.0) + Math.pow(y - midY, 2.0));
                if (d > (double)radius) {
                    img.pixels[y * img.width + x] = this.color(0, 0, 0);
                } else {
                    int dx = x - midX;
                    int dy = y - midY;
                    double normAngle = (((double)demo.atan2((float)dx, (float)dy) - Math.PI) / (Math.PI * -2) + cwDelta) % 1.0;
                    double saturation = d < (double)halfRadius ? d / (double)halfRadius : 1.0;
                    double value = d < (double)halfRadius ? 1.0 : ((double)radius - d) / (double)halfRadius;
                    img.pixels[y * img.width + x] = this.hsvToRgb(normAngle, saturation, value * fadeout);
                }
                ++x;
            }
            ++y;
        }
        img.updatePixels();
        return img;
    }

    public PImage waterWith(PImage img, PImage other, int lrAmount, int udAmount) {
        PImage newImg = this.createImage(img.width, img.height, 1);
        img.loadPixels();
        other.loadPixels();
        int y = 0;
        while (y < img.height) {
            int x = 0;
            while (x < img.width) {
                int ny;
                int col = other.pixels[y * img.width + x];
                double diff = Math.max(Math.max(this.red(col), this.green(col)), this.blue(col));
                int nx = (int)Math.round((1.0 + diff / 255.0) * (double)lrAmount + (double)x) % img.width;
                if (nx < 0) {
                    nx += img.width;
                }
                if ((ny = (int)Math.round((1.0 + diff / 255.0) * (double)udAmount + (double)y) % img.height) < 0) {
                    ny += img.height;
                }
                newImg.pixels[y * img.width + x] = img.pixels[ny * img.width + nx];
                ++x;
            }
            ++y;
        }
        newImg.updatePixels();
        return newImg;
    }

    public PImage sineWaveBoth(PImage img, int peaksUD, int h, int peaksLR, int w) {
        PImage newImg = this.createImage(img.width, img.height, 1);
        img.loadPixels();
        double kUD = (float)peaksUD * (float)Math.PI;
        double kLR = (float)peaksLR * (float)Math.PI;
        int y = 0;
        while (y < img.height) {
            int x = 0;
            while (x < img.width) {
                double dy;
                int y2;
                double dx = Math.sin((double)y / (double)img.height * kLR) * (double)w;
                int x2 = (int)Math.floor(((double)x + dx) % (double)img.width);
                if (x2 < 0) {
                    x2 += img.width;
                }
                if ((y2 = (int)Math.floor(((double)y + (dy = Math.sin((double)x / (double)img.width * kUD) * (double)h)) % (double)img.height)) < 0) {
                    y2 += img.height;
                }
                newImg.pixels[y * img.width + x] = img.pixels[y2 * img.width + x2];
                ++x;
            }
            ++y;
        }
        newImg.updatePixels();
        return newImg;
    }

    public int clamp255(int v) {
        if (v < 0) {
            return 0;
        }
        if (v > 255) {
            return 255;
        }
        return v;
    }

    public PImage convolute(PImage img, int[] matrix, int divisor) {
        PImage newImg = this.createImage(img.width, img.height, 1);
        img.loadPixels();
        int[] nArray = new int[9];
        nArray[0] = -1;
        nArray[2] = 1;
        nArray[3] = -1;
        nArray[5] = 1;
        nArray[6] = -1;
        nArray[8] = 1;
        int[] DX = nArray;
        int[] nArray2 = new int[9];
        nArray2[0] = -1;
        nArray2[1] = -1;
        nArray2[2] = -1;
        nArray2[6] = 1;
        nArray2[7] = 1;
        nArray2[8] = 1;
        int[] DY = nArray2;
        int y = 0;
        while (y < img.height) {
            int x = 0;
            while (x < img.width) {
                int[] comps = new int[3];
                int i = 0;
                while (i < DX.length) {
                    int rx = x + DX[i];
                    if (rx < 0) {
                        rx = 0;
                    } else if (rx >= img.width) {
                        rx = img.width - 1;
                    }
                    int ry = y + DY[i];
                    if (ry < 0) {
                        ry = 0;
                    } else if (ry >= img.height) {
                        ry = img.height - 1;
                    }
                    int px = img.pixels[img.width * ry + rx];
                    comps[0] = (int)((float)comps[0] + this.red(px) * (float)matrix[i]);
                    comps[1] = (int)((float)comps[1] + this.green(px) * (float)matrix[i]);
                    comps[2] = (int)((float)comps[2] + this.blue(px) * (float)matrix[i]);
                    ++i;
                }
                newImg.pixels[y * img.width + x] = this.color(this.clamp255(comps[0] / divisor), this.clamp255(comps[1] / divisor), this.clamp255(comps[2] / divisor));
                ++x;
            }
            ++y;
        }
        return newImg;
    }

    public PImage blur(PImage img) {
        return this.convolute(img, new int[]{3, 3, 3, 3, 8, 3, 3, 3, 3}, 32);
    }

    public PImage softenLess(PImage img) {
        int[] nArray = new int[9];
        nArray[1] = 1;
        nArray[3] = 1;
        nArray[4] = 2;
        nArray[5] = 1;
        nArray[7] = 1;
        return this.convolute(img, nArray, 6);
    }

    public PImage findEdges(PImage img) {
        return this.convolute(img, new int[]{1, 1, 1, 1, -2, 1, -1, -1, -1}, 1);
    }

    public int alphaBlend(int c1, int c2, float alpha) {
        return this.color(PApplet.parseInt((float)(this.red(c1) * alpha + this.red(c2) * (1.0f - alpha))), PApplet.parseInt((float)(this.green(c1) * alpha + this.green(c2) * (1.0f - alpha))), PApplet.parseInt((float)(this.blue(c1) * alpha + this.blue(c2) * (1.0f - alpha))));
    }

    public void drawTiled(PImage img) {
        int yCount = this.height / img.height + 1;
        int xCount = this.width / img.width + 1;
        int y = 0;
        while (y < yCount) {
            int x = 0;
            while (x < xCount) {
                this.image(img, x * img.width, y * img.height, img.width, img.height);
                ++x;
            }
            ++y;
        }
    }

    public void titleText() {
        if (this.blurredText == null) {
            PGraphics graphics = this.createGraphics(this.width, this.height);
            graphics.beginDraw();
            graphics.background(0);
            graphics.fill(255);
            graphics.textAlign(3, 101);
            String str1 = "Graffathon";
            String str2 = "Graffathon 2018";
            int ts = 369;
            int i = 0;
            while (i < 10) {
                graphics.textSize((float)ts);
                if (graphics.textWidth(str1) < (float)graphics.width) break;
                ++i;
                --ts;
            }
            graphics.textSize((float)ts);
            graphics.text(str2, 0.0f, 0.0f, (float)graphics.width, (float)graphics.height);
            graphics.endDraw();
            this.blurredText = this.blur(this.blur((PImage)graphics));
        }
        float textAlpha = (float)this.moonlander.getValue("titleTextAlpha");
        this.loadPixels();
        int y = 0;
        while (y < this.height) {
            int x = 0;
            while (x < this.width) {
                int blurredPx = this.blurredText.pixels[this.blurredText.width * y + x];
                if (this.red(blurredPx) != 0.0f || this.green(blurredPx) != 0.0f || this.blue(blurredPx) != 0.0f) {
                    this.pixels[this.blurredText.width * y + x] = this.alphaBlend(blurredPx, this.pixels[this.blurredText.width * y + x], textAlpha);
                }
                ++x;
            }
            ++y;
        }
        this.updatePixels();
    }

    public void dezgegEffect() {
        this.resetMatrix();
        this.ortho();
        this.translate(-this.width / 2, -this.height / 2);
        int wh = Math.min(this.width, this.height) / 4;
        float timeSin = (float)this.moonlander.getValue("colorEffectTimeSinMult") * demo.cos((float)((float)Math.PI * 2 * (0.125f * (float)this.moonlander.getCurrentRow())));
        float cwDelta = (float)this.moonlander.getValue("colorEffectHueDelta");
        float cwFade = (float)this.moonlander.getValue("colorEffectFadeout");
        PImage img = this.colorWheel(cwDelta + timeSin, cwFade, wh, wh);
        int swWidth = (int)(this.moonlander.getValue("colorEffectSineWaveWidth") * (double)wh);
        int swHeight = (int)(this.moonlander.getValue("colorEffectSineWaveHeight") * (double)wh);
        img = this.sineWaveBoth(img, 2, swHeight, 2, swWidth);
        int waterLR = (int)(this.moonlander.getValue("colorEffectWaterLR") * (double)wh);
        int waterUD = (int)(this.moonlander.getValue("colorEffectWaterUD") * (double)wh);
        img = this.waterWith(img, img, waterLR, waterUD);
        int sw2Width = (int)(this.moonlander.getValue("colorEffectSineWave2Width") * (double)wh);
        int sw2Height = (int)(this.moonlander.getValue("colorEffectSineWave2Height") * (double)wh);
        img = this.sineWaveBoth(img, 4, sw2Height, 2, sw2Width);
        this.drawTiled(img);
    }

    public void doFade(float amount) {
    }

    public void wavesEffect() {
        this.pushStyle();
        this.pushMatrix();
        this.noStroke();
        float fadein = (float)this.moonlander.getValue("waves_fadein");
        int zoom = this.moonlander.getIntValue("waves_zoom");
        float ambient = 0.8f;
        this.ambientLight(255.0f * (1.0f - ambient), 255.0f * (1.0f - ambient), 255.0f * (1.0f - ambient));
        this.lightFalloff(1.0f, 0.0f, 1.0E-5f / (float)zoom);
        this.translate(0.0f, 0.0f, zoom);
        this.pointLight(this.red(this.teal), this.green(this.teal), this.blue(this.teal), 0.0f, 0.0f, 200.0f);
        float time = (float)this.moonlander.getCurrentTime();
        float beat = (float)this.moonlander.getCurrentRow();
        float boxSize = 30.0f;
        demo.pow((float)((1.0f + demo.sin((float)beat)) / 2.0f), (float)2.0f);
        int x = -40;
        while (x < 40) {
            int y = -30;
            while (y < 30) {
                this.pushMatrix();
                float z_wave = demo.pow((float)((1.0f + demo.sin((float)(demo.sqrt((float)(x * x + y * y)) + beat / 2.0f))) / 2.0f), (float)4.0f);
                this.translate((float)x * boxSize, (float)y * boxSize, this.noise(x, y, time) * 20.0f + z_wave * 30.0f);
                this.translate((float)(-x) * boxSize * (float)(zoom - 1) / 1000.0f, (float)(-y) * boxSize * (float)(zoom - 1) / 1000.0f, -demo.pow((float)((float)(zoom - 1) / demo.sqrt((float)(x * x + y * y))), (float)1.2f));
                this.box(fadein * boxSize * 2.0f * (1.0f - 2.0f * this.noise(x + 40, y + 30)));
                this.popMatrix();
                ++y;
            }
            ++x;
        }
        this.popMatrix();
        this.popStyle();
    }

    public void puu(float x, float y, float dist, float d) {
        if (d > 4.0f) {
            return;
        }
        float time = (float)this.moonlander.getCurrentTime();
        if (this.noise(x, y, d) < 0.1f * d && d > 2.5f) {
            return;
        }
        float p = -20.0f / d;
        this.line(0.0f, 0.0f, 0.0f, 0.0f, p, 0.0f);
        this.translate(0.0f, p, 0.0f);
        int i = 0;
        while (i < 3) {
            float n = 0.5f - this.noise(x, y, time / 5.0f + PApplet.parseFloat((int)i) / 3.0f + d);
            this.rotateZ(1.0471976f * (float)(-1 + i) + (n *= 2.0f));
            this.puu(x, y, dist, d + 1.0f);
            this.rotateZ(-1.0471976f * (float)(-1 + i) - n);
            ++i;
        }
        this.translate(0.0f, -p, 0.0f);
    }

    public void treeEffect() {
        this.pushStyle();
        this.pushMatrix();
        float curParam = (float)this.moonlander.getValue("treeCursorParam");
        float curParam2 = curParam * curParam;
        this.textSize(100.0f);
        float fadeout = Math.min(Math.min(demo.map((float)curParam, (float)0.9f, (float)1.0f, (float)1.0f, (float)0.0f), demo.map((float)curParam, (float)0.0f, (float)0.004f, (float)0.0f, (float)1.0f)), 1.0f);
        this.fill(255.0f * fadeout);
        this.text(this.credits, 900.0f - (this.textWidth(this.credits) + 700.0f) * curParam, -300.0f);
        this.rotateX(-0.17453294f);
        this.pushMatrix();
        this.translate(0.0f, -100.0f, 950.0f - 2500.0f * curParam2);
        this.rotateX((1.0f - curParam2) * 0.5f * (float)Math.PI);
        this.rotateZ((1.0f - curParam2 * curParam2) * 0.35f);
        this.mousePointer3D(50.0f, 5.0f);
        this.popMatrix();
        float time = (float)this.moonlander.getCurrentTime();
        this.translate(0.0f, -100.0f, 500.0f + time * 100.0f);
        float jd = 2.0f * time;
        float j1 = -10.0f - jd;
        float j2 = 10.0f - jd;
        int i = -7;
        while (i <= 7) {
            int j = (int)j1;
            while (j < (int)j2) {
                if (i < -1 || i > 1) {
                    float nx = this.noise(i, j) - 0.5f;
                    float nz = this.noise(j, i);
                    float dx = 50.0f * ((float)i + nx);
                    float dz = 50.0f * ((float)j + nz);
                    this.translate(dx, 0.0f, dz);
                    if (j % 2 == 0) {
                        this.stroke(this.hsvToRgb(this.hue(this.fuchsia) / 255.0f, this.saturation(this.fuchsia) / 255.0f, demo.map((float)j, (float)j1, (float)j2, (float)0.0f, (float)1.0f) * fadeout));
                    }
                    if (j % 2 != 0) {
                        this.stroke(this.hsvToRgb(this.hue(this.teal) / 255.0f, this.saturation(this.teal) / 255.0f, demo.map((float)j, (float)j1, (float)j2, (float)0.0f, (float)1.0f) * fadeout));
                    }
                    if (j % 3 == 0) {
                        this.stroke(this.hsvToRgb(this.hue(this.paleBlue) / 255.0f, this.saturation(this.paleBlue) / 255.0f, demo.map((float)j, (float)j1, (float)j2, (float)0.0f, (float)1.0f) * fadeout));
                    }
                    this.strokeWeight(this.height / 240);
                    this.puu(i, j, dz, 1.0f);
                    this.translate(-dx, 0.0f, -dz);
                }
                ++j;
            }
            ++i;
        }
        this.popMatrix();
        this.popStyle();
    }

    public void namedropEffect() {
        this.pushStyle();
        this.pushMatrix();
        this.fill(255);
        this.textSize(100.0f);
        this.text(this.name, -600.0f, -200.0f, 0.0f);
        float factor = (float)this.moonlander.getValue("dangle_factor");
        this.translate(215.0f, -150.0f, 0.0f);
        this.rotateZ(demo.sin((float)((float)Math.PI * 2 * factor * 3.0f)));
        this.translate(0.0f, 200.0f, 0.0f);
        this.rotateZ(demo.sin((float)0.5235988f));
        this.mousePointer3D(70.0f, 1.0f);
        this.popMatrix();
        this.popStyle();
    }

    public void draw() {
        float fade;
        int effect;
        this.moonlander.update();
        float fov = 1.0471976f;
        float cameraZ = (float)this.height / 2.0f / demo.tan((float)(fov / 2.0f));
        this.perspective(fov, PApplet.parseFloat((int)this.width) / PApplet.parseFloat((int)this.height), cameraZ / 100.0f, cameraZ * 10.0f);
        this.camera(0.0f, 0.0f, 1000.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f);
        this.background(0);
        if (this.firstFrame) {
            this.textSize(100.0f);
            this.textWidth(this.name);
            this.textWidth(this.credits);
            this.firstFrame = false;
        }
        if ((effect = this.moonlander.getIntValue("effect")) == 0) {
            this.flyingPointerEffect();
        }
        if (effect == 1) {
            this.dezgegEffect();
        }
        if (effect == 9) {
            this.namedropEffect();
        }
        if (effect == 2) {
            this.cubeEffect();
        }
        if (effect == 3) {
            this.wavesEffect();
        }
        if (effect == 4) {
            this.boxTunnelEffect();
        }
        if (effect == 5) {
            this.treeEffect();
        }
        if ((fade = (float)this.moonlander.getValue("fade")) < 1.0f) {
            this.doFade(fade);
        }
    }

    public static void main(String[] passedArgs) {
        String[] appletArgs = new String[]{"demo"};
        if (passedArgs != null) {
            PApplet.main((String[])demo.concat((String[])appletArgs, (String[])passedArgs));
        } else {
            PApplet.main((String[])appletArgs);
        }
    }
}

