// rectangular lens

class LensTest2 extends Scene {
  void init() {
    // load shaders here or globally?
  }
  void render() {

    PGraphics fb = frameBuffer1;

    fb.beginDraw();
    fb.background(0);
    fb.noStroke();

    translate(- width / 2, -height / 2);
    randomSeed(0);

    fb.ellipseMode(CENTER);

    int boxsize = 50;
    float bs1 = (float) (boxsize / Math.sqrt(2));

    for(int y = 0; y < height + boxsize; y += boxsize) {
      for(int x = 0; x < width + boxsize; x += boxsize) {
        fb.pushMatrix();
        fb.translate(x, y);
        fb.rotate((float) Math.PI * 0.25);

        fb.fill((int) x * 1.0 / width * 255, (int) (y * 1.0/height * 255), 0, 255);
        fb.rectMode(CENTER);
        fb.rect(0, 0, bs1, bs1);
        fb.popMatrix();
      }
    }

    fb.endDraw();

    float p = (float) moonlander.getValue("lens parameter");
    int s = (int) moonlander.getValue("lens seed");
    int lensCount = max((int) moonlander.getValue("lens count"), 0);

    randomSeed(s);

    // bounce lens rendering between two framebuffers (might be very bad idea (inefficient))
    PGraphics fba = fb;
    PGraphics fbb = frameBuffer2;

    int i;
    for(i = 0; i < lensCount; i++) {
      float la = random(0, 1) + random(-1, 1) * p;
      float lb = random(0, 1);
      float lc = random(lensMinW, lensMaxW);
      float ld = random(lensMinH, lensMaxH);

      if(random(0, 1) < 0.5) {
        rectLens.set("lensCenterX", la);
        rectLens.set("lensCenterY", lb);
        rectLens.set("lensW", lc);
        rectLens.set("lensH", ld);
      } else {
        rectLens.set("lensCenterX", lb);
        rectLens.set("lensCenterY", la);
        rectLens.set("lensW", ld);
        rectLens.set("lensH", lc);
      }
      rectLens.set("zoomFactor", random(lensMinZoom, lensMaxZoom));

      fbb.beginDraw();
      fbb.shader(rectLens);
      fbb.image(fba, 0, 0);
      fbb.endDraw();


      if(i % 2 == 0) {
        fba = frameBuffer2;
        fbb = fb;
      } else {
        fba = fb;
        fbb = frameBuffer2;
      }

    }

    if(i % 2 == 1) {
      fbb = fb;
    }

    image(fbb, 0, 0);
  }
}
