// A class to describe a group of Particles
// An ArrayList is used to manage the list of Particles

class ParticleSystem {
  ArrayList<Particle> particles;
  PVector origin;
  color col;
  float size;
  int max_particles = 100; // TODO: increase this to at least 100-200 (depending on perf)

  ParticleSystem(PVector position, color col, float size) {
    origin = position.copy();
    this.col = col;
    this.size = size;
    particles = new ArrayList<Particle>();
  }

  void addParticle() {
    if(particles.size() <= max_particles)
    particles.add(new Particle(origin, col, size));
  }

  void updateOrigin(PVector newOrigin) {
    origin = newOrigin.copy();
  }

  void run() {
    for (int i = particles.size()-1; i >= 0; i--) {
      Particle p = particles.get(i);
      p.run();
      if (p.isDead()) {
        particles.remove(i);
      }
    }
  }

  void display(PGraphics fb) {
    for (int i = particles.size()-1; i >= 0; i--) {
      Particle p = particles.get(i);
      p.display(fb);
    }
  }
}
