// A simple Particle class

class Particle {
  PVector position;
  PVector velocity;
  PVector acceleration;
  color col;
  float lifespan;
  float age;
  float size;

  Particle(PVector l, color col, float size) {
    randomSeed((long) (moonlander.getValue("time") * 1000));
    //acceleration = new PVector(random(-0.1, 0.1), random(-0.1, 0.1));
    //velocity = new PVector(random(-2.5, 2.5), random(-2.5, 2.5));
    velocity = new PVector(0, 0);
    position = l.copy();
    lifespan = (float) moonlander.getValue("particle_lifespan");
    this.col = col;
    this.age = 0;
    //this.size = size;
  }

  void run() {
    update();
    //display(null);
  }

  // Method to update position
  void update() {
    randomSeed((long) ((moonlander.getValue("time") + position.x) * 1000) );
    //randomSeed((long) position.x);
    //randomSeed(0);
    //velocity.add(new PVector(random(-0.5, 0.5), random(-0.5, 0.5)));
    //velocity.add(acceleration);
    //position.add(velocity);

    // random velocity, use with caution
    float rv = (float) moonlander.getValue("s1randomVel");
    float rvx = rv * width * 0.5 * random(-0.5, 0.5);
    float rvy = rv * height * 0.5 * random(-0.5, 0.5);
    position.add(rvx, rvy);
    //lifespan -= 1.0;
    age += 1;
  }

  // Method to display
  void display(PGraphics fb) {
    randomSeed((long) ((moonlander.getValue("time") + position.y) * 1000) );
    //randomSeed((long) position.y );
    //randomSeed(0);
    //float r = size; - lifespan/2;
    float s = (float) moonlander.getValue("scene1particleSize");
    float k = (float) moonlander.getValue("kick");
    float ks = (float) moonlander.getValue("kick scale factor");
    float strength = 1 - age / lifespan;
    float r = strength * s * (1 + k * ks);
    if(fb == null) {
      //stroke(col, lifespan);
      ////fill(255, lifespan);
      //ellipse(position.x, position.y, r, r);

    } else {
      fb.strokeWeight(r / 10);
      fb.stroke(col, 255 * (1 - (1 - strength) * 0.5));
      //fb.fill(255, lifespan);
      fb.noFill();
      float rp = (float) moonlander.getValue("s1randomPos");
      float rx = rp * width * 0.5 * random(-1, 1);
      float ry = rp * height * 0.5 * random(-1, 1);
      fb.ellipse(position.x * (1 - rp) + rx, position.y * (1 - rp) + ry, r, r);
    }
  }

  // Is the particle still useful?
  boolean isDead() {
    //if (lifespan < 0.0) {
    if (age >= lifespan) {
      return true;
    } else {
      return false;
    }
  }
}
