//IMPORTS FOR LIBRARIES
import ddf.minim.*;
import ddf.minim.analysis.*;
import ddf.minim.effects.*;
import ddf.minim.signals.*;
import ddf.minim.spi.*;
import ddf.minim.ugens.*;
import moonlander.library.*;
import ch.bildspur.postfx.builder.*;
import ch.bildspur.postfx.pass.*;
import ch.bildspur.postfx.*;

//shader asignments
PostFXSupervisor supervisor;
InvertPass sobelPass;
Glitches glitches;


//Moonlander audiosync
Moonlander moonlander;

// we pass the canvas through postFX
PGraphics canvas;

//custom font
PFont font;
int fontsize = 0;

// Quote texts
// This is the textscene2 and 3 text
char[] msg1 = "As far as i know,".toCharArray();
char[] msg2 = "you really shouldn't exist.".toCharArray();

void setup()
{
  //window
  //size(1920, 1080, P2D);
  fullScreen(P2D);
  
  //supervisor and new shaders for FX
  supervisor = new PostFXSupervisor(this);
  glitches = new Glitches();
  sobelPass = new InvertPass(this); 
  //graphics canvas
  canvas = createGraphics(width, height, P3D);
  //audio load
  moonlander = Moonlander.initWithSoundtrack(this,"audio.wav",82,4);
  //rasterize and apply font
  font = createFont("C64_Pro-STYLE.ttf",100);
  fontsize = height / 30;
  //init for audio sync
  moonlander.start("localhost", 1338, "data/syncdata.rocket");
}

boolean glitchflash= false;
void draw()
{
    

  noCursor();
  //update audio and moonlander vars
  moonlander.update();
  float rot = (float) moonlander.getValue("rot");
  int scene = (int) moonlander.getValue("scene");
  float fadeIn = (int) moonlander.getValue("fadein");
  
  if (moonlander.getValue("glitchflash") == 1)
    glitchflash = true;
  else
    glitchflash = false;

  //begin canvas drawing
  canvas.beginDraw();
  canvas.textFont(font);
  
  switch(scene)
  {
    case 0:
      titlescene();
      break;
    case 10:
      thankscene();
      break;
    case 20:
      cubescene(rot);
      break;
    case 30:
      textscene2(fadeIn);
      break;
    case 40:
      cubescene(rot);
      break;
    case 50:
      textscene3(fadeIn);
      break;
    case 60:
      cubescene2(rot,fadeIn);
      break; 
    case 70:
      cubescene2 (rot,fadeIn);
      break;
    case 80:
      cubescene(rot);
      break;
    case 90:
      cubescene3();
      break;
    case 100:
      ballscene();
      break;
    case 110:
      cubetransform();
      break;
    case 420:
      endcredits(fadeIn);
      break;
    case 999:
      exit();
    default:
      cubescene(rot);
  }
  canvas.endDraw();
  //canvas has been drawn
  
  // apply post FX
  blendMode(BLEND);
  supervisor.render(canvas);

  if (glitchflash)
  {
    glitches.shader.set("colorshift",true);
    supervisor.pass(sobelPass);
  }
  else
  {
     glitches.shader.set("colorshift",false);
       
  }
  //scene based selection
  switch(scene)
  {
    case 40:
      supervisor.pass(glitches);
      break;
    case 60:
      supervisor.pass(glitches);
      glitches.shader.set("wiggle",false);
      glitches.shader.set("scan",false);
      glitches.shader.set("colorshift",false);
      
      break;
    case 70:
      glitches.shader.set("wiggle",true);
      glitches.shader.set("scan",false);
      glitches.shader.set("colorshift",true);
      supervisor.pass(glitches);
      break;
    case 100:
      supervisor.pass(glitches);
      break;
    case 110:
      glitches.shader.set("wiggle",true);
      glitches.shader.set("scan",false);
      glitches.shader.set("colorshift",true);
      supervisor.pass(glitches);
      break;
    default:
      supervisor.pass(glitches);
      
      glitches.shader.set("wiggle",false);
      glitches.shader.set("scan",false);
      glitches.shader.set("colorshift",false);
      //do nothing
  }
  supervisor.compose();
  
}
