void cubescene(float rot)
{
  float floora = PI/2;
  canvas.background(255);
  canvas.lights();
  //cube
  canvas.pushMatrix();
  canvas.translate(width / 2, height / 3);
  
  canvas.rotateX(radians(rot % 360));
  canvas.rotateZ(radians(rot % 360));
  
  canvas.noStroke();
  canvas.fill(30, 30, 30);
  canvas.box(200);
  canvas.popMatrix(); 
  
  
  //floor
  canvas.pushMatrix();
  canvas.noStroke();
  canvas.fill(250, 250, 250);
  canvas.translate(width / 2, 2*height / 3);
  canvas.rectMode(CENTER);
  canvas.rotateX(floora);
  canvas.rect(0,0,10000,10000);
  canvas.popMatrix(); 
 
  
  canvas.ellipseMode(CENTER);
  for(int i = 100;i>1;i--)
  {
    canvas.pushMatrix();
    canvas.translate(width / 2, (2-(100-i)*0.0002)*height / 3);
    canvas.rotateX(floora);
    canvas.fill(2.5*i, 2.5*i, 2.5*i);
    canvas.ellipse(0,0,3*i,3*i);
    canvas.popMatrix(); 
  }

}
