/*
 * Decompiled with CFR 0.152.
 */
package ch.bildspur.postfx.pass;

import ch.bildspur.postfx.Supervisor;
import ch.bildspur.postfx.pass.Pass;
import java.net.URL;
import java.nio.file.Paths;
import processing.core.PApplet;
import processing.core.PGraphics;
import processing.core.PImage;
import processing.opengl.PShader;

public abstract class BasePass
implements Pass {
    PShader shader;
    PApplet sketch;

    public BasePass(PApplet sketch, String passName) {
        this.sketch = sketch;
        this.shader = sketch.loadShader(Paths.get(this.getLibPath(), "shader", passName + ".glsl").toString());
    }

    @Override
    public void prepare(Supervisor supervisor) {
    }

    @Override
    public void apply(Supervisor supervisor) {
        PGraphics pass = supervisor.getNextPass();
        supervisor.clearPass(pass);
        pass.beginDraw();
        pass.shader(this.shader);
        pass.image((PImage)supervisor.getCurrentPass(), 0.0f, 0.0f);
        pass.endDraw();
    }

    private String getLibPath() {
        URL url = this.getClass().getResource(BasePass.class.getSimpleName() + ".class");
        if (url != null) {
            String path = url.toString().replace("%20", " ");
            if (!path.contains(".jar")) {
                return this.sketch.sketchPath();
            }
            int n0 = path.indexOf(47);
            int n1 = -1;
            String fullJarPath = BasePass.class.getProtectionDomain().getCodeSource().getLocation().getPath();
            if (PApplet.platform == 1) {
                fullJarPath = fullJarPath.substring(1);
            }
            String jar = Paths.get(fullJarPath, new String[0]).getFileName().toString();
            n1 = path.indexOf(jar);
            if (PApplet.platform == 1) {
                ++n0;
            }
            if (-1 < n0 && -1 < n1) {
                return path.substring(n0, n1);
            }
            return this.sketch.sketchPath();
        }
        return this.sketch.sketchPath();
    }

    public PShader getShader() {
        return this.shader;
    }
}

