/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import moonlander.library.Moonlander;
import processing.core.PApplet;
import processing.core.PFont;

public class graffathon
extends PApplet {
    Moonlander moonlander;
    PFont t;
    PFont g;
    float d = 1.0f;
    int size;
    float tStart;
    float xDef;
    float yDef;
    float zDef;
    float sizeDef;
    float distanceDef;
    String kela;
    String drunch;
    String greet;
    String uki;
    String deka;
    String lors;
    String semilors;
    String title;
    String presents;
    String graffathon;
    String tommila;
    String kala;
    String eeli;
    String music;
    String code;
    float xorig;
    float yorig;
    float vx;
    float xpos;
    float ypos;
    float hue;
    float custart;
    float cupos;
    float cpos;
    int titleSize;
    int greetSize;
    int cur;
    int bpm;
    Letter[] dGreet;
    Letter[] tit;
    Letter cu;
    float[] lin;
    float[] noises;
    boolean setup;
    ArrayList<ArrayList<Integer>> values;
    ArrayList<Float> nois;
    String[][] l = this.grid();
    int m = 0;
    float[][][] coords = new float[][][]{new float[][]{{0.0f, 2.0f}, {1.0f, 3.0f}, {2.0f, 1.0f}, {2.0f, 2.0f}, {2.0f, 3.0f}}, new float[][]{{1.0f, 1.0f}, {1.0f, 3.0f}, {2.0f, 2.0f}, {2.0f, 3.0f}, {3.0f, 2.0f}}, new float[][]{{1.0f, 3.0f}, {2.0f, 1.0f}, {2.0f, 3.0f}, {3.0f, 2.0f}, {3.0f, 3.0f}}, new float[][]{{1.0f, 3.0f}, {2.0f, 3.0f}, {2.0f, 4.0f}, {3.0f, 2.0f}, {3.0f, 3.0f}}};

    public void setup() {
        this.size = this.width * this.height;
        this.noCursor();
        this.noises = new float[72];
        this.values = new ArrayList();
        this.nois = new ArrayList();
        this.noiseSeed(0L);
        this.frameRate(60.0f);
        this.bpm = 82;
        this.moonlander = Moonlander.initWithSoundtrack((PApplet)this, (String)"./data/Helium.mp3", (int)this.bpm, (int)8);
        this.xDef = 1000.0f;
        this.yDef = 2000.0f;
        this.zDef = 0.0f;
        this.sizeDef = 1.0f;
        this.distanceDef = 500.0f;
        this.greet = "Greetings to:";
        this.deka = "dekadenssi boys";
        this.lors = "FK-L\u00f6rs";
        this.semilors = "FK-Semil\u00f6rs";
        this.uki = "ukimies";
        this.title = "Pelkk\u00e4\u00e4 p\u00f6hin\u00e4\u00e4";
        this.presents = "fkbois @ Graffathon 2018 presents:";
        this.graffathon = "Graffathon 2018";
        this.tommila = "tommila";
        this.kala = "kalamies";
        this.eeli = "eeli";
        this.music = "Music";
        this.code = "Code";
        this.drunch = "Drunch pizza";
        this.kela = "Kela";
        this.greetSize = this.height / this.deka.length();
        this.titleSize = graffathon.ceil((float)(this.width / this.title.length()));
        this.t = this.createFont("./data/fonts/Black_Ops_One/BlackOpsOne-Regular.ttf", this.titleSize);
        this.g = this.createFont("./data/fonts/Righteous-Regular.ttf", this.greetSize);
        this.textFont(this.t);
        this.textAlign(3, 3);
        this.background(0);
        this.fill(240.0f, 100.0f, 100.0f);
        this.text("Loading", this.width / 2, this.height / 2);
        this.colorMode(3, 360.0f, 100.0f, 100.0f);
        this.dGreet = this.letterList(this.deka, this.width, this.titleSize / 2, this.g, this.greetSize);
        this.setup = true;
    }

    public String[][] grid() {
        String[][] g = new String[10][100];
        int x = 0;
        while (x < g.length) {
            int z = 0;
            while (z < g[0].length) {
                g[x][z] = Integer.toString((int)this.random(10.0f));
                ++z;
            }
            ++x;
        }
        return g;
    }

    public float[] drawGlider(int j, float time) {
        int step = 15;
        this.color(255);
        this.noStroke();
        this.lights();
        float[][] data = this.gliderCoords(step, time, this.coords[j]);
        int i = 0;
        while (i < data.length) {
            this.pushMatrix();
            this.translate(data[i][0], data[i][1]);
            this.fill(255);
            this.box(step);
            this.popMatrix();
            ++i;
        }
        return data[0];
    }

    public float[][] gliderCoords(int step, float time, float[][] coords) {
        float[][] out = new float[coords.length][coords[0].length];
        int i = 0;
        while (i < coords.length) {
            float[] a = new float[]{(float)step * coords[i][0] + time, (float)step * coords[i][1] + time};
            out[i] = a;
            ++i;
        }
        return out;
    }

    public void drawNumberGrid(int xPos, int yPos, int zPos, float t1, float t2, float t3) {
        int size = 15;
        this.pushMatrix();
        this.translate(xPos, yPos, zPos);
        this.rotateZ(graffathon.radians((float)60.0f));
        int x = 0;
        while (x < 10) {
            int z = 0;
            while (z < 100) {
                this.pushMatrix();
                this.fill(0.0f, 255.0f, 0.0f);
                this.textSize(2 * size);
                this.translate(x * size, 0.0f, 2 * size * z - 50 * size);
                if (x == 0 || x == 4 || x == 8) {
                    this.translate(0.0f, 0.0f, t1);
                }
                if (x == 1 || x == 3 || x == 5 || x == 7 || x == 9) {
                    this.translate(0.0f, 0.0f, t2);
                }
                if (x == 2 || x == 6) {
                    this.translate(0.0f, 0.0f, t3);
                }
                this.rotateX(graffathon.radians((float)-90.0f));
                this.text(this.l[x][z], 0.0f, 0.0f, 0.0f);
                this.popMatrix();
                ++z;
            }
            ++x;
        }
        this.fill(0);
        this.noStroke();
        this.rotateX(graffathon.radians((float)-90.0f));
        this.rotateZ(graffathon.radians((float)180.0f));
        this.rectMode(1);
        this.translate(0.0f, 0.0f, 1.0f);
        this.rect(size, 20 * size, -size * 11, 1000.0f);
        this.rect(size, 0.0f, -size * 11, -1000.0f);
        this.popMatrix();
    }

    public void draw() {
        if (this.setup) {
            this.lin = this.linspace(1.0f, -10.0f, 72);
            this.noises = this.linspace(0.0f, 4.672f, 72);
            int j = 0;
            while (j < 72) {
                this.values.add(new ArrayList());
                float x0 = 0.001643722f;
                float y0 = -0.8224676f;
                float scale = graffathon.exp((float)this.lin[j]);
                int i = 0;
                while (i < this.size) {
                    int xIndex = i % this.width;
                    int yIndex = i / this.width;
                    float xNormalized = graffathon.map((float)(xIndex - this.width / 2), (float)(-this.height / 2), (float)(this.height / 2), (float)-1.0f, (float)1.0f);
                    float yNormalized = graffathon.map((float)(yIndex - this.height / 2), (float)(-this.height / 2), (float)(this.height / 2), (float)-1.0f, (float)1.0f);
                    float xInc = x0 + scale * xNormalized;
                    float yInc = y0 + scale * yNormalized;
                    float x = 0.0f;
                    float y = 0.0f;
                    int max_iteration = 100;
                    int iteration = 0;
                    while (x * x + y * y < 4.0f && iteration < max_iteration) {
                        float xTemp = x * x - y * y + xInc;
                        y = 2.0f * x * y + yInc;
                        x = xTemp;
                        ++iteration;
                    }
                    this.values.get(j).add(iteration);
                    ++i;
                }
                this.nois.add(Float.valueOf(this.noise(this.noises[j])));
                ++j;
            }
            this.moonlander.start("localhost", 1338, "./data/syncdata.rocket");
            this.setup = !this.setup;
        } else {
            this.moonlander.update();
            float time = (float)this.moonlander.getCurrentTime();
            int flag = (int)this.moonlander.getValue("flag");
            if (flag == 2) {
                this.draw1(this.tStart);
            } else if (flag == 1) {
                this.draw2();
            } else {
                this.draw3(time);
            }
            int exit = (int)this.moonlander.getValue("exit");
            if (exit == 1) {
                this.exit();
            }
        }
    }

    public void draw1(float tStart) {
        this.colorMode(1, 255.0f);
        float t1 = (float)this.moonlander.getValue("xEye");
        float t2 = (float)this.moonlander.getValue("yEye");
        float t3 = (float)this.moonlander.getValue("zEye");
        float t4 = (float)this.moonlander.getValue("xCenter");
        float t5 = (float)this.moonlander.getValue("yCenter");
        float t6 = (float)this.moonlander.getValue("zCenter");
        float t7 = (float)this.moonlander.getValue("Grid1Pos");
        float t8 = (float)this.moonlander.getValue("Grid2Pos");
        float t9 = (float)this.moonlander.getValue("Grid3Pos");
        this.moonlander.getValue("fade");
        this.background(0);
        float time = (float)this.moonlander.getCurrentTime() - tStart;
        this.drawGlider(this.m / 10 % 4, 100.0f * time);
        ++this.m;
        if (this.m / 10 % 4 == 0) {
            this.d += 0.01f;
        }
        float eyeX = t1;
        float eyeY = t2;
        float eyeZ = t3;
        float centerX = t4;
        float centerY = t5;
        float centerZ = t6;
        float upX = 0.0f;
        float upY = 0.0f;
        float upZ = -1.0f;
        this.camera(eyeX, eyeY, eyeZ, centerX, centerY, centerZ, upX, upY, upZ);
        this.fill(255);
        this.pushMatrix();
        this.translate(1300.0f, 900.0f, 200.0f);
        this.rotateX(graffathon.radians((float)-90.0f));
        this.rotateY(graffathon.radians((float)-60.0f));
        this.textSize(60.0f);
        this.text("sample text", 1800.0f - 150.0f * time, 0.0f, 0.0f);
        this.popMatrix();
        this.drawNumberGrid(1000, 200, -200, t7, t8, t9);
        float x = this.xDef;
        float y = this.yDef;
        float z = this.zDef;
        float size = this.sizeDef;
        float distance = this.distanceDef;
        this.pushMatrix();
        this.fill(128);
        this.stroke(0);
        this.strokeWeight(1.0f);
        this.pushMatrix();
        this.translate(x, y, z);
        this.box(10.0f * size, 200.0f * size, 120.0f * size);
        this.popMatrix();
        this.pushMatrix();
        this.translate((x + distance) * size, y * size, z * size);
        this.box(10.0f * size, 200.0f * size, 120.0f * size);
        this.popMatrix();
        this.pushMatrix();
        this.translate(x - 100.0f, y - 50.0f, z);
        this.rotateZ(graffathon.radians((float)90.0f));
        this.fill(0);
        this.stroke(0);
        this.box(30.0f * size, 200.0f * size, 120.0f * size);
        this.popMatrix();
        this.pushMatrix();
        this.translate((x + distance + 100.0f) * size, y * size - 100.0f, z * size);
        this.rotateZ(graffathon.radians((float)90.0f));
        this.fill(0);
        this.stroke(0);
        this.box(30.0f * size, 200.0f * size, 120.0f * size);
        this.popMatrix();
        float xPosDef = (float)this.moonlander.getValue("zPos");
        float xPos = graffathon.map((float)xPosDef, (float)-1.0f, (float)1.0f, (float)(x - 40.0f), (float)(x + distance + 40.0f));
        this.pushMatrix();
        this.translate(xPos, y * size, z);
        this.colorMode(3, 100.0f);
        this.stroke(30.0f + xPosDef * 50.0f, 80.0f, 80.0f);
        this.fill(30.0f + xPosDef * 50.0f, 80.0f, 80.0f);
        this.sphere(40.0f * size);
        this.popMatrix();
        this.colorMode(1, 255.0f);
        this.pushMatrix();
        this.translate(x + 6.0f, y, z);
        this.rotateY(graffathon.radians((float)90.0f));
        this.fill(0);
        this.stroke(253.0f, 102.0f, 0.0f);
        this.strokeWeight(4.0f);
        this.ellipse(0.0f, 0.0f, 96.0f * size, 180.0f * size);
        this.popMatrix();
        this.pushMatrix();
        this.translate((x + distance) * size - 6.0f, y * size, z * size);
        this.rotateY(graffathon.radians((float)90.0f));
        this.fill(0);
        this.stroke(0.0f, 120.0f, 255.0f);
        this.strokeWeight(4.0f);
        this.ellipse(0.0f, 0.0f, 96.0f, 180.0f);
        this.popMatrix();
        this.popMatrix();
    }

    public void draw2() {
        this.colorMode(3, 100.0f);
        this.loadPixels();
        int frame = (int)this.moonlander.getValue("scale");
        int i = 0;
        while (i < this.size) {
            int c;
            float noiseVal = this.nois.get(frame).floatValue();
            int iteration = this.values.get(frame).get(i);
            float col2 = 100.0f - (float)iteration * (1.0f + noiseVal) % 100.0f;
            this.pixels[i] = c = this.color(iteration, col2, col2);
            ++i;
        }
        this.updatePixels();
        this.tStart = (float)this.moonlander.getCurrentTime();
    }

    public void draw3(float time) {
        this.pushMatrix();
        this.background(0);
        int b = graffathon.floor((float)(time * ((float)this.bpm / 60.0f) / 2.0f - 0.5f)) + 1;
        this.textFont(this.g, this.greetSize);
        int i = 0;
        while (i < this.dGreet.length) {
            Letter l = this.dGreet[i];
            this.xorig = l.xhome;
            this.hue = graffathon.map((float)this.noise(time, i), (float)0.0f, (float)1.0f, (float)0.0f, (float)360.0f);
            int col = this.color(this.hue, 100.0f, 100.0f);
            l.setColor(col);
            this.xpos = this.xorig + this.vx * time;
            this.ypos = this.yorig + this.yorig / 2.0f * graffathon.sin((float)(this.xpos / 30.0f));
            l.move(this.xpos, this.ypos);
            l.draw();
            ++i;
        }
        if (b < 16) {
            this.textFont(this.t);
            this.textSize(this.titleSize);
            this.textAlign(3, 3);
            if (b >= 1) {
                this.textFont(this.t);
                this.textSize(0.6f * (float)this.titleSize);
                this.text(this.presents, this.width / 2, this.textAscent());
            }
            this.textSize(this.titleSize);
            if (b >= 2 && b < 3) {
                this.textFont(this.t);
                this.textAlign(3, 101);
                this.text(this.title, this.width / 2, this.height / 4);
                this.fill(0);
                this.rect(this.width / 2, this.height / 4, this.width / 2, this.height / 2);
            }
            if (b >= 3) {
                this.textFont(this.t);
                this.textAlign(3, 101);
                this.text(this.title, this.width / 2, this.height / 4);
            }
            this.textFont(this.g);
            if (b >= 4 && b < 10) {
                this.text(this.music, this.width / 2, (float)this.height / 2.5f);
            }
            if (b >= 5 && b < 10) {
                this.text(this.uki, this.width / 2, (float)this.height / 2.5f + 0.1f * (float)this.height);
            }
            if (b >= 6 && b < 10) {
                this.text(this.code, this.width / 2, (float)this.height / 2.5f + 0.2f * (float)this.height);
            }
            if (b >= 7 && b < 10) {
                this.text(this.tommila, (float)this.width * 0.25f, (float)this.height / 2.5f + 0.3f * (float)this.height);
            }
            if (b >= 8 && b < 10) {
                this.text(this.kala, this.width / 2, (float)this.height / 2.5f + 0.3f * (float)this.height);
            }
            if (b >= 9 && b < 10) {
                this.text(this.eeli, (float)this.width * 0.75f, (float)this.height / 2.5f + 0.3f * (float)this.height);
            }
            if (b >= 10 && b < 11) {
                this.text(this.greet, this.width / 2, this.height / 2);
            }
            if (b >= 11 && b < 13) {
                this.textAlign(3, 3);
                this.text(this.deka, this.width / 2, this.height / 2);
            }
            if (b >= 12 && b < 13) {
                this.textAlign(3, 3);
                this.text(this.semilors, this.width / 2, (float)this.height * 0.75f);
            }
            if (b >= 13) {
                this.textAlign(3, 3);
                this.text(this.lors, this.width / 2, (float)this.height / 2.2f);
            }
            if (b >= 14) {
                this.textAlign(3, 3);
                this.text(this.drunch, this.width / 2, (float)this.height / 2.2f + 0.1f * (float)this.height);
            }
            if (b >= 15) {
                this.textAlign(3, 3);
                this.text(this.kela, this.width / 2, (float)this.height / 2.2f + 0.2f * (float)this.height);
            }
        }
        this.popMatrix();
    }

    public Letter[] letterList(String s, float x, float y, PFont font, int textSize) {
        this.textFont(font);
        this.textSize(textSize);
        Letter[] ls = new Letter[s.length()];
        int i = 0;
        while (i < ls.length) {
            ls[i] = new Letter(x, y, s.charAt(i), this.color(120, 50, 50));
            x += this.textWidth(s.charAt(i));
            ++i;
        }
        return ls;
    }

    public float[] linspace(float min, float max, int points) {
        float[] f = new float[points];
        int i = 0;
        while (i < points) {
            f[i] = min + (float)i * (max - min) / (float)(points - 1);
            ++i;
        }
        return f;
    }

    public void settings() {
        this.fullScreen("processing.opengl.PGraphics3D");
    }

    public static void main(String[] passedArgs) {
        String[] appletArgs = new String[]{"graffathon"};
        if (passedArgs != null) {
            PApplet.main((String[])graffathon.concat((String[])appletArgs, (String[])passedArgs));
        } else {
            PApplet.main((String[])appletArgs);
        }
    }

    class Letter {
        char letter;
        float x;
        float y;
        float xhome;
        float yhome;
        int col;

        Letter(float x_, float y_, char c, int col_) {
            this.x = x_;
            this.xhome = x_;
            this.y = y_;
            this.yhome = y_;
            this.letter = c;
            this.col = col_;
        }

        public void draw() {
            graffathon.this.fill(this.col);
            graffathon.this.textAlign(37, 3);
            graffathon.this.text(this.letter, this.x, this.y);
        }

        public void move(float dx, float dy) {
            this.x = dx;
            this.y = dy;
        }

        public void setColor(int col_) {
            this.col = col_;
        }
    }
}

