
import moonlander.library.*;
// Minim on pakollinen moonlanderiäänien kanssa
import ddf.minim.*;

Moonlander moonlander;

double player = 0;

//jongbin variables-----------------------------
int jongbin1;
int jongbin2;
int jongbin3;
float speed=0;

//eeromuuttujat---------------------------------
Eero e1 = new Eero();
float t = 0;
float x,y;
int rr =255;
int gg = 255;
int bb = 255;
//
String str = "GRAFFATHON 2018  [team  2F2K]   Oblo, KIM, SONGDAMON & RUISKE   special thanks to Dr. GONZO"; // teksti
PFont fontti; 
int tx, ty; 
////////////Songda var-----------------------
float xRed = 237, xGreen = 255, xBlue = 0;
float yRed = 0, yGreen = 104, yBlue = 255;
 
boolean backwards=false;
int timeLapse=2000;
int timeTrack;

//tommimuuttujat------------------------------
int zvalue = -200;
boolean eka = true;
int cellSize = 25;  //solujen koko
int cellCount = 20;
int minN = 4;
int maxN = 6;
int spawnN = 5;
float timeInSecs;
int past;  //hetki jona viimeisin päivitys tehtiin
int updateInterval = 50;  //päivitysten välinen aika
int likelinessOfbirth = 60;  // todennäköisyydellä solu on elävä kun se alussa luodaan

//luodaan 3d matriisit soluille
Cell[][][] cellMatrix;
Cell[][][] tempMatrix;
Cell[][][] endMatrix;

void setup(){
  
  moonlander = Moonlander.initWithSoundtrack(this, "../data/aruba.mp3", 125, 8);
  
  
  fullScreen(P3D);
  noCursor();
  frameRate(30);
  smooth();

  /////////tekstipelleilyä
  fontti = createFont("arvo.ttf", 80, true);  
  tx = width;
  ty = int(height/6);
  textFont(fontti);
  /////////





  //tehdään soluille säilytysmatriisit
  
  cellMatrix = new Cell[cellCount][cellCount][cellCount];
  tempMatrix = new Cell[cellCount][cellCount][cellCount];
  endMatrix = new Cell[cellCount][cellCount][cellCount];
  
  randomSeed(5);
  
  //täytetään matriisit soluilla
  
  for(int i=0; i<cellCount; i++){
    for(int j=0; j<cellCount; j++){
      for(int k=0; k<cellCount; k++){
        float chance = random(100); 
        int state = 0;
        if(chance > likelinessOfbirth){
          state = 1;
        }
        cellMatrix[i][j][k] = new Cell(new PVector(cellSize*i-(1.0*cellSize*cellCount/2), cellSize*j-(1.0*cellSize*cellCount/2),cellSize*k-(1.0*cellSize*cellCount/2)), state, cellSize);
        tempMatrix[i][j][k] = new Cell(new PVector(cellSize*i-(1.0*cellSize*cellCount/2), cellSize*j-(1.0*cellSize*cellCount/2),cellSize*k-(1.0*cellSize*cellCount/2)), state, cellSize);
        endMatrix[i][j][k] = new Cell(new PVector(cellSize*i-(1.0*cellSize*cellCount/2), cellSize*j-(1.0*cellSize*cellCount/2),cellSize*k-(1.0*cellSize*cellCount/2)), state, cellSize);
      }
    }
  }
  moonlander.start();
}

//int x = frameCount;//just to remember framecount by...

void draw(){
  
  moonlander.update();
  //tommi setup----------------------------------------
  double size = moonlander.getValue("size");
  double rotationX = moonlander.getValue("rotationX");
  double rotationY = moonlander.getValue("rotationY");
  double space = moonlander.getValue("space");
  double endfunk = moonlander.getValue("killAutomata");
  double zvalue = moonlander.getValue("zvalue");
  
 //eero setup---------------------------------------------- 
  int eero = moonlander.getIntValue("eero");
  int eero2 = moonlander.getIntValue("eero2");
  int r = moonlander.getIntValue("r");
  int dir = moonlander.getIntValue("dir");
  int rr = moonlander.getIntValue("rr");
  int gg = moonlander.getIntValue("gg");
  int bb = moonlander.getIntValue("bb");
  
 //341 64 216
 t -=0.07+(int)dir;
  x = r*cos(t)+(int)eero;
  y = r*sin(t)+(int)eero2;
  
 player = moonlander.getIntValue("player");
 
 //jongbin setup-----------------------------------------------------
 
 jongbin1 = moonlander.getIntValue("jongbin1");
 jongbin2 = moonlander.getIntValue("jongbin2");
 jongbin3 = moonlander.getIntValue("jongbin3");
 
 //Songda s---------------------------------------------------------
 double songda = moonlander.getValue("songda");
 double songda2 = moonlander.getValue("songda2");
 
 
 //-----------------------------------------------------------------
  if(player == 0){
    colorMode(HSB,360,100,100);
    e1.DrawEero();
  }else if(player == 1){
    colorMode(RGB,255,255,255);
    Jongbin1();
  }else if(player == 2){
    colorMode(RGB,255,255,255);
    Jongbin2();
     }else if(player == 3){
    colorMode(RGB,255,255,255);
    
    Songda();
  }else{
    
    colorMode(RGB,255,255,255);
    stroke(34);
    
    translate(width/2, height/2, (float)zvalue);
    rotateY((float)rotationX);
    rotateX((float) rotationY);
  
  background(0, 104, 155);
  
  //tutkitaan onko jo aika päivittää ruutu
  if(millis() - past > updateInterval){
    past = millis();
    
    
    if(endfunk == 1 && eka){
      eka = false;
      KillFunction();
    }
    
    
    //Päivitetään tempMatrix tutkimalla cellMatrixin soluja
    for(int i=0; i<cellCount; i++){
      for(int j=0; j<cellCount; j++){
        for(int k=0; k<cellCount; k++){
      
          //lasketaan käsiteltävänä olevan solun elävät naapurit
          int neighbours = countNeighbours(i, j, k, cellMatrix, cellCount);
          
          Cell theCell = tempMatrix[i][j][k];
          cellMatrix[i][j][k].SetColor(neighbours);     
          
          
          //jos solulla on <2 tai >3 elävää naapuria, se tapetaan
          if((neighbours > maxN) || (neighbours < minN)){
            theCell.Kill();
          }
          //jos solu on kuollut ja sillä on 3 elävää naapuria, se herää eloon
          if(cellMatrix[i][j][k].GetState()==0 && neighbours == spawnN){
            theCell.Spawn();
          } 
          
        }
      }
    }
    
    //päivitetään cellMatrixin solut tempMatrixin solujen arvoilla.
    //näin saadaan cellMatrix päivitettyä, mutta pidetään kuitenkin matriisit erillisinä
    //cellmatrix=tempmatrix johtaa siihen, että molemmat viittaa samaan matriisiin = fail
    for(int i=0; i<cellCount; i++){
      for(int j=0; j<cellCount; j++){
        for(int k=0; k<cellCount; k++){
        
          Cell current = cellMatrix[i][j][k];
          
          if(tempMatrix[i][j][k].GetState()==1){
            current.Spawn();
          }else{
            current.Kill();
          }
          current.SetSpace((float)space*i, (float)space*j, (float)space*k);
          current.SetSize((float)(cellSize*size));
          //current.SetColor(tempMatrix[i][j][k].GetColor());
        }
      }
    }    
  }
  //piirretään päivitetty matrix
    for(int i=0; i<cellCount; i++){
      for(int j=0; j<cellCount; j++){
        for(int k=0; k<cellCount; k++){
      
          cellMatrix[i][j][k].draw();
        }
      }
    }
  }
  
}

//laskee annetun solun elävät naapurisolut annetussa solumatriisissa. size == solujen määrä rivissä
int countNeighbours(int xx, int yy, int zz, Cell[][][] matrix, int size){
  int count = 0;
  
  for(int i=-1; i<2; i++){
    for(int j=-1; j<2;j++){
      for(int k=-1; k<2; k++){
        if((i==0 && j==0 && k==0) || (xx+i<0 || xx+i==size) || (yy+j<0 || yy+j==size) || (zz+k<0 || zz+k==size)){
          continue;
        }else {
          count += matrix[xx+i][yy+j][zz+k].GetState();//lukee solun tilan
        } 
      }
    }
  }
  return count;
}

//tarkastaa onko solu reunasolu
boolean isEdgeCell(int xx, int yy, int size){
  return xx == size-1 || xx==0 || yy==size-1 || yy==0; 
}

void Jongbin1(){
  
  fill(0);
  noStroke();
  rectMode(CENTER);
  noiseDetail(1, 0.9);  
  
  background(230);
  for (int x = 0; x < width; x += 12) {
    for (int y = 0; y < height; y += 12) {
      float n = noise(x * 0.005, y * 0.005, frameCount * 0.15);
      pushMatrix();
      translate(x, y);
      rotate(PI * n);
      scale(jongbin1 * n);
      fill(#ff012b);      
      rect(0, 0, 1, 1);
      popMatrix();
    }
  }
}

void Jongbin2(){
  speed+=.10;
  background(255);
  stroke(0,104,255);
  translate(width/2, height/2);
  noFill();
  float r=300;
  for (float i=0.0*PI;i<PI+0.1*PI;i+=0.01*PI) {
    beginShape();
    for (float j=-sin(i)*r;j<sin(i)*r+sin(i);j+=sin(i)*20) {
      curveVertex(j, cos(i)*r+sin(speed-(j/jongbin2))*abs(i*jongbin3));
    }
    endShape();
  }

}

void Songda(){
  
  noiseSeed(243);
  stroke(0,10);
  // noLoop();  // draw() will not loop
  ///////
  timeTrack=millis()+timeLapse;
  
  //background(64);
  
  
  

  float time = millis() * 0.0003;

  noiseDetail(12,0.45);
  noStroke();

  float per = (timeTrack-millis())/float(timeLapse);  
  if (backwards==true){  per = 1-per;}
  surface.setTitle(nf(per*100, 3, 2)+"% Flag="+backwards);
  fill(lerpColor(color(xRed, xGreen, xBlue), color(yRed, yGreen, yBlue), per));
  
  
  for (float x = 0; x < width; x = x + 1) {
  float noiseValue = noise(x/500, time);
  float y = map(noiseValue, 0, 1, 0, height);
  ellipse(x,y,15,height);
  }
  fill(237,255,0);
  for (float x = 0; x < width; x = x + 1) {
  float noiseValue = noise(x/500, time);
  float y = map(noiseValue, 0, 2, 0, height);
  ellipse(x,y,1,1);
  }
  fill(237,255,0);
  for (float x = 0; x < width; x = x + 1) {
  float noiseValue = noise(x/500, time);
  float y = map(noiseValue, 0, 3, 0, height);
  ellipse(x,y,1,1);
  }
  fill(237,255,0);
  for (float x = 0; x < width; x = x + 1) {
  float noiseValue = noise(x/500, time);
  float y = map(noiseValue, 0, 4, 0, height);
  ellipse(x,y,1,1);
  }
  fill(237,255,0);
  for (float x = 0; x < width; x = x + 1) {
  float noiseValue = noise(x/500, time);
  float y = map(noiseValue, 0, 5, 0, height);
  ellipse(x,y,1,1);
  }
  fill(237,255,0);
  for (float x = 0; x < width; x = x + 1) {
  float noiseValue = noise(x/500, time);
  float y = map(noiseValue, 0, 6, 0, height);
  ellipse(x,y,1,1);
  }

//Next inverts diretion  
  if (millis()>timeTrack) {
    timeTrack=millis()+timeLapse;
    backwards=!backwards;
  }
}

void KillFunction(){
  
  minN = 6;
  maxN = 9;
  spawnN = 5; //The killingrules
  
  updateInterval = 200;
  
  cellMatrix = endMatrix;
  //tempMatrix = endMatrix;
  
  /*
  for(int i=0; i<cellCount; i++){
    for(int j=0; j<cellCount; j++){
      for(int k=0; k<cellCount; k++){
        
        float chance = random(100); 
        int state = 0;
        if(chance > likelinessOfbirth){
          state = 1;
        }
        if(state == 0 ){
          cellMatrix[i][j][k].Kill(); 
        }else{
          cellMatrix[i][j][k].Spawn();
        }
      }
    }
  }
  */
}
