import processing.core.*; 
import processing.data.*; 
import processing.event.*; 
import processing.opengl.*; 

import ddf.minim.*; 
import ddf.minim.analysis.*; 
import ddf.minim.effects.*; 
import ddf.minim.signals.*; 
import ddf.minim.spi.*; 
import ddf.minim.ugens.*; 
import moonlander.library.*; 

import java.util.HashMap; 
import java.util.ArrayList; 
import java.io.File; 
import java.io.BufferedReader; 
import java.io.PrintWriter; 
import java.io.InputStream; 
import java.io.OutputStream; 
import java.io.IOException; 

public class cheers extends PApplet {









Moonlander moon;
PImage keiju;
PImage kuvio;;

public void setup(){
  
  frameRate(60);
  
  keiju = loadImage("data/krapulakeiju.png");
  keiju.resize(width, height);
  kuvio = loadImage("data/kuvio.png");
  imageMode(CENTER);
  moon = Moonlander.initWithSoundtrack(this, "data/MoveForward.mp3", 111, 8);
  moon.start("localhost", 1339, "data/synkki");
}

public void taustakaruselli(float time, float val){
  //py\u00f6rii paikallaan keskell\u00e4 ruutua
  float suunta = 0.0f;
  if(val != 4.00f){
    switch(floor(val)){
      case 6:
       suunta = 1.0f;
       break;
       default:
       suunta = -1.0f;
       break;
    }
    pushMatrix();
    float angle = radians(suunta * time/30.0f);
    translate(width/2, height/2);
    rotate(angle);
    scale(1.8f);
    image(kuvio,0,0);
    popMatrix();
  }
}

public void bcolsync(float val){
  int num = floor(val);
  switch(num){
    //kulta
    case 1:
    background(235,240,30);
    break;
    //terrakotta
    case 2:
    background(250,130,40);
    break;
    //tummapunaruskea
    case 3:
    background(210,60,45);
    break;
    //m\u00f6rk\u00f6
    case 4:
    background(keiju);
    break;
    //turkoosi
    case 5:
    background(80,225,115);
    break;
    //oranssi
    default:
    background(250,200,80);
    break;
  }
}

public void spiral(float time){
  pushMatrix();
  translate(width/2, height/2);
  noStroke();
  fill(50, 180,245);
  for(int i = 0; i < 1000; i+=5){
    float r = radians(i*time/2.0f);
    float x = r * cos(r);
    float y = r * sin(r);
    ellipse(x,y,8,8);
  }
  popMatrix();
}

public void draw(){
  moon.update();
  float time = (float)millis();
  background(250,200,80);
  float val = (float)moon.getValue("val");
  bcolsync(val);
  taustakaruselli(time, val);
  spiral(time/1000.0f);
  if(val == 13.0f){
    exit();
  }
}
  public void settings() {  fullScreen();  smooth(); }
  static public void main(String[] passedArgs) {
    String[] appletArgs = new String[] { "cheers" };
    if (passedArgs != null) {
      PApplet.main(concat(appletArgs, passedArgs));
    } else {
      PApplet.main(appletArgs);
    }
  }
}
