var
    debugTime = 0,
    cameraOriginal,
    camera,
    camera2,
    scene,
    renderer,
    particleSystem,
    earthWire,
    material = new THREE.MeshBasicMaterial({
        color: 0xffffff
    }),
    effect,
    effect2,
    effect3,
    histoLum = 1,
    net,
    distanceFromSun = 0,
    nBar = 41,
    sound,
    textGeom = [],
    textMesh = [],
    objectBoundingBox = [],
    fontMaterial = [],
    fontObject,
    fontLoadedObject,
    sceneGeometry,
    sceneMesh,
    lineGeometry,
    lineMaterial,
    lineObject,
    textCounter = 0,
    box,
    whiteMesh,
    musicTimerActual = 0,
    musicTimerActualFIXED = 0,
    musicTimerStart = 0,
    musicTimerFlag = false,
    end = false,
    volume = 1,
    debug = false;

var _app = {

        Player: function () {

            var loader = new THREE.ObjectLoader();

            /*
             ---------------------
             debug
             ------------------------------
             */
            if (debug) {

                var stats = new Stats();
                stats.showPanel(0); // 0: fps, 1: ms, 2: mb, 3+: custom
                document.body.appendChild(stats.dom);


            }
            /*
             ---------------------
             debug END
             ------------------------------
             */

            var events = {};

            var dom = document.createElement('div');

            this.dom = dom;

            this.width = 500;
            this.height = 500;

            this.load = function (json) {

                renderer = new THREE.WebGLRenderer({antialias: true});
                renderer.setClearColor(0x000000);
                renderer.setPixelRatio(window.devicePixelRatio);


                if (json.project.gammaInput) renderer.gammaInput = true;
                if (json.project.gammaOutput) renderer.gammaOutput = true;

                if (json.project.shadows) {

                    renderer.shadowMap.enabled = true;
                    // renderer.shadowMap.type = THREE.PCFSoftShadowMap;

                }

                if (json.project.vr) {

                    renderer.vr.enabled = true;

                }

                dom.appendChild(renderer.domElement);

                this.setScene(loader.parse(json.scene));
                this.setCamera(loader.parse(json.camera));

                events = {
                    init: [],
                    start: [],
                    stop: [],
                    keydown: [],
                    keyup: [],
                    mousedown: [],
                    mouseup: [],
                    mousemove: [],
                    touchstart: [],
                    touchend: [],
                    touchmove: [],
                    update: []
                };

                var scriptWrapParams = 'player,renderer,scene,camera';
                var scriptWrapResultObj = {};

                for (var eventKey in events) {

                    scriptWrapParams += ',' + eventKey;
                    scriptWrapResultObj[eventKey] = eventKey;

                }

                var scriptWrapResult = JSON.stringify(scriptWrapResultObj).replace(/\"/g, '');

                for (var uuid in json.scripts) {

                    var object = scene.getObjectByProperty('uuid', uuid, true);

                    if (object === undefined) {

                        console.warn('_app.Player: Script without object.', uuid);
                        continue;

                    }

                    var scripts = json.scripts[uuid];

                    for (var i = 0; i < scripts.length; i++) {

                        var script = scripts[i];

                        var functions = (new Function(scriptWrapParams, script.source + '\nreturn ' + scriptWrapResult + ';').bind(object))(this, renderer, scene, camera);

                        for (var name in functions) {

                            if (functions[name] === undefined) continue;

                            if (events[name] === undefined) {

                                console.warn('_app.Player: Event type not supported (', name, ')');
                                continue;

                            }

                            events[name].push(functions[name].bind(object));

                        }

                    }

                }

                dispatch(events.init, arguments);

            };

            this.setCamera = function (value) {

                camera = value;
                camera.aspect = this.width / this.height;
                camera.updateProjectionMatrix();


            };

            this.setScene = function (value) {

                scene = value;

            };

            this.setSize = function (width, height) {

                this.width = width;
                this.height = height;

                if (camera) {

                    camera.aspect = this.width / this.height;
                    camera.updateProjectionMatrix();

                }

                if (renderer) {

                    renderer.setSize(width, height);

                }

            };

            function dispatch(array, event) {

                for (var i = 0, l = array.length; i < l; i++) {

                    array[i](event);

                }

            }

            var fadeIn = function () {

                var el = document.querySelector('.js-fade');
                if (el.classList.contains('is-paused')) {
                    el.classList.remove('is-paused');
                }
            }

            var fadeOut = function () {

                if (!end) {
                    var el = document.querySelector('.js-fade');
                    el.classList.add('fade-out');

                    end = !end;
                }

                if (sound.volume() > 0) {
                    (volume < 0 ? volume = 0 : volume -= 0.01);
                    sound.volume(volume)
                }

            }

            var fontLoader = function () {
                var
                    self = this;

                var manager = new THREE.LoadingManager();
                manager.onLoad = function () { // when all resources are loaded
                }

                var font = null;
                fontObject = new THREE.FontLoader(manager);
                fontObject.load('../assets/fonts/font_seas.json', function (response) {
                    fontLoadedObject = response;
                });


                // const fontJson = require( "../assets/fonts/font_seas.json" );
                //
                // fontObject= new THREE.Font( fontJson );
                //

                //
                // fontObject = new THREE.FontLoader();
                // fontObject.load('../assets/fonts/font_seas.json', function(font){
                //     return font
                // });

            }

            var absoluteStaticText = function (text, id, size, time, x, y, z) {
                var
                    self = this;


                /*
                 -----------------------------------
                 init objects
                 -----------------------------------------[
                 */

                fontMaterial[id] = new THREE.LineBasicMaterial({
                    color: 0xffffff,
                    transparent: true,
                    opacity: 0.4,
                    side: THREE.DoubleSide
                });

                textGeom[id] = new THREE.TextBufferGeometry(text,
                    {
                        size: (size !== undefined ? size : 3), height: 0, curveSegments: 1,
                        font: fontLoadedObject, weight: "normal", style: "normal",
                        bevelThickness: 0, bevelSize: 0, bevelEnabled: false,
                        material: 0, extrudeMaterial: 0
                    });

                textMesh[id] = new THREE.Mesh(textGeom[id], fontMaterial[id]);
                textMesh[id].scale.x = textMesh[id].scale.y = textMesh[id].scale.z = 0.202;


                scene.add(textMesh[id]);
                obj = textMesh[id];

                textMesh[id].material.opacity = 1;
                // console.log(object.position.x);
                // textMesh[id].position.set = (x, y, z)
                textMesh[id].position.x = x;
                textMesh[id].position.y = y;
                textMesh[id].position.z = z;

                objectBoundingBox[id] = new THREE.Box3().setFromObject(textMesh[id]);

                textMesh[id].material.opacity = 0;

                /*
                 ---------------------
                 show and hide animation
                 ---------------------------------
                 */
                function animate() {

                    textMesh[id].material.opacity += 0.01;
                    requestAnimationFrame(animate);

                }

                requestAnimationFrame(animate);

                var opaOut = setTimeout(function () {

                    function animateOut() {

                        textMesh[id].material.opacity -= 0.07;
                        requestAnimationFrame(animateOut);

                    }

                    requestAnimationFrame(animateOut);

                }, (time !== null ? time : 3000));

            }

            var staticText = function (text, id, object, speed, offset, y) {
                var
                    self = this;

                /*
                 -----------------------------------
                 init objects
                 -----------------------------------------[
                 */
                fontMaterial[id] = new THREE.LineBasicMaterial({
                    color: 0xffffff,
                    transparent: true,
                    opacity: 0.4,
                    side: THREE.DoubleSide
                });

                textGeom[id] = new THREE.TextBufferGeometry(text,
                    {
                        size: (size !== undefined ? size : 3), height: 0, curveSegments: 1,
                        font: fontLoadedObject, weight: "normal", style: "normal",
                        bevelThickness: 0, bevelSize: 0, bevelEnabled: false,
                        material: 0, extrudeMaterial: 0
                    });

                textMesh[id] = new THREE.Mesh(textGeom[id], fontMaterial[id]);
                textMesh[id].scale.x = textMesh[id].scale.y = textMesh[id].scale.z = 0.202;

                textMesh[id].position.set = (0, 0, 0)
                scene.add(textMesh[id]);

                textMesh[id].material.opacity = 0;


                /*
                 ---------------------
                 animation
                 ---------------------------------
                 */
                function animate() {

                    textMesh[id].position.x = object.position.x + offset;
                    textMesh[id].position.y = object.position.y;
                    requestAnimationFrame(animate);

                }

                requestAnimationFrame(animate);

                var opaOut = setTimeout(function () {

                    function animateOut() {

                        textMesh[id].material.opacity -= 0.07;
                        requestAnimationFrame(animateOut);

                    }

                    requestAnimationFrame(animateOut);

                }, 13000);


            }

            var animateText = function (text, id, time, x, y, size) {

                /*
                 -----------------------------------
                 init objects
                 -----------------------------------------[
                 */
                fontMaterial[id] = new THREE.LineBasicMaterial({
                    color: 0xffffff,
                    transparent: true,
                    opacity: 0.4,
                    side: THREE.DoubleSide
                });

                textGeom[id] = new THREE.TextBufferGeometry(text,
                    {
                        size: (size !== undefined ? size : 3), height: 0, curveSegments: 1,
                        font: fontLoadedObject, weight: "normal", style: "normal",
                        bevelThickness: 0, bevelSize: 0, bevelEnabled: false,
                        material: 0, extrudeMaterial: 0
                    });

                textMesh[id] = new THREE.Mesh(textGeom[id], fontMaterial[id]);
                textMesh[id].scale.x = textMesh[id].scale.y = textMesh[id].scale.z = 0.202;

                textMesh[id].position.set(camera.position.x, (y !== undefined ? y : -10.4), 0);
                console.log(textMesh[id])
                scene.add(textMesh[id]);

                textMesh[id].material.opacity = 0;


                /*
                 ---------------------
                 show and hide animation
                 ---------------------------------
                 */
                function animate() {

                    textMesh[id].material.opacity += 0.01;
                    textMesh[id].position.x -= 0.01;
                    requestAnimationFrame(animate);

                }

                requestAnimationFrame(animate);

                var opaOut = setTimeout(function () {

                    function animateOut() {

                        textMesh[id].material.opacity -= 0.07;
                        requestAnimationFrame(animateOut);

                    }

                    requestAnimationFrame(animateOut);

                }, (time !== null ? time : 3000));


            }

            var animateObject = function (obj, time) {

                if (animateTimer_ < 100) {
                    obj.rotation.x = Math.sin(time * animateSpeed);
                    animateSpeed -= animateSpeed - 0.01
                    animateTimer++;
                } else {
                    obj.rotation.x = Math.sin(time * 0.0008281);
                }

            }

            var prevTime;
            var meteorSpeed = Math.random() * 0.0802

            function animate(time) {
                var
                    self = this;

                // stats.begin();

                // monitored code goes here

                /*
                 --------------------------------------
                 */

                /* szonda rotáció */
                scene.children[0].rotation.x += 0.0001;
                scene.children[0].rotation.y += 0.0014;
                scene.children[0].rotation.z += 0.0024;

                /*
                 zenei részek
                 --------------------------------------
                 */
                nBarHalf = Math.ceil(nBar / 2)
                histo = sound.makeHistogram(nBarHalf);

                var
                    histo3 = (histo[2] / 20 < 0.0012 ? 0.0012 : (histo[2] / 20 > 6 ? 6 : histo[2] / 20)),
                    histo6 = (histo[6] / 20 < 0.0012 ? 0.0012 : (histo[6] / 20 > 6 ? 6 : histo[6] / 20)),
                    histo10 = (histo[10] / 20 < 0.0012 ? 0.0012 : (histo[10] / 20 > 6 ? 6 : histo[10] / 20)),
                    histo14 = (histo[4] / 2920 < 0.022 ? 0.022 : histo[4] / 2920);

                if (histo[1] !== 0 && !musicTimerFlag) {
                    musicTimerStart = time;
                    musicTimerFlag = !musicTimerFlag;
                }
                if (musicTimerFlag) {
                    musicTimerActual = time - musicTimerStart;
                    musicTimerActualFIXED = ( (musicTimerActual + debugTime) / 1000).toFixed(1);

                }

                /*
                 -------------------------------------------------------------
                 [0] szonda
                 [1] bg_gomb /background stramap/

                 [2] fold
                 [3] hold

                 [4] jupiter
                 [5] europe
                 [6] io
                 [7] light - point (main)
                 [8] camera 2
                 [9] callisto
                 [10] ganymede
                 [11] amalthea

                 [13] titan
                 [14] dione
                 [15] calypso
                 [16] mimas
                 [17] enceladus
                 [18] tethys
                 [20] saturn

                 [21] uranus
                 [22] miranda
                 [23] ariel
                 [24] umbriel
                 [25] titania

                 [26] neptune
                 [27] triton
                 [28] protheus
                 -------------------------------------------------------------
                 */

                if (musicTimerActual > 1) {

                    composer.render(scene, camera);

                    /* start */
                    fadeIn();

                    /* szonda start */
                    scene.children[0].position.x = camera.position.x;

                    /* net rotáció */
                    net.rotation.x += 0.001;
                    net.rotation.y += 0.001;
                    net.rotation.z += 0.001;

                    net.material.opacity = ( Math.sin(0.4 * musicTimerActualFIXED) > 0.1 ? 0.1 : Math.sin(0.4 * musicTimerActualFIXED) );

                    /*earth háló */
                    earthWire.position.z = -100;
                    earthWire.material.opacity = (histo3 / 20 < 0.2 ? 0 : histo3 / 100);
                    earthWire.rotation.y += 0.001;

                    earthWire.scale.set(105.8 + histo3, 105.8 + histo3, 105.8 + histo3);

                    /* particleSystem rotáció */
                    particleSystem.rotation.y += 0.001;

                    /* háttér rotáció */
                    scene.children[1].rotation.y += 0.001;

                    /* föld rotáció */
                    scene.children[2].rotation.x += 0;
                    scene.children[2].rotation.y += 0.0071;
                    scene.children[2].rotation.z += 0;

                    /* hold rotáció */
                    scene.children[3].rotation.x += 0;
                    scene.children[3].rotation.y += 0.0071;
                    scene.children[3].rotation.z += 0;

                    /* jupiter rotáció */
                    scene.children[4].rotation.y += 0.0091;
                    scene.children[5].rotation.y += 0.0091;
                    scene.children[6].rotation.y += 0.0091;
                    scene.children[9].rotation.y += 0.0091;
                    scene.children[10].rotation.y += 0.0091;
                    scene.children[11].rotation.y += 0.0091;

                    /* szaturnusz rotáció */
                    scene.children[13].rotation.y += 0.0091;
                    scene.children[14].rotation.y += 0.0091;
                    scene.children[15].rotation.y += 0.0091;
                    scene.children[16].rotation.y += 0.0091;
                    scene.children[17].rotation.y += 0.0091;
                    scene.children[18].rotation.y += 0.0091;
                    // scene.children[20].rotation.y += 0.0091;

                    /* uránusz rotáció */
                    scene.children[21].rotation.y += 0.0091;
                    scene.children[22].rotation.y += 0.0091;
                    scene.children[23].rotation.y += 0.0091;
                    scene.children[24].rotation.y += 0.0091;
                    scene.children[25].rotation.y += 0.0091;

                    /* nept rotáció */
                    scene.children[26].rotation.y += 0.0091;
                    scene.children[27].rotation.y += 0.0091;
                    scene.children[28].rotation.y += 0.0091;

                    /* white mesh move */
                    whiteMesh.position.x = camera.position.x;

                }

                if (musicTimerActualFIXED == 1.0) {


                }

                if (musicTimerActualFIXED == 3.0) {


                }

                /*
                 calculate many many many things
                 -------------------------------------
                 -------------------------------------
                 -------------------------------------
                 -------------------------------------
                 */


                if (musicTimerActualFIXED == 4.0) {

                    /*
                     text
                     -----------------------
                     */
                    if (textMesh[0] == undefined) {

                        animateText('Alone', 0, null, 0, 0);

                    }

                }

                if (musicTimerActualFIXED > 4.1) {


                }

                /*
                 -----------------------------
                 earth and moon
                 ----------------------------------------
                 */
                if (musicTimerActualFIXED > 6.1) {


                    scene.children[2].position.x -= 0.0202;
                    scene.children[3].position.x -= 0.0201;

                }

                if (musicTimerActualFIXED == 8.0) {

                    /*
                     text
                     -----------------------
                     */
                    if (textGeom[1] == undefined) {

                        textGeom[1] = '';
                        animateText('Created by netro', 1, null, null, null);

                    }

                }

                if (musicTimerActualFIXED == 12.0) {

                    /* kezdő évszám */
                    if (textGeom[300] == undefined) {

                        absoluteStaticText('1977: Voyager-2 launched', 300, 1, 5000, 0.5 - (visibleWidthAtZDepth((10), camera) / 4), 0.5 - (visibleHeightAtZDepth(10, camera) / 4), 0)

                    }

                }


                if (musicTimerActualFIXED == 28.0) {


                }

                if (musicTimerActualFIXED == 31.0) {

                    if (textGeom[2] == undefined) {

                        animateText('The Earth is a very small\nstage in a vast cosmic arena', 2, null, null, null)

                    }

                }

                if (musicTimerActualFIXED > 29.2) {

                    scene.children[7].intensity = 1.5 + histo3;

                }


                if (musicTimerActualFIXED == 35.0) {

                    if (textGeom[3] == undefined) {

                        textGeom[3] = '';
                        animateText('The aggregate of all our\njoys and sufferings', 3, null, null, null, 3);

                    }

                }

                if (musicTimerActualFIXED == 37.0) {

                    if (textGeom[301] == undefined) {

                        absoluteStaticText('1977: Entered asteroid belt', 301, 1, 3000, 0.5 - (visibleWidthAtZDepth((10), camera) / 4), 0.5 - (visibleHeightAtZDepth(10, camera) / 4), 0)

                    }


                }

                if (musicTimerActualFIXED == 39.0) {

                    if (textGeom[4] == undefined) {

                        textGeom[4] = '';
                        animateText('thousands of\nconfident religions', 4, null, null, null, 3);

                    }


                }


                if (musicTimerActualFIXED == 43.0) {

                    if (textGeom[5] == undefined) {

                        textGeom[5] = '';
                        animateText('ideologies and\neconomic doctrines', 5, null, null, null, 3);

                    }


                }


                if (musicTimerActualFIXED == 47.0) {

                    if (textGeom[6] == undefined) {

                        textGeom[6] = '';
                        animateText('every hunter\nand forager', 6, null, null, null, 3);

                    }

                    if (textGeom[302] == undefined) {

                        absoluteStaticText('1977: Voyager-1 overtook Voyager-2', 302, 1, 3000, 0.5 - (visibleWidthAtZDepth((10), camera) / 4), 0.5 - (visibleHeightAtZDepth(10, camera) / 4), 0)

                    }


                }

                if (musicTimerActualFIXED == 51.0) {

                    if (textGeom[7] == undefined) {

                        textGeom[7] = '';
                        animateText('every hero\nand coward', 7, null, null, null, 3);

                    }

                }

                if (musicTimerActualFIXED == 55.0) {

                    if (textGeom[8] == undefined) {

                        textGeom[8] = '';
                        animateText('every creator\nand destroyer of\ncivilizations', 8, null, null, null, 3);

                    }

                }

                /*
                 -----------------------------
                 jupiter
                 ----------------------------------------
                 */
                if (musicTimerActualFIXED > 57.1) {

                    if (textGeom[303] == undefined) {

                        absoluteStaticText('1979: Voyager-2 encountered with Jovian system', 303, 1, 10000, 0.5 - (visibleWidthAtZDepth((10), camera) / 4), 0.5 - (visibleHeightAtZDepth(10, camera) / 4), 0)

                    }

                    scene.children[4].position.x -= 0.016;
                    scene.children[5].position.x -= 0.014;
                    scene.children[6].position.x -= 0.010;

                    scene.children[9].position.x -= 0.012;
                    scene.children[10].position.x -= 0.013;
                    scene.children[11].position.x -= 0.009;

                    // scene.children[7].intensity = -3 + histo3;

                }


                if (musicTimerActualFIXED > 59.0) {


                }


                if (musicTimerActualFIXED == 88.0) {

                    if (textGeom[9] == undefined) {

                        textGeom[9] = '';
                        animateText('every king\nand peasant', 9, null, null, null, 3);

                    }

                }

                if (musicTimerActualFIXED == 92.0) {

                    if (textGeom[10] == undefined) {

                        textGeom[10] = '';
                        animateText('every young\ncouple in love', 10, null, null, null, 3);

                    }

                }

                if (musicTimerActualFIXED == 96.0) {

                    if (textGeom[11] == undefined) {

                        textGeom[11] = '';
                        animateText('every\nhopeful child', 11, null, null, null, 3);

                    }

                }

                if (musicTimerActualFIXED == 100.0) {

                    if (textGeom[12] == undefined) {

                        textGeom[12] = '';
                        animateText('every mother\nand father', 12, null, null, null, 3);

                    }

                }

                if (musicTimerActualFIXED == 104.0) {

                    if (textGeom[13] == undefined) {

                        textGeom[13] = '';
                        animateText('every inventor\nand explorer', 13, null, null, null, 3);

                    }

                }

                if (musicTimerActualFIXED == 108.0) {

                    if (textGeom[14] == undefined) {

                        textGeom[14] = '';
                        animateText('every teacher\nof morals', 14, null, null, null, 3);

                    }

                }

                if (musicTimerActualFIXED == 112.0) {

                    if (textGeom[15] == undefined) {

                        textGeom[15] = '';
                        animateText('every corrupt\npolitician', 15, null, null, null, 3);

                    }

                }

                if (musicTimerActualFIXED == 116.0) {

                    if (textGeom[16] == undefined) {

                        textGeom[16] = '';
                        animateText('every\nsuperstar', 16, null, null, null, 3);

                    }

                }

                if (musicTimerActualFIXED > 117.0) {

                    if (histoLum > -2) {
                        histoLum = 120.5 - musicTimerActualFIXED;

                        scene.children[7].intensity = histoLum + histo3;
                    } else {
                        scene.children[7].intensity = -2 + histo3;
                    }

                }


                if (musicTimerActualFIXED == 120.0) {

                    if (textGeom[17] == undefined) {

                        textGeom[17] = '';
                        animateText('every\nsupreme leader', 17, null, null, null, 3);

                    }

                }

                if (musicTimerActualFIXED == 124.0) {

                    if (textGeom[18] == undefined) {

                        textGeom[18] = '';
                        animateText('every saint\nand sinner', 18, null, null, null, 3);

                    }

                }

                if (musicTimerActualFIXED == 128.0) {

                    if (textGeom[19] == undefined) {

                        textGeom[19] = '';
                        animateText('in the history of\nour species', 19, null, null, null, 3);

                    }

                }

                if (musicTimerActualFIXED == 132.0) {

                    if (textGeom[20] == undefined) {

                        textGeom[20] = '';
                        animateText('lived there\non a mote of dust\nsuspended in a sunbeam', 20, 8000, null, 0.5, 3);

                    }

                }


                /*
                 -----------------------------
                 saturn
                 ----------------------------------------
                 */

                if (musicTimerActualFIXED == 145.0) {

                    if (textGeom[304] == undefined) {

                        absoluteStaticText('1981: Encountered with Saturnian system', 304, 1, 10000, 0.5 - (visibleWidthAtZDepth((10), camera) / 4), 0.5 - (visibleHeightAtZDepth(10, camera) / 4), 0)

                    }
                }


                if (musicTimerActualFIXED > 147.0) {

                    // scene.children[7].intensity = 0.2 + histo3;

                    scene.children[20].position.x -= 0.01195;

                    scene.children[13].position.x -= 0.012;
                    scene.children[14].position.x -= 0.012;
                    scene.children[15].position.x -= 0.012;
                    scene.children[16].position.x -= 0.012;
                    scene.children[17].position.x -= 0.012;
                    scene.children[18].position.x -= 0.012;

                }


                if (musicTimerActualFIXED > 147.6) {

                    scene.children[7].intensity = 1.5 + histo3;

                }

                // if (musicTimerActualFIXED == 161.2)
                //     scene.children[7].intensity = 1.7 + histo3;
                //
                // if (musicTimerActualFIXED == 161.3)
                //     scene.children[7].intensity = 1.5 + histo3;
                //
                // if (musicTimerActualFIXED == 161.4)
                //     scene.children[7].intensity = 1.3 + histo3;
                //
                // if (musicTimerActualFIXED == 161.5)
                //     scene.children[7].intensity = 1.2 + histo3;
                //
                // if (musicTimerActualFIXED == 161.6)
                //     scene.children[7].intensity = 1 + histo3;


                if (musicTimerActualFIXED == 177.0) {

                    if (textGeom[21] == undefined) {

                        textGeom[21] = '';
                        animateText('Our planet is a\nlonely speck', 21, null, null, null, 3);

                    }

                }

                if (musicTimerActualFIXED == 181.0) {

                    if (textGeom[22] == undefined) {

                        textGeom[22] = '';
                        animateText('in the great enveloping\ncosmic dark', 22, null, null, null, 3);

                    }

                }

                if (musicTimerActualFIXED == 185.0) {

                    if (textGeom[23] == undefined) {

                        textGeom[23] = '';
                        animateText('In our obscurity\nthere is no hint  ', 23, null, null, null, 3);

                    }

                }

                if (musicTimerActualFIXED == 189.0) {

                    if (textGeom[24] == undefined) {

                        textGeom[24] = '';
                        animateText('that help will\ncome from elsewhere', 24, null, null, null, 3);

                    }

                }

                if (musicTimerActualFIXED == 193.0) {

                    if (textGeom[25] == undefined) {

                        textGeom[25] = '';
                        animateText('to save us from\nourselves', 25, null, null, null, 3);

                    }

                }

                if (musicTimerActualFIXED == 197.0) {

                    if (textGeom[26] == undefined) {

                        textGeom[26] = '';
                        animateText('It underscores our\nresponsibility to deal ', 26, null, null, null, 3);

                    }

                }

                if (musicTimerActualFIXED == 201.0) {

                    if (textGeom[305] == undefined) {

                        absoluteStaticText('1986: Encountered with Uranian system', 305, 1, 10000, 0.5 - (visibleWidthAtZDepth((10), camera) / 4), 0.5 - (visibleHeightAtZDepth(10, camera) / 4), 0)

                    }

                }


                /*
                 -----------------------------
                 uranus
                 ----------------------------------------
                 */
                if (musicTimerActualFIXED > 206.0) {

                    scene.children[21].position.x -= 0.018;
                    scene.children[22].position.x -= 0.018;
                    scene.children[23].position.x -= 0.018;
                    scene.children[24].position.x -= 0.018;
                    scene.children[25].position.x -= 0.018;

                }

                if (musicTimerActualFIXED == 236.0) {

                    if (textGeom[28] == undefined) {

                        textGeom[28] = '';
                        animateText('more kindly and\ncompassionately with', 28, null, null, null, 3);

                    }

                }

                if (musicTimerActualFIXED == 240.0) {

                    if (textGeom[29] == undefined) {

                        textGeom[29] = '';
                        animateText('one another and to\npreserve and cherish', 29, null, null, null, 3);

                    }

                }

                if (musicTimerActualFIXED == 248.0) {

                    if (textGeom[30] == undefined) {

                        textGeom[30] = '';
                        animateText('that pale\nblue dot', 30, 6000, null, null, 3);

                    }

                }

                if (musicTimerActualFIXED == 245.0) {

                    if (textGeom[307] == undefined) {

                        absoluteStaticText('1987: After 10 years of continuous flight and operation', 307, 1, 10000, 0.5 - (visibleWidthAtZDepth((10), camera) / 4), 0.5 - (visibleHeightAtZDepth(10, camera) / 4), 0)

                    }

                }

                if (musicTimerActualFIXED == 255.0) {

                    if (textGeom[31] == undefined) {

                        textGeom[31] = '';
                        animateText('the only home\nwe have ever known', 31, 6000, null, null, 3);

                    }

                }

                if (musicTimerActualFIXED == 265.0) {

                    if (textGeom[306] == undefined) {

                        absoluteStaticText('1989: Encountered with Neptunian system', 306, 1, 10000, 0.5 - (visibleWidthAtZDepth((10), camera) / 4), 0.5 - (visibleHeightAtZDepth(10, camera) / 4), 0)

                    }

                }


                /*
                 -----------------------------
                 neptune
                 ----------------------------------------
                 */
                if (musicTimerActualFIXED > 265.0) {

                    scene.children[26].position.x -= 0.019;
                    scene.children[27].position.x -= 0.019;
                    scene.children[28].position.x -= 0.019;

                }

                if (musicTimerActualFIXED == 295.0) {

                    if (textGeom[32] == undefined) {

                        textGeom[32] = '';
                        animateText('Cherish it\nbecause', 32, 5000, null, null, 3);

                    }

                }

                if (musicTimerActualFIXED == 301.0) {

                    if (textGeom[33] == undefined) {

                        textGeom[33] = '';
                        animateText('its the only one\nwe have', 33, 5000, null, null, 3);

                    }

                }

                if (musicTimerActualFIXED == 312.0) {

                    if (textGeom[34] == undefined) {

                        textGeom[34] = '';
                        animateText('we are alone', 34, 9000, null, null, 3);

                    }

                }

                if (musicTimerActualFIXED == 315.0) {

                    if (textGeom[307] == undefined) {

                        absoluteStaticText('1989: Begin Voyager Interstellar Mission', 307, 1, 10000, 0.5 - (visibleWidthAtZDepth((10), camera) / 4), 0.5 - (visibleHeightAtZDepth(10, camera) / 4), 0)

                    }

                }

                if (musicTimerActualFIXED == 325.0) {

                    fadeOut();

                }

                if (musicTimerActualFIXED == 332.0) {

                    window.close();

                }


                /*
                 --------------------------------------
                 */

                // fadeOut();


                /*
                 --------------------------------------
                 */

                try {

                    dispatch(events.update, {time: time, delta: time - prevTime});

                } catch (e) {

                    console.error((e.message || e), (e.stack || ""));

                }

                // stats.end();


            }

            this.play = function () {

                prevTime = performance.now();

                dispatch(events.start, arguments);

                sceneGeometry = new THREE.Geometry();
                sceneMesh = new THREE.Mesh();


                //
                // --------------------------------------
                // postprocessing
                // ----------------------
                // --------------------------------------

                composer = new THREE.EffectComposer(renderer);
                composer.addPass(new THREE.RenderPass(scene, camera));

                effect = new THREE.ShaderPass(THREE.DotScreenShader);
                effect.uniforms['scale'].value = 30;
                composer.addPass(effect);

                effect2 = new THREE.ShaderPass(THREE.RGBShiftShader);
                effect2.uniforms['amount'].value = 0.001;
                effect2.renderToScreen = true;
                composer.addPass(effect2);

                // effect3 = new THREE.ShaderPass(THREE.PixelShader);
                // effect3.uniforms.resolution.value = new THREE.Vector2( window.innerWidth, window.innerHeight );
                // effect3.uniforms.resolution.value.multiplyScalar( window.devicePixelRatio );
                // effect3.renderToScreen = true;
                // composer.addPass( effect3 );

                //
                // --------------------------------------
                // init setup (model and others...)
                // ----------------------
                // --------------------------------------
                camera.position.x = -14;
                camera.fov = 50;
                camera.aspect = window.innerWidth / window.innerHeight;
                camera.near = 1;
                camera.far = 10000;
                camera.position.set(0, 0, 10);

                /*
                 -------------------------------------------------------------
                 [0] szonda
                 [1] bg_gomb /background stramap/

                 [2] fold
                 [3] hold

                 [4] jupiter
                 [5] europe
                 [6] io
                 [7] light - point (main)
                 [8] camera 2
                 [9] callisto
                 [10] ganymede
                 [11] amalthea

                 [13] titan
                 [14] dione
                 [15] calypso
                 [16] mimas
                 [17] enceladus
                 [18] tethys
                 [20] saturn

                 [21] uranus
                 [22] miranda
                 [23] ariel
                 [24] umbriel
                 [25] titania

                 [26] neptune
                 [27] triton
                 [28] protheus
                 -------------------------------------------------------------
                 */

                //
                // --------------------------------------
                // wire material
                // ----------------------
                // --------------------------------------
                var materialSide = new THREE.MeshBasicMaterial({
                    color: 0xffffff,
                    wireframe: true,
                    transparent: true,
                    opacity: 0.0
                });

                //
                // --------------------------------------
                // font loader
                // ----------------------
                // --------------------------------------
                fontLoader();

                //
                // --------------------------------------
                // lights
                // ----------------------
                // --------------------------------------
                scene.children[7].position.x = 0;
                scene.children[7].position.z = 6;
                scene.children[7].intensity = 1.25;

                //
                // --------------------------------------
                // szonda
                // ----------------------
                // --------------------------------------
                scene.children[0].position.y = -1;

                earthWire = new THREE.Mesh(scene.children[2].geometry, materialSide);
                earthWire.position.set(0,0,0);
                earthWire.scale.set(105.8, 105.8, 105.8);

                scene.add(earthWire);

                // var earthWire = new THREE.Mesh(scene.children[1].geometry, materialSide);
                // earthWire.position.set(scene.children[1].position.x, scene.children[1].position.y, scene.children[1].position.z);
                // earthWire.scale.set(0.8, 0.8, 0.8);
                //
                // scene.add(earthWire);

                //
                // --------------------------------------
                // earth és moon
                // ----------------------
                // --------------------------------------
                scene.children[2].position.x = 2 + camera.position.x + (visibleWidthAtZDepth((scene.children[2].position.z), camera) / 2) + scene.children[2].geometry.parameters.radius * 6;
                scene.children[3].position.x = camera.position.x + (visibleWidthAtZDepth((scene.children[3].position.z), camera) / 2) + scene.children[3].geometry.parameters.radius * 6;

                scene.children[2].position.z = 0
                scene.children[3].position.z = 2

                // var earthWire = new THREE.Mesh(scene.children[2], materialSide);
                // earthWire.position.set(camera.position.x, camera.position.y, camera.position.z);

                // scene.add(earthWire);

                //
                // --------------------------------------
                // net
                // ----------------------
                // --------------------------------------
                var netGeometry = new THREE.SphereGeometry(5, 32, 32);
                net = new THREE.Mesh(netGeometry, materialSide);

                net.position.set(camera.position.x, camera.position.y, camera.position.z);

                // scene.add(net);

                //
                // --------------------------------------
                // jupiter és holdak
                // ----------------------
                // --------------------------------------
                // scene.children[4].position.z = -14;
                scene.children[4].position.x = camera.position.x + (visibleWidthAtZDepth((scene.children[4].position.z), camera) / 2) + scene.children[4].geometry.parameters.radius * 6.5;

                scene.children[5].position.z = 4;
                scene.children[5].position.x = camera.position.x + (visibleWidthAtZDepth((scene.children[5].position.z), camera) / 2) + scene.children[5].geometry.parameters.radius * 6.4;

                scene.children[6].position.x = camera.position.x + (visibleWidthAtZDepth((scene.children[6].position.z), camera) / 2) + scene.children[6].geometry.parameters.radius * 6.3;

                scene.children[9].position.z = 3.6;
                scene.children[9].position.x = camera.position.x + (visibleWidthAtZDepth((scene.children[9].position.z), camera) / 2) + scene.children[9].geometry.parameters.radius * 6.6;

                scene.children[10].position.z = 6;
                scene.children[10].position.y = -0.5;
                scene.children[10].position.x = camera.position.x + (visibleWidthAtZDepth((scene.children[10].position.z), camera) / 2) + scene.children[10].geometry.parameters.radius * 6;

                // scene.children[11].position.z = 1;
                scene.children[11].position.x = camera.position.x + (visibleWidthAtZDepth((scene.children[11].position.z), camera) / 2) + scene.children[11].geometry.parameters.radius * 6.2;


                //
                // --------------------------------------
                // szaturnusz és holdak
                // ----------------------
                // --------------------------------------
                scene.children[20].children[0].material.opacity = 0.5;
                scene.children[20].position.z = 4;
                scene.children[20].position.x = camera.position.x + (visibleWidthAtZDepth((scene.children[20].position.z), camera) / 2) + 6;

                scene.children[13].position.z = 0;
                scene.children[13].position.x = camera.position.x + (visibleWidthAtZDepth((scene.children[13].position.z), camera) / 2) + scene.children[13].geometry.parameters.radius * 6;

                scene.children[14].position.y = 0.6;
                scene.children[14].position.z = 6.6;
                scene.children[14].position.x = camera.position.x + (visibleWidthAtZDepth((scene.children[14].position.z), camera) / 2) + scene.children[14].geometry.parameters.radius * 6;

                scene.children[15].position.y = -1.6;
                scene.children[15].position.z = 4.2;
                scene.children[15].scale.x = scene.children[15].scale.y = scene.children[15].scale.z = 0.3;
                scene.children[15].position.x = camera.position.x + (visibleWidthAtZDepth((scene.children[15].position.z), camera) / 2) + scene.children[15].geometry.parameters.radius * 6;

                scene.children[16].position.y = 2.6;
                scene.children[16].position.z = 2.2;
                scene.children[16].scale.x = scene.children[16].scale.y = scene.children[16].scale.z = 0.6;
                scene.children[16].position.x = camera.position.x + (visibleWidthAtZDepth((scene.children[16].position.z), camera) / 2) + scene.children[16].geometry.parameters.radius * 6;

                scene.children[17].position.y = -2.6;
                scene.children[17].position.z = 2.2;
                scene.children[17].scale.x = scene.children[17].scale.y = scene.children[17].scale.z = 0.4;
                scene.children[17].position.x = camera.position.x + (visibleWidthAtZDepth((scene.children[17].position.z), camera) / 2) + scene.children[17].geometry.parameters.radius * 6;

                // scene.children[18].position.y = 0;
                scene.children[18].position.x = camera.position.x + (visibleWidthAtZDepth((scene.children[18].position.z), camera) / 2) + scene.children[18].geometry.parameters.radius * 6;

                //
                // --------------------------------------
                // uránusz és holdak
                // ----------------------
                // --------------------------------------
                scene.children[21].position.y = 0;
                scene.children[21].position.x = camera.position.x + (visibleWidthAtZDepth((scene.children[21].position.z), camera) / 2) + scene.children[21].geometry.parameters.radius * 6;

                scene.children[22].position.y = 0;
                scene.children[22].position.x = camera.position.x + (visibleWidthAtZDepth((scene.children[22].position.z), camera) / 2) + scene.children[22].geometry.parameters.radius * 6;

                scene.children[23].position.y = 0;
                scene.children[23].position.x = camera.position.x + (visibleWidthAtZDepth((scene.children[23].position.z), camera) / 2) + scene.children[23].geometry.parameters.radius * 6;

                scene.children[24].position.y = 0;
                scene.children[24].position.x = camera.position.x + (visibleWidthAtZDepth((scene.children[24].position.z), camera) / 2) + scene.children[24].geometry.parameters.radius * 6;

                scene.children[25].position.y = 0;
                scene.children[25].position.x = camera.position.x + (visibleWidthAtZDepth((scene.children[25].position.z), camera) / 2) + scene.children[25].geometry.parameters.radius * 6;


                //
                // --------------------------------------
                // neptunusz és holdak
                // ----------------------
                // --------------------------------------
                scene.children[26].position.y = 0;
                scene.children[26].position.x = camera.position.x + (visibleWidthAtZDepth((scene.children[26].position.z), camera) / 2) + scene.children[26].geometry.parameters.radius * 6;

                scene.children[27].position.y = 0;
                scene.children[27].position.x = camera.position.x + (visibleWidthAtZDepth((scene.children[27].position.z), camera) / 2) + scene.children[27].geometry.parameters.radius * 6;

                scene.children[28].position.y = 0;
                scene.children[28].position.x = camera.position.x + (visibleWidthAtZDepth((scene.children[28].position.z), camera) / 2) + scene.children[28].geometry.parameters.radius * 6;


                //
                // --------------------------------------
                // második kamera init
                // ----------------------
                // --------------------------------------
                cameraOriginal = camera;

                //
                // --------------------------------------
                // második kamera
                // ----------------------
                // --------------------------------------
                scene.children[8].rotation.y = -230;
                scene.children[8].position.x = 2.54;
                scene.children[8].fov = 2.54;

                //
                // --------------------------------------
                // particles
                // ----------------------
                // --------------------------------------
                var particleCount = 1800,
                    particles = new THREE.Geometry(),
                    pMaterial = new THREE.PointsMaterial({
                        color: 0xFFFFFF,
                        size: 0.2
                    });

                for (var p = 0; p < particleCount; p++) {

                    // create a particle with random
                    // position values, -250 -> 250
                    var pX = Math.random() * 500 - 250,
                        pY = Math.random() * 500 - 250,
                        pZ = Math.random() * 500 - 250,
                        particle = new THREE.Vector3 (pX, pY, pZ
                        );

                    // add it to the geometry
                    particles.vertices.push(particle);
                }

                particleSystem = new THREE.Points(
                    particles,
                    pMaterial);

                scene.add(particleSystem);

                //
                // --------------------------------------
                // flat rctngl
                // ----------------------
                // --------------------------------------
                const whiteGeom = new THREE.BoxBufferGeometry(10, 10, 10);
                const whiteMat = new THREE.MeshBasicMaterial({color: 0x393939, wireframe: true});
                whiteMesh = new THREE.Mesh(whiteGeom, whiteMat);
                whiteMesh.position.set(0, 0, -200);
                whiteMesh.scale.set(visibleWidthAtZDepth(-200, camera), visibleHeightAtZDepth(-200, camera), 1);
                whiteMesh.material.opacity = 0;

                // scene.add(whiteMesh);

                //
                // --------------------------------------
                // call renderer anim
                // ----------------------
                // --------------------------------------
                renderer.animate(animate);

            };


            this.dispose = function () {

                while (dom.children.length) {

                    dom.removeChild(dom.firstChild);

                }

                renderer.dispose();

                camera = undefined;
                scene = undefined;
                renderer = undefined;

            };


        }

    }
;

function audioPlayer() {

    webaudio = new WebAudio();

    sound = webaudio.createSound().load('../../music/function2018_1.mp3', function (sound) {
        sound.loop(false).play();
        sound.volume(1);
    });

}


function visibleHeightAtZDepth(depth, camera) {
    // compensate for cameras not positioned at z=0
    const cameraOffset = camera.position.z;
    if (depth < cameraOffset) depth -= cameraOffset;
    else depth += cameraOffset;

    // vertical fov in radians
    const vFOV = camera.fov * Math.PI / 180;

    // Math.abs to ensure the result is always positive
    return 2 * Math.tan(vFOV / 2) * Math.abs(depth);
};

function visibleWidthAtZDepth(depth, camera) {
    const height = visibleHeightAtZDepth(depth, camera);
    return height * camera.aspect;
};

