#version 330 core

in vec2 texCoord;
in vec4 vertexFragColor;
out vec4 fragColor;
uniform sampler2D texture0;
uniform vec4 color = vec4(1,1,1,1);
uniform bool enableVertexColor = false;

void main()
{
    vec4 col = texture(texture0, texCoord);
    vec2 rayCoord = (2.0 * texCoord - 1.0);
    fragColor = (1.0-distance(rayCoord,vec2(0,0))*0.8)*col * color;
}
