
var img = [];  
var x;
var time;
var previous_millis;
var seconds;
var anim_framerate;
var anim_millis;
var index;

var song;

var fft;

var rain = []; 
var meteo = []; 
var stars = [];

var fade_time;

var path;

var x_;
var y_;

var low_mid_signal;
var high_mid_signal;
var treble_signal;
var mid_signal;
var avg_signal;

var render_fft;

var grain;

var cnv;

//•••••••••••••••••••••••••••••••••••

function preload(){
	for(var i = 0 ; i < 14 ; i ++){
		var filename = 'assets/anim5/anim5_' + i + '.png';
		img[i] = loadImage(filename);
	}

	grain = loadImage('assets/grain.png');
	
	song = loadSound('assets/09 Hunting bears.mp3');
}

//•••••••••••••••••••••••••••••••••••

function setup() {

	 cnv = createCanvas(1200, 700);

	  centerCanvas();


	initColors();

	fft = new p5.FFT(0,1024);
    fft.setInput();

    path = new Path(30, width,300,30);

	var img_scale_factor = 0.2;
	for(var i = 0 ; i < img.length ; i++){
		img[i].resize(img[i].width*img_scale_factor,img[i].height*img_scale_factor);
	}
	imageMode(CENTER);
	time = song.duration();

	previous_millis = 0;
	anim_millis = 0;
	seconds = 0;
	anim_framerate = 12;
	index = 0;
	x = 0;

	fade_time = 4000;

	song.play();

	x_ = 0;
	y_ = 0;



	low_mid_signal = new Signal(170,100);  // meteoritos
	mid_signal = new Signal(120,100); //meteoritos
	high_mid_signal = new Signal(100,200);  // lluvia
	treble_signal = new Signal(30,50);  // estrellas
	avg_signal = new Signal(10,200);

	render_fft = false;

}

//•••••••••••••••••••••••••••••••••••

function draw() {
	var sky_moment = map(millis()/1000,0,time,-1,1);
	var sky_moment = abs(sky_moment);
	var sky = lerpColor(SKY_COLOR_1, SKY_COLOR_2, sky_moment);
	background(sky);

	fill(255);

	seconds = millis()/1000;

	x = map(seconds,0,time, -50, width + 50);

	x = constrain(x, -50, width + 50);

	path.calculate(x);

	var frame_time = 1000 / anim_framerate;

	anim_millis += millis() - previous_millis;

	if(anim_millis > frame_time){

		index ++;
		index = index % img.length;
		anim_millis = anim_millis - frame_time;
	}
	
	previous_millis = millis();

  	for (var i = rain.length - 1; i > -1; i--) {
	    if (rain[i].kill_flag)
	      rain.splice(i, 1);
  	} 

  	for (var i=0; i<meteo.length; i++) {
	    meteo[i].move();
	    meteo[i].display(avg_signal.getCurrent());
  	}

  	for (var i=0; i<stars.length; i++) {
	    stars[i].move();
	    stars[i].display();
  	}
	
	for (var i = stars.length - 1; i > -1; i--) {
	    if (stars[i].kill_flag)
	      stars.splice(i, 1);
  	} 


  	for (var i = meteo.length - 1; i > -1; i--) {
	    if (meteo[i].kill_flag)
	      meteo.splice(i, 1);
  	} 

  	if(high_mid_signal.getFlag()){
  		createRainBurst();
  		high_mid_signal.lowerFlag();
  	}


  	if(low_mid_signal.getFlag()){
  		createMeteo();
  		low_mid_signal.lowerFlag();
  	}


	if(mid_signal.getFlag()){
  		createMeteo();
  		mid_signal.lowerFlag();
  	}

  	if(treble_signal.getFlag()){
  		createStars();
  		treble_signal.lowerFlag();
  	}


	renderSunset(avg_signal.getCurrent());

	path.renderGround(GROUND_COLOR);


	//rect(0,300,width,50);

	push();

	tint(ANIMATION_TINT);

	translate(x + 10,path.getPosY()-17);

	//rotate(path.getAngle()+PI);

	if(path.getPosY() > 50){

		image(img[index],0,0);

	}


	pop();



	for (var i=0; i<rain.length; i++) {
	    rain[i].move();
	    rain[i].display();
  	}

  	fill(0);
  	rect(0,350,width,350);

	analyzeSpectrum();
  	
	blendMode(OVERLAY);

	//tint(255,128);

  	image(grain,0,0);

  	noTint();

  	blendMode(BLEND);

	manageFade();
}

//•••••••••••••••••••••••••••••••••••

function keyTyped() {
  if (key === 'r') {
 	createRainBurst();
  }else if (key === 'm') {
  	createMeteo();
  }else if (key === 's') {
  	createStars();
  }else if (key === 'f') {
  	render_fft =! render_fft;
  }
}

//•••••••••••••••••••••••••••••••••••

function centerCanvas() {
  var x = (windowWidth - width) / 2;
  var y = (windowHeight - height) / 2 + 40;
  cnv.position(x, y);
}

//•••••••••••••••••••••••••••••••••••

function windowResized() {
  centerCanvas();
}


