
static const v16 vects[] = {
    floattov16(-0.5), floattov16(-0.5), floattov16(0.5),
    floattov16(0.5),  floattov16(-0.5), floattov16(0.5),
    floattov16(0.5),  floattov16(-0.5), floattov16(-0.5),
    floattov16(-0.5), floattov16(-0.5), floattov16(-0.5),
    floattov16(-0.5), floattov16(0.5),  floattov16(0.5),
    floattov16(0.5),  floattov16(0.5),  floattov16(0.5),
    floattov16(0.5),  floattov16(0.5),  floattov16(-0.5),
    floattov16(-0.5), floattov16(0.5),  floattov16(-0.5)
};
static const u8 faces[] = {
    3,2,1,0,
    0,1,5,4,
    1,2,6,5,
    2,3,7,6,
    3,0,4,7,
    5,6,7,4
};
static const u32 norms[] = {
    NORMAL_PACK(0,floattov10(-.97),0),
    NORMAL_PACK(0,0,floattov10(.97)),
    NORMAL_PACK(floattov10(.97),0,0),
    NORMAL_PACK(0,0,floattov10(-.97)),
    NORMAL_PACK(floattov10(-.97),0,0),
    NORMAL_PACK(0,floattov10(.97),0)
};

static void cube(float w, float h, float d) {
    glPushMatrix();
    glBegin(GL_QUAD);
    glScalef(w,h,d);
    for (size_t i = 0; i < 6; ++i) {
        u32 f0 = faces[i<<2]*3,
            f1 = faces[(i<<2)|1]*3,
            f2 = faces[(i<<2)|2]*3,
            f3 = faces[(i<<2)|3]*3;

        glNormal(norms[i]);
        glVertex3v16(vects[f0],vects[f0+1],vects[f0+2]);
        glVertex3v16(vects[f1],vects[f1+1],vects[f1+2]);
        glVertex3v16(vects[f2],vects[f2+1],vects[f2+2]);
        glVertex3v16(vects[f3],vects[f3+1],vects[f3+2]);

    }
    glEnd();
    glPopMatrix(1);
}

static void k2logo() {
    glColor3b(250,250,250);
    // kader
    glPushMatrix();
    glTranslatef(0,1.6f,0);
    cube(3.4f,0.2f,0.2f);
    glTranslatef(0,-1.6f*2,0);
    cube(3.4f,0.2f,0.2f);
    glPopMatrix(1);
    glPushMatrix();
    glTranslatef(1.6f,0,0);
    cube(0.2f,3.4f,0.2f);
    glTranslatef(-1.6f*2,0,0);
    cube(0.2f,3.2f,0.2f);
    glPopMatrix(1);


    // K
    glPushMatrix();
    glTranslatef(-1.2f,0.6f,0);
    cube(0.2f,1.0f,0.2f);
    glTranslatef(0.6f,-0.4f,0);
    cube(0.6f,0.2f,0.2f);
    glTranslatef(0.4f,0.4f,0);
    cube(0.2f,1.0f,0.2f);
    glPopMatrix(1);

    glPushMatrix();
    glTranslatef(-1.2f,-0.6f,0);
    cube(0.2f,1.0f,0.2f);
    glTranslatef(0.6f,0.4f,0);
    cube(0.6f,0.2f,0.2f);
    glTranslatef(0.4f,-0.4f,0);
    cube(0.2f,-1.0f,0.2f);
    glPopMatrix(1);

    // 2
    glPushMatrix();
    glTranslatef(0.7f,0.2f,0);
    cube(1.0f,0.2f,0.2f);
    glTranslatef(0,0.8f,0);
    cube(1.0f,0.2f,0.2f);
    glTranslatef(0.4f,-0.4f,0);
    cube(0.2f,1,0.2f);
    glPopMatrix(1);

    glPushMatrix();
    glTranslatef(0.7f,-0.2f,0);
    cube(1.0f,0.2f,0.2f);
    glTranslatef(0,-0.8f,0);
    cube(1.0f,0.2f,0.2f);
    glTranslatef(-0.4f,0.4f,0);
    cube(0.2f,1,0.2f);
    glPopMatrix(1);
}

static void dumbcube() {
    glColor3b(250,250,250);
    cube(2.0f,2.0f,2.0f);
}

