
static uint8_t tiles[8*8*6];

static uint16_t tilemap[32*32];

static const u16 palette[] = {
    RGB15( 5, 5, 5),
    RGB15(12,12,13)
};

static uint32_t xorshift32() {
    static uint32_t state = 0xDEADBEEF;

	uint32_t x = state;
	x ^= x << 13;
	x ^= x >> 17;
	x ^= x <<  5;
	return (state = x);
}

static void bg_init(int bg) {
    for (size_t i = 0; i < 4; ++i) {
        // 0: UL black, BR white
        // 1: UR white, BL black
        // 2: UL white, BR black
        // 3: UR black, BL white
        //// 4: white
        //// 5: black

        uint8_t* tile = &tiles[i*(8*8)];

        for (size_t y = 0; y < 8; ++y) {
            for (size_t x = 0; x < 8; ++x) {
                size_t fillto = (i & 1) ? y : (8 - y);
                int hi = (i & 2) ? 1 : 0, lo = hi ^ 1;

                tile[(y*8)|x] = (x < fillto) ? hi : lo;
            }
        }
    }
    /*memset(&tiles[4*(8*8)], 1, 8*8*sizeof(uint8_t));
    memset(&tiles[5*(8*8)], 0, 8*8*sizeof(uint8_t));*/

    for (size_t i = 0; i < 32*32; ++i) {
        tilemap[i] = xorshift32() & 3; // init to random
    }

    dmaCopy(tiles  , bgGetGfxPtr(bg), sizeof tiles  );
    dmaCopy(tilemap, bgGetMapPtr(bg), sizeof tilemap);
    dmaCopy(palette, BG_PALETTE     , sizeof palette);
}

static void bg_update(int bg) {
    static size_t upcd = 6;
    if (--upcd) return;
    upcd = 6;

    size_t x = xorshift32()&0x1F,
           y = xorshift32()&0x1F;

    tilemap[(y*32)|x] = xorshift32()&3;

    dmaCopy(tilemap, bgGetMapPtr(bg), sizeof tilemap);
}

