#include "common_fs.glsl"





// ------------------------------------------------------------------------------------------------
//
// ------------------------------------------------------------------------------------------------

const highp float tam_pixel_x = 1.0 / 1024.0 ;    // Tam franjas / tam_textura
const highp float tam_pixel_y = 1.0 / 768.0 ;    // Tam franjas / tam_textura





#define TAM_LADO_FILTRO_3x3           3

const highp float array_filtro_3x3[TAM_LADO_FILTRO_3x3 * TAM_LADO_FILTRO_3x3] = float[](

  -1.0,  -1.0,  -1.0, 


  -1.0,   8.0,  -1.0, 


  -1.0,  -1.0,  -1.0 

) ;






#define TAM_LADO_FILTRO_5x5           5

const highp float array_filtro_5x5[TAM_LADO_FILTRO_5x5 * TAM_LADO_FILTRO_5x5] = float[](

  -1.0,  -1.0,  -1.0,  -1.0,  -1.0, 


  -1.0,   0.0,   0.0,   0.0,  -1.0, 


  -1.0,   0.0,  16.0,   0.0,  -1.0,


  -1.0,   0.0,   0.0,   0.0,  -1.0, 


  -1.0,  -1.0,  -1.0,  -1.0,  -1.0 

) ;





// ------------------------------------------------------------------------------------------------
//
void Edges3x3()
{
  highp vec4 color_final_BLUR = vec4(0, 0, 0, 0) ;

  for(int vary = 0; vary < TAM_LADO_FILTRO_3x3; vary++) {
  
    for(int varx = 0; varx < TAM_LADO_FILTRO_3x3; varx++) {

      float x = text_coord[0].x + ((varx - floor(TAM_LADO_FILTRO_3x3 / 2.0)) * tam_pixel_x) ;
      float y = text_coord[0].y + ((vary - floor(TAM_LADO_FILTRO_3x3 / 2.0)) * tam_pixel_y) ;

      color_final_BLUR  += texture2D(shader_texture_ids[0], vec2(x, y)) * array_filtro_3x3[(vary * TAM_LADO_FILTRO_3x3)+varx] ;
    }
  }

  gl_FragColor = clamp(color_final_BLUR, 0.0, 1.0) ;
  gl_FragColor.a = 1.0 ;
}




// ------------------------------------------------------------------------------------------------
//
void Edges5x5()
{
  highp vec4 color_final_BLUR = vec4(0, 0, 0, 0) ;

  for(int vary = 0; vary < TAM_LADO_FILTRO_5x5; vary++) {
  
    for(int varx = 0; varx < TAM_LADO_FILTRO_5x5; varx++) {

      float x = text_coord[0].x + ((varx - floor(TAM_LADO_FILTRO_5x5 / 2.0)) * tam_pixel_x) ;
      float y = text_coord[0].y + ((vary - floor(TAM_LADO_FILTRO_5x5 / 2.0)) * tam_pixel_y) ;

      color_final_BLUR  += texture2D(shader_texture_ids[0], vec2(x, y)) * array_filtro_5x5[(vary * TAM_LADO_FILTRO_5x5)+varx] ;
    }
  }

  gl_FragColor = clamp(color_final_BLUR, 0.0, 1.0) ;
  gl_FragColor.a = 1.0 ;
}








#define THRESHOLD_BORDES               6.0
#define VALOR_INTENSIDAD_BORDES        0.15

// ------------------------------------------------------------------------------------------------
//
void Edges5x5_Extra()
{
  highp vec4 color_final_BLUR = vec4(0, 0, 0, 0) ;

  for(int vary = 0; vary < TAM_LADO_FILTRO_5x5; vary++) {
  
    for(int varx = 0; varx < TAM_LADO_FILTRO_5x5; varx++) {

      float x = text_coord[0].x + ((varx - floor(TAM_LADO_FILTRO_5x5 / 2.0)) * tam_pixel_x) ;
      float y = text_coord[0].y + ((vary - floor(TAM_LADO_FILTRO_5x5 / 2.0)) * tam_pixel_y) ;

      color_final_BLUR  += texture2D(shader_texture_ids[0], vec2(x, y)) * array_filtro_5x5[(vary * TAM_LADO_FILTRO_5x5)+varx] ;
    }
  }

  //color_final_BLUR = normalize(color_final_BLUR /** color_final_BLUR*/) ;
  float intensidad = sqrt((color_final_BLUR.r*color_final_BLUR.r) + (color_final_BLUR.g*color_final_BLUR.g) + (color_final_BLUR.b*color_final_BLUR.b)) ;

  if(intensidad < THRESHOLD_BORDES) intensidad = 0.0 ;
  else intensidad = VALOR_INTENSIDAD_BORDES ;

  gl_FragColor.r = intensidad ;
  gl_FragColor.g = intensidad ;
  gl_FragColor.b = intensidad ;
  gl_FragColor.a = 1.0 ;
/*
  gl_FragColor = clamp(color_final_BLUR, 0.0, 1.0) ;
  gl_FragColor.a = 1.0 ;
*/
}




// ------------------------------------------------------------------------------------------------
//
void main()
{
//  Edges3x3() ;
//  Edges5x5() ;
  Edges5x5_Extra() ;
}



