/*
 * Decompiled with CFR 0.152.
 */
package ch.bildspur.postfx.pass;

import ch.bildspur.postfx.Supervisor;
import ch.bildspur.postfx.pass.BlurPass;
import ch.bildspur.postfx.pass.BrightPass;
import ch.bildspur.postfx.pass.Pass;
import processing.core.PApplet;
import processing.core.PGraphics;
import processing.core.PImage;

public class BloomPass
implements Pass {
    private PApplet sketch;
    private BlurPass blurPass;
    private BrightPass brightPass;
    private int blurSize;
    private float sigma;
    private float threshold;

    public BloomPass(PApplet sketch) {
        this.sketch = sketch;
        this.blurPass = new BlurPass(sketch);
        this.brightPass = new BrightPass(sketch);
    }

    public BloomPass(PApplet sketch, float threshold, int blurSize, float sigma) {
        this(sketch);
        this.threshold = threshold;
        this.blurSize = blurSize;
        this.sigma = sigma;
    }

    @Override
    public void prepare(Supervisor supervisor) {
    }

    @Override
    public void apply(Supervisor supervisor) {
        PGraphics np = supervisor.getNextPass();
        PGraphics cp = supervisor.getCurrentPass();
        supervisor.clearPass(np);
        np.beginDraw();
        np.blendMode(1);
        np.image((PImage)cp, 0.0f, 0.0f);
        np.endDraw();
        supervisor.clearPass(cp);
        cp.beginDraw();
        this.brightPass.setThreshold(this.threshold);
        this.brightPass.prepare(supervisor);
        cp.shader(this.brightPass.shader);
        cp.image((PImage)np, 0.0f, 0.0f);
        cp.endDraw();
        this.blurPass.setBlurSize(this.blurSize);
        this.blurPass.setSigma(this.sigma);
        cp.beginDraw();
        this.blurPass.setHorizontal(true);
        this.blurPass.prepare(supervisor);
        cp.shader(this.blurPass.shader);
        cp.image((PImage)cp, 0.0f, 0.0f);
        cp.endDraw();
        cp.beginDraw();
        this.blurPass.setHorizontal(false);
        this.blurPass.prepare(supervisor);
        cp.shader(this.blurPass.shader);
        cp.image((PImage)cp, 0.0f, 0.0f);
        cp.endDraw();
        np.beginDraw();
        np.blendMode(256);
        np.image((PImage)cp, 0.0f, 0.0f);
        np.blendMode(1);
        np.endDraw();
    }

    public int getBlurSize() {
        return this.blurSize;
    }

    public void setBlurSize(int blurSize) {
        this.blurSize = blurSize;
    }

    public float getSigma() {
        return this.sigma;
    }

    public void setSigma(float sigma) {
        this.sigma = sigma;
    }

    public float getThreshold() {
        return this.threshold;
    }

    public void setThreshold(float threshold) {
        this.threshold = threshold;
    }
}

