/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.tools.fileconverter;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.JTextComponent;
import jkcemu.Main;
import jkcemu.audio.AudioFile;
import jkcemu.audio.AudioPlayer;
import jkcemu.audio.AudioUtil;
import jkcemu.audio.BitSampleBuffer;
import jkcemu.audio.CSWFile;
import jkcemu.audio.PCMDataInfo;
import jkcemu.base.BaseDlg;
import jkcemu.base.BaseFrm;
import jkcemu.base.EmuUtil;
import jkcemu.base.FileFormat;
import jkcemu.base.FileInfo;
import jkcemu.base.FileNameFld;
import jkcemu.base.HelpFrm;
import jkcemu.base.HexDocument;
import jkcemu.base.LimitedDocument;
import jkcemu.base.LoadData;
import jkcemu.base.UserInputException;
import jkcemu.disk.AbstractFloppyDisk;
import jkcemu.disk.AnaDisk;
import jkcemu.disk.CPCDisk;
import jkcemu.disk.CopyQMDisk;
import jkcemu.disk.DiskUtil;
import jkcemu.disk.FloppyDiskFormat;
import jkcemu.disk.FloppyDiskFormatDlg;
import jkcemu.disk.ImageDisk;
import jkcemu.disk.PlainDisk;
import jkcemu.disk.TeleDisk;
import jkcemu.emusys.zxspectrum.ZXSpectrumAudioCreator;
import jkcemu.text.TextUtil;
import jkcemu.tools.fileconverter.AC1AudioFileTarget;
import jkcemu.tools.fileconverter.AbstractConvertTarget;
import jkcemu.tools.fileconverter.AnaDiskFileTarget;
import jkcemu.tools.fileconverter.AudioFileTarget;
import jkcemu.tools.fileconverter.BinFileTarget;
import jkcemu.tools.fileconverter.CPCDiskFileTarget;
import jkcemu.tools.fileconverter.CSWFileTarget;
import jkcemu.tools.fileconverter.CopyQMFileTarget;
import jkcemu.tools.fileconverter.HeadersaveFileTarget;
import jkcemu.tools.fileconverter.ImageDiskFileTarget;
import jkcemu.tools.fileconverter.IntelHexFileTarget;
import jkcemu.tools.fileconverter.KCAudioFileTarget;
import jkcemu.tools.fileconverter.KCBasicFileTarget;
import jkcemu.tools.fileconverter.KCBasicSystemFileTarget;
import jkcemu.tools.fileconverter.KCSystemFileTarget;
import jkcemu.tools.fileconverter.KCTapBasicFileTarget;
import jkcemu.tools.fileconverter.KCTapSystemFileTarget;
import jkcemu.tools.fileconverter.LogDlg;
import jkcemu.tools.fileconverter.PlainDiskFileTarget;
import jkcemu.tools.fileconverter.SCCHAudioFileTarget;
import jkcemu.tools.fileconverter.TZXFileTarget;
import jkcemu.tools.fileconverter.TeleDiskFileTarget;
import jkcemu.tools.fileconverter.Z1013AudioFileTarget;

public class FileConvertFrm
extends BaseFrm
implements DropTargetListener,
ListSelectionListener {
    private static final int MAX_MEM_FILE_SIZE = 262144;
    private static final int MAX_DISK_FILE_SIZE = 0x200000;
    private static final int MAX_TAPE_FILE_SIZE = 0x100000;
    private static final String HELP_PAGE = "/help/tools/fileconverter.htm";
    private static final String LABEL_BEG_ADDR = "Anfangsadresse:";
    private static final String LABEL_START_ADDR = "Startadresse:";
    private static FileConvertFrm instance = null;
    private String orgFileDesc = null;
    private int orgFileTypeChar = -1;
    private int orgStartAddr = -1;
    private String orgRemark = null;
    private boolean orgIsBasicPrg = false;
    private boolean lastOutDirAsInDir = false;
    private String lastSavedTargetText = null;
    private FileNameFld fldSrcFile;
    private JButton btnSrcSelect;
    private JButton btnSrcRemove;
    private JTextField fldSrcInfo;
    private Vector<AbstractConvertTarget> targets;
    private JList<AbstractConvertTarget> listTarget;
    private JLabel labelBegAddr;
    private JLabel labelStartAddr;
    private JLabel labelFileDesc;
    private JLabel labelFileType;
    private JLabel labelRemark;
    private JTextField fldFileDesc;
    private JTextField fldBegAddr;
    private JTextField fldStartAddr;
    private JTextField fldRemark;
    private JComboBox<String> comboFileType;
    private HexDocument docBegAddr;
    private HexDocument docStartAddr;
    private LimitedDocument docFileDesc;
    private LimitedDocument docFileType;
    private LimitedDocument docRemark;
    private JButton btnConvert;
    private JButton btnPlay;
    private JButton btnHelp;
    private JButton btnClose;

    public static void open() {
        if (instance != null) {
            if (instance.getExtendedState() == 1) {
                instance.setExtendedState(0);
            }
        } else {
            instance = new FileConvertFrm();
        }
        instance.toFront();
        instance.setVisible(true);
    }

    public static void open(File file) {
        FileConvertFrm.open();
        if (file != null) {
            instance.openFile(file);
        }
    }

    public boolean getOrgIsBasicPrg() {
        return this.orgIsBasicPrg;
    }

    public int getOrgFileTypeChar() {
        return this.orgFileTypeChar;
    }

    public int getOrgStartAddr() {
        return this.orgStartAddr;
    }

    public int getBegAddr(boolean bl) throws UserInputException {
        int n = this.getAddr(this.docBegAddr);
        if (n < 0 && bl) {
            throw new UserInputException("Anfangsadresse nicht angegeben");
        }
        return n;
    }

    public int getStartAddr(boolean bl) throws UserInputException {
        int n = this.getAddr(this.docStartAddr);
        if (n < 0 && bl) {
            throw new UserInputException("Startadresse nicht angegeben");
        }
        return n;
    }

    public String getFileDesc() {
        return FileConvertFrm.strip(this.fldFileDesc.getText());
    }

    public String getFileDesc(boolean bl) throws UserInputException {
        String string = this.getFileDesc();
        if (string == null && bl) {
            throw new UserInputException("Bezeichnung nicht angegeben");
        }
        return string;
    }

    public String getFileType() {
        Object object = this.comboFileType.getSelectedItem();
        return object != null ? object.toString() : null;
    }

    public int getFileTypeChar(boolean bl) throws UserInputException {
        int n = -1;
        String string = this.getFileType();
        if (!(string == null || string.isEmpty() || (n = (int)string.charAt(0)) > 32 && n < 127)) {
            n = -1;
        }
        if (n < 0 && bl) {
            throw new UserInputException("Typ nicht angegeben oder ung\u00fcltig");
        }
        return n;
    }

    public String getRemark() {
        return FileConvertFrm.strip(this.fldRemark.getText());
    }

    public void openFile(File file) {
        if (file != null) {
            try {
                int n;
                Object object;
                Object object2;
                int n2;
                if (!file.isFile() || !file.canRead()) {
                    throw new IOException(file.getPath() + ": Nicht gefunden oder nicht lesbar");
                }
                this.clearOutFields();
                this.orgFileDesc = null;
                this.orgFileTypeChar = -1;
                this.orgStartAddr = -1;
                this.orgIsBasicPrg = false;
                this.orgRemark = null;
                String string = null;
                AbstractFloppyDisk abstractFloppyDisk = null;
                Object object3 = -1;
                int n3 = 0;
                int n4 = 0;
                int n5 = 0;
                int n6 = 0;
                byte[] byArray = null;
                byte[] byArray2 = null;
                FileFormat fileFormat = null;
                boolean bl = false;
                String string2 = null;
                String string3 = file.getName();
                if (string3 != null) {
                    int n7;
                    if (!string3.isEmpty()) {
                        int n8;
                        String string4 = string3;
                        n2 = string4.lastIndexOf(46);
                        if (n2 >= 0) {
                            string4 = string4.substring(0, n2);
                        }
                        if ((n8 = string4.length()) > 0) {
                            boolean bl2 = false;
                            for (int i = 0; i < n8; ++i) {
                                if (!Character.isUpperCase(string4.charAt(i))) continue;
                                bl2 = true;
                                break;
                            }
                            this.orgFileDesc = bl2 ? string4 : string4.toUpperCase();
                        }
                    }
                    if ((string3 = string3.toLowerCase()) != null && (n7 = string3.lastIndexOf(46)) > 0 && n7 + 1 < string3.length()) {
                        string2 = string3.substring(n7 + 1);
                    }
                }
                StringBuilder stringBuilder = new StringBuilder(128);
                n2 = 0;
                try {
                    object2 = AudioFile.getInfo(file);
                    stringBuilder.append("Sound-Datei");
                    stringBuilder.append(", ");
                    AudioUtil.appendAudioFormatText(stringBuilder, (PCMDataInfo)object2);
                    this.targets.add(new AudioFileTarget(this, file));
                    n2 = 1;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (n2 == 0 && string3 != null) {
                    if (string3.endsWith(".bin") || string3.endsWith(".rom")) {
                        stringBuilder.append("Einfache Speicherabbilddatei");
                        object2 = EmuUtil.extractAddressesFromFileName(string3);
                        if (object2 != null) {
                            if (((Object)object2).length > 0) {
                                object3 = object2[0];
                                this.setAddr(this.fldBegAddr, (int)object3);
                            }
                            if (((Object)object2).length > 2) {
                                this.orgStartAddr = (int)object2[2];
                                this.setAddr(this.fldStartAddr, this.orgStartAddr);
                            }
                        }
                        fileFormat = FileFormat.BIN;
                        byte[] byArray3 = EmuUtil.readFile(file, false, 262144);
                        if (byArray3 != null) {
                            byArray = byArray3;
                            n6 = byArray3.length;
                        }
                        n2 = 1;
                    } else if (TextUtil.endsWith(string3, DiskUtil.plainDiskFileExt)) {
                        abstractFloppyDisk = this.getPlainFloppyDisk(file);
                        if (abstractFloppyDisk != null) {
                            stringBuilder.append("Einfache Diskettenabbildddtei");
                        }
                        n2 = 1;
                    } else if (TextUtil.endsWith(string3, DiskUtil.gzPlainDiskFileExt)) {
                        abstractFloppyDisk = this.getPlainFloppyDisk(file);
                        if (abstractFloppyDisk != null) {
                            stringBuilder.append("Komprimierte einfache Diskettenabbildddtei");
                        }
                        n2 = 1;
                    }
                }
                if (n2 == 0 && (abstractFloppyDisk = DiskUtil.readNonPlainDiskFile(this, file, true)) != null) {
                    object2 = abstractFloppyDisk.getFileFormatText();
                    if (object2 == null) {
                        object2 = "Diskettenabbilddatei";
                    }
                    stringBuilder.append((String)object2);
                    if (string3.endsWith(".gz")) {
                        stringBuilder.append(" (GZip-komprimiert)");
                    }
                    this.orgRemark = FileConvertFrm.strip(abstractFloppyDisk.getRemark());
                    n2 = 1;
                }
                if (n2 == 0 && (object2 = FileInfo.analyzeFile(file)) != null) {
                    fileFormat = ((FileInfo)object2).getFileFormat();
                    if (fileFormat != null) {
                        byte[] byArray4;
                        byte[] byArray5;
                        stringBuilder.append(((FileInfo)object2).getInfoText());
                        String string5 = ((FileInfo)object2).getFileDesc();
                        if (string5 != null && !string5.isEmpty()) {
                            this.orgFileDesc = string5;
                        }
                        this.orgFileTypeChar = ((FileInfo)object2).getFileType();
                        object3 = ((FileInfo)object2).getBegAddr();
                        if ((fileFormat.equals(FileFormat.HEADERSAVE) && this.orgFileTypeChar == 66 && object3 == 1025 || fileFormat.equals(FileFormat.KCB) || fileFormat.equals(FileFormat.KCB_BLKN) || fileFormat.equals(FileFormat.KCB_BLKN_CKS) || fileFormat.equals(FileFormat.KCTAP_BASIC_PRG) || fileFormat.equals(FileFormat.KCBASIC_HEAD_PRG) || fileFormat.equals(FileFormat.KCBASIC_HEAD_PRG_BLKN) || fileFormat.equals(FileFormat.KCBASIC_HEAD_PRG_BLKN_CKS) || fileFormat.equals(FileFormat.KCBASIC_PRG)) && (byArray5 = EmuUtil.readFile(file, false, 262144)) != null) {
                            try {
                                object = ((FileInfo)object2).createLoadData(byArray5);
                                if (object != null) {
                                    byArray2 = ((LoadData)object).getByteArray();
                                    n3 = ((LoadData)object).getOffset();
                                    n4 = ((LoadData)object).getLength();
                                    if (byArray2 != null && n4 > 0) {
                                        this.orgIsBasicPrg = true;
                                    }
                                }
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                        if (fileFormat.equals(FileFormat.KCB)) {
                            fileFormat = FileFormat.KCC;
                        } else if (fileFormat.equals(FileFormat.KCB_BLKN)) {
                            fileFormat = FileFormat.KCC_BLKN;
                        } else if (fileFormat.equals(FileFormat.KCB_BLKN_CKS)) {
                            fileFormat = FileFormat.KCC_BLKN_CKS;
                        }
                        if ((fileFormat.equals(FileFormat.HEADERSAVE) || fileFormat.equals(FileFormat.INTELHEX) || fileFormat.equals(FileFormat.KCC) || fileFormat.equals(FileFormat.KCC_BLKN) || fileFormat.equals(FileFormat.KCC_BLKN_CKS) || fileFormat.equals(FileFormat.KCTAP_SYS) || fileFormat.equals(FileFormat.KCTAP_Z9001) || fileFormat.equals(FileFormat.KCTAP_KC85)) && (byArray4 = EmuUtil.readFile(file, false, 262144)) != null) {
                            try {
                                object = FileInfo.createLoadData(byArray4, fileFormat);
                                if (object != null) {
                                    string = ((LoadData)object).getInfoMsg();
                                    byArray = ((LoadData)object).getByteArray();
                                    n5 = ((LoadData)object).getOffset();
                                    n6 = ((LoadData)object).getLength();
                                    object3 = ((LoadData)object).getBegAddr();
                                    this.orgStartAddr = ((LoadData)object).getStartAddr();
                                    this.setAddr(this.fldBegAddr, (int)object3);
                                    this.setAddr(this.fldStartAddr, this.orgStartAddr);
                                }
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                        if (((FileInfo)object2).getNextTAPOffset() > 0 && (byArray2 != null || byArray != null)) {
                            string = "Die Quelldatei ist eine Mutli-TAP-Datei.\nEs wird nur die erste Teildatei konvertiert.";
                        }
                    }
                    n2 = 1;
                }
                if (n2 == 0 && (n = string3.lastIndexOf(".")) >= 0 && n + 1 < string3.length()) {
                    stringBuilder.append(string3.substring(n + 1).toUpperCase());
                    stringBuilder.append("-Datei");
                }
                if (abstractFloppyDisk != null) {
                    string = abstractFloppyDisk.getWarningText();
                    if (!(abstractFloppyDisk instanceof PlainDisk)) {
                        this.targets.add(new PlainDiskFileTarget(this, abstractFloppyDisk));
                    }
                    if (!(abstractFloppyDisk instanceof AnaDisk)) {
                        this.targets.add(new AnaDiskFileTarget(this, abstractFloppyDisk));
                    }
                    if (!(abstractFloppyDisk instanceof CopyQMDisk)) {
                        this.targets.add(new CopyQMFileTarget(this, abstractFloppyDisk));
                    }
                    if (!(abstractFloppyDisk instanceof CPCDisk)) {
                        this.targets.add(new CPCDiskFileTarget(this, abstractFloppyDisk));
                    }
                    if (!(abstractFloppyDisk instanceof ImageDisk)) {
                        this.targets.add(new ImageDiskFileTarget(this, abstractFloppyDisk));
                    }
                    if (!(abstractFloppyDisk instanceof TeleDisk)) {
                        this.targets.add(new TeleDiskFileTarget(this, abstractFloppyDisk));
                    }
                }
                if (fileFormat != null) {
                    byte[] byArray6;
                    byte[] byArray7;
                    if (byArray2 != null) {
                        if (!fileFormat.equals(FileFormat.KCBASIC_PRG)) {
                            this.targets.add(new KCBasicFileTarget(this, byArray2, n3, n4));
                        }
                        if (!fileFormat.equals(FileFormat.KCB)) {
                            this.targets.add(new KCBasicSystemFileTarget(this, byArray2, n3, n4));
                        }
                        if (!fileFormat.equals(FileFormat.KCTAP_BASIC_PRG)) {
                            this.targets.add(new KCTapBasicFileTarget(this, byArray2, n3, n4));
                        }
                        this.targets.add(new KCAudioFileTarget(this, byArray2, n3, n4, KCAudioFileTarget.Target.KCBASIC_PRG));
                    }
                    if (byArray != null) {
                        if (!fileFormat.equals(FileFormat.BIN)) {
                            this.targets.add(new BinFileTarget(this, byArray, n5, n6, (int)object3, object3 + n6 - 1 & 0xFFFF, this.orgStartAddr));
                        }
                        if (!fileFormat.equals(FileFormat.HEADERSAVE)) {
                            this.targets.add(new HeadersaveFileTarget(this, byArray, n5, n6));
                        }
                        if (!fileFormat.equals(FileFormat.INTELHEX)) {
                            this.targets.add(new IntelHexFileTarget(this, byArray, n5, n6));
                        }
                        if (!fileFormat.equals(FileFormat.KCC)) {
                            this.targets.add(new KCSystemFileTarget(this, byArray, n5, n6));
                        }
                        if (!fileFormat.equals(FileFormat.KCTAP_Z9001)) {
                            this.targets.add(new KCTapSystemFileTarget(this, byArray, n5, n6, true));
                        }
                        if (!fileFormat.equals(FileFormat.KCTAP_KC85)) {
                            this.targets.add(new KCTapSystemFileTarget(this, byArray, n5, n6, false));
                        }
                        boolean bl3 = false;
                        if (fileFormat.equals(FileFormat.BASIC_PRG)) {
                            bl3 = true;
                        } else if (fileFormat.equals(FileFormat.HEADERSAVE) && this.orgFileTypeChar == 66) {
                            bl3 = true;
                        }
                        this.targets.add(new AC1AudioFileTarget(this, byArray, n5, n6, bl3));
                        this.targets.add(new SCCHAudioFileTarget(this, byArray, n5, n6));
                        this.targets.add(new KCAudioFileTarget(this, byArray, n5, n6, KCAudioFileTarget.Target.Z9001));
                        this.targets.add(new KCAudioFileTarget(this, byArray, n5, n6, KCAudioFileTarget.Target.KC85));
                        this.targets.add(new Z1013AudioFileTarget(this, byArray, n5, n6, false));
                        this.targets.add(new Z1013AudioFileTarget(this, byArray, n5, n6, true));
                    }
                    if (fileFormat.equals(FileFormat.CSW) && (byArray7 = EmuUtil.readFile(file, false, 0x100000)) != null) {
                        BitSampleBuffer bitSampleBuffer = CSWFile.getBitSampleBuffer(byArray7, 0);
                        this.targets.add(new AudioFileTarget(this, bitSampleBuffer));
                        this.targets.add(new TZXFileTarget(this, bitSampleBuffer));
                    }
                    if ((fileFormat.equals(FileFormat.CDT) || fileFormat.equals(FileFormat.TZX) || fileFormat.equals(FileFormat.ZXTAP)) && (byArray6 = EmuUtil.readFile(file, false, 0x100000)) != null) {
                        ZXSpectrumAudioCreator zXSpectrumAudioCreator = new ZXSpectrumAudioCreator(byArray6, 0, byArray6.length);
                        this.targets.add(new AudioFileTarget(this, zXSpectrumAudioCreator));
                        this.targets.add(new CSWFileTarget(this, zXSpectrumAudioCreator));
                    }
                }
                if (this.targets.size() > 0) {
                    try {
                        Collections.sort(this.targets);
                    }
                    catch (ClassCastException classCastException) {
                        // empty catch block
                    }
                    this.listTarget.setListData(this.targets);
                    int n9 = 0;
                    if (this.lastSavedTargetText != null) {
                        int n10 = this.targets.size();
                        for (int i = 0; i < n10; ++i) {
                            object = this.targets.get(i).toString();
                            if (object == null || !((String)object).equals(this.lastSavedTargetText)) continue;
                            n9 = i;
                            break;
                        }
                    }
                    EmuUtil.fireSelectRow(this.listTarget, n9);
                } else {
                    if (stringBuilder.length() == 0) {
                        stringBuilder.append("unbekannt");
                    }
                    stringBuilder.append(" (nicht konvertierbar)");
                }
                this.fldSrcFile.setFile(file);
                this.fldSrcInfo.setText(stringBuilder.toString());
                this.btnSrcRemove.setEnabled(true);
                Main.setLastFile(file, "fileconnverter.in");
                if (string != null) {
                    BaseDlg.showInfoDlg(this, string);
                }
            }
            catch (IOException iOException) {
                BaseDlg.showErrorDlg((Component)this, iOException);
            }
        }
    }

    @Override
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        if (!EmuUtil.isFileDrop(dropTargetDragEvent)) {
            dropTargetDragEvent.rejectDrag();
        }
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        File file = EmuUtil.fileDrop(this, dropTargetDropEvent);
        if (file != null) {
            this.openFile(file);
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        if (!EmuUtil.isFileDrop(dropTargetDragEvent)) {
            dropTargetDragEvent.rejectDrag();
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getSource() == this.listTarget) {
            this.targetSelectionChanged();
        }
    }

    @Override
    protected boolean doAction(EventObject eventObject) {
        boolean bl = false;
        if (eventObject != null) {
            Object object = eventObject.getSource();
            if (object == this.btnSrcSelect) {
                bl = true;
                this.doSelectSrcFile();
            }
            if (object == this.btnSrcRemove) {
                bl = true;
                this.doRemoveSrcFile();
            } else if (object == this.btnConvert) {
                bl = true;
                this.doSave();
            } else if (object == this.btnPlay) {
                bl = true;
                this.doPlay();
            } else if (object == this.btnClose) {
                bl = true;
                this.doClose();
            } else if (object == this.btnHelp) {
                bl = true;
                HelpFrm.open(HELP_PAGE);
            }
        }
        return bl;
    }

    @Override
    public boolean doClose() {
        boolean bl = super.doClose();
        if (bl && !Main.checkQuit(this)) {
            this.doRemoveSrcFile();
        }
        return bl;
    }

    @Override
    public void lookAndFeelChanged() {
        super.lookAndFeelChanged();
        this.setFileTypeDocument();
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
        if (windowEvent.getWindow() == this) {
            this.btnSrcSelect.requestFocus();
        }
    }

    private void doPlay() {
        AbstractConvertTarget abstractConvertTarget = this.listTarget.getSelectedValue();
        if (abstractConvertTarget != null && abstractConvertTarget.canPlay()) {
            try {
                AudioPlayer.play(this, abstractConvertTarget.createPCMDataSource(), "Wiedergabe...");
            }
            catch (IOException iOException) {
                BaseDlg.showErrorDlg((Component)this, iOException);
            }
            catch (UserInputException userInputException) {
                BaseDlg.showErrorDlg((Component)this, userInputException);
            }
        }
    }

    private void doRemoveSrcFile() {
        this.fldSrcFile.setFile(null);
        this.fldSrcInfo.setText("");
        this.btnSrcRemove.setEnabled(false);
        this.clearOutFields();
    }

    private void doSelectSrcFile() {
        File file = this.fldSrcFile.getFile();
        if (file != null) {
            file = file.getParentFile();
        }
        if (file == null) {
            file = Main.getLastDirFile("fileconnverter.in");
        }
        if ((file = EmuUtil.showFileOpenDlg(this, "Quelldatei ausw\u00e4hlen", file, AudioFile.getFileFilter(), EmuUtil.getBinaryFileFilter(), EmuUtil.getHeadersaveFileFilter(), EmuUtil.getHexFileFilter(), EmuUtil.getKCBasicFileFilter(), EmuUtil.getKCSystemFileFilter(), EmuUtil.getTapeFileFilter(), EmuUtil.getPlainDiskFileFilter(), EmuUtil.getAnaDiskFileFilter(), EmuUtil.getCopyQMFileFilter(), EmuUtil.getDskFileFilter(), EmuUtil.getImageDiskFileFilter(), EmuUtil.getTeleDiskFileFilter())) != null) {
            this.openFile(file);
        }
    }

    private void doSave() {
        AbstractConvertTarget abstractConvertTarget = this.listTarget.getSelectedValue();
        if (abstractConvertTarget != null) {
            Object object;
            Object object2;
            File file = this.fldSrcFile.getFile();
            File file2 = abstractConvertTarget.getSuggestedOutFile(file);
            if (file2 != null && !this.lastOutDirAsInDir && (object2 = Main.getLastDirFile("fileconnverter.out")) != null && file2 != null && (object = file2.getName()) != null && !((String)object).isEmpty()) {
                file2 = new File((File)object2, (String)object);
            }
            if ((file2 = EmuUtil.showFileSaveDlg(this, "Konvertierte Datei speichern", file2, abstractConvertTarget.getFileFilters())) != null) {
                try {
                    object2 = abstractConvertTarget.save(file2);
                    Main.setLastFile(file2, "fileconnverter.out");
                    this.lastOutDirAsInDir = false;
                    if (file != null) {
                        object = file.getParentFile();
                        File file3 = file2.getParentFile();
                        if (object != null && file3 != null) {
                            this.lastOutDirAsInDir = file3.equals(object);
                        } else if (object == null && file3 == null) {
                            this.lastOutDirAsInDir = true;
                        }
                    }
                    if (object2 != null && !((String)object2).isEmpty()) {
                        LogDlg.showDlg(this, (String)object2, "Hinweise");
                    }
                    this.lastSavedTargetText = abstractConvertTarget.toString();
                }
                catch (IOException iOException) {
                    BaseDlg.showErrorDlg((Component)this, iOException);
                }
                catch (UserInputException userInputException) {
                    BaseDlg.showErrorDlg((Component)this, userInputException);
                }
            }
        }
    }

    private FileConvertFrm() {
        this.setTitle("JKCEMU Dateikonverter");
        Main.updIcon(this);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0);
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.add((Component)jPanel, gridBagConstraints);
        jPanel.setBorder(BorderFactory.createTitledBorder("Quelldatei"));
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0);
        jPanel.add((Component)new JLabel("Datei:"), gridBagConstraints2);
        this.fldSrcFile = new FileNameFld();
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.insets.left = 0;
        ++gridBagConstraints2.gridx;
        jPanel.add((Component)this.fldSrcFile, gridBagConstraints2);
        this.btnSrcSelect = this.createImageButton("/images/file/open.png", "Quelldatei ausw\u00e4hlen");
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.fill = 0;
        ++gridBagConstraints2.gridx;
        jPanel.add((Component)this.btnSrcSelect, gridBagConstraints2);
        this.btnSrcRemove = this.createImageButton("/images/file/delete.png", "Quelldatei entfernen");
        this.btnSrcRemove.setEnabled(false);
        ++gridBagConstraints2.gridx;
        jPanel.add((Component)this.btnSrcRemove, gridBagConstraints2);
        gridBagConstraints2.insets.left = 5;
        gridBagConstraints2.gridx = 0;
        ++gridBagConstraints2.gridy;
        jPanel.add((Component)new JLabel("Typ:"), gridBagConstraints2);
        this.fldSrcInfo = new JTextField();
        this.fldSrcInfo.setEditable(false);
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.insets.left = 0;
        gridBagConstraints2.gridwidth = 0;
        ++gridBagConstraints2.gridx;
        jPanel.add((Component)this.fldSrcInfo, gridBagConstraints2);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        ++gridBagConstraints.gridy;
        this.add((Component)jPanel2, gridBagConstraints);
        jPanel2.setBorder(BorderFactory.createTitledBorder("Ausgabedatei"));
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0);
        jPanel2.add((Component)new JLabel("Dateiformat:"), gridBagConstraints3);
        this.targets = new Vector();
        this.listTarget = new JList();
        this.listTarget.setSelectionMode(0);
        this.listTarget.addListSelectionListener(this);
        gridBagConstraints3.fill = 1;
        gridBagConstraints3.weightx = 1.0;
        gridBagConstraints3.weighty = 1.0;
        ++gridBagConstraints3.gridy;
        jPanel2.add((Component)new JScrollPane(this.listTarget), gridBagConstraints3);
        gridBagConstraints3.fill = 0;
        gridBagConstraints3.weightx = 0.0;
        gridBagConstraints3.weighty = 0.0;
        gridBagConstraints3.insets.top = 15;
        ++gridBagConstraints3.gridy;
        jPanel2.add((Component)new JLabel("Kopfdaten:"), gridBagConstraints3);
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        jPanel3.setBorder(BorderFactory.createEtchedBorder());
        gridBagConstraints3.fill = 2;
        gridBagConstraints3.weightx = 1.0;
        gridBagConstraints3.insets.top = 0;
        gridBagConstraints3.insets.bottom = 5;
        ++gridBagConstraints3.gridy;
        jPanel2.add((Component)jPanel3, gridBagConstraints3);
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0);
        this.labelFileDesc = new JLabel("Bezeichnung:");
        jPanel3.add((Component)this.labelFileDesc, gridBagConstraints4);
        this.docFileDesc = new LimitedDocument();
        this.fldFileDesc = new JTextField(this.docFileDesc, "", 0);
        gridBagConstraints4.fill = 2;
        gridBagConstraints4.weightx = 1.0;
        gridBagConstraints4.gridwidth = 3;
        ++gridBagConstraints4.gridx;
        jPanel3.add((Component)this.fldFileDesc, gridBagConstraints4);
        this.labelFileType = new JLabel("Typ:");
        gridBagConstraints4.fill = 0;
        gridBagConstraints4.weightx = 0.0;
        gridBagConstraints4.gridwidth = 1;
        gridBagConstraints4.gridx = 0;
        ++gridBagConstraints4.gridy;
        jPanel3.add((Component)this.labelFileType, gridBagConstraints4);
        this.comboFileType = new JComboBox();
        this.comboFileType.setEditable(true);
        gridBagConstraints4.fill = 2;
        gridBagConstraints4.weightx = 1.0;
        gridBagConstraints4.gridwidth = 3;
        ++gridBagConstraints4.gridx;
        jPanel3.add(this.comboFileType, gridBagConstraints4);
        this.docFileType = new LimitedDocument();
        this.docFileType.setAsciiOnly(true);
        this.setFileTypeDocument();
        Font font = this.fldFileDesc.getFont();
        if (font != null) {
            this.comboFileType.setFont(font);
        }
        this.labelBegAddr = new JLabel(LABEL_BEG_ADDR);
        gridBagConstraints4.fill = 0;
        gridBagConstraints4.weightx = 0.0;
        gridBagConstraints4.gridwidth = 1;
        gridBagConstraints4.gridx = 0;
        ++gridBagConstraints4.gridy;
        jPanel3.add((Component)this.labelBegAddr, gridBagConstraints4);
        this.docBegAddr = new HexDocument(4, LABEL_BEG_ADDR);
        this.fldBegAddr = new JTextField(this.docBegAddr, "", 0);
        gridBagConstraints4.fill = 2;
        gridBagConstraints4.weightx = 0.5;
        ++gridBagConstraints4.gridx;
        jPanel3.add((Component)this.fldBegAddr, gridBagConstraints4);
        this.labelStartAddr = new JLabel(LABEL_START_ADDR);
        gridBagConstraints4.fill = 0;
        gridBagConstraints4.weightx = 0.0;
        ++gridBagConstraints4.gridx;
        jPanel3.add((Component)this.labelStartAddr, gridBagConstraints4);
        this.docStartAddr = new HexDocument(4, LABEL_START_ADDR);
        this.fldStartAddr = new JTextField(this.docStartAddr, "", 0);
        gridBagConstraints4.fill = 2;
        gridBagConstraints4.weightx = 0.5;
        gridBagConstraints4.insets.left = 0;
        ++gridBagConstraints4.gridx;
        jPanel3.add((Component)this.fldStartAddr, gridBagConstraints4);
        this.labelRemark = new JLabel("Kommentar:");
        gridBagConstraints4.fill = 0;
        gridBagConstraints4.weightx = 0.0;
        gridBagConstraints4.insets.left = 5;
        gridBagConstraints4.insets.bottom = 5;
        gridBagConstraints4.gridx = 0;
        ++gridBagConstraints4.gridy;
        jPanel3.add((Component)this.labelRemark, gridBagConstraints4);
        this.docRemark = new LimitedDocument();
        this.fldRemark = new JTextField(this.docRemark, "", 0);
        gridBagConstraints4.fill = 2;
        gridBagConstraints4.weightx = 1.0;
        gridBagConstraints4.gridwidth = 3;
        ++gridBagConstraints4.gridx;
        jPanel3.add((Component)this.fldRemark, gridBagConstraints4);
        JPanel jPanel4 = new JPanel(new GridBagLayout());
        gridBagConstraints3.fill = 2;
        gridBagConstraints3.weightx = 1.0;
        gridBagConstraints3.gridwidth = 0;
        gridBagConstraints3.gridx = 0;
        ++gridBagConstraints3.gridy;
        jPanel2.add((Component)jPanel4, gridBagConstraints3);
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0);
        JPanel jPanel5 = new JPanel(new GridLayout(1, 4, 5, 5));
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets.bottom = 10;
        ++gridBagConstraints.gridy;
        this.add((Component)jPanel5, gridBagConstraints);
        this.btnConvert = new JButton("Konvertieren");
        this.btnConvert.addActionListener(this);
        jPanel5.add(this.btnConvert);
        this.btnPlay = new JButton("Wiedergeben");
        this.btnPlay.addActionListener(this);
        jPanel5.add(this.btnPlay);
        this.btnHelp = new JButton("Hilfe");
        this.btnHelp.addActionListener(this);
        jPanel5.add(this.btnHelp);
        this.btnClose = new JButton("Schlie\u00dfen");
        this.btnClose.addActionListener(this);
        jPanel5.add(this.btnClose);
        if (!this.applySettings(Main.getProperties(), true)) {
            this.listTarget.setVisibleRowCount(7);
            this.pack();
            this.listTarget.setVisibleRowCount(1);
            this.setScreenCentered();
        }
        this.setResizable(true);
        new DropTarget(this.fldSrcFile, this).setActive(true);
        this.clearOutFields();
    }

    private void clearOutFields() {
        this.targets.clear();
        this.listTarget.setListData(this.targets);
        this.labelFileDesc.setEnabled(false);
        this.labelFileType.setEnabled(false);
        this.labelBegAddr.setEnabled(false);
        this.labelStartAddr.setEnabled(false);
        this.labelRemark.setEnabled(false);
        this.fldFileDesc.setText("");
        this.comboFileType.setSelectedItem("");
        this.fldBegAddr.setText("");
        this.fldStartAddr.setText("");
        this.fldRemark.setText("");
        this.fldFileDesc.setEnabled(false);
        this.comboFileType.setEnabled(false);
        this.fldBegAddr.setEnabled(false);
        this.fldStartAddr.setEnabled(false);
        this.fldRemark.setEnabled(false);
        this.btnConvert.setEnabled(false);
        this.btnPlay.setEnabled(false);
    }

    public int getAddr(HexDocument hexDocument) throws UserInputException {
        int n = -1;
        try {
            Integer n2 = hexDocument.getInteger();
            if (n2 != null) {
                n = n2 & 0xFFFF;
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new UserInputException(numberFormatException.getMessage());
        }
        return n;
    }

    private AbstractFloppyDisk getPlainFloppyDisk(File file) throws IOException {
        PlainDisk plainDisk = null;
        byte[] byArray = EmuUtil.readFile(file, false, 0x200000);
        if (byArray != null) {
            FloppyDiskFormatDlg floppyDiskFormatDlg = new FloppyDiskFormatDlg((Window)this, FloppyDiskFormat.getFormatByDiskSize(file.length()), FloppyDiskFormatDlg.Flag.PHYS_FORMAT);
            floppyDiskFormatDlg.setVisible(true);
            FloppyDiskFormat floppyDiskFormat = floppyDiskFormatDlg.getFormat();
            if (floppyDiskFormat != null) {
                plainDisk = PlainDisk.createForByteArray(this, file.getPath(), byArray, floppyDiskFormat);
            }
        }
        return plainDisk;
    }

    private void setAddr(JTextField jTextField, int n) {
        if (n >= 0) {
            jTextField.setText(String.format("%04X", n));
        } else {
            jTextField.setText("");
        }
    }

    private void setFileTypeDocument() {
        Component component;
        ComboBoxEditor comboBoxEditor = this.comboFileType.getEditor();
        if (comboBoxEditor != null && (component = comboBoxEditor.getEditorComponent()) != null && component instanceof JTextComponent) {
            ((JTextComponent)component).setDocument(this.docFileType);
        }
    }

    private static String strip(String string) {
        if (string != null && (string = string.trim()).isEmpty()) {
            string = null;
        }
        return string;
    }

    private void targetSelectionChanged() {
        int n;
        AbstractConvertTarget abstractConvertTarget = this.listTarget.getSelectedValue();
        if (abstractConvertTarget != null) {
            String string;
            Object object;
            this.labelBegAddr.setEnabled(abstractConvertTarget.usesBegAddr());
            this.fldBegAddr.setEnabled(abstractConvertTarget.usesBegAddr());
            n = this.docFileDesc.getMaxLength();
            String string2 = this.fldFileDesc.getText();
            if (string2 == null) {
                string2 = "";
            }
            int n2 = string2.length();
            int n3 = abstractConvertTarget.getMaxFileDescLength();
            this.docFileDesc.setMaxLength(n3);
            this.labelFileDesc.setEnabled(n3 > 0);
            this.fldFileDesc.setEnabled(n3 > 0);
            if (this.orgFileDesc == null) {
                this.orgFileDesc = "";
            }
            if (n2 > 0) {
                if (n2 < n && this.orgFileDesc.equals(string2) || n2 == n && this.orgFileDesc.startsWith(string2)) {
                    string2 = this.orgFileDesc;
                }
            } else {
                string2 = this.orgFileDesc;
            }
            this.fldFileDesc.setText(string2);
            n3 = abstractConvertTarget.getMaxFileTypeLength();
            this.docFileType.setMaxLength(n3);
            abstractConvertTarget.setFileTypesTo(this.comboFileType);
            this.labelFileType.setEnabled(this.comboFileType.isEnabled());
            if (this.orgFileDesc != null && this.getOrgFileTypeChar() < 0 && (object = this.comboFileType.getSelectedItem()) != null && (string = object.toString()) != null) {
                int n4;
                String string3 = "." + string.toUpperCase();
                if (this.orgFileDesc.toUpperCase().endsWith(string3) && (n4 = this.orgFileDesc.length() - string3.length()) > 0) {
                    this.fldFileDesc.setText(this.orgFileDesc.substring(0, n4));
                }
            }
            n3 = abstractConvertTarget.getMaxRemarkLength();
            this.docRemark.setMaxLength(n3);
            this.labelRemark.setEnabled(n3 > 0);
            this.fldRemark.setEnabled(n3 > 0);
            this.fldRemark.setText(this.orgRemark);
            this.btnConvert.setEnabled(abstractConvertTarget != null);
            this.btnPlay.setEnabled(abstractConvertTarget.canPlay());
        } else {
            this.labelBegAddr.setEnabled(false);
            this.fldBegAddr.setEnabled(false);
            this.labelFileDesc.setEnabled(false);
            this.docFileDesc.setMaxLength(0);
            this.fldFileDesc.setEnabled(false);
            this.fldFileDesc.setText(this.orgFileDesc);
            this.labelFileType.setEnabled(false);
            this.comboFileType.setEnabled(false);
            this.comboFileType.removeAllItems();
            this.labelRemark.setEnabled(false);
            this.docRemark.setMaxLength(0);
            this.fldRemark.setEnabled(false);
            this.fldRemark.setText(this.orgRemark);
            this.btnConvert.setEnabled(false);
            this.btnPlay.setEnabled(false);
        }
        n = 0;
        if (abstractConvertTarget != null) {
            try {
                n = abstractConvertTarget.usesStartAddr(this.getFileTypeChar(false));
            }
            catch (UserInputException userInputException) {
                // empty catch block
            }
        }
        this.labelStartAddr.setEnabled(n != 0);
        this.fldStartAddr.setEnabled(n != 0);
        this.fldStartAddr.setEditable(n != 0);
    }
}

