/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.tools.fileconverter;

import java.io.File;
import java.io.IOException;
import javax.swing.JComboBox;
import javax.swing.filechooser.FileFilter;
import jkcemu.audio.AudioFile;
import jkcemu.audio.PCMDataSource;
import jkcemu.base.EmuUtil;
import jkcemu.base.UserInputException;
import jkcemu.tools.fileconverter.FileConvertFrm;

public abstract class AbstractConvertTarget
implements Comparable<AbstractConvertTarget> {
    private static String suggestedAudioFileExt = null;
    protected FileConvertFrm fileConvertFrm;
    private String infoText;

    public AbstractConvertTarget(FileConvertFrm fileConvertFrm, String string) {
        this.fileConvertFrm = fileConvertFrm;
        this.setInfoText(string);
    }

    public boolean canPlay() {
        return false;
    }

    protected void checkFileExtension(File file, String ... stringArray) throws IOException {
        CharSequence charSequence;
        boolean bl = false;
        if (file != null && stringArray != null) {
            charSequence = file.getPath().toLowerCase();
            for (String string : stringArray) {
                if (!((String)charSequence).endsWith(string)) continue;
                bl = true;
                break;
            }
        }
        if (!bl) {
            if (stringArray != null) {
                if (stringArray.length == 1) {
                    throw new IOException("Die Ausgabedatei muss die Endung '" + stringArray[0] + "' haben.");
                }
                if (stringArray.length > 1) {
                    charSequence = new StringBuilder(256);
                    ((StringBuilder)charSequence).append("Die Ausgabedatei muss eine der folgenden Endungen haben:");
                    for (String string : stringArray) {
                        ((StringBuilder)charSequence).append("\n    ");
                        ((StringBuilder)charSequence).append(string);
                    }
                    throw new IOException(((StringBuilder)charSequence).toString());
                }
            }
            throw new IOException("Die Ausgabedatei hat die falsche Endung.");
        }
    }

    public PCMDataSource createPCMDataSource() throws IOException, UserInputException {
        return null;
    }

    public FileFilter getFileFilter() {
        return null;
    }

    public FileFilter[] getFileFilters() {
        FileFilter[] fileFilterArray;
        FileFilter fileFilter = this.getFileFilter();
        if (fileFilter != null) {
            FileFilter[] fileFilterArray2 = new FileFilter[1];
            fileFilterArray = fileFilterArray2;
            fileFilterArray2[0] = fileFilter;
        } else {
            fileFilterArray = null;
        }
        return fileFilterArray;
    }

    public int getMaxFileDescLength() {
        return 0;
    }

    public int getMaxFileTypeLength() {
        return 0;
    }

    public int getMaxRemarkLength() {
        return 0;
    }

    public abstract File getSuggestedOutFile(File var1);

    protected File getSuggestedOutFile(File file, String[] stringArray, String string) {
        File file2 = null;
        if (file != null && stringArray != null && stringArray.length > 0) {
            String string2 = stringArray[0];
            if (string != null) {
                for (String string3 : stringArray) {
                    if (!string3.equalsIgnoreCase(string)) continue;
                    string2 = string;
                    break;
                }
            }
            file2 = this.replaceExtension(file, string2);
        }
        return file2;
    }

    public abstract String save(File var1) throws IOException, UserInputException;

    public void setInfoText(String string) {
        this.infoText = string != null ? string : "";
    }

    protected File replaceExtension(File file, String string) {
        int n;
        String string2;
        File file2 = null;
        if (file != null && string != null && (string2 = file.getName()) != null && (n = string2.lastIndexOf(46)) >= 0) {
            string2 = string.startsWith(".") ? string2.substring(0, n) + string : string2.substring(0, n + 1) + string;
            File file3 = file.getParentFile();
            file2 = file3 != null ? new File(file3, string2) : new File(string2);
        }
        return file2;
    }

    protected File replaceExtensionToAudioFile(File file) {
        return this.replaceExtension(file, AbstractConvertTarget.getSuggestedAudioFileExtension());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveAudioFile(File file, PCMDataSource pCMDataSource) throws IOException {
        try {
            if (file != null && pCMDataSource != null) {
                AudioFile.write(pCMDataSource, file);
            }
        }
        finally {
            EmuUtil.closeSilent(pCMDataSource);
        }
    }

    public void setFileTypesTo(JComboBox<String> jComboBox) {
        jComboBox.removeAllItems();
        jComboBox.setEnabled(false);
    }

    public boolean usesBegAddr() {
        return false;
    }

    public boolean usesStartAddr(int n) {
        return false;
    }

    @Override
    public int compareTo(AbstractConvertTarget abstractConvertTarget) {
        return this.infoText.compareTo(abstractConvertTarget.infoText);
    }

    public String toString() {
        return this.infoText;
    }

    private static String getSuggestedAudioFileExtension() {
        String[] stringArray;
        if (suggestedAudioFileExt == null && (stringArray = AudioFile.getSupportedFileExtensions()) != null && stringArray.length > 0) {
            String[] stringArray2;
            for (String string : stringArray2 = new String[]{"wav", "aif", "aifc", "aiff", "au"}) {
                for (String string2 : stringArray) {
                    if (!string.equalsIgnoreCase(string2)) continue;
                    suggestedAudioFileExt = string;
                    break;
                }
                if (suggestedAudioFileExt != null) break;
            }
            if (suggestedAudioFileExt == null) {
                suggestedAudioFileExt = stringArray[0];
            }
        }
        return suggestedAudioFileExt;
    }
}

