/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.tools.debugger;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.util.EventObject;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import jkcemu.base.BaseDlg;
import jkcemu.base.HexDocument;
import jkcemu.base.UserInputException;
import jkcemu.tools.debugger.DebugFrm;
import jkcemu.tools.debugger.VarData;

public class VarDataDlg
extends BaseDlg {
    private DebugFrm debugFrm;
    private VarData varData;
    private VarData appliedVarData;
    private JTextField fldName;
    private JTextField fldAddr;
    private HexDocument docAddr;
    private JRadioButton btnInt1;
    private JRadioButton btnInt2;
    private JRadioButton btnInt3;
    private JRadioButton btnInt4;
    private JRadioButton btnInt8;
    private JRadioButton btnFloat4;
    private JRadioButton btnFloat8;
    private JRadioButton btnByteArray;
    private JRadioButton btnPointer;
    private JRadioButton btnLE;
    private JRadioButton btnBE;
    private JSpinner spinnerSize;
    private JLabel labelSize;
    private JLabel labelByteOrder;
    private JButton btnOK;
    private JButton btnCancel;

    public static VarData showEditVarDlg(DebugFrm debugFrm, VarData varData) {
        VarDataDlg varDataDlg = new VarDataDlg(debugFrm, varData);
        varDataDlg.setVisible(true);
        return varDataDlg.appliedVarData;
    }

    public static VarData showNewVarDlg(DebugFrm debugFrm) {
        VarDataDlg varDataDlg = new VarDataDlg(debugFrm, null);
        varDataDlg.setVisible(true);
        return varDataDlg.appliedVarData;
    }

    @Override
    protected boolean doAction(EventObject eventObject) {
        boolean bl = false;
        Object object = eventObject.getSource();
        if (object != null) {
            if (object == this.fldName) {
                bl = true;
                this.fldAddr.requestFocus();
            } else if (object == this.fldAddr) {
                bl = true;
                this.fldAddr.transferFocus();
            } else if (object == this.btnOK) {
                bl = true;
                this.doApply();
            } else if (object == this.btnCancel) {
                bl = true;
                this.doClose();
            } else if (object instanceof JRadioButton) {
                bl = true;
                this.updFieldsEnabled();
            }
        }
        return bl;
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
        if (windowEvent.getSource() == this && this.fldAddr != null) {
            this.fldAddr.requestFocus();
        }
    }

    private VarDataDlg(DebugFrm debugFrm, VarData varData) {
        super((Window)debugFrm, varData != null ? "Variable bearbeiten" : "Variable anlegen");
        this.debugFrm = debugFrm;
        this.varData = varData;
        this.appliedVarData = null;
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0);
        this.add((Component)new JLabel("Bezeichnung (optional):"), gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.add((Component)new JLabel("Adresse (hex):"), gridBagConstraints);
        gridBagConstraints.anchor = 12;
        ++gridBagConstraints.gridy;
        this.add((Component)new JLabel("Typ:"), gridBagConstraints);
        this.fldName = new JTextField();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridy = 0;
        ++gridBagConstraints.gridx;
        this.add((Component)this.fldName, gridBagConstraints);
        this.docAddr = new HexDocument(4, "Adresse");
        this.fldAddr = new JTextField(this.docAddr, "", 0);
        ++gridBagConstraints.gridy;
        this.add((Component)this.fldAddr, gridBagConstraints);
        JPanel jPanel = new JPanel(new GridBagLayout());
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        ++gridBagConstraints.gridy;
        this.add((Component)jPanel, gridBagConstraints);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints(0, 0, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0);
        ButtonGroup buttonGroup = new ButtonGroup();
        this.btnInt1 = new JRadioButton("1 Byte Integer", true);
        buttonGroup.add(this.btnInt1);
        jPanel.add((Component)this.btnInt1, gridBagConstraints2);
        this.btnInt2 = new JRadioButton("2 Byte Integer");
        buttonGroup.add(this.btnInt2);
        ++gridBagConstraints2.gridy;
        jPanel.add((Component)this.btnInt2, gridBagConstraints2);
        this.btnInt3 = new JRadioButton("3 Byte Integer");
        buttonGroup.add(this.btnInt3);
        ++gridBagConstraints2.gridy;
        jPanel.add((Component)this.btnInt3, gridBagConstraints2);
        this.btnInt4 = new JRadioButton("4 Byte Integer");
        buttonGroup.add(this.btnInt4);
        ++gridBagConstraints2.gridy;
        jPanel.add((Component)this.btnInt4, gridBagConstraints2);
        this.btnInt8 = new JRadioButton("8 Byte Integer");
        buttonGroup.add(this.btnInt8);
        ++gridBagConstraints2.gridy;
        jPanel.add((Component)this.btnInt8, gridBagConstraints2);
        this.btnFloat4 = new JRadioButton("4 Byte Float (IEEE 754)");
        buttonGroup.add(this.btnFloat4);
        ++gridBagConstraints2.gridy;
        jPanel.add((Component)this.btnFloat4, gridBagConstraints2);
        this.btnFloat8 = new JRadioButton("8 Byte Float (IEEE 754)");
        buttonGroup.add(this.btnFloat8);
        ++gridBagConstraints2.gridy;
        jPanel.add((Component)this.btnFloat8, gridBagConstraints2);
        this.btnByteArray = new JRadioButton("Bytes / Text");
        buttonGroup.add(this.btnByteArray);
        ++gridBagConstraints2.gridy;
        jPanel.add((Component)this.btnByteArray, gridBagConstraints2);
        this.labelSize = new JLabel("Anzahl Bytes:");
        gridBagConstraints2.insets.left = 50;
        gridBagConstraints2.gridwidth = 1;
        ++gridBagConstraints2.gridy;
        jPanel.add((Component)this.labelSize, gridBagConstraints2);
        this.spinnerSize = new JSpinner(new SpinnerNumberModel(16, 1, 256, 1));
        gridBagConstraints2.insets.left = 5;
        gridBagConstraints2.gridwidth = 0;
        ++gridBagConstraints2.gridx;
        jPanel.add((Component)this.spinnerSize, gridBagConstraints2);
        this.btnPointer = new JRadioButton("Zeiger auf Bytes / Text");
        buttonGroup.add(this.btnPointer);
        gridBagConstraints2.gridx = 0;
        ++gridBagConstraints2.gridy;
        jPanel.add((Component)this.btnPointer, gridBagConstraints2);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        gridBagConstraints2.insets.top = 10;
        gridBagConstraints2.gridx = 0;
        ++gridBagConstraints2.gridy;
        jPanel.add((Component)jPanel2, gridBagConstraints2);
        this.labelByteOrder = new JLabel("Byte Order:");
        jPanel2.add(this.labelByteOrder);
        jPanel2.add(Box.createRigidArea(new Dimension(5, 0)));
        ButtonGroup buttonGroup2 = new ButtonGroup();
        this.btnLE = new JRadioButton("Little Endian (LE, Intel-Format)", true);
        buttonGroup2.add(this.btnLE);
        jPanel2.add((Component)this.btnLE, gridBagConstraints2);
        jPanel2.add(Box.createRigidArea(new Dimension(5, 0)));
        this.btnBE = new JRadioButton("Big Endian (BE)");
        buttonGroup2.add(this.btnBE);
        jPanel2.add((Component)this.btnBE, gridBagConstraints2);
        JPanel jPanel3 = new JPanel(new GridLayout(1, 2, 5, 5));
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets.top = 15;
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.insets.bottom = 10;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        this.add((Component)jPanel3, gridBagConstraints);
        this.btnOK = new JButton("OK");
        jPanel3.add(this.btnOK);
        this.btnCancel = new JButton("Abbrechen");
        jPanel3.add(this.btnCancel);
        if (varData != null) {
            this.fldName.setText(varData.getName());
            this.docAddr.setValue(varData.getAddress(), 4);
            switch (varData.getType()) {
                case INT1: {
                    this.btnInt1.setSelected(true);
                    break;
                }
                case INT2LE: {
                    this.btnInt2.setSelected(true);
                    this.btnLE.setSelected(true);
                    break;
                }
                case INT2BE: {
                    this.btnInt2.setSelected(true);
                    this.btnBE.setSelected(true);
                    break;
                }
                case INT3LE: {
                    this.btnInt3.setSelected(true);
                    this.btnLE.setSelected(true);
                    break;
                }
                case INT3BE: {
                    this.btnInt3.setSelected(true);
                    this.btnBE.setSelected(true);
                    break;
                }
                case INT4LE: {
                    this.btnInt4.setSelected(true);
                    this.btnLE.setSelected(true);
                    break;
                }
                case INT4BE: {
                    this.btnInt4.setSelected(true);
                    this.btnBE.setSelected(true);
                    break;
                }
                case INT8LE: {
                    this.btnInt8.setSelected(true);
                    this.btnLE.setSelected(true);
                    break;
                }
                case INT8BE: {
                    this.btnInt8.setSelected(true);
                    this.btnBE.setSelected(true);
                    break;
                }
                case FLOAT4LE: {
                    this.btnFloat4.setSelected(true);
                    this.btnLE.setSelected(true);
                    break;
                }
                case FLOAT4BE: {
                    this.btnFloat4.setSelected(true);
                    this.btnBE.setSelected(true);
                    break;
                }
                case FLOAT8LE: {
                    this.btnFloat8.setSelected(true);
                    this.btnLE.setSelected(true);
                    break;
                }
                case FLOAT8BE: {
                    this.btnFloat8.setSelected(true);
                    this.btnBE.setSelected(true);
                    break;
                }
                case BYTE_ARRAY: {
                    this.btnByteArray.setSelected(true);
                    break;
                }
                case POINTER: {
                    this.btnPointer.setSelected(true);
                }
            }
            this.spinnerSize.setValue(varData.getSize());
        }
        this.updFieldsEnabled();
        this.fldName.addActionListener(this);
        this.fldAddr.addActionListener(this);
        this.btnInt1.addActionListener(this);
        this.btnInt2.addActionListener(this);
        this.btnInt3.addActionListener(this);
        this.btnInt4.addActionListener(this);
        this.btnInt8.addActionListener(this);
        this.btnFloat4.addActionListener(this);
        this.btnFloat8.addActionListener(this);
        this.btnByteArray.addActionListener(this);
        this.btnPointer.addActionListener(this);
        this.btnLE.addActionListener(this);
        this.btnBE.addActionListener(this);
        this.btnOK.addActionListener(this);
        this.btnCancel.addActionListener(this);
        this.pack();
        this.setParentCentered();
    }

    private void doApply() {
        try {
            int n;
            Object object;
            Object object2;
            String string = this.fldName.getText();
            if (string != null && string.isEmpty()) {
                string = null;
            }
            if (string != null && (object2 = this.debugFrm.getVarByName(string)) != null && (this.varData == null || object2 != this.varData)) {
                this.debugFrm.selectVar((VarData)object2);
                throw new UserInputException("Eine Variable mit dem Namen existiert bereits.");
            }
            object2 = VarData.VarType.BYTE_ARRAY;
            int n2 = 0;
            boolean bl = this.btnLE.isSelected();
            if (this.btnInt1.isSelected()) {
                object2 = VarData.VarType.INT1;
                n2 = 1;
            } else if (this.btnInt2.isSelected()) {
                object2 = bl ? VarData.VarType.INT2LE : VarData.VarType.INT2BE;
                n2 = 2;
            } else if (this.btnInt3.isSelected()) {
                object2 = bl ? VarData.VarType.INT3LE : VarData.VarType.INT3BE;
                n2 = 3;
            } else if (this.btnInt4.isSelected()) {
                object2 = bl ? VarData.VarType.INT4LE : VarData.VarType.INT4BE;
                n2 = 4;
            } else if (this.btnInt8.isSelected()) {
                object2 = bl ? VarData.VarType.INT8LE : VarData.VarType.INT8BE;
                n2 = 8;
            } else if (this.btnFloat4.isSelected()) {
                object2 = bl ? VarData.VarType.FLOAT4LE : VarData.VarType.FLOAT4BE;
                n2 = 4;
            } else if (this.btnFloat8.isSelected()) {
                object2 = bl ? VarData.VarType.FLOAT8LE : VarData.VarType.FLOAT8BE;
                n2 = 8;
            } else if (this.btnPointer.isSelected()) {
                object2 = VarData.VarType.POINTER;
                n2 = 2;
            } else {
                object = this.spinnerSize.getValue();
                if (object != null && object instanceof Number && (n = ((Number)object).intValue()) > 0) {
                    n2 = n;
                }
            }
            if (n2 < 1) {
                throw new UserInputException("Ung\u00fcltige Variablengr\u00f6\u00dfe (Anzahl Bytes)");
            }
            object = this.varData;
            if (this.varData != null) {
                n = this.docAddr.intValue();
                this.varData.setValues(string, n, (VarData.VarType)((Object)object2), n2, this.varData.wasImported() && n == this.varData.getAddress() && string.equalsIgnoreCase(this.varData.getName()));
            } else {
                this.varData = new VarData(string, this.docAddr.intValue(), (VarData.VarType)((Object)object2), n2, false);
            }
            this.appliedVarData = this.varData;
            this.doClose();
        }
        catch (NumberFormatException numberFormatException) {
            VarDataDlg.showErrorDlg((Component)this, "Ung\u00fcltige Variablenadresse");
        }
        catch (UserInputException userInputException) {
            VarDataDlg.showErrorDlg((Component)this, userInputException);
        }
    }

    private void updFieldsEnabled() {
        boolean bl = this.btnByteArray.isSelected();
        this.labelSize.setEnabled(bl);
        this.spinnerSize.setEnabled(bl);
        bl = this.btnInt2.isSelected() || this.btnInt3.isSelected() || this.btnInt4.isSelected() || this.btnInt8.isSelected() || this.btnFloat4.isSelected() || this.btnFloat8.isSelected();
        this.labelByteOrder.setEnabled(bl);
        this.btnLE.setEnabled(bl);
        this.btnBE.setEnabled(bl);
    }
}

