/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.tools.debugger;

import jkcemu.tools.debugger.AbstractBreakpoint;
import jkcemu.tools.debugger.DebugFrm;
import z80emu.Z80CPU;
import z80emu.Z80InterruptSource;

public class PCBreakpoint
extends AbstractBreakpoint {
    private int addr;
    private String reg;
    private int mask;
    private String cond;
    private int value;
    private boolean imported;

    public PCBreakpoint(DebugFrm debugFrm, int n, String string, int n2, String string2, int n3, boolean bl) {
        super(debugFrm);
        this.addr = n & 0xFFFF;
        this.imported = bl;
        this.setConditionValues(string, n2, string2, n3);
    }

    public int getAddress() {
        return this.addr;
    }

    public String getCondition() {
        return this.cond;
    }

    public int getMask() {
        return this.mask;
    }

    public String getRegister() {
        return this.reg;
    }

    public int getValue() {
        return this.value;
    }

    public void setConditionValues(String string, int n, String string2, int n2) {
        this.reg = string;
        this.mask = n & 0xFFFF;
        this.cond = string2;
        this.value = n2 & 0xFFFF;
        String string3 = String.format("%04X", this.addr);
        if (this.reg != null && this.cond != null && !this.reg.isEmpty() && !this.cond.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder(32);
            stringBuilder.append(string3);
            stringBuilder.append(':');
            if (string.length() == 2) {
                if ((this.mask & 0xFFFF) != 65535) {
                    stringBuilder.append(String.format("(%s&%04X)", this.reg, this.mask));
                } else {
                    stringBuilder.append(string);
                }
                stringBuilder.append(this.cond);
                stringBuilder.append(String.format("%04X", this.value));
            } else {
                if ((this.mask & 0xFF) != 255) {
                    stringBuilder.append(String.format("(%s&%02X)", this.reg, this.mask));
                } else {
                    stringBuilder.append(string);
                }
                stringBuilder.append(this.cond);
                stringBuilder.append(String.format("%02X", this.value));
            }
            string3 = stringBuilder.toString();
        }
        this.setText(string3);
    }

    public boolean wasImported() {
        return this.imported;
    }

    @Override
    protected boolean matchesImpl(Z80CPU z80CPU, Z80InterruptSource z80InterruptSource) {
        boolean bl;
        boolean bl2 = bl = z80CPU.getRegPC() == this.addr;
        if (bl && this.reg != null && this.cond != null) {
            int n = -1;
            int n2 = -1;
            if (this.reg.equals("A")) {
                n = z80CPU.getRegA();
            } else if (this.reg.equals("B")) {
                n = z80CPU.getRegB();
            } else if (this.reg.equals("C")) {
                n = z80CPU.getRegC();
            } else if (this.reg.equals("D")) {
                n = z80CPU.getRegD();
            } else if (this.reg.equals("E")) {
                n = z80CPU.getRegE();
            } else if (this.reg.equals("H")) {
                n = z80CPU.getRegH();
            } else if (this.reg.equals("L")) {
                n = z80CPU.getRegL();
            } else if (this.reg.equals("BC")) {
                n2 = z80CPU.getRegBC();
            } else if (this.reg.equals("DE")) {
                n2 = z80CPU.getRegDE();
            } else if (this.reg.equals("HL")) {
                n2 = z80CPU.getRegHL();
            } else if (this.reg.equals("IX")) {
                n2 = z80CPU.getRegIX();
            } else if (this.reg.equals("IXH")) {
                n = z80CPU.getRegIX() >> 8;
            } else if (this.reg.equals("IXL")) {
                n = z80CPU.getRegIX() & 0xFF;
            } else if (this.reg.equals("IY")) {
                n2 = z80CPU.getRegIY();
            } else if (this.reg.equals("IYH")) {
                n = z80CPU.getRegIY() >> 8;
            } else if (this.reg.equals("IYL")) {
                n = z80CPU.getRegIY() & 0xFF;
            } else if (this.reg.equals("SP")) {
                n2 = z80CPU.getRegSP();
            }
            if (n >= 0 || n2 >= 0) {
                int n3 = 0;
                int n4 = 0;
                if (n >= 0) {
                    n3 = n & this.mask & 0xFF;
                    n4 = this.value & 0xFF;
                } else {
                    n3 = n2 & this.mask & 0xFFFF;
                    n4 = this.value & 0xFFFF;
                }
                bl = PCBreakpoint.checkValues(n3, this.cond, n4);
            }
        }
        return bl;
    }
}

