/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.tools.debugger;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.WindowEvent;
import java.util.EventObject;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import jkcemu.base.HexDocument;
import jkcemu.tools.debugger.AbstractBreakpoint;
import jkcemu.tools.debugger.AbstractBreakpointDlg;
import jkcemu.tools.debugger.DebugFrm;
import jkcemu.tools.debugger.MemoryBreakpoint;

public class MemoryBreakpointDlg
extends AbstractBreakpointDlg {
    private HexDocument docBegAddr;
    private HexDocument docEndAddr;
    private HexDocument docMask;
    private HexDocument docValue;
    private JCheckBox btnOnRead;
    private JCheckBox btnOnWrite;
    private JCheckBox btnCheckValue;
    private JLabel labelValue1;
    private JLabel labelValue2;
    private JComboBox<String> comboCond;
    private JTextField fldBegAddr;
    private JTextField fldEndAddr;
    private JTextField fldMask;
    private JTextField fldValue;

    public MemoryBreakpointDlg(DebugFrm debugFrm, AbstractBreakpoint abstractBreakpoint) {
        super(debugFrm, "Speicherbereich", abstractBreakpoint);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 5), 0, 0);
        this.add((Component)new JLabel("Adresse/Anfangsadresse:"), gridBagConstraints);
        this.docBegAddr = new HexDocument(4);
        this.fldBegAddr = new JTextField(this.docBegAddr, "", 0);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 2;
        ++gridBagConstraints.gridx;
        this.add((Component)this.fldBegAddr, gridBagConstraints);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        this.add((Component)new JLabel("Endadresse (optional):"), gridBagConstraints);
        this.docEndAddr = new HexDocument(4);
        this.fldEndAddr = new JTextField(this.docEndAddr, "", 0);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 2;
        ++gridBagConstraints.gridx;
        this.add((Component)this.fldEndAddr, gridBagConstraints);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets.bottom = 5;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        this.add((Component)new JLabel("Anhalten/Loggen beim:"), gridBagConstraints);
        this.btnOnRead = new JCheckBox("Lesen", true);
        gridBagConstraints.anchor = 17;
        ++gridBagConstraints.gridx;
        this.add((Component)this.btnOnRead, gridBagConstraints);
        this.btnOnWrite = new JCheckBox("Schreiben", true);
        ++gridBagConstraints.gridx;
        this.add((Component)this.btnOnWrite, gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets.top = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        this.add((Component)new JSeparator(), gridBagConstraints);
        this.btnCheckValue = new JCheckBox("Zus\u00e4tzlich Wert der Speicherzelle bzw. zu schreibenden Wert pr\u00fcfen", false);
        gridBagConstraints.insets.bottom = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        ++gridBagConstraints.gridy;
        this.add((Component)this.btnCheckValue, gridBagConstraints);
        JPanel jPanel = new JPanel(new GridBagLayout());
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets.left = 50;
        ++gridBagConstraints.gridy;
        this.add((Component)jPanel, gridBagConstraints);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0);
        this.labelValue1 = new JLabel("Nur anhalten/loggen wenn Wert UND");
        jPanel.add((Component)this.labelValue1, gridBagConstraints2);
        this.docMask = new HexDocument(2);
        this.fldMask = new JTextField(this.docMask, "", 2);
        this.fldMask.setToolTipText("Maske");
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.weightx = 0.5;
        gridBagConstraints2.insets.left = 5;
        ++gridBagConstraints2.gridx;
        jPanel.add((Component)this.fldMask, gridBagConstraints2);
        this.comboCond = new JComboBox<String>(conditions);
        this.comboCond.setEditable(false);
        gridBagConstraints2.fill = 0;
        gridBagConstraints2.weightx = 0.0;
        ++gridBagConstraints2.gridx;
        jPanel.add(this.comboCond, gridBagConstraints2);
        this.docValue = new HexDocument(2);
        this.fldValue = new JTextField(this.docValue, "", 2);
        this.fldValue.setToolTipText("Vergleichswert");
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.weightx = 0.5;
        ++gridBagConstraints2.gridx;
        jPanel.add((Component)this.fldValue, gridBagConstraints2);
        this.labelValue2 = new JLabel("ist.");
        gridBagConstraints2.fill = 0;
        gridBagConstraints2.weightx = 0.0;
        ++gridBagConstraints2.gridx;
        jPanel.add((Component)this.labelValue2, gridBagConstraints2);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets.top = 10;
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        this.add((Component)new JSeparator(), gridBagConstraints);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets.top = 5;
        ++gridBagConstraints.gridy;
        this.add((Component)this.createGeneralButtons(), gridBagConstraints);
        boolean bl = false;
        String string = null;
        int n = 255;
        int n2 = 0;
        if (abstractBreakpoint != null && abstractBreakpoint instanceof MemoryBreakpoint) {
            MemoryBreakpoint memoryBreakpoint = (MemoryBreakpoint)abstractBreakpoint;
            this.docBegAddr.setValue(memoryBreakpoint.getBegAddress(), 4);
            int n3 = memoryBreakpoint.getEndAddress();
            if (n3 >= 0) {
                this.docEndAddr.setValue(n3, 4);
            }
            this.btnOnRead.setSelected(memoryBreakpoint.getOnRead());
            this.btnOnWrite.setSelected(memoryBreakpoint.getOnWrite());
            n = memoryBreakpoint.getMask();
            string = memoryBreakpoint.getCondition();
            n2 = memoryBreakpoint.getValue();
            if (string != null) {
                bl = true;
            }
        }
        this.docMask.setValue(n, 2);
        this.comboCond.setSelectedItem(string != null ? string : "=");
        this.docValue.setValue(n2, 2);
        this.btnCheckValue.setSelected(bl);
        this.updCheckValueFieldsEnabled();
        this.pack();
        this.setParentCentered();
        this.setResizable(true);
        this.fldMask.setColumns(0);
        this.fldValue.setColumns(0);
        this.fldBegAddr.addActionListener(this);
        this.fldEndAddr.addActionListener(this);
        this.btnOnRead.addActionListener(this);
        this.btnOnWrite.addActionListener(this);
        this.btnCheckValue.addActionListener(this);
        this.fldMask.addActionListener(this);
        this.fldValue.addActionListener(this);
    }

    @Override
    protected boolean doAction(EventObject eventObject) {
        Object object;
        boolean bl = false;
        if (eventObject != null && (object = eventObject.getSource()) != null) {
            if (object == this.btnCheckValue) {
                bl = true;
                this.updCheckValueFieldsEnabled();
            } else if (object == this.fldBegAddr) {
                bl = true;
                this.fldEndAddr.requestFocus();
            } else if (object == this.fldEndAddr || object == this.fldValue) {
                bl = true;
                this.doApprove();
            } else if (object == this.btnOnRead || object == this.btnOnWrite) {
                bl = true;
                if (!this.btnOnRead.isSelected() && !this.btnOnWrite.isSelected()) {
                    if (object == this.btnOnRead) {
                        this.btnOnWrite.setSelected(true);
                    } else {
                        this.btnOnRead.setSelected(true);
                    }
                }
            } else if (object == this.fldMask) {
                bl = true;
                this.comboCond.requestFocus();
            }
        }
        if (!bl) {
            bl = super.doAction(eventObject);
        }
        return bl;
    }

    @Override
    protected void doApprove() {
        String string = "Anfangsadresse";
        try {
            boolean bl = true;
            int n = this.docBegAddr.intValue();
            int n2 = -1;
            Integer n3 = this.docEndAddr.getInteger();
            if (n3 != null) {
                n2 = n3 & 0xFFFF;
            }
            String string2 = null;
            int n4 = 255;
            int n5 = 0;
            if (this.btnCheckValue.isSelected()) {
                Object object = this.comboCond.getSelectedItem();
                if (object != null) {
                    string2 = object.toString();
                }
                if (string2 != null) {
                    string = "Maske";
                    n4 = this.docMask.intValue() & 0xFF;
                    string = "Vergleichswert";
                    n5 = this.docValue.intValue() & 0xFF;
                    bl = this.checkMaskValue(true, n4, n5);
                }
            }
            if (bl) {
                this.approveBreakpoint(new MemoryBreakpoint(this.debugFrm, n, n2, this.btnOnRead.isSelected(), this.btnOnWrite.isSelected(), n4, string2, n5));
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.showInvalidFmt(string);
        }
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
        if (this.fldBegAddr != null) {
            this.fldBegAddr.requestFocus();
        }
    }

    private void updCheckValueFieldsEnabled() {
        boolean bl = this.btnCheckValue.isSelected();
        this.labelValue1.setEnabled(bl);
        this.labelValue2.setEnabled(bl);
        this.fldMask.setEnabled(bl);
        this.comboCond.setEnabled(bl);
        this.fldValue.setEnabled(bl);
    }
}

