/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.tools.debugger;

import jkcemu.tools.debugger.AbstractBreakpoint;
import jkcemu.tools.debugger.DebugFrm;
import z80emu.Z80CPU;
import z80emu.Z80InterruptSource;

public class MemoryBreakpoint
extends AbstractBreakpoint {
    private static int[] instLen = new int[]{1, 3, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 2, 1, 2, 3, 1, 1, 1, 1, 2, 1, 2, 1, 1, 1, 1, 1, 2, 1, 2, 3, 3, 1, 1, 1, 2, 1, 2, 1, 3, 1, 1, 1, 2, 1, 2, 3, 3, 1, 1, 1, 2, 1, 2, 1, 3, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 1, 2, 1, 1, 1, 3, 2, 3, 3, 2, 1, 1, 1, 3, 2, 3, 1, 2, 1, 1, 1, 3, 2, 3, 0, 2, 1, 1, 1, 3, 1, 3, 1, 2, 1, 1, 1, 3, 1, 3, 0, 2, 1, 1, 1, 3, 1, 3, 1, 2, 1, 1, 1, 3, 1, 3, 0, 2, 1};
    private static int[] instLenDD_FD = new int[]{2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 4, 4, 2, 2, 2, 3, 2, 2, 2, 4, 2, 2, 2, 3, 2, 2, 2, 2, 2, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 2, 2, 2, 2, 2, 2, 2, 3, 2, 2, 2, 2, 2, 2, 2, 3, 2, 2, 2, 2, 2, 2, 2, 3, 2, 2, 2, 2, 2, 2, 2, 3, 2, 2, 2, 2, 2, 2, 2, 3, 2, 3, 3, 3, 3, 3, 3, 2, 3, 2, 2, 2, 2, 2, 2, 3, 2, 2, 2, 2, 2, 2, 2, 3, 2, 2, 2, 2, 2, 2, 2, 3, 2, 2, 2, 2, 2, 2, 2, 3, 2, 2, 2, 2, 2, 2, 2, 3, 2, 2, 2, 2, 2, 2, 2, 3, 2, 2, 2, 2, 2, 2, 2, 3, 2, 2, 2, 2, 2, 2, 2, 3, 2, 2, 2, 2, 2, 2, 2, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 4, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2};
    private static int[] instLenED = new int[]{2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 4, 2, 2, 2, 2, 2, 2, 2, 4, 2, 2, 2, 2, 2, 2, 2, 4, 2, 2, 2, 2, 2, 2, 2, 4, 2, 2, 2, 2, 2, 2, 2, 4, 2, 2, 2, 2, 2, 2, 2, 4, 2, 2, 2, 2, 2, 2, 2, 4, 2, 2, 2, 2, 2, 2, 2, 4, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2};
    private int begAddr;
    private int endAddr;
    private boolean onRead;
    private boolean onWrite;
    private int mask;
    private String cond;
    private int value;

    public MemoryBreakpoint(DebugFrm debugFrm, int n, int n2, boolean bl, boolean bl2, int n3, String string, int n4) {
        super(debugFrm);
        this.begAddr = n & 0xFFFF;
        this.endAddr = n2 >= 0 ? n2 & 0xFFFF : -1;
        this.onRead = bl;
        this.onWrite = bl2;
        this.mask = n3 & 0xFF;
        this.cond = string;
        this.value = n4 & 0xFF;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(String.format("%04X", this.begAddr));
        if (this.endAddr >= 0) {
            stringBuilder.append(String.format("-%04X", this.endAddr));
        }
        stringBuilder.append(':');
        if (this.onRead) {
            stringBuilder.append('R');
        }
        if (this.onWrite) {
            stringBuilder.append('W');
        }
        if (this.cond != null) {
            if (this.mask != 255) {
                stringBuilder.append(String.format(":(Wert&%02X)%s%02X", this.mask, this.cond, this.value));
            } else {
                stringBuilder.append(String.format(":Wert%s%02X", this.cond, this.value));
            }
        }
        this.setText(stringBuilder.toString());
    }

    public int getBegAddress() {
        return this.begAddr;
    }

    public String getCondition() {
        return this.cond;
    }

    public int getEndAddress() {
        return this.endAddr;
    }

    public int getMask() {
        return this.mask;
    }

    public boolean getOnRead() {
        return this.onRead;
    }

    public boolean getOnWrite() {
        return this.onWrite;
    }

    public int getValue() {
        return this.value;
    }

    @Override
    protected boolean matchesImpl(Z80CPU z80CPU, Z80InterruptSource z80InterruptSource) {
        boolean bl = false;
        int n = z80CPU.getRegPC();
        int n2 = z80CPU.getMemByte(n, false);
        int n3 = z80CPU.getMemByte(n + 1, false);
        int n4 = z80CPU.getMemByte(n + 2, false);
        int n5 = z80CPU.getMemByte(n + 3, false);
        if (this.onRead) {
            bl = this.matchesRead(z80CPU, n, n2, n3, n4, n5);
        }
        if (!bl && this.onWrite) {
            bl = this.matchesWrite(z80CPU, z80InterruptSource, n, n2, n3, n4, n5);
        }
        return bl;
    }

    private static int computeRelAddr(int n, int n2) {
        return n + (byte)n2 & 0xFFFF;
    }

    private static int getBitInstValue(Z80CPU z80CPU, int n, int n2) {
        int n3 = -1;
        switch (n & 0xF8) {
            case 0: {
                n3 = n2 << 1 & 0xFE;
                if ((n2 & 0x80) == 0) break;
                n3 |= 1;
                break;
            }
            case 8: {
                n3 = n2 >> 1 & 0x7F;
                if ((n2 & 1) == 0) break;
                n3 |= 0x80;
                break;
            }
            case 16: {
                n3 = n2 << 1 & 0xFE;
                if (!z80CPU.getFlagCarry()) break;
                n3 |= 1;
                break;
            }
            case 24: {
                n3 = n2 >> 1 & 0x7F;
                if (!z80CPU.getFlagCarry()) break;
                n3 |= 0x80;
                break;
            }
            case 32: {
                n3 = n2 << 1 & 0xFE;
                break;
            }
            case 40: {
                n3 = n2 >> 1 & 0x7F | n2 & 0x80;
                break;
            }
            case 48: {
                n3 = n2 << 1 & 0xFE | 1;
                break;
            }
            case 56: {
                n3 = n2 >> 1 & 0x7F;
                break;
            }
            case 128: {
                n3 = n2 & 0xFE;
                break;
            }
            case 136: {
                n3 = n2 & 0xFD;
                break;
            }
            case 144: {
                n3 = n2 & 0xFB;
                break;
            }
            case 152: {
                n3 = n2 & 0xF7;
                break;
            }
            case 160: {
                n3 = n2 & 0xEF;
                break;
            }
            case 168: {
                n3 = n2 & 0xDF;
                break;
            }
            case 176: {
                n3 = n2 & 0xBF;
                break;
            }
            case 184: {
                n3 = n2 & 0x7F;
                break;
            }
            case 192: {
                n3 = n2 | 1;
                break;
            }
            case 200: {
                n3 = n2 | 2;
                break;
            }
            case 208: {
                n3 = n2 | 4;
                break;
            }
            case 216: {
                n3 = n2 | 8;
                break;
            }
            case 224: {
                n3 = n2 | 0x10;
                break;
            }
            case 232: {
                n3 = n2 | 0x20;
                break;
            }
            case 240: {
                n3 = n2 | 0x40;
                break;
            }
            case 248: {
                n3 = n2 | 0x80;
            }
        }
        return n3;
    }

    private boolean matchesRead(Z80CPU z80CPU, int n, int n2, int n3, int n4, int n5) {
        boolean bl;
        block33: {
            int n6;
            int n7;
            block34: {
                int n8;
                bl = false;
                int n9 = 0;
                if (n2 == 221 || n2 == 253) {
                    if (n3 >= 0 && n3 < instLenDD_FD.length) {
                        n9 = instLenDD_FD[n3];
                    }
                } else if (n2 == 237) {
                    if (n3 >= 0 && n3 < instLenED.length) {
                        n9 = instLenED[n3];
                    }
                } else if (n2 >= 0 && n3 < instLen.length) {
                    n9 = instLen[n2];
                }
                if ((n8 = n + n9) > 65536) {
                    n8 = 65536;
                }
                for (n7 = n; n7 < n8; ++n7) {
                    if (!this.matchesReadAccess(n7, z80CPU)) continue;
                    bl = true;
                    break;
                }
                if (bl) break block33;
                n7 = -1;
                n6 = -1;
                block0 : switch (n2) {
                    case 10: {
                        n7 = z80CPU.getRegBC();
                        break;
                    }
                    case 26: {
                        n7 = z80CPU.getRegDE();
                        break;
                    }
                    case 42: {
                        n7 = n4 << 8 | n3;
                        n6 = n7 + 1 & 0xFFFF;
                        break;
                    }
                    case 52: 
                    case 53: 
                    case 70: 
                    case 78: 
                    case 86: 
                    case 94: 
                    case 102: 
                    case 110: 
                    case 126: 
                    case 134: 
                    case 142: 
                    case 150: 
                    case 158: 
                    case 166: 
                    case 174: 
                    case 182: 
                    case 190: {
                        n7 = z80CPU.getRegHL();
                        break;
                    }
                    case 58: {
                        n7 = n4 << 8 | n3;
                        break;
                    }
                    case 192: 
                    case 193: 
                    case 200: 
                    case 201: 
                    case 208: 
                    case 209: 
                    case 216: 
                    case 224: 
                    case 225: 
                    case 232: 
                    case 235: 
                    case 240: 
                    case 241: 
                    case 248: {
                        n7 = z80CPU.getRegSP();
                        n6 = n7 + 1 & 0xFFFF;
                        break;
                    }
                    case 203: {
                        if (n3 >= 128 || (n3 & 7) != 6) break;
                        n7 = z80CPU.getRegHL();
                        break;
                    }
                    case 237: {
                        switch (n3) {
                            case 75: 
                            case 91: 
                            case 107: 
                            case 123: {
                                n7 = n5 << 8 | n4;
                                n6 = n7 + 1 & 0xFFFF;
                                break;
                            }
                            case 69: 
                            case 77: 
                            case 85: 
                            case 93: 
                            case 101: 
                            case 109: 
                            case 117: 
                            case 125: {
                                n7 = z80CPU.getRegSP();
                                n6 = n7 + 1 & 0xFFFF;
                                break;
                            }
                            case 103: 
                            case 111: 
                            case 160: 
                            case 161: 
                            case 163: 
                            case 168: 
                            case 169: 
                            case 171: 
                            case 176: 
                            case 177: 
                            case 179: 
                            case 184: 
                            case 185: 
                            case 187: {
                                n7 = z80CPU.getRegHL();
                            }
                        }
                        break;
                    }
                    case 221: 
                    case 253: {
                        int n10 = n2 == 221 ? z80CPU.getRegIX() : z80CPU.getRegIY();
                        switch (n3) {
                            case 52: 
                            case 53: 
                            case 70: 
                            case 78: 
                            case 86: 
                            case 94: 
                            case 102: 
                            case 110: 
                            case 126: 
                            case 134: 
                            case 142: 
                            case 150: 
                            case 158: 
                            case 166: 
                            case 174: 
                            case 182: 
                            case 190: {
                                n7 = MemoryBreakpoint.computeRelAddr(n10, n4);
                                break block0;
                            }
                            case 203: {
                                if (n5 < 128) {
                                    n7 = MemoryBreakpoint.computeRelAddr(n10, n4);
                                    break block0;
                                }
                                break block34;
                            }
                            case 225: 
                            case 235: {
                                n7 = z80CPU.getRegSP();
                                n6 = n7 + 1 & 0xFFFF;
                            }
                        }
                    }
                }
            }
            if (n7 >= 0) {
                bl = this.matchesReadAccess(n7, z80CPU);
            }
            if (!bl && n6 >= 0) {
                bl = this.matchesReadAccess(n6, z80CPU);
            }
        }
        return bl;
    }

    private boolean matchesReadAccess(int n, Z80CPU z80CPU) {
        boolean bl = false;
        if (n == this.begAddr || n >= this.begAddr && n <= this.endAddr) {
            bl = this.cond != null ? MemoryBreakpoint.checkValues(z80CPU.getMemByte(n, false) & this.mask, this.cond, this.value) : true;
        }
        return bl;
    }

    private boolean matchesWrite(Z80CPU z80CPU, Z80InterruptSource z80InterruptSource, int n, int n2, int n3, int n4, int n5) {
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        boolean bl;
        block56: {
            bl = false;
            n10 = -1;
            n9 = -1;
            n8 = -1;
            n7 = -1;
            block0 : switch (n2) {
                case 2: {
                    n10 = z80CPU.getRegBC();
                    n8 = z80CPU.getRegA();
                    break;
                }
                case 18: {
                    n10 = z80CPU.getRegDE();
                    n8 = z80CPU.getRegA();
                    break;
                }
                case 34: {
                    n10 = n4 << 8 | n3;
                    n9 = n10 + 1 & 0xFFFF;
                    n8 = z80CPU.getRegL();
                    n7 = z80CPU.getRegH();
                    break;
                }
                case 50: {
                    n10 = n4 << 8 | n3;
                    n8 = z80CPU.getRegA();
                    break;
                }
                case 52: {
                    n10 = z80CPU.getRegHL();
                    n8 = z80CPU.getMemByte(n10, false) + 1 & 0xFF;
                    break;
                }
                case 53: {
                    n10 = z80CPU.getRegHL();
                    n8 = z80CPU.getMemByte(n10, false) - 1 & 0xFF;
                    break;
                }
                case 54: {
                    n10 = z80CPU.getRegHL();
                    n8 = n3;
                    break;
                }
                case 112: {
                    n10 = z80CPU.getRegHL();
                    n8 = z80CPU.getRegB();
                    break;
                }
                case 113: {
                    n10 = z80CPU.getRegHL();
                    n8 = z80CPU.getRegC();
                    break;
                }
                case 114: {
                    n10 = z80CPU.getRegHL();
                    n8 = z80CPU.getRegC();
                    break;
                }
                case 115: {
                    n10 = z80CPU.getRegHL();
                    n8 = z80CPU.getRegE();
                    break;
                }
                case 116: {
                    n10 = z80CPU.getRegHL();
                    n8 = z80CPU.getRegH();
                    break;
                }
                case 117: {
                    n10 = z80CPU.getRegHL();
                    n8 = z80CPU.getRegL();
                    break;
                }
                case 119: {
                    n10 = z80CPU.getRegHL();
                    n8 = z80CPU.getRegA();
                    break;
                }
                case 196: 
                case 204: 
                case 205: 
                case 212: 
                case 220: 
                case 228: 
                case 236: 
                case 244: 
                case 252: {
                    n10 = z80CPU.getRegSP() - 2 & 0xFFFF;
                    n9 = z80CPU.getRegSP() - 1 & 0xFFFF;
                    n8 = n + 3 & 0xFF;
                    n7 = n + 3 >> 8 & 0xFF;
                    break;
                }
                case 197: {
                    n10 = z80CPU.getRegSP() - 2 & 0xFFFF;
                    n9 = z80CPU.getRegSP() - 1 & 0xFFFF;
                    n8 = z80CPU.getRegC();
                    n7 = z80CPU.getRegB();
                    break;
                }
                case 213: {
                    n10 = z80CPU.getRegSP() - 2 & 0xFFFF;
                    n9 = z80CPU.getRegSP() - 1 & 0xFFFF;
                    n8 = z80CPU.getRegE();
                    n7 = z80CPU.getRegD();
                    break;
                }
                case 229: {
                    n10 = z80CPU.getRegSP() - 2 & 0xFFFF;
                    n9 = z80CPU.getRegSP() - 1 & 0xFFFF;
                    n8 = z80CPU.getRegL();
                    n7 = z80CPU.getRegH();
                    break;
                }
                case 245: {
                    n10 = z80CPU.getRegSP() - 2 & 0xFFFF;
                    n9 = z80CPU.getRegSP() - 1 & 0xFFFF;
                    n8 = z80CPU.getRegF();
                    n7 = z80CPU.getRegA();
                    break;
                }
                case 199: 
                case 207: 
                case 215: 
                case 223: 
                case 231: 
                case 239: 
                case 247: 
                case 255: {
                    n10 = z80CPU.getRegSP() - 2 & 0xFFFF;
                    n9 = z80CPU.getRegSP() - 1 & 0xFFFF;
                    n8 = n + 1 & 0xFF;
                    n7 = n + 1 >> 8 & 0xFF;
                    break;
                }
                case 203: {
                    if (n3 >= 64 && n3 < 128 || (n3 & 7) != 6) break;
                    n10 = z80CPU.getRegHL();
                    n8 = MemoryBreakpoint.getBitInstValue(z80CPU, n3, z80CPU.getMemByte(n10, false));
                    break;
                }
                case 227: {
                    n10 = z80CPU.getRegSP();
                    n9 = n10 + 1 & 0xFFFF;
                    n8 = z80CPU.getRegL();
                    n7 = z80CPU.getRegH();
                    break;
                }
                case 237: {
                    switch (n3) {
                        case 67: {
                            n10 = n5 << 8 | n4;
                            n9 = n10 + 1 & 0xFFFF;
                            n8 = z80CPU.getRegC();
                            n7 = z80CPU.getRegB();
                            break;
                        }
                        case 83: {
                            n10 = n5 << 8 | n4;
                            n9 = n10 + 1 & 0xFFFF;
                            n8 = z80CPU.getRegE();
                            n7 = z80CPU.getRegD();
                            break;
                        }
                        case 99: {
                            n10 = n5 << 8 | n4;
                            n9 = n10 + 1 & 0xFFFF;
                            n8 = z80CPU.getRegL();
                            n7 = z80CPU.getRegH();
                            break;
                        }
                        case 103: {
                            n10 = z80CPU.getRegHL();
                            n8 = z80CPU.getMemByte(n10, false) >> 4 | z80CPU.getRegA() << 4 & 0xF0;
                            break;
                        }
                        case 111: {
                            n10 = z80CPU.getRegHL();
                            n8 = z80CPU.getMemByte(n10, false) << 4 | z80CPU.getRegA() & 0xF;
                            break;
                        }
                        case 115: {
                            n10 = n5 << 8 | n4;
                            n9 = n10 + 1 & 0xFFFF;
                            n8 = z80CPU.getRegSP() & 0xFF;
                            n7 = z80CPU.getRegSP() >> 8 & 0xFF;
                            break;
                        }
                        case 160: 
                        case 168: 
                        case 176: 
                        case 184: {
                            n10 = z80CPU.getRegDE();
                            n8 = z80CPU.getMemByte(z80CPU.getRegHL(), false);
                            break;
                        }
                        case 162: 
                        case 170: 
                        case 178: 
                        case 186: {
                            n10 = z80CPU.getRegHL();
                        }
                    }
                    break;
                }
                case 221: 
                case 253: {
                    n6 = n2 == 221 ? z80CPU.getRegIX() : z80CPU.getRegIY();
                    switch (n3) {
                        case 34: {
                            n10 = n5 << 8 | n4;
                            n9 = n10 + 1 & 0xFFFF;
                            n8 = n6 & 0xFF;
                            n7 = n6 >> 8 & 0xFF;
                            break block0;
                        }
                        case 52: {
                            n10 = MemoryBreakpoint.computeRelAddr(n6, n4);
                            n8 = z80CPU.getMemByte(n10, false) + 1 & 0xFF;
                            break block0;
                        }
                        case 53: {
                            n10 = MemoryBreakpoint.computeRelAddr(n6, n4);
                            n8 = z80CPU.getMemByte(n10, false) - 1 & 0xFF;
                            break block0;
                        }
                        case 54: {
                            n10 = MemoryBreakpoint.computeRelAddr(n6, n4);
                            n8 = n5;
                            break block0;
                        }
                        case 112: {
                            n10 = MemoryBreakpoint.computeRelAddr(n6, n4);
                            n8 = z80CPU.getRegB();
                            break block0;
                        }
                        case 113: {
                            n10 = MemoryBreakpoint.computeRelAddr(n6, n4);
                            n8 = z80CPU.getRegC();
                            break block0;
                        }
                        case 114: {
                            n10 = MemoryBreakpoint.computeRelAddr(n6, n4);
                            n8 = z80CPU.getRegC();
                            break block0;
                        }
                        case 115: {
                            n10 = MemoryBreakpoint.computeRelAddr(n6, n4);
                            n8 = z80CPU.getRegE();
                            break block0;
                        }
                        case 116: {
                            n10 = MemoryBreakpoint.computeRelAddr(n6, n4);
                            n8 = z80CPU.getRegH();
                            break block0;
                        }
                        case 117: {
                            n10 = MemoryBreakpoint.computeRelAddr(n6, n4);
                            n8 = z80CPU.getRegL();
                            break block0;
                        }
                        case 119: {
                            n10 = MemoryBreakpoint.computeRelAddr(n6, n4);
                            n8 = z80CPU.getRegA();
                            break block0;
                        }
                        case 203: {
                            if (n5 < 64 || n5 >= 128) {
                                n10 = MemoryBreakpoint.computeRelAddr(n6, n4);
                                n8 = MemoryBreakpoint.getBitInstValue(z80CPU, n5, z80CPU.getMemByte(n10, false));
                                break block0;
                            }
                            break block56;
                        }
                        case 227: {
                            n10 = z80CPU.getRegSP();
                            n9 = n10 + 1 & 0xFFFF;
                            n8 = n6 & 0xFF;
                            n7 = n6 >> 8 & 0xFF;
                            break block0;
                        }
                        case 229: {
                            n10 = z80CPU.getRegSP() - 2;
                            n9 = n10 + 1 & 0xFFFF;
                            n8 = n6 & 0xFF;
                            n7 = n6 >> 8 & 0xFF;
                        }
                    }
                }
            }
        }
        if (n10 >= 0) {
            bl = this.matchesWriteAccess(n10, n8);
        }
        if (!bl && n9 >= 0) {
            bl = this.matchesWriteAccess(n9, n7);
        }
        if (!bl && z80InterruptSource != null && !(bl = this.matchesWriteAccess(n6 = z80CPU.getRegSP(), z80CPU.getMemByte(n6, false)))) {
            n6 = n6 - 1 & 0xFFFF;
            bl = this.matchesWriteAccess(n6, z80CPU.getMemByte(n6, false));
        }
        return bl;
    }

    private boolean matchesWriteAccess(int n, int n2) {
        boolean bl = false;
        if (n == this.begAddr || n >= this.begAddr && n <= this.endAddr) {
            bl = this.cond != null ? MemoryBreakpoint.checkValues(n2 & this.mask, this.cond, this.value) : true;
        }
        return bl;
    }
}

