/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.tools.debugger;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.WindowEvent;
import java.util.EventObject;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JSeparator;
import jkcemu.tools.debugger.AbstractBreakpoint;
import jkcemu.tools.debugger.AbstractBreakpointDlg;
import jkcemu.tools.debugger.DebugFrm;
import jkcemu.tools.debugger.InterruptBreakpoint;
import z80emu.Z80InterruptSource;

public class InterruptBreakpointDlg
extends AbstractBreakpointDlg {
    private JComboBox<Object> comboIntSource;

    public InterruptBreakpointDlg(DebugFrm debugFrm, AbstractBreakpoint abstractBreakpoint, Z80InterruptSource[] z80InterruptSourceArray) {
        super(debugFrm, "Interrupt-Quelle", abstractBreakpoint);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 5, 5, 5), 0, 0);
        this.comboIntSource = new JComboBox();
        this.comboIntSource.setEditable(false);
        this.comboIntSource.addKeyListener(this);
        this.setInterruptSources(z80InterruptSourceArray);
        this.add(this.comboIntSource, gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        ++gridBagConstraints.gridy;
        this.add((Component)new JSeparator(), gridBagConstraints);
        gridBagConstraints.insets.bottom = 0;
        ++gridBagConstraints.gridy;
        this.add((Component)this.createGeneralButtons(), gridBagConstraints);
        if (abstractBreakpoint != null && abstractBreakpoint instanceof InterruptBreakpoint) {
            this.comboIntSource.setSelectedItem(((InterruptBreakpoint)abstractBreakpoint).getInterruptSource());
        }
        this.pack();
        this.setParentCentered();
        this.setResizable(true);
    }

    public void setInterruptSources(Z80InterruptSource[] z80InterruptSourceArray) {
        if (z80InterruptSourceArray != null && z80InterruptSourceArray.length == 0) {
            z80InterruptSourceArray = null;
        }
        if (z80InterruptSourceArray != null) {
            this.comboIntSource.setModel(new DefaultComboBoxModel<Object>((Object[])z80InterruptSourceArray));
        } else {
            Object[] objectArray = new Object[]{"--- Keine Interrupt-Quelle vorhanden---"};
            this.comboIntSource.setModel(new DefaultComboBoxModel<Object>(objectArray));
        }
        this.pack();
    }

    @Override
    protected boolean doAction(EventObject eventObject) {
        Object object;
        boolean bl = false;
        if (eventObject != null && (object = eventObject.getSource()) != null && object == this.comboIntSource) {
            bl = true;
            this.doApprove();
        }
        if (!bl) {
            bl = super.doAction(eventObject);
        }
        return bl;
    }

    @Override
    protected void doApprove() {
        Object object = this.comboIntSource.getSelectedItem();
        if (object != null && object instanceof Z80InterruptSource) {
            this.approveBreakpoint(new InterruptBreakpoint(this.debugFrm, (Z80InterruptSource)object));
        }
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
        if (this.comboIntSource != null) {
            this.comboIntSource.requestFocus();
        }
    }
}

