/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.tools.debugger;

import jkcemu.tools.debugger.AbstractBreakpoint;
import jkcemu.tools.debugger.DebugFrm;
import z80emu.Z80CPU;
import z80emu.Z80InterruptSource;

public class InputBreakpoint
extends AbstractBreakpoint {
    private boolean is8Bit;
    private int begPort;
    private int endPort;

    public InputBreakpoint(DebugFrm debugFrm, boolean bl, int n, int n2) {
        super(debugFrm);
        this.is8Bit = bl;
        this.begPort = n & 0xFFFF;
        int n3 = this.endPort = n2 >= 0 ? n2 & 0xFFFF : -1;
        if (this.is8Bit) {
            this.begPort &= 0xFF;
            if (this.endPort >= 0) {
                this.endPort &= 0xFF;
                this.setText(String.format("%02X-%02X", this.begPort, this.endPort));
            } else {
                this.setText(String.format("%02X", this.begPort));
            }
        } else if (this.endPort >= 0) {
            this.setText(String.format("%04X-%04X", this.begPort, this.endPort));
        } else {
            this.setText(String.format("%04X", this.begPort));
        }
    }

    public boolean get8Bit() {
        return this.is8Bit;
    }

    public int getBegPort() {
        return this.begPort;
    }

    public int getEndPort() {
        return this.endPort;
    }

    @Override
    protected boolean matchesImpl(Z80CPU z80CPU, Z80InterruptSource z80InterruptSource) {
        boolean bl = false;
        int n = z80CPU.getRegPC();
        int n2 = z80CPU.getMemByte(n, false);
        int n3 = z80CPU.getMemByte(n + 1, false);
        if (n2 == 219) {
            bl = this.matchesPort(z80CPU.getRegA() << 8 | n3);
        } else if (n2 == 237 && (n3 == 64 || n3 == 72 || n3 == 80 || n3 == 88 || n3 == 96 || n3 == 104 || n3 == 112 || n3 == 120 || n3 == 162 || n3 == 170 || n3 == 178 || n3 == 186)) {
            bl = this.matchesPort(z80CPU.getRegBC());
        }
        return bl;
    }

    private boolean matchesPort(int n) {
        n = this.is8Bit ? (n &= 0xFF) : (n &= 0xFFFF);
        return n == this.begPort || n >= this.begPort && n <= this.endPort;
    }
}

