/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.tools.debugger;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.util.EventObject;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import jkcemu.base.BaseDlg;
import jkcemu.tools.debugger.AbstractBreakpoint;
import jkcemu.tools.debugger.DebugFrm;

public abstract class AbstractBreakpointDlg
extends BaseDlg {
    protected static String[] conditions = new String[]{"<", "<=", "<>", "=", ">=", ">"};
    protected DebugFrm debugFrm;
    protected AbstractBreakpoint breakpoint;
    private static boolean lastStopEnabled = true;
    private static boolean lastLogEnabled = false;
    private AbstractBreakpoint approvedBreakpoint;
    private JCheckBox btnStopEnabled;
    private JCheckBox btnLogEnabled;
    private JButton btnOK;
    private JButton btnCancel;

    protected AbstractBreakpointDlg(DebugFrm debugFrm, String string, AbstractBreakpoint abstractBreakpoint) {
        super((Window)debugFrm, abstractBreakpoint != null ? "Halte-/Log-Punkt auf " + string + " bearbeiten" : "Neuer Halte-/Log-Punkt auf " + string);
        this.debugFrm = debugFrm;
        this.breakpoint = abstractBreakpoint;
        this.approvedBreakpoint = null;
    }

    protected void approveBreakpoint(AbstractBreakpoint abstractBreakpoint) {
        abstractBreakpoint.setStopEnabled(this.btnStopEnabled.isSelected());
        abstractBreakpoint.setLogEnabled(this.btnLogEnabled.isSelected());
        this.approvedBreakpoint = abstractBreakpoint;
        this.doClose();
        lastStopEnabled = abstractBreakpoint.isStopEnabled();
        lastLogEnabled = abstractBreakpoint.isLogEnabled();
    }

    protected boolean checkMaskValue(boolean bl, int n, int n2) {
        int n3;
        boolean bl2 = true;
        int n4 = n3 = bl ? 255 : 65535;
        if (n == 0) {
            AbstractBreakpointDlg.showErrorDlg((Component)this, "Die Maske 00 blendet den zu testenden Wert vollst\u00e4ndig aus.");
            bl2 = false;
        } else if ((~n & n2 & n3) != 0) {
            bl2 = AbstractBreakpointDlg.showYesNoWarningDlg(this, String.format("Es ist i.d.R. nicht sinnvoll, wenn im Vergleichswert (rechtes Eingabefeld) Bits gesetzt sind,\ndie mit der Maske (linkes Eingabefeld) vom zu testenden Wert ausgeblendet werden.\nEin zur Maske passender Vergleichswert w\u00e4re z.B. hexadezimal %02X.\nSollen trotzdem die von Ihnen angegeben Werte verwendet werden?", n & n2 & n3), "Best\u00e4tigung");
        }
        return bl2;
    }

    protected JPanel createGeneralButtons() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0);
        this.btnStopEnabled = new JCheckBox("Programmausf\u00fchrung anhalten (Haltepunkt)", lastStopEnabled);
        jPanel.add((Component)this.btnStopEnabled, gridBagConstraints);
        this.btnLogEnabled = new JCheckBox("Log-Meldung erzeugen (Log-Punkt)", lastLogEnabled);
        gridBagConstraints.insets.top = 0;
        gridBagConstraints.insets.bottom = 10;
        ++gridBagConstraints.gridy;
        jPanel.add((Component)this.btnLogEnabled, gridBagConstraints);
        JPanel jPanel2 = new JPanel(new GridLayout(1, 2, 5, 5));
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets.left = 5;
        ++gridBagConstraints.gridy;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        this.btnOK = new JButton("OK");
        this.btnOK.addActionListener(this);
        jPanel2.add(this.btnOK);
        this.btnCancel = new JButton("Abbrechen");
        this.btnCancel.addActionListener(this);
        jPanel2.add(this.btnCancel);
        if (this.breakpoint != null) {
            this.btnStopEnabled.setSelected(this.breakpoint.isStopEnabled());
            this.btnLogEnabled.setSelected(this.breakpoint.isLogEnabled());
        }
        return jPanel;
    }

    protected abstract void doApprove();

    public AbstractBreakpoint getApprovedBreakpoint() {
        return this.approvedBreakpoint;
    }

    protected void showInvalidFmt(String string) {
        AbstractBreakpointDlg.showErrorDlg((Component)this, string + " hat ung\u00fcltiges Format.");
    }

    @Override
    protected boolean doAction(EventObject eventObject) {
        boolean bl = false;
        Object object = eventObject.getSource();
        if (object != null) {
            if (object == this.btnOK) {
                bl = true;
                this.doApprove();
            } else if (object == this.btnCancel) {
                bl = true;
                this.doClose();
            }
        }
        return bl;
    }
}

