/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.tools.calculator;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.text.CharacterIterator;
import java.text.ParseException;
import java.text.StringCharacterIterator;

public class ExprParser {
    private static final int MAX_BINARY_DIGITS = 64;
    private static final int MAX_DECIMAL_DIGITS = 1000;
    private static final int MAX_DECIMAL_EXP_DIGITS = 5;
    private static final int MAX_OCTAL_DIGITS = 21;
    private static final int MAX_HEX_DIGITS = 16;
    private static final int MIN_DIV_SCALE = 16;
    private String text = null;
    private CharacterIterator iter = null;

    public BigDecimal parseExpr(String string) throws ParseException {
        BigDecimal bigDecimal = null;
        try {
            this.text = string != null ? string : "";
            this.iter = new StringCharacterIterator(this.text);
            bigDecimal = this.parseInclusiveORExpr().stripTrailingZeros();
            char c = this.skipSpaces();
            if (c != '\uffff') {
                this.fireUnexpectedChar(c);
            }
        }
        catch (ArithmeticException arithmeticException) {
            String string2 = "Arithmetischer Fehler";
            String string3 = arithmeticException.getMessage();
            if (string3 != null && !string3.isEmpty()) {
                string2 = string2 + ": " + string3;
            }
            this.fireError(string2);
        }
        return bigDecimal;
    }

    private void checkInteger(BigDecimal bigDecimal) throws ParseException {
        if (bigDecimal.scale() > 0) {
            this.fireError("Operation mit Flie\u00dfkommazahlen nicht m\u00f6glich");
        }
    }

    private void checkToken(char c) throws ParseException {
        if (this.skipSpaces() != c) {
            this.fireError("'" + Character.toString(c) + "' erwartet");
        }
        this.iter.next();
    }

    private void fireError(String string) throws ParseException {
        throw new ParseException(string, this.iter.getIndex());
    }

    private void fireUnexpectedChar(char c) throws ParseException {
        this.fireError(String.format("Unerwartetes Zeichen '%c'", Character.valueOf(c)));
    }

    private boolean isHexDigit(char c) {
        return c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f' || c >= '0' && c <= '9';
    }

    private void fireHexOverflow() throws ParseException {
        this.fireError("Hexadezimalzahl zu gro\u00df");
    }

    private BigDecimal parseInclusiveORExpr() throws ParseException {
        BigDecimal bigDecimal = this.parseExclusiveORExpr();
        char c = this.skipSpaces();
        while (c == '|') {
            this.checkInteger(bigDecimal);
            this.iter.next();
            BigDecimal bigDecimal2 = this.parseExclusiveORExpr();
            this.checkInteger(bigDecimal2);
            bigDecimal = new BigDecimal(this.toLong(bigDecimal) | this.toLong(bigDecimal2));
            c = this.skipSpaces();
        }
        return bigDecimal;
    }

    private BigDecimal parseExclusiveORExpr() throws ParseException {
        BigDecimal bigDecimal = this.parseAndExpr();
        char c = this.skipSpaces();
        while (c == '^') {
            this.checkInteger(bigDecimal);
            this.iter.next();
            BigDecimal bigDecimal2 = this.parseAndExpr();
            this.checkInteger(bigDecimal2);
            bigDecimal = new BigDecimal(this.toLong(bigDecimal) ^ this.toLong(bigDecimal2));
            c = this.skipSpaces();
        }
        return bigDecimal;
    }

    private BigDecimal parseAndExpr() throws ParseException {
        BigDecimal bigDecimal = this.parseAddExpr();
        char c = this.skipSpaces();
        while (c == '&') {
            this.checkInteger(bigDecimal);
            this.iter.next();
            BigDecimal bigDecimal2 = this.parseAddExpr();
            this.checkInteger(bigDecimal2);
            bigDecimal = new BigDecimal(this.toLong(bigDecimal) & this.toLong(bigDecimal2));
            c = this.skipSpaces();
        }
        return bigDecimal;
    }

    private BigDecimal parseAddExpr() throws ParseException {
        BigDecimal bigDecimal = this.parseMulExpr();
        char c = this.skipSpaces();
        while (c == '+' || c == '-') {
            this.iter.next();
            BigDecimal bigDecimal2 = this.parseMulExpr();
            if (c == '+') {
                bigDecimal = bigDecimal.add(bigDecimal2);
            } else if (c == '-') {
                bigDecimal = bigDecimal.subtract(bigDecimal2);
            }
            c = this.skipSpaces();
        }
        return bigDecimal;
    }

    private BigDecimal parseMulExpr() throws ParseException {
        BigDecimal bigDecimal = this.parseUnaryExpr();
        char c = this.skipSpaces();
        while (c == '*' || c == '/' || c == '%') {
            if (c == '%') {
                this.checkInteger(bigDecimal);
            }
            this.iter.next();
            BigDecimal bigDecimal2 = this.parseUnaryExpr();
            if (c == '*') {
                bigDecimal = bigDecimal.multiply(bigDecimal2);
            } else if (c == '/') {
                if (bigDecimal2.compareTo(BigDecimal.ZERO) == 0) {
                    this.fireError("Division durch 0");
                }
                int n = Math.max(bigDecimal.precision(), bigDecimal.scale());
                int n2 = Math.max(bigDecimal2.precision(), bigDecimal2.scale());
                bigDecimal = bigDecimal.divide(bigDecimal2, new MathContext(Math.max(n, n2) + 16, RoundingMode.HALF_EVEN));
            } else if (c == '%') {
                long l = this.toLong(bigDecimal2);
                if (l == 0L) {
                    this.fireError("Module durch 0");
                }
                bigDecimal = new BigDecimal(this.toLong(bigDecimal) % l);
            }
            c = this.skipSpaces();
        }
        return bigDecimal;
    }

    private BigDecimal parseUnaryExpr() throws ParseException {
        BigDecimal bigDecimal = null;
        char c = this.skipSpaces();
        if (c == '+') {
            this.iter.next();
            bigDecimal = this.parsePrimExpr();
        } else if (c == '-') {
            this.iter.next();
            bigDecimal = this.parsePrimExpr().negate();
        } else if (c == '~') {
            this.iter.next();
            bigDecimal = this.parsePrimExpr();
            this.checkInteger(bigDecimal);
            bigDecimal = new BigDecimal(this.toLong(bigDecimal) ^ 0xFFFFFFFFFFFFFFFFL);
        } else {
            bigDecimal = this.parsePrimExpr();
        }
        return bigDecimal;
    }

    private BigDecimal parsePrimExpr() throws ParseException {
        BigDecimal bigDecimal = null;
        char c = this.skipSpaces();
        if (c == '(') {
            this.iter.next();
            bigDecimal = this.parseInclusiveORExpr();
            this.checkToken(')');
        } else if (c == '$' || c >= '0' && c <= '9') {
            bigDecimal = this.parseNumber();
        } else if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z') {
            bigDecimal = this.parseIdentifier();
        } else if (c != '\uffff') {
            this.fireUnexpectedChar(c);
        } else {
            this.fireError("Unerwartetes Ende");
        }
        return bigDecimal;
    }

    private BigDecimal parseNumber() throws ParseException {
        char c = this.skipSpaces();
        int n = this.iter.getIndex();
        int n2 = 0;
        if (c == '$') {
            c = this.iter.next();
            if (c == '0' || c == '1') {
                long l = 0L;
                do {
                    if (c != '0' || n2 > 0) {
                        ++n2;
                    }
                    l <<= 1;
                    if (c != '1') continue;
                    l |= 1L;
                } while ((c = this.iter.next()) == '0' || c == '1');
                if (n2 > 64) {
                    this.fireError("Bin\u00e4rzahl zu gro\u00df");
                }
                return new BigDecimal(l);
            }
            this.fireError("Bin\u00e4rzahl hinter '$' erwartet");
        }
        n2 = 0;
        if (c == '0' && ((c = this.iter.next()) == 'x' || c == 'X')) {
            c = this.iter.next();
            if (this.isHexDigit(c)) {
                long l = 0L;
                do {
                    if (c != '0' || n2 > 0) {
                        ++n2;
                    }
                    l <<= 4;
                    if (c >= '0' && c <= '9') {
                        l |= (long)(c - 48);
                        continue;
                    }
                    if (c >= 'A' && c <= 'F') {
                        l |= (long)(c - 65 + 10);
                        continue;
                    }
                    if (c < 'a' || c > 'f') continue;
                    l |= (long)(c - 97 + 10);
                } while (this.isHexDigit(c = this.iter.next()));
                if (n2 > 16) {
                    this.fireHexOverflow();
                }
                return new BigDecimal(l);
            }
            this.fireError("Hexadezimalziffern hinter '0x' erwartet");
        }
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = true;
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        n2 = 0;
        while (this.isHexDigit(c)) {
            if (c != '0' || n2 > 0) {
                ++n2;
            }
            if (c == '0' || c == '1') {
                l = l << 1 | (long)(c - 48);
                l2 = l2 << 3 | (long)(c - 48);
                l3 = l3 << 4 | (long)(c - 48);
            } else if (c >= '2' && c <= '7') {
                bl = false;
                l2 = l2 << 3 | (long)(c - 48);
                l3 = l3 << 4 | (long)(c - 48);
            } else if (c == '8' || c == '9') {
                bl = false;
                bl2 = false;
                l3 = l3 << 4 | (long)(c - 48);
            } else if (c >= 'A' && c <= 'F') {
                bl = false;
                bl2 = false;
                l3 = l3 << 4 | (long)(c - 65 + 10);
            } else if (c >= 'a' && c <= 'f') {
                bl = false;
                bl2 = false;
                l3 = l3 << 4 | (long)(c - 97 + 10);
            }
            c = this.iter.next();
        }
        if (bl2 && (c == 'Q' || c == 'q')) {
            this.iter.next();
            if (bl2) {
                if (n2 > 21) {
                    this.fireError("Oktalzahl zu gro\u00df");
                }
                return new BigDecimal(l2);
            }
            this.fireError("Ung\u00fcltige Oktalzahl");
        } else if (bl3 && (c == 'H' || c == 'h')) {
            if (n2 > 16) {
                this.fireHexOverflow();
            }
            this.iter.next();
            return new BigDecimal(l3);
        }
        String string = "Ung\u00fcltige Dezimalzahl";
        this.iter.setIndex(n);
        c = this.iter.current();
        n2 = 0;
        while (c >= '0' && c <= '9') {
            if ((c != '0' || n2 > 0) && ++n2 > 1000) {
                this.fireError("Zahl zu gro\u00df");
            }
            c = this.iter.next();
        }
        if (c == '.') {
            string = "Ung\u00fcltige Flie\u00dfkommazahl";
            c = this.iter.next();
            if (c < '0' || c > '9') {
                this.fireError(string);
            }
            n2 = 1;
            c = this.iter.next();
            while (c >= '0' && c <= '9') {
                if (++n2 > 1000) {
                    this.fireError("Zu viele Nachkommastellen");
                }
                c = this.iter.next();
            }
        }
        if (c == 'e' || c == 'E') {
            c = this.iter.next();
            if (c == '-' || c == '+') {
                c = this.iter.next();
            }
            if (c < '0' || c > '9') {
                this.fireError(string);
            }
            n2 = 0;
            while (c >= '0' && c <= '9') {
                if ((c != '0' || n2 > 0) && ++n2 > 5) {
                    this.fireError("Exponent zu gro\u00df");
                }
                c = this.iter.next();
            }
        }
        BigDecimal bigDecimal = null;
        int n3 = this.iter.getIndex();
        if (n3 > n) {
            try {
                bigDecimal = new BigDecimal(this.text.substring(n, n3));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (bigDecimal == null) {
            this.fireError(string);
        }
        return bigDecimal;
    }

    private BigDecimal parseIdentifier() throws ParseException {
        StringBuilder stringBuilder = new StringBuilder();
        char c = this.skipSpaces();
        while (c >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c == '_') {
            stringBuilder.append(c);
            c = this.iter.next();
        }
        BigDecimal bigDecimal = null;
        String string = stringBuilder.toString().toUpperCase();
        if (string.equals("PI")) {
            bigDecimal = new BigDecimal(Math.PI);
        } else if (string.equals("E")) {
            bigDecimal = new BigDecimal(Math.E);
        } else if (string.equals("ABS")) {
            BigDecimal bigDecimal2 = this.parseFunctionArg();
            bigDecimal = bigDecimal2.compareTo(BigDecimal.ZERO) < 0 ? bigDecimal2.negate() : bigDecimal2;
        } else if (string.equals("ACOS") || string.equals("ARCCOS")) {
            bigDecimal = new BigDecimal(Math.acos(this.parseFunctionArg().doubleValue()));
        } else if (string.equals("ASIN") || string.equals("ARCSIN")) {
            bigDecimal = new BigDecimal(Math.asin(this.parseFunctionArg().doubleValue()));
        } else if (string.equals("ATAN") || string.equals("ARCTAN")) {
            bigDecimal = new BigDecimal(Math.atan(this.parseFunctionArg().doubleValue()));
        } else if (string.equals("COS")) {
            bigDecimal = new BigDecimal(Math.cos(this.parseFunctionArg().doubleValue()));
        } else if (string.equals("COSH")) {
            bigDecimal = new BigDecimal(Math.cosh(this.parseFunctionArg().doubleValue()));
        } else if (string.equals("EXP")) {
            bigDecimal = new BigDecimal(Math.exp(this.parseFunctionArg().doubleValue()));
        } else if (string.equals("LOG")) {
            bigDecimal = new BigDecimal(Math.log(this.parseFunctionArg().doubleValue()));
        } else if (string.equals("LOG10")) {
            bigDecimal = new BigDecimal(Math.log10(this.parseFunctionArg().doubleValue()));
        } else if (string.equals("MAX")) {
            this.checkToken('(');
            bigDecimal = this.parseInclusiveORExpr();
            while (this.skipSpaces() == ',') {
                this.iter.next();
                BigDecimal bigDecimal3 = this.parseInclusiveORExpr();
                if (bigDecimal3.compareTo(bigDecimal) <= 0) continue;
                bigDecimal = bigDecimal3;
            }
            this.checkToken(')');
        } else if (string.equals("MIN")) {
            this.checkToken('(');
            bigDecimal = this.parseInclusiveORExpr();
            while (this.skipSpaces() == ',') {
                this.iter.next();
                BigDecimal bigDecimal4 = this.parseInclusiveORExpr();
                if (bigDecimal4.compareTo(bigDecimal) >= 0) continue;
                bigDecimal = bigDecimal4;
            }
            this.checkToken(')');
        } else if (string.equals("POW")) {
            this.checkToken('(');
            BigDecimal bigDecimal5 = this.parseInclusiveORExpr();
            this.checkToken(',');
            BigDecimal bigDecimal6 = this.parseInclusiveORExpr();
            this.checkToken(')');
            try {
                long l;
                if (bigDecimal6.scale() == 0 && (l = bigDecimal6.longValue()) >= 0L && l <= 999999999L) {
                    bigDecimal = bigDecimal5.pow((int)l);
                }
            }
            catch (ArithmeticException arithmeticException) {
                // empty catch block
            }
            if (bigDecimal == null) {
                bigDecimal = new BigDecimal(Math.pow(bigDecimal5.doubleValue(), bigDecimal6.doubleValue()));
            }
        } else if (string.equals("RND") || string.equals("RANDOM")) {
            this.checkToken('(');
            bigDecimal = new BigDecimal(Math.random());
            this.checkToken(')');
        } else if (string.equals("ROUND")) {
            BigDecimal bigDecimal7 = this.parseFunctionArg();
            try {
                bigDecimal = bigDecimal7.round(new MathContext(bigDecimal7.precision() - bigDecimal7.scale(), RoundingMode.HALF_EVEN));
            }
            catch (ArithmeticException arithmeticException) {
                // empty catch block
            }
            if (bigDecimal == null) {
                bigDecimal = new BigDecimal(Math.round(bigDecimal7.doubleValue()));
            }
        } else if (string.equals("SIG") || string.equals("SIGNUM")) {
            int n = this.parseFunctionArg().compareTo(BigDecimal.ZERO);
            bigDecimal = n < 0 ? new BigDecimal(-1) : (n > 0 ? new BigDecimal(1) : BigDecimal.ZERO);
        } else if (string.equals("SIN")) {
            bigDecimal = new BigDecimal(Math.sin(this.parseFunctionArg().doubleValue()));
        } else if (string.equals("SINH")) {
            bigDecimal = new BigDecimal(Math.sinh(this.parseFunctionArg().doubleValue()));
        } else if (string.equals("SQR") || string.equals("SQRT")) {
            bigDecimal = new BigDecimal(Math.sqrt(this.parseFunctionArg().doubleValue()));
        } else if (string.equals("TAN")) {
            bigDecimal = new BigDecimal(Math.tan(this.parseFunctionArg().doubleValue()));
        } else if (string.equals("TANH")) {
            bigDecimal = new BigDecimal(Math.tanh(this.parseFunctionArg().doubleValue()));
        } else if (string.equals("TO_DEGREES") || string.equals("TODEGREES")) {
            bigDecimal = new BigDecimal(Math.toDegrees(this.parseFunctionArg().doubleValue()));
        } else if (string.equals("TO_RADIANS") || string.equals("TORADIANS")) {
            bigDecimal = new BigDecimal(Math.toRadians(this.parseFunctionArg().doubleValue()));
        }
        if (bigDecimal == null) {
            this.fireError("'" + stringBuilder.toString() + "': Unbekannter Bezeichner");
        }
        return bigDecimal;
    }

    private BigDecimal parseFunctionArg() throws ParseException {
        this.checkToken('(');
        BigDecimal bigDecimal = this.parseInclusiveORExpr();
        this.checkToken(')');
        return bigDecimal;
    }

    private char skipSpaces() {
        char c = this.iter.current();
        while (c == ' ' || c == '\t') {
            c = this.iter.next();
        }
        return c;
    }

    private long toLong(BigDecimal bigDecimal) throws ParseException {
        this.checkInteger(bigDecimal);
        return bigDecimal.longValueExact();
    }
}

