/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.tools.calculator;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.FlavorEvent;
import java.awt.datatransfer.FlavorListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowEvent;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.ParseException;
import java.util.EventObject;
import javax.swing.BorderFactory;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import jkcemu.Main;
import jkcemu.base.BaseFrm;
import jkcemu.base.HelpFrm;
import jkcemu.tools.calculator.ExprParser;

public class CalculatorFrm
extends BaseFrm
implements CaretListener,
DocumentListener,
FlavorListener,
FocusListener {
    private static final String DEFAULT_TEXT = "Geben Sie bitte ein Zeichen oder einen numerischen Ausdruck ein!";
    private static final String HELP_PAGE = "/help/tools/calculator.htm";
    private static CalculatorFrm instance = null;
    private ExprParser parser = new ExprParser();
    private Clipboard clipboard = null;
    private boolean clipboardHasText = false;
    private JTextComponent lastTextFld = null;
    private JMenuItem mnuFileClose;
    private JMenuItem mnuEditCut;
    private JMenuItem mnuEditCopy;
    private JMenuItem mnuEditPaste;
    private JMenuItem mnuEditSelectAll;
    private JMenuItem mnuHelpContent;
    private Document docInput;
    private JTextField fldInput;
    private JEditorPane fldOutput;

    public static void open() {
        if (instance != null) {
            if (instance.getExtendedState() == 1) {
                instance.setExtendedState(0);
            }
        } else {
            instance = new CalculatorFrm();
        }
        instance.toFront();
        instance.setVisible(true);
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.docChanged(documentEvent);
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.docChanged(documentEvent);
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.docChanged(documentEvent);
    }

    @Override
    public void caretUpdate(CaretEvent caretEvent) {
        this.updCutCopyButtons();
    }

    @Override
    public void flavorsChanged(FlavorEvent flavorEvent) {
        this.updClipboardStatus();
        this.updPasteButton();
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        JTextComponent jTextComponent = null;
        Component component = focusEvent.getComponent();
        if (component != null && component instanceof JTextComponent) {
            jTextComponent = (JTextComponent)component;
        }
        this.lastTextFld = jTextComponent;
        this.updCutCopyButtons();
        this.updPasteButton();
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    protected boolean doAction(EventObject eventObject) {
        boolean bl = false;
        if (eventObject != null) {
            Object object = eventObject.getSource();
            if (object == this.fldInput) {
                bl = true;
                this.updOutput();
            } else if (object == this.mnuFileClose) {
                bl = true;
                this.doClose();
            } else if (object == this.mnuEditCut) {
                bl = true;
                this.doEditCut();
            } else if (object == this.mnuEditCopy) {
                bl = true;
                this.doEditCopy();
            } else if (object == this.mnuEditPaste) {
                bl = true;
                this.doEditPaste();
            } else if (object == this.mnuEditSelectAll) {
                bl = true;
                this.doEditSelectAll();
            } else if (object == this.mnuHelpContent) {
                bl = true;
                HelpFrm.open(HELP_PAGE);
            }
        }
        return bl;
    }

    @Override
    public boolean doClose() {
        boolean bl = super.doClose();
        if (bl && !Main.checkQuit(this)) {
            this.fldInput.setText("");
        }
        return bl;
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
        if (windowEvent.getWindow() == this) {
            this.fldInput.requestFocus();
        }
    }

    private void doEditCut() {
        JTextComponent jTextComponent = this.lastTextFld;
        if (jTextComponent != null) {
            jTextComponent.cut();
        }
    }

    private void doEditCopy() {
        JTextComponent jTextComponent = this.lastTextFld;
        if (jTextComponent != null) {
            jTextComponent.copy();
        }
    }

    private void doEditPaste() {
        JTextComponent jTextComponent = this.lastTextFld;
        if (jTextComponent != null) {
            jTextComponent.paste();
        }
    }

    private void doEditSelectAll() {
        JTextComponent jTextComponent = this.lastTextFld;
        if (jTextComponent != null) {
            jTextComponent.selectAll();
        }
    }

    private CalculatorFrm() {
        this.setTitle("JKCEMU Rechner");
        Main.updIcon(this);
        JMenu jMenu = new JMenu("Datei");
        jMenu.setMnemonic(68);
        this.mnuFileClose = this.createJMenuItem("Schlie\u00dfen");
        jMenu.add(this.mnuFileClose);
        JMenu jMenu2 = new JMenu("Bearbeiten");
        jMenu2.setMnemonic(66);
        this.mnuEditCut = this.createJMenuItem("Ausschneiden", KeyStroke.getKeyStroke(88, 2));
        jMenu2.add(this.mnuEditCut);
        this.mnuEditCopy = this.createJMenuItem("Kopieren", KeyStroke.getKeyStroke(67, 2));
        jMenu2.add(this.mnuEditCopy);
        this.mnuEditPaste = this.createJMenuItem("Einf\u00fcgen", KeyStroke.getKeyStroke(86, 2));
        jMenu2.add(this.mnuEditPaste);
        jMenu2.addSeparator();
        this.mnuEditSelectAll = this.createJMenuItem("Alles ausw\u00e4hlen");
        jMenu2.add(this.mnuEditSelectAll);
        JMenu jMenu3 = new JMenu("?");
        this.mnuHelpContent = this.createJMenuItem("Hilfe...");
        jMenu3.add(this.mnuHelpContent);
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.add(jMenu);
        jMenuBar.add(jMenu2);
        jMenuBar.add(jMenu3);
        this.setJMenuBar(jMenuBar);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0);
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.add((Component)jPanel, gridBagConstraints);
        jPanel.setBorder(BorderFactory.createTitledBorder("Eingabe"));
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0);
        jPanel.add((Component)new JLabel("Ausdruck:"), gridBagConstraints2);
        this.fldInput = new JTextField();
        this.fldInput.addActionListener(this);
        this.fldInput.addCaretListener(this);
        this.fldInput.addFocusListener(this);
        this.docInput = this.fldInput.getDocument();
        if (this.docInput != null) {
            this.docInput.addDocumentListener(this);
        }
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.gridwidth = 0;
        ++gridBagConstraints2.gridx;
        jPanel.add((Component)this.fldInput, gridBagConstraints2);
        gridBagConstraints2.anchor = 13;
        gridBagConstraints2.fill = 0;
        gridBagConstraints2.insets.bottom = 0;
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.gridwidth = 1;
        ++gridBagConstraints2.gridy;
        jPanel.add((Component)new JLabel("Bin\u00e4rzahl:"), gridBagConstraints2);
        gridBagConstraints2.anchor = 17;
        ++gridBagConstraints2.gridx;
        jPanel.add((Component)new JLabel("$..."), gridBagConstraints2);
        gridBagConstraints2.anchor = 13;
        gridBagConstraints2.insets.top = 0;
        gridBagConstraints2.gridx = 1;
        ++gridBagConstraints2.gridy;
        jPanel.add((Component)new JLabel("Oktalzahl:"), gridBagConstraints2);
        gridBagConstraints2.anchor = 17;
        ++gridBagConstraints2.gridx;
        jPanel.add((Component)new JLabel("...Q"), gridBagConstraints2);
        gridBagConstraints2.anchor = 13;
        gridBagConstraints2.insets.bottom = 5;
        gridBagConstraints2.gridx = 1;
        ++gridBagConstraints2.gridy;
        jPanel.add((Component)new JLabel("Hexadezimalzahl:"), gridBagConstraints2);
        gridBagConstraints2.anchor = 17;
        ++gridBagConstraints2.gridx;
        jPanel.add((Component)new JLabel("0x... oder ...H"), gridBagConstraints2);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        ++gridBagConstraints.gridy;
        this.add((Component)jPanel2, gridBagConstraints);
        jPanel2.setBorder(BorderFactory.createTitledBorder("Ausgabe"));
        this.fldOutput = new JEditorPane("text/html", DEFAULT_TEXT);
        this.fldOutput.setBorder(BorderFactory.createLoweredBevelBorder());
        this.fldOutput.setEditable(false);
        this.fldOutput.addCaretListener(this);
        this.fldOutput.addFocusListener(this);
        jPanel2.add((Component)new JScrollPane(this.fldOutput), "Center");
        Toolkit toolkit = this.getToolkit();
        if (toolkit != null) {
            this.clipboard = toolkit.getSystemClipboard();
            if (this.clipboard != null) {
                this.clipboard.addFlavorListener(this);
                this.mnuEditPaste.setEnabled(false);
                this.updClipboardStatus();
            }
        }
        if (!this.applySettings(Main.getProperties(), true)) {
            this.fldOutput.setPreferredSize(new Dimension(300, 100));
            this.pack();
            this.setScreenCentered();
            this.fldOutput.setPreferredSize(null);
        }
        this.setResizable(true);
    }

    private void docChanged(DocumentEvent documentEvent) {
        if (this.docInput != null && documentEvent.getDocument() == this.docInput) {
            this.updOutput();
        }
    }

    private void updOutput() {
        int n;
        String string = DEFAULT_TEXT;
        String string2 = this.fldInput.getText();
        if (string2 != null && (n = string2.length()) > 0) {
            boolean bl = false;
            StringBuilder stringBuilder = new StringBuilder(256);
            try {
                char c;
                if (n == 1 && Character.isDefined(c = string2.charAt(0))) {
                    this.appendResultRow(stringBuilder, "Unicode des Zeichen", (int)c);
                }
                this.appendResultRow(stringBuilder, "Ergebnis des Ausdrucks", this.parser.parseExpr(string2));
                this.appendResultEnd(stringBuilder);
            }
            catch (ParseException parseException) {
                if (stringBuilder.length() > 0) {
                    this.appendResultEnd(stringBuilder);
                }
                int n2 = parseException.getErrorOffset();
                if (n2 > n) {
                    n2 = n;
                }
                if (n2 < 0) {
                    n2 = 0;
                }
                stringBuilder.append("<html>\n<p>");
                this.appendText(stringBuilder, parseException.getMessage());
                stringBuilder.append("</p>\n<p>");
                this.appendText(stringBuilder, string2.substring(0, n2));
                stringBuilder.append(" <b>?</b> ");
                this.appendText(stringBuilder, string2.substring(n2));
                stringBuilder.append("</p>\n</html>\n");
            }
            string = stringBuilder.toString();
        }
        this.fldOutput.setText(string);
        try {
            this.fldOutput.setCaretPosition(0);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void appendResultRow(StringBuilder stringBuilder, String string, Number number) {
        if (number != null) {
            boolean bl = false;
            long l = 0L;
            if (number instanceof BigDecimal && ((BigDecimal)number).scale() <= 0) {
                try {
                    l = ((BigDecimal)number).longValueExact();
                    bl = true;
                }
                catch (ArithmeticException arithmeticException) {
                    // empty catch block
                }
            }
            if (number instanceof BigInteger) {
                if (((BigInteger)number).bitLength() < 64) {
                    l = number.longValue();
                    bl = true;
                }
            } else if (number instanceof Integer || number instanceof Long) {
                l = number.longValue();
                bl = true;
            }
            if (stringBuilder.length() < 1) {
                stringBuilder.append("<html>\n<table border=1>\n<tr><th nowrap></th><th nowrap>Hex</th><th nowrap>Dezimal</th><th nowrap>Oktal</th><th nowrap>Bin&auml;r</th><th nowrap>Unicode-Zeichen</th></tr>\n");
            }
            stringBuilder.append("<tr><td nowrap>");
            this.appendText(stringBuilder, string);
            stringBuilder.append(":</td><td>");
            if (bl) {
                this.appendText(stringBuilder, Long.toHexString(l).toUpperCase());
            }
            stringBuilder.append("</td><td nowrap>");
            String string2 = null;
            if (number instanceof BigDecimal && Math.abs(((BigDecimal)number).scale()) < 10) {
                string2 = ((BigDecimal)number).toPlainString();
            }
            if (string2 == null) {
                string2 = number.toString();
            }
            this.appendText(stringBuilder, string2);
            stringBuilder.append("</td><td nowrap>");
            if (bl) {
                this.appendText(stringBuilder, Long.toOctalString(l));
            }
            stringBuilder.append("</td><td nowrap>");
            if (bl) {
                this.appendText(stringBuilder, Long.toBinaryString(l));
            }
            stringBuilder.append("</td><td nowrap>");
            if (bl && l >= 0L && l < Integer.MAX_VALUE) {
                if (l > 32L && l <= 126L) {
                    this.appendText(stringBuilder, Character.toString((char)l));
                } else if (Character.isDefined((int)l)) {
                    stringBuilder.append(String.format("&#%d;", l));
                }
            }
            stringBuilder.append("</td></tr>\n");
        }
    }

    private void appendResultEnd(StringBuilder stringBuilder) {
        stringBuilder.append("</table>\n</html>\n");
    }

    private void appendText(StringBuilder stringBuilder, String string) {
        if (string != null) {
            int n = string.length();
            block13: for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                switch (c) {
                    case '<': {
                        stringBuilder.append("&lt;");
                        continue block13;
                    }
                    case '>': {
                        stringBuilder.append("&gt;");
                        continue block13;
                    }
                    case '\"': {
                        stringBuilder.append("&quot;");
                        continue block13;
                    }
                    case '&': {
                        stringBuilder.append("&amp;");
                        continue block13;
                    }
                    case '\u00c4': {
                        stringBuilder.append("&Auml;");
                        continue block13;
                    }
                    case '\u00d6': {
                        stringBuilder.append("&Ouml;");
                        continue block13;
                    }
                    case '\u00dc': {
                        stringBuilder.append("&Uuml;");
                        continue block13;
                    }
                    case '\u00e4': {
                        stringBuilder.append("&auml;");
                        continue block13;
                    }
                    case '\u00f6': {
                        stringBuilder.append("&ouml;");
                        continue block13;
                    }
                    case '\u00fc': {
                        stringBuilder.append("&uuml;");
                        continue block13;
                    }
                    case '\u00df': {
                        stringBuilder.append("&szlig;");
                        continue block13;
                    }
                    default: {
                        if (c < ' ') {
                            stringBuilder.append(' ');
                            continue block13;
                        }
                        if (c > '~') {
                            stringBuilder.append("&#");
                            stringBuilder.append((int)c);
                            stringBuilder.append(';');
                            continue block13;
                        }
                        stringBuilder.append(c);
                    }
                }
            }
        }
    }

    private void updClipboardStatus() {
        boolean bl = false;
        if (this.clipboard != null) {
            try {
                bl = this.clipboard.isDataFlavorAvailable(DataFlavor.stringFlavor);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        this.clipboardHasText = bl;
    }

    private void updCutCopyButtons() {
        boolean bl = false;
        boolean bl2 = false;
        if (this.lastTextFld != null) {
            bl = this.lastTextFld.isEditable();
            bl2 = this.lastTextFld.getSelectionStart() >= 0 && this.lastTextFld.getSelectionEnd() > this.lastTextFld.getSelectionStart();
        }
        this.mnuEditCut.setEnabled(bl && bl2);
        this.mnuEditCopy.setEnabled(bl2);
    }

    private void updPasteButton() {
        boolean bl = this.lastTextFld != null ? this.lastTextFld.isEditable() : false;
        this.mnuEditPaste.setEnabled(bl && this.clipboardHasText);
    }
}

