/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.text;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.dnd.DropTarget;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PushbackInputStream;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.undo.UndoManager;
import jkcemu.Main;
import jkcemu.base.BaseDlg;
import jkcemu.base.EmuMemView;
import jkcemu.base.EmuUtil;
import jkcemu.base.FileFormat;
import jkcemu.base.FileInfo;
import jkcemu.base.LoadData;
import jkcemu.base.SourceUtil;
import jkcemu.base.UserCancelException;
import jkcemu.emusys.AC1;
import jkcemu.emusys.BCS3;
import jkcemu.emusys.KC85;
import jkcemu.emusys.KramerMC;
import jkcemu.emusys.LC80;
import jkcemu.emusys.LLC1;
import jkcemu.emusys.Z1013;
import jkcemu.emusys.Z9001;
import jkcemu.programming.PrgOptions;
import jkcemu.programming.PrgSource;
import jkcemu.programming.basic.BasicOptions;
import jkcemu.text.CharConverter;
import jkcemu.text.TextEditFrm;

public class EditText
implements CaretListener,
DocumentListener,
UndoableEditListener {
    public static final String TEXT_WITH_BOM = " mit Byte-Order-Markierung";
    public static final String PROP_PROPERTIES_TYPE = "jkcemu.properties.type";
    public static final String PROP_PRG_SOURCE_FILE_NAME = "jkcemu.programming.source.file.name";
    public static final String VALUE_PROPERTIES_TYPE_PROJECT = "project";
    private boolean used;
    private boolean charsLostOnOpen;
    private boolean dataChanged;
    private boolean prjChanged;
    private boolean saved;
    private boolean askFileNameOnSave;
    private boolean byteOrderMark;
    private boolean trimLines;
    private int eofByte;
    private PrgOptions prgOptions;
    private File file;
    private File prjFile;
    private CharConverter charConverter;
    private String encodingName;
    private String encodingDesc;
    private String lineEnd;
    private String textName;
    private String textValue;
    private JTextArea textArea;
    private Component tabComponent;
    private DropTarget dropTarget1;
    private DropTarget dropTarget2;
    private UndoManager undoMngr;
    private EditText resultEditText;
    private TextEditFrm textEditFrm;

    public EditText(TextEditFrm textEditFrm, Component component, JTextArea jTextArea) {
        this.init(textEditFrm);
        this.textName = "Neuer Text";
        int n = this.textEditFrm.getNewTextNum();
        if (n > 1) {
            this.textName = this.textName + " <" + String.valueOf(n) + ">";
        }
        this.setComponents(component, jTextArea);
    }

    public EditText(TextEditFrm textEditFrm, File file, CharConverter charConverter, String string, String string2, boolean bl) throws IOException, UserCancelException {
        this.init(textEditFrm);
        this.loadFile(file, charConverter, string, string2, bl);
    }

    public boolean canUndo() {
        return this.undoMngr.canUndo();
    }

    public void die() {
        this.disableDropTargets();
        if (this.textArea != null) {
            this.textArea.removeCaretListener(this);
            Document document = this.textArea.getDocument();
            if (document != null) {
                document.removeDocumentListener(this);
                document.removeUndoableEditListener(this);
            }
        }
        this.textEditFrm = null;
        this.file = null;
        this.charConverter = null;
        this.encodingDesc = null;
        this.encodingName = null;
        this.lineEnd = null;
        this.textName = null;
        this.textValue = null;
        this.textArea = null;
        this.tabComponent = null;
        this.undoMngr.discardAllEdits();
    }

    public boolean getAskFileNameOnSave() {
        return this.askFileNameOnSave;
    }

    public int getCaretPosition() {
        return this.textArea != null ? this.textArea.getCaretPosition() : 0;
    }

    public CharConverter getCharConverter() {
        return this.charConverter;
    }

    public boolean getCharsLostOnOpen() {
        return this.charsLostOnOpen;
    }

    public String getEncodingDescription() {
        return this.encodingDesc;
    }

    public String getEncodingName() {
        return this.encodingName;
    }

    public int getEofByte() {
        return this.eofByte;
    }

    public File getFile() {
        return this.file;
    }

    public JTextArea getJTextArea() {
        return this.textArea;
    }

    public String getLineEnd() {
        return this.lineEnd;
    }

    public String getName() {
        return this.textName;
    }

    public PrgOptions getPrgOptions() {
        return this.prgOptions;
    }

    public File getProjectFile() {
        return this.prjFile;
    }

    public EditText getResultEditText() {
        return this.resultEditText;
    }

    public Component getTabComponent() {
        return this.tabComponent;
    }

    public int getTabSize() {
        int n = 8;
        if (this.textArea != null && (n = this.textArea.getTabSize()) < 1) {
            n = 8;
        }
        return n;
    }

    public String getText() {
        String string = null;
        if (this.textArea != null) {
            string = this.textArea.getText();
        } else if (this.textValue != null) {
            string = this.textValue;
        }
        return string != null ? string : "";
    }

    public TextEditFrm getTextEditFrm() {
        return this.textEditFrm;
    }

    public int getTextLength() {
        if (this.textArea != null) {
            return this.textArea.getDocument().getLength();
        }
        if (this.textValue != null) {
            return this.textValue.length();
        }
        return 0;
    }

    public boolean getTrimLines() {
        return this.trimLines;
    }

    public void gotoLine(int n) {
        this.textEditFrm.setState(0);
        this.textEditFrm.toFront();
        this.textEditFrm.setSelectedTabComponent(this.tabComponent);
        this.textEditFrm.gotoLine(this.textArea, n);
    }

    public boolean hasByteOrderMark() {
        return this.byteOrderMark;
    }

    public boolean hasDataChanged() {
        return this.dataChanged;
    }

    public boolean hasProjectChanged() {
        return this.prjChanged || this.prgOptions == null;
    }

    public boolean hasRowHeader() {
        Component component;
        JViewport jViewport;
        boolean bl = false;
        JScrollPane jScrollPane = this.getJScrollPane();
        if (jScrollPane != null && (jViewport = jScrollPane.getRowHeader()) != null && (component = jViewport.getView()) != null) {
            bl = true;
        }
        return bl;
    }

    public boolean isSameFile(File file) {
        return this.file != null && file != null ? EmuUtil.equals(this.file, file) : false;
    }

    public boolean isSameText(PrgSource prgSource) {
        boolean bl = false;
        if (prgSource != null) {
            String string = prgSource.getText();
            if (string != null) {
                boolean bl2 = bl = !string.isEmpty() && string.equals(this.getText());
            }
            if (!bl) {
                bl = this.isSameFile(prgSource.getFile());
            }
        }
        return bl;
    }

    public boolean isSaved() {
        return this.saved;
    }

    public boolean isUsed() {
        return this.used;
    }

    public void loadFile(File file, CharConverter object, String string, String string2, boolean bl) throws IOException, UserCancelException {
        try {
            Object object2;
            Object object3;
            Object object4 = new TextProps(string, string2);
            boolean bl2 = false;
            FileInfo fileInfo = null;
            String string3 = null;
            String string4 = null;
            byte[] byArray = EmuUtil.readFile(file, true, Integer.MAX_VALUE);
            if (byArray != null) {
                if (object == null && string == null) {
                    fileInfo = FileInfo.analyzeFile(byArray, file);
                    if (fileInfo != null && (object3 = fileInfo.getFileFormat()) != null) {
                        try {
                            LoadData loadData;
                            object2 = null;
                            if (object3.equals(FileFormat.BIN)) {
                                string4 = "BCS3-BASIC-Programm";
                                string3 = BCS3.getBasicProgram(byArray);
                            } else if (object3.equals(FileFormat.BASIC_PRG)) {
                                object2 = FileInfo.createLoadData(byArray, (FileFormat)object3);
                            } else if (object3.equals(FileFormat.HEADERSAVE)) {
                                loadData = null;
                                block2 : switch (fileInfo.getFileType()) {
                                    case 65: {
                                        loadData = FileInfo.createLoadData(byArray, (FileFormat)object3);
                                        if (loadData == null) break;
                                        string4 = "EDAS*4-Quelltext";
                                        string3 = SourceUtil.getEDAS4Text(loadData, fileInfo.getBegAddr());
                                        break;
                                    }
                                    case 66: {
                                        object2 = FileInfo.createLoadData(byArray, (FileFormat)object3);
                                        break;
                                    }
                                    case 98: {
                                        loadData = FileInfo.createLoadData(byArray, (FileFormat)object3);
                                        if (loadData == null) break;
                                        switch (loadData.getBegAddr()) {
                                            case 4096: {
                                                string4 = "Z1013-TinyBASIC-Programm";
                                                string3 = Z1013.getTinyBasicProgram(loadData);
                                                break block2;
                                            }
                                            case 5120: {
                                                string4 = "LLC1-TinyBASIC-Programm";
                                                string3 = LLC1.getBasicProgram(loadData);
                                                break block2;
                                            }
                                            case 6336: {
                                                string4 = "AC1-MiniBASIC-Programm";
                                                string3 = AC1.getTinyBasicProgram(loadData);
                                            }
                                        }
                                        break;
                                    }
                                    case 73: 
                                    case 84: {
                                        if (byArray.length <= 32) break;
                                        StringBuilder stringBuilder = new StringBuilder(byArray.length - 32);
                                        boolean bl3 = false;
                                        for (int i = 32; i < byArray.length; ++i) {
                                            int n = byArray[i] & 0xFF;
                                            if (n == 13) {
                                                bl3 = true;
                                                stringBuilder.append('\n');
                                                continue;
                                            }
                                            if (n == 10) {
                                                if (bl3) {
                                                    bl3 = false;
                                                    continue;
                                                }
                                                stringBuilder.append('\n');
                                                continue;
                                            }
                                            if (n == 30) {
                                                stringBuilder.append('\n');
                                                continue;
                                            }
                                            if (n != 9 && n < 32) continue;
                                            stringBuilder.append((char)n);
                                        }
                                        string3 = stringBuilder.toString();
                                        string4 = "Headersave-Textdatei";
                                    }
                                }
                            } else if ((object3.equals(FileFormat.KCB) || object3.equals(FileFormat.KCB_BLKN) || object3.equals(FileFormat.KCB_BLKN_CKS) || object3.equals(FileFormat.KCTAP_BASIC_PRG) || object3.equals(FileFormat.KCBASIC_HEAD_PRG) || object3.equals(FileFormat.KCBASIC_HEAD_PRG_BLKN) || object3.equals(FileFormat.KCBASIC_HEAD_PRG_BLKN_CKS) || object3.equals(FileFormat.KCBASIC_PRG)) && (loadData = FileInfo.createLoadData(byArray, (FileFormat)object3)) != null) {
                                string3 = this.getKCBasicProgram(loadData, fileInfo.getBegAddr());
                                string4 = "KC-BASIC-Programm";
                            }
                            if (object2 != null) {
                                int n = fileInfo.getBegAddr();
                                switch (n) {
                                    case 960: 
                                    case 1024: 
                                    case 1025: {
                                        string4 = "KC-BASIC-Programm";
                                        string3 = this.getKCBasicProgram((LoadData)object2, 1025);
                                        break;
                                    }
                                    case 4097: {
                                        string4 = "KramerMC-BASIC-Programm";
                                        string3 = KramerMC.getBasicProgram((EmuMemView)object2);
                                        break;
                                    }
                                    case 9216: {
                                        string4 = "LC-80ex-BASIC-Programm";
                                        string3 = LC80.getBasicProgram((EmuMemView)object2);
                                        break;
                                    }
                                    case 11200: 
                                    case 11264: 
                                    case 11265: {
                                        string4 = "KC-BASIC-Programm";
                                        string3 = this.getKCBasicProgram((LoadData)object2, 11265);
                                        break;
                                    }
                                    case 24823: 
                                    case 25344: 
                                    case 28599: {
                                        string4 = "AC1/LLC2 BASIC-Programm";
                                        string3 = AC1.getBasicProgram(this.textEditFrm, (LoadData)object2);
                                    }
                                }
                            }
                        }
                        catch (IOException iOException) {
                            string3 = null;
                        }
                    }
                    if (string3 != null) {
                        object3 = new StringBuilder(512);
                        if (string4 != null) {
                            ((StringBuilder)object3).append(string4);
                            if (!string4.endsWith(":")) {
                                ((StringBuilder)object3).append(':');
                            }
                            ((StringBuilder)object3).append('\n');
                        }
                        ((StringBuilder)object3).append("Die Datei ist keine reine Textdatei und kann\ndeshalb auch nicht als solche ge\u00f6ffnet werden.\nDer in der Datei enthaltene Text wird aber\nextrahiert und als neue Textdatei ge\u00f6ffnet.");
                        BaseDlg.showInfoDlg(this.textEditFrm, ((StringBuilder)object3).toString());
                    }
                }
                if (string3 != null) {
                    bl2 = true;
                    object = null;
                } else if (byArray.length > 0) {
                    String string5;
                    string3 = EditText.readText(byArray, (CharConverter)object, bl, (TextProps)object4);
                    if (((TextProps)object4).charsLost && object == null && string == null && (string5 = EditText.readText(byArray, (CharConverter)(object3 = new CharConverter(CharConverter.Encoding.LATIN1)), bl, (TextProps)(object2 = new TextProps(((CharConverter)object3).getEncodingName(), ((CharConverter)object3).toString())))) != null && !((TextProps)object2).charsLost) {
                        string3 = string5;
                        object = object3;
                        object4 = object2;
                    }
                }
            }
            this.used = true;
            this.byteOrderMark = ((TextProps)object4).hasBOM;
            this.charConverter = object;
            this.encodingName = ((TextProps)object4).encodingName;
            this.encodingDesc = ((TextProps)object4).encodingDesc;
            this.eofByte = ((TextProps)object4).eofByte;
            if (bl2) {
                this.file = null;
                this.textName = "Neuer Text (Quelle: " + file.getName() + ")";
                this.setDataUnchanged(false);
            } else {
                this.file = file;
                this.textName = file.getName();
                this.setDataUnchanged(true);
            }
            if (this.textArea != null) {
                this.textArea.setText(string3);
                this.textArea.setCaretPosition(0);
                this.textValue = null;
            } else {
                this.textValue = string3;
            }
            this.undoMngr.discardAllEdits();
            this.textEditFrm.updUndoButtons();
            this.textEditFrm.updCaretButtons();
            this.textEditFrm.updTitle();
            this.charsLostOnOpen = ((TextProps)object4).charsLost;
            if (((TextProps)object4).charsLost) {
                object3 = new StringBuilder(512);
                ((StringBuilder)object3).append("Die Datei enth\u00e4lt Bytes bzw. Bytefolgen, die sich nicht\nals Zeichen im");
                if (object == null && string == null) {
                    ((StringBuilder)object3).append(" Systemzeichensatz");
                } else {
                    ((StringBuilder)object3).append(" dem ausgew\u00e4hlten Zeichensatz");
                }
                ((StringBuilder)object3).append(" abbilden lassen.\nDiese Bytes wurden ignoriert. Sie sollten evtl. versuchen,\ndie Datei mit einem anderen Zeichensatz zu \u00f6ffnen\n(siehe Men\u00fcpunkt '\u00d6ffnen mit Zeichensatz...').");
                object2 = ((StringBuilder)object3).toString();
                final TextEditFrm textEditFrm = this.textEditFrm;
                EventQueue.invokeLater(new Runnable((String)object2){
                    final /* synthetic */ String val$msg;
                    {
                        this.val$msg = string;
                    }

                    @Override
                    public void run() {
                        BaseDlg.showWarningDlg(textEditFrm, this.val$msg);
                    }
                });
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IOException(string + ": Der Zeichensatz wird auf dieser Plattform" + " nicht unterst\u00fctzt.");
        }
    }

    public void removeRowHeader() {
        JScrollPane jScrollPane = this.getJScrollPane();
        if (jScrollPane != null) {
            jScrollPane.setRowHeader(null);
        }
    }

    public void replaceText(String string) {
        boolean bl = false;
        if (this.textArea != null) {
            Document document = this.textArea.getDocument();
            if (document != null) {
                try {
                    int n = document.getLength();
                    if (document instanceof AbstractDocument) {
                        ((AbstractDocument)document).replace(0, n, string, null);
                    } else {
                        if (n > 0) {
                            document.remove(0, n);
                        }
                        if (string != null) {
                            document.insertString(0, string, null);
                        }
                    }
                    bl = true;
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            if (!bl) {
                this.textArea.setText(string);
            }
            this.textArea.setCaretPosition(0);
        } else if (this.textValue != null) {
            this.textValue = string;
        }
        if (!bl) {
            this.undoMngr.discardAllEdits();
        }
        this.textEditFrm.updUndoButtons();
        this.textEditFrm.updCaretButtons();
    }

    public void saveFile(Component component, File file, CharConverter charConverter, String string, String string2, boolean bl, int n, boolean bl2, String string3) throws IOException {
        String string4;
        boolean bl3 = false;
        String string5 = string4 = this.textArea != null ? this.textArea.getText() : this.textValue;
        if (string4 == null) {
            string4 = "";
        }
        if (string3 == null) {
            string3 = System.getProperty("line.separator");
        }
        byte[] byArray = null;
        if (string3 != null && (byArray = string3.getBytes()) != null && byArray.length < 1) {
            byArray = null;
        }
        if (string3 == null) {
            byArray = new byte[]{13, 10};
        }
        OutputStream outputStream = null;
        try {
            outputStream = EmuUtil.createOptionalGZipOutputStream(file);
            BufferedWriter bufferedWriter = null;
            if (charConverter == null) {
                if (string != null) {
                    if (bl) {
                        if (string.equalsIgnoreCase("UTF-8")) {
                            outputStream.write(239);
                            outputStream.write(187);
                            outputStream.write(191);
                        } else if (string.equalsIgnoreCase("UTF-16BE")) {
                            outputStream.write(254);
                            outputStream.write(255);
                        } else if (string.equalsIgnoreCase("UTF-16LE")) {
                            outputStream.write(255);
                            outputStream.write(254);
                        } else {
                            bl = false;
                        }
                    }
                    bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream, string));
                } else {
                    bl = false;
                    bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream));
                }
            }
            int n2 = string4.length();
            if (bl2) {
                int n3 = -1;
                block9: for (int i = 0; i < n2; ++i) {
                    char c = string4.charAt(i);
                    switch (c) {
                        case '\n': {
                            if (bufferedWriter != null) {
                                this.writeLineEnd(bufferedWriter, string3);
                            } else {
                                outputStream.write(byArray);
                            }
                            n3 = -1;
                            continue block9;
                        }
                        case '\t': 
                        case ' ': {
                            if (n3 >= 0) continue block9;
                            n3 = i;
                            continue block9;
                        }
                        default: {
                            if (n3 >= 0) {
                                for (int j = n3; j < i; ++j) {
                                    char c2 = string4.charAt(j);
                                    if (bufferedWriter != null) {
                                        bufferedWriter.write(c2);
                                        continue;
                                    }
                                    outputStream.write(c2 & 0xFF);
                                }
                                n3 = -1;
                            }
                            if (bufferedWriter != null) {
                                bufferedWriter.write(c);
                                continue block9;
                            }
                            if (this.writeChar(outputStream, charConverter, c)) continue block9;
                            bl3 = true;
                        }
                    }
                }
            } else if (bufferedWriter != null) {
                for (int i = 0; i < n2; ++i) {
                    char c = string4.charAt(i);
                    if (c == '\n') {
                        this.writeLineEnd(bufferedWriter, string3);
                        continue;
                    }
                    bufferedWriter.write(c);
                }
            } else {
                for (int i = 0; i < n2; ++i) {
                    char c = string4.charAt(i);
                    if (c == '\n') {
                        outputStream.write(byArray);
                        continue;
                    }
                    if (this.writeChar(outputStream, charConverter, c)) continue;
                    bl3 = true;
                }
            }
            if (bufferedWriter != null) {
                if (n >= 0) {
                    bufferedWriter.write(n);
                }
                bufferedWriter.flush();
                bufferedWriter.close();
            } else {
                if (n >= 0) {
                    outputStream.write(n);
                }
                outputStream.close();
            }
            outputStream = null;
            if (!this.isSameFile(file)) {
                this.setProjectChanged(true);
                this.prjFile = null;
            }
            this.file = file;
            this.charConverter = charConverter;
            this.encodingName = string;
            this.encodingDesc = string2;
            this.byteOrderMark = bl;
            this.eofByte = n;
            this.trimLines = bl2;
            this.lineEnd = string3;
            this.textName = this.file.getName();
            this.setDataUnchanged(true);
            this.textEditFrm.updTitle();
            if (bl3) {
                BaseDlg.showWarningDlg(component, "Der Text enth\u00e4lt Zeichen, die in dem gew\u00fcnschten\nZeichensatz nicht existieren und somit auch nicht\ngespeichert werden k\u00f6nnen, d.h.,\ndiese Zeichen fehlen in der gespeicherten Datei.");
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IOException(string2 + ": Der Zeichensatz wird auf dieser Plattform" + " nicht unterst\u00fctzt.");
        }
        finally {
            EmuUtil.closeSilent(outputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveProject(Frame frame, boolean bl) {
        boolean bl2 = false;
        if (this.file != null) {
            Object object;
            String string;
            Serializable serializable;
            Object object2;
            File file = this.prjFile;
            if (file == null || bl) {
                object2 = file;
                if (object2 == null) {
                    serializable = this.file.getParentFile();
                    string = this.file.getName();
                    if (string != null) {
                        object = string;
                        int n = string.lastIndexOf(46);
                        if (n >= 0 && n < string.length()) {
                            object = string.substring(0, n);
                        }
                        object = (String)object + ".prj";
                        object2 = serializable != null ? new File((File)serializable, (String)object) : new File((String)object);
                    }
                }
                file = EmuUtil.showFileSaveDlg(frame, "Projekt speichern", (File)object2, EmuUtil.getProjectFileFilter());
            }
            if (file != null) {
                object2 = null;
                try {
                    object2 = new FileOutputStream(file);
                    serializable = new Properties();
                    ((Properties)serializable).setProperty(PROP_PROPERTIES_TYPE, VALUE_PROPERTIES_TYPE_PROJECT);
                    string = this.file.getPath();
                    object = file.getParentFile();
                    if (object != null) {
                        String string2 = ((File)object).getPath();
                        if (!string2.endsWith(File.separator)) {
                            string2 = string2 + File.separator;
                        }
                        int n = string2.length();
                        if (string.startsWith(string2) && string.length() > n) {
                            string = string.substring(n);
                        }
                    }
                    ((Properties)serializable).setProperty(PROP_PRG_SOURCE_FILE_NAME, string);
                    if (this.prgOptions == null) {
                        this.prgOptions = new BasicOptions();
                    }
                    this.prgOptions.putOptionsTo((Properties)serializable);
                    ((Properties)serializable).storeToXML((OutputStream)object2, "Programming Options");
                    ((OutputStream)object2).close();
                    object2 = null;
                    bl2 = true;
                    this.prjFile = file;
                    this.prjChanged = true;
                    this.setProjectChanged(false);
                    Main.setLastFile(file, VALUE_PROPERTIES_TYPE_PROJECT);
                }
                catch (IOException iOException) {
                    BaseDlg.showErrorDlg((Component)frame, "Speichern des Projektes fehlgeschlagen:\n" + iOException.getMessage());
                }
                finally {
                    EmuUtil.closeSilent((Closeable)object2);
                }
            }
        } else {
            BaseDlg.showErrorDlg((Component)frame, "Das Projekt kann nicht gespeichert werden,\nda kein Dateiname f\u00fcr den Quelltext bekannt ist.\nSpeichern Sie bitte zuerst den Quelltext\nund dann das Projekt.");
        }
        return bl2;
    }

    public void setAskFileNameOnSave(boolean bl) {
        this.askFileNameOnSave = bl;
    }

    public void setCaretPosition(int n) {
        if (this.textArea != null) {
            try {
                this.textArea.setCaretPosition(n);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    public void setComponents(Component component, JTextArea jTextArea) {
        this.tabComponent = component;
        this.textArea = jTextArea;
        if (this.textArea != null) {
            this.textArea.setText(this.textValue);
            this.textArea.setCaretPosition(0);
            this.textArea.addCaretListener(this);
            this.textValue = null;
            Document document = this.textArea.getDocument();
            if (document != null) {
                document.addDocumentListener(this);
                document.addUndoableEditListener(this);
            }
        }
        this.disableDropTargets();
        if (component != null) {
            this.dropTarget1 = new DropTarget(component, this.textEditFrm);
            this.dropTarget1.setActive(true);
        }
        if (jTextArea != null) {
            this.dropTarget2 = new DropTarget(jTextArea, this.textEditFrm);
            this.dropTarget2.setActive(true);
        }
    }

    public void setDataChanged() {
        boolean bl = this.dataChanged;
        this.dataChanged = true;
        this.saved = false;
        if (this.dataChanged != bl) {
            this.textEditFrm.dataChangedStateChanged(this);
        }
    }

    public void setPrgOptions(PrgOptions prgOptions) {
        boolean bl = true;
        if (this.prgOptions != null && prgOptions != null) {
            bl = !this.prgOptions.equals(prgOptions);
        }
        this.prgOptions = prgOptions;
        this.setProjectChanged(bl);
    }

    public void setProject(File file, Properties properties) {
        this.prgOptions = PrgOptions.getPrgOptions(properties);
        this.prjFile = file;
        this.prjChanged = false;
    }

    public void setProjectChanged(boolean bl) {
        boolean bl2 = this.prjChanged;
        this.prjChanged = bl;
        if (this.prjChanged != bl2) {
            this.textEditFrm.dataChangedStateChanged(this);
        }
    }

    public void setText(String string) {
        if (this.textArea != null) {
            this.textArea.setText(string);
            this.textArea.setCaretPosition(0);
        } else if (this.textValue != null) {
            this.textValue = string;
        }
        this.undoMngr.discardAllEdits();
        this.textEditFrm.updUndoButtons();
        this.textEditFrm.updCaretButtons();
        this.textEditFrm.updTitle();
        this.setDataUnchanged(false);
    }

    public void setResultEditText(EditText editText) {
        this.resultEditText = editText;
    }

    public void undo() {
        if (this.undoMngr.canUndo()) {
            this.undoMngr.undo();
        }
        this.textEditFrm.updUndoButtons();
    }

    @Override
    public void caretUpdate(CaretEvent caretEvent) {
        this.textEditFrm.caretPositionChanged();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.setDataChanged();
        this.used = true;
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.setDataChanged();
        this.used = true;
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.setDataChanged();
        this.used = true;
    }

    @Override
    public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
        this.undoMngr.undoableEditHappened(undoableEditEvent);
        this.textEditFrm.updUndoButtons();
    }

    private void init(TextEditFrm textEditFrm) {
        this.textEditFrm = textEditFrm;
        this.undoMngr = new UndoManager();
        this.prgOptions = null;
        this.file = null;
        this.charConverter = null;
        this.encodingName = null;
        this.encodingDesc = null;
        this.lineEnd = null;
        this.resultEditText = null;
        this.textName = null;
        this.textValue = null;
        this.textArea = null;
        this.tabComponent = null;
        this.dropTarget1 = null;
        this.dropTarget2 = null;
        this.used = false;
        this.charsLostOnOpen = false;
        this.dataChanged = false;
        this.prjChanged = false;
        this.saved = true;
        this.askFileNameOnSave = false;
        this.byteOrderMark = false;
        this.trimLines = false;
        this.eofByte = -1;
    }

    private void disableDropTargets() {
        DropTarget dropTarget = this.dropTarget1;
        if (dropTarget != null) {
            this.dropTarget1 = null;
            dropTarget.setActive(false);
        }
        if ((dropTarget = this.dropTarget2) != null) {
            this.dropTarget2 = null;
            dropTarget.setActive(false);
        }
    }

    private String getKCBasicProgram(LoadData loadData, int n) throws UserCancelException {
        String string = null;
        String string2 = SourceUtil.getBasicProgram(loadData, n, KC85.basicTokens);
        String string3 = SourceUtil.getBasicProgram(loadData, n, Z9001.basicTokens);
        String string4 = SourceUtil.getBasicProgram(loadData, n, Z1013.basicTokens);
        if (string2 != null && string4 != null && string3 != null && string2.equals(string4) && string2.equals(string3)) {
            string = string2;
            string2 = null;
            string4 = null;
            string3 = null;
        }
        if (string == null && (string2 != null || string4 != null || string3 != null)) {
            int n2;
            String string5;
            ArrayList<String> arrayList = new ArrayList<String>(3);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            if (string2 != null) {
                string5 = "KC85/2...5";
                arrayList.add(string5);
                hashMap.put(string5, string2);
            }
            if (string3 != null) {
                string5 = "KC87, Z9001";
                arrayList.add(string5);
                hashMap.put(string5, string3);
            }
            if (string4 != null) {
                string5 = "Z1013";
                arrayList.add(string5);
                hashMap.put(string5, string4);
            }
            if ((n2 = arrayList.size()) == 1) {
                String string6 = (String)arrayList.get(0);
                if (string6 != null) {
                    string = (String)hashMap.get(string6);
                }
            } else if (n2 > 1) {
                try {
                    arrayList.add("Abbrechen");
                    Object[] objectArray = arrayList.toArray(new String[n2 + 1]);
                    if (objectArray != null) {
                        JOptionPane jOptionPane = new JOptionPane("Das KC-BASIC-Programm enth\u00e4lt Tokens, die auf den einzelnen\nSystemen unterschiedliche Anweisungen repr\u00e4sentieren.\nAuf welchem System wurde das BASIC-Programm erstellt?", 3);
                        jOptionPane.setOptions(objectArray);
                        jOptionPane.setWantsInput(false);
                        jOptionPane.createDialog(this.textEditFrm, "BASIC-Version").setVisible(true);
                        Object object = jOptionPane.getValue();
                        if (object != null) {
                            string = (String)hashMap.get(object);
                        }
                        if (string == null) {
                            throw new UserCancelException();
                        }
                    }
                }
                catch (ArrayStoreException arrayStoreException) {
                    // empty catch block
                }
            }
        }
        return string;
    }

    private JScrollPane getJScrollPane() {
        JScrollPane jScrollPane = null;
        for (Component component = this.tabComponent; jScrollPane == null && component != null; component = component.getParent()) {
            if (!(component instanceof JScrollPane)) continue;
            jScrollPane = (JScrollPane)component;
            break;
        }
        return jScrollPane;
    }

    private static int readChar(Reader reader, InputStream inputStream, CharConverter charConverter) throws IOException {
        int n = -1;
        if (reader != null) {
            n = reader.read();
        } else {
            n = inputStream.read();
            if (n != -1 && charConverter != null) {
                n = charConverter.toUnicode(n);
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readText(byte[] byArray, CharConverter charConverter, boolean bl, TextProps textProps) throws IOException {
        PushbackInputStream pushbackInputStream;
        PushbackReader pushbackReader;
        StringBuilder stringBuilder;
        block50: {
            stringBuilder = new StringBuilder(byArray.length);
            pushbackReader = null;
            pushbackInputStream = null;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            try {
                int n;
                int n2;
                String string = null;
                int n3 = 0;
                if (byArray.length >= 2) {
                    n2 = byArray[0] & 0xFF;
                    n = byArray[1] & 0xFF;
                    if (n2 == 254 && n == 255) {
                        string = "UTF-16BE";
                        n3 = 2;
                    } else if (n2 == 255 && n == 254) {
                        string = "UTF-16LE";
                        n3 = 2;
                    } else if (n2 == 239 && n == 187 && byArray.length >= 3 && (byArray[2] & 0xFF) == 191) {
                        string = "UTF-8";
                        n3 = 3;
                    }
                }
                if (string != null) {
                    if (charConverter == null && textProps.encodingName == null) {
                        textProps.encodingName = string;
                        textProps.encodingDesc = string + TEXT_WITH_BOM;
                        textProps.hasBOM = true;
                    } else if (textProps.encodingName != null && textProps.encodingName.equals(string)) {
                        textProps.encodingDesc = string + TEXT_WITH_BOM;
                        textProps.hasBOM = true;
                    }
                }
                if (!textProps.hasBOM) {
                    n3 = 0;
                }
                pushbackInputStream = new PushbackInputStream(new ByteArrayInputStream(byArray, n3, byArray.length - n3));
                if (charConverter == null) {
                    pushbackReader = textProps.encodingName != null ? new PushbackReader(new InputStreamReader((InputStream)pushbackInputStream, textProps.encodingName)) : new PushbackReader(new InputStreamReader(pushbackInputStream));
                }
                n2 = EditText.readChar(pushbackReader, pushbackInputStream, charConverter);
                while (n2 != -1 && n2 != 10 && n2 != 13 && n2 != 30) {
                    if (!bl && n2 == 26) {
                        textProps.eofByte = n2;
                        n2 = -1;
                        break;
                    }
                    if (n2 == 65533) {
                        textProps.charsLost = true;
                    } else {
                        stringBuilder.append((char)n2);
                    }
                    n2 = EditText.readChar(pushbackReader, pushbackInputStream, charConverter);
                }
                if (n2 == 13) {
                    bl3 = true;
                    stringBuilder.append('\n');
                    n2 = EditText.readChar(pushbackReader, pushbackInputStream, charConverter);
                    if (n2 == 65533) {
                        textProps.charsLost = true;
                    } else if (n2 == 10) {
                        bl4 = true;
                    } else if (n2 != -1) {
                        if (pushbackReader != null) {
                            pushbackReader.unread(n2);
                        } else {
                            pushbackInputStream.unread(n2);
                        }
                    }
                } else if (n2 == 10) {
                    stringBuilder.append('\n');
                    bl4 = true;
                } else if (n2 == 30) {
                    stringBuilder.append('\n');
                    bl2 = true;
                }
                if (n2 != -1) {
                    n = 0;
                    n2 = EditText.readChar(pushbackReader, pushbackInputStream, charConverter);
                    while (n2 >= 0) {
                        if (!bl && n2 == 26) {
                            textProps.eofByte = n2;
                            break;
                        }
                        if (n2 == 65533) {
                            textProps.charsLost = true;
                        } else if (n2 == 13) {
                            stringBuilder.append('\n');
                            n = 1;
                        } else {
                            if (n2 == 10) {
                                if (n == 0) {
                                    stringBuilder.append((char)n2);
                                }
                            } else if (n2 == 30 || n2 == 12) {
                                stringBuilder.append('\n');
                            } else if (n2 != 0 && n2 != 3 && n2 != 4) {
                                stringBuilder.append((char)n2);
                            }
                            n = 0;
                        }
                        n2 = EditText.readChar(pushbackReader, pushbackInputStream, charConverter);
                    }
                }
                if (pushbackReader != null) {
                    pushbackReader.close();
                    pushbackReader = null;
                } else {
                    pushbackInputStream.close();
                }
                pushbackInputStream = null;
                if (bl3) {
                    if (bl4) {
                        textProps.lineEnd = "\r\n";
                    } else {
                        textProps.lineEnd = "\r";
                    }
                    break block50;
                }
                if (bl4) {
                    textProps.lineEnd = "\n";
                    break block50;
                }
                if (bl2) {
                    textProps.lineEnd = "\u001e";
                    break block50;
                }
                textProps.lineEnd = null;
            }
            catch (Throwable throwable) {
                EmuUtil.closeSilent(pushbackReader);
                EmuUtil.closeSilent(pushbackInputStream);
                throw throwable;
            }
        }
        EmuUtil.closeSilent(pushbackReader);
        EmuUtil.closeSilent(pushbackInputStream);
        return stringBuilder.toString();
    }

    private void setDataUnchanged(final boolean bl) {
        final EditText editText = this;
        editText.dataChanged = false;
        editText.saved = bl;
        editText.charsLostOnOpen = false;
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                editText.dataChanged = false;
                editText.saved = bl;
                if (editText.textEditFrm != null) {
                    editText.textEditFrm.dataChangedStateChanged(editText);
                }
            }
        });
    }

    private boolean writeChar(OutputStream outputStream, CharConverter charConverter, int n) throws IOException {
        boolean bl = false;
        if (n > 0 && charConverter != null) {
            n = charConverter.toCharsetByte((char)n);
        }
        if (n > 0 && n <= 255) {
            outputStream.write(n);
            bl = true;
        }
        return bl;
    }

    private void writeLineEnd(BufferedWriter bufferedWriter, String string) throws IOException {
        if (string != null) {
            bufferedWriter.write(string);
        } else {
            bufferedWriter.newLine();
        }
    }

    private static class TextProps {
        private String encodingName;
        private String encodingDesc;
        private String lineEnd;
        private boolean hasBOM;
        private boolean charsLost;
        private int eofByte;

        private TextProps(String string, String string2) {
            this.encodingName = string;
            this.encodingDesc = string2;
            this.lineEnd = null;
            this.hasBOM = false;
            this.charsLost = false;
            this.eofByte = -1;
        }
    }
}

