/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.programming.basic.target;

import jkcemu.base.EmuSys;
import jkcemu.emusys.Z9001;
import jkcemu.programming.basic.AsmCodeBuf;
import jkcemu.programming.basic.BasicCompiler;
import jkcemu.programming.basic.BasicLibrary;
import jkcemu.programming.basic.target.Z9001Target;

public class Z9001KRTTarget
extends Z9001Target {
    public static final String BASIC_TARGET_NAME = "TARGET_Z9001_KRT";
    private boolean needsScreenSizeChar;
    private boolean needsScreenSizePixel;
    private boolean usesScreens;
    private boolean usesPaint;

    public Z9001KRTTarget() {
        this.setNamedValue("GRAPHICSCREEN", 1);
        this.setNamedValue("LASTSCREEN", 1);
    }

    @Override
    public void appendBssTo(AsmCodeBuf asmCodeBuf) {
        super.appendBssTo(asmCodeBuf);
        if (this.usesPaint) {
            asmCodeBuf.append("X_M_PBANK:\tDS\t1\n");
        }
        if (this.usesScreens) {
            asmCodeBuf.append("X_M_SCREEN:\tDS\t1\n");
        }
    }

    @Override
    public void appendEtcPastXOutTo(AsmCodeBuf asmCodeBuf) {
        if (this.needsScreenSizeChar) {
            if (this.usesScreens) {
                asmCodeBuf.append("X_HCHR:\tLD\tHL,001BH\n\tJR\tX_SSZC\nX_WCHR:\tLD\tHL,0028H\nX_SSZC:\tLD\tA,(X_M_SCREEN)\n\tOR\tA\n\tRET\tZ\n\tLD\tL,00H\n\tRET\n");
            } else {
                asmCodeBuf.append("X_HCHR:\tLD\tHL,001BH\n\tRET\nX_WCHR:\tLD\tHL,0028H\n\tRET\n");
            }
        }
        if (this.needsScreenSizePixel) {
            if (this.usesScreens) {
                asmCodeBuf.append("X_HPIX:\tLD\tHL,00C0H\n\tJR\tX_HWPIX1\nX_WPIX:\tLD\tHL,0140H\nX_HWPIX1:\n\tLD\tA,(X_M_SCREEN)\n\tDEC\tA\n\tRET\tZ\n\tLD\tHL,0000H\n\tRET\n");
            } else {
                asmCodeBuf.append("X_HPIX:\nX_WPIX:\tLD\tHL,0000H\n\tRET\n");
            }
        }
    }

    @Override
    public void appendPreExitTo(AsmCodeBuf asmCodeBuf) {
        if (this.usesScreens) {
            asmCodeBuf.append("\tLD\tL,00H\n\tCALL\tXSCRN1\n");
        }
    }

    @Override
    public void appendHCharTo(AsmCodeBuf asmCodeBuf) {
        asmCodeBuf.append("\tCALL\tX_HCHR\n");
        this.needsScreenSizeChar = true;
    }

    @Override
    public void appendHPixelTo(AsmCodeBuf asmCodeBuf) {
        asmCodeBuf.append("\tCALL\tX_HPIX\n");
        this.needsScreenSizePixel = true;
    }

    @Override
    public void appendInitTo(AsmCodeBuf asmCodeBuf) {
        super.appendInitTo(asmCodeBuf);
        if (this.usesScreens) {
            asmCodeBuf.append("\tXOR\tA\n\tLD\t(X_M_SCREEN),A\n\tOUT\t(0B8H),A\n");
        }
    }

    @Override
    public void appendSwitchToTextScreenTo(AsmCodeBuf asmCodeBuf) {
        if (this.usesScreens) {
            asmCodeBuf.append("\tLD\tL,00H\n\tCALL\tXSCRN1\n");
        }
    }

    @Override
    public void appendWCharTo(AsmCodeBuf asmCodeBuf) {
        asmCodeBuf.append("\tCALL\tX_WCHR\n");
        this.needsScreenSizeChar = true;
    }

    @Override
    public void appendWPixelTo(AsmCodeBuf asmCodeBuf) {
        asmCodeBuf.append("\tCALL\tX_WPIX\n");
        this.needsScreenSizePixel = true;
    }

    @Override
    public void appendXClsTo(AsmCodeBuf asmCodeBuf) {
        if (this.usesScreens) {
            asmCodeBuf.append("XCLS:\tLD\tA,(X_M_SCREEN)\n\tCP\t01\n\tJR\tZ,XCLS1\n\tLD\tA,0CH\n\tJR\tXOUTCH\nXCLS1:\tDI\n\tLD\tA,08H\nXCLS2:\tOUT\t(0B8H),A\n\tPUSH\tAF\n\tXOR\tA\n\tLD\tHL,0EC00H\n\tLD\t(HL),A\n\tLD\tDE,0EC01H\n\tLD\tBC,03BFH\n\tLDIR\n\tPOP\tAF\n\tINC\tA\n\tCP\t10H\n\tJR\tC,XCLS2\n\tLD\tA,08\n\tOUT\t(0B8H),A\n\tEI\n");
            if (this.usesColors) {
                asmCodeBuf.append("\tLD\tHL,0E800H\n\tLD\tA,(0027H)\n\tLD\t(HL),A\n\tLD\tDE,0E801H\n\tLD\tBC,03BFH\n\tLDIR\n");
            }
            asmCodeBuf.append("\tRET\n");
        } else {
            asmCodeBuf.append("XCLS:\tLD\tA,0CH\n\tJR\tXOUTCH\n");
        }
        this.appendXOutchTo(asmCodeBuf);
    }

    @Override
    public void appendXHLineTo(AsmCodeBuf asmCodeBuf, BasicCompiler basicCompiler) {
        asmCodeBuf.append("XHLINE:\tBIT\t7,B\n\tRET\tNZ\n\tPUSH\tBC\n\tPUSH\tDE\n\tPUSH\tHL\n\tCALL\tX_PST\n\tLD\tA,B\n\tEXX\n\tPOP\tHL\n\tPOP\tDE\n\tPOP\tBC\n\tRET\tC\n\tLD\tD,00H\nXHLINE1:\n\tOR\tD\n\tLD\tD,A\n\tSRL\tA\n\tJR\tNC,XHLINE2\n\tLD\tA,D\n\tEXX\n\tLD\tB,A\n\tCALL\tXPSET_B\n");
        if (this.usesColors) {
            asmCodeBuf.append("\tSET\t2,H\n");
        }
        asmCodeBuf.append("\tINC\tHL\n\tEXX\n\tLD\tA,80H\n\tLD\tD,00H\nXHLINE2:\n\tDEC\tBC\n\tBIT\t7,B\n\tJR\tZ,XHLINE1\n\tLD\tA,D\n\tOR\tA\n\tRET\tZ\n\tEXX\n\tLD\tB,A\n\tJR\tXPSET_B\n");
        this.appendXPSetTo(asmCodeBuf, basicCompiler);
    }

    @Override
    public void appendXOutchTo(AsmCodeBuf asmCodeBuf) {
        if (!this.xoutchAppended) {
            asmCodeBuf.append("XOUTCH:\tLD\tE,A\n");
            if (this.usesScreens) {
                asmCodeBuf.append("\tLD\tA,(X_M_SCREEN)\n\tOR\tA\n\tRET\tNZ\n");
            }
            asmCodeBuf.append("\tLD\tC,2\n\tJP\t0005H\n");
            this.xoutchAppended = true;
        }
    }

    @Override
    public void appendXPaintTo(AsmCodeBuf asmCodeBuf, BasicCompiler basicCompiler) {
        asmCodeBuf.append("XPAINT_LEFT:\n\tLD\tDE,(PAINT_M_X)\n\tLD\tA,D\n\tOR\tE\n\tJR\tZ,XPAINT_LEFT6\n\tLD\tHL,(PAINT_M_Y)\n\tDEC\tDE\n\tPUSH\tDE\n\tCALL\tX_PST\n\tLD\tA,C\n\tLD\t(X_M_PBANK),A\n\tPOP\tDE\n\tJR\tC,XPAINT_LEFT5\n\tLD\tC,B\n\tCALL\tXPAINT_RD_B\nXPAINT_LEFT1:\n\tLD\tA,B\nXPAINT_LEFT2:\n\tAND\tC\n\tJR\tNZ,XPAINT_LEFT4\n\tLD\tA,B\n\tOR\tC\n\tLD\tB,A\n\tDEC\tDE\n\tSLA\tC\n\tJR\tNC,XPAINT_LEFT2\n\tCALL\tXPAINT_WR_B\n\tDEC\tHL\n\tBIT\t0,D\n\tJR\tZ,XPAINT_LEFT3\n\tLD\tA,E\n\tINC\tA\n\tJR\tZ,XPAINT_LEFT5\nXPAINT_LEFT3:\n\tCALL\tXPAINT_RD_B\n\tLD\tC,01H\n\tJR\tXPAINT_LEFT1\nXPAINT_LEFT4:\n\tCALL\tXPAINT_WR_B\nXPAINT_LEFT5:\n\tINC\tDE\nXPAINT_LEFT6:\n\tLD\t(PAINT_M_X1),DE\n\tRET\nXPAINT_RIGHT:\n\tLD\tDE,(PAINT_M_X)\n\tLD\tHL,(PAINT_M_Y)\n\tPUSH\tDE\n\tCALL\tX_PST\n\tPOP\tDE\n\tRET\tC\n\tLD\tA,C\n\tLD\t(X_M_PBANK),A\n\tLD\tC,B\n\tCALL\tXPAINT_RD_B\n\tLD\tA,C\n\tAND\tB\n\tSCF\n\tRET\tNZ\n\tJR\tXPAINT_RIGHT3\nXPAINT_RIGHT1:\n\tLD\tA,B\nXPAINT_RIGHT2:\n\tAND\tC\n\tJR\tNZ,XPAINT_RIGHT5\nXPAINT_RIGHT3:\n\tLD\tA,B\n\tOR\tC\n\tLD\tB,A\n\tINC\tDE\n\tSRL\tC\n\tJR\tNC,XPAINT_RIGHT2\n\tCALL\tXPAINT_WR_B\n\tINC\tHL\n\tLD\tA,E\n\tCP\t40H\n\tJR\tNZ,XPAINT_RIGHT4\n\tLD\tA,D\n\tDEC\tA\n\tJR\tZ,XPAINT_RIGHT6\nXPAINT_RIGHT4:\n\tCALL\tXPAINT_RD_B\n\tLD\tC,80H\n\tJR\tXPAINT_RIGHT1\nXPAINT_RIGHT5:\n\tCALL\tXPAINT_WR_B\nXPAINT_RIGHT6:\n\tDEC\tDE\n\tLD\t(PAINT_M_X2),DE\n\tOR\tA\n\tRET\nXPAINT_RD_B:\n\tDI\n\tLD\tA,(X_M_PBANK)\n\tOUT\t(0B8H),A\n\tLD\tB,(HL)\n\tLD\tA,08H\n\tOUT\t(0B8H),A\n\tEI\n\tRET\nXPAINT_WR_B:\n\tDI\n\tLD\tA,(X_M_PBANK)\n\tOUT\t(0B8H),A\n\tLD\t(HL),B\n\tLD\tA,08H\n\tOUT\t(0B8H),A\n\tEI\n");
        if (this.usesColors) {
            asmCodeBuf.append("\tRES\t2,H\n\tLD\tA,(0027H)\n\tLD\t(HL),A\n\tSET\t2,H\n");
        }
        asmCodeBuf.append("\tRET\n");
        this.appendPixUtilTo(asmCodeBuf, basicCompiler);
        this.usesPaint = true;
    }

    @Override
    public void appendXPointTo(AsmCodeBuf asmCodeBuf, BasicCompiler basicCompiler) {
        if (this.usesScreens) {
            asmCodeBuf.append("XPOINT:\tLD\tA,(X_M_SCREEN)\n\tCP\t01H\n\tJR\tNZ,XPOINT2\n\tCALL\tX_PST1\n\tJR\tC,XPOINT2\n\tDI\n\tLD\tA,C\n\tOUT\t(0B8H),A\n\tLD\tA,B\n\tAND\t(HL)\n\tLD\tD,A\n\tLD\tA,08H\n\tOUT\t(0B8H),A\n\tEI\n\tRES\t2,H\n\tLD\tA,D\n\tOR\tA\n\tLD\tA,(HL)\n\tLD\tE,07H\n\tJR\tZ,XPOINT1\n\tSRL\tA\n\tSRL\tA\n\tSRL\tA\n\tSRL\tA\n\tLD\tE,0FH\nXPOINT1:\n\tAND\tE\n\tLD\tL,A\n\tLD\tH,00H\n\tRET\nXPOINT2:\n\tLD\tHL,0FFFFH\n\tRET\n");
            this.appendPixUtilTo(asmCodeBuf, basicCompiler);
        } else {
            asmCodeBuf.append("XPOINT:\tLD\tHL,0FFFFH\n\tRET\n");
        }
    }

    @Override
    public void appendXPResTo(AsmCodeBuf asmCodeBuf, BasicCompiler basicCompiler) {
        asmCodeBuf.append("XPRES:\tCALL\tX_PST\n\tRET\tC\n");
        if (this.usesX_M_PEN) {
            asmCodeBuf.append("\tJR\tXPSET1\n");
        } else {
            asmCodeBuf.append("\tDI\n\tLD\tA,C\n\tOUT\t(0B8H),A\n\tLD\tA,B\n\tCPL\n\tAND\t(HL)\n\tJR\tXPSET_WR_A\n");
        }
        this.appendXPSetTo(asmCodeBuf, basicCompiler);
    }

    @Override
    public void appendXPSetTo(AsmCodeBuf asmCodeBuf, BasicCompiler basicCompiler) {
        if (!this.xpsetAppended) {
            asmCodeBuf.append("XPSET:\tCALL\tX_PST\n\tRET\tC\nXPSET_B:\n");
            if (this.usesX_M_PEN) {
                asmCodeBuf.append("\tLD\tA,(X_M_PEN)\n\tDEC\tA\n\tJR\tZ,XPSET2\n\tDEC\tA\n\tJR\tZ,XPSET1\n\tDEC\tA\n\tRET\tNZ\n\tDI\n\tLD\tA,C\n\tOUT\t(0B8H),A\n\tLD\tA,B\n\tXOR\t(HL)\n\tJR\tXPSET_WR_A\nXPSET1:\tDI\n\tLD\tA,C\n\tOUT\t(0B8H),A\n\tLD\tA,B\n\tCPL\n\tAND\t(HL)\n\tJR\tXPSET_WR_A\n");
            }
            asmCodeBuf.append("XPSET2:\tDI\n\tLD\tA,C\n\tOUT\t(0B8H),A\n\tLD\tA,B\n\tOR\t(HL)\nXPSET_WR_A:\n\tLD\t(HL),A\n\tLD\tA,08H\n\tOUT\t(0B8H),A\n\tEI\n");
            if (this.usesColors) {
                asmCodeBuf.append("\tRES\t2,H\n\tLD\tA,(0027H)\n\tLD\t(HL),A\n");
            }
            asmCodeBuf.append("\tRET\n");
            this.appendPixUtilTo(asmCodeBuf, basicCompiler);
            this.xpsetAppended = true;
        }
    }

    @Override
    public void appendXPTestTo(AsmCodeBuf asmCodeBuf, BasicCompiler basicCompiler) {
        if (this.usesScreens) {
            asmCodeBuf.append("XPTEST:\tLD\tA,(X_M_SCREEN)\n\tCP\t01H\n\tJR\tNZ,XPTST1\n\tCALL\tX_PST1\n\tJR\tC,XPTST1\n\tDI\n\tLD\tA,C\n\tOUT\t(0B8H),A\n\tLD\tA,B\n\tAND\t(HL)\n\tLD\tA,08H\n\tOUT\t(0B8H),A\n\tEI\n\tLD\tHL,0000H\n\tRET\tZ\n\tINC\tHL\n\tRET\nXPTST1:\tLD\tHL,0FFFFH\n\tRET\n");
            this.appendPixUtilTo(asmCodeBuf, basicCompiler);
        } else {
            asmCodeBuf.append("XPTEST:\tLD\tHL,0FFFFH\n\tRET\n");
        }
    }

    @Override
    public void appendXScreenTo(AsmCodeBuf asmCodeBuf) {
        if (this.usesScreens) {
            asmCodeBuf.append("XSCREEN:\n\tLD\tA,H\n\tOR\tA\n\tJR\tNZ,XSCRN2\nXSCRN1:\tLD\tA,(X_M_SCREEN)\n\tCP\tL\n\tRET\tZ\n\tLD\tA,L\n\tOR\tA\n\tJR\tZ,XSCRN3\n\tCP\t01H\n\tJR\tZ,XSCRN4\nXSCRN2:\tSCF\n\tRET\nXSCRN3:\tLD\tDE,0800H\n\tJR\tXSCRN5\nXSCRN4:\tLD\tC,29\n\tCALL\t0005H\n\tLD\tDE,0008H\nXSCRN5:\tLD\t(X_M_SCREEN),A\n\tLD\tBC,40B8H\n\tLD\tHL,0EFC0H\n\tDI\nXSCRN6:\tOUT\t(C),D\n\tLD\tA,(HL)\n\tOUT\t(C),E\n\tLD\t(HL),A\n\tINC\tHL\n\tDJNZ\tXSCRN6\n\tEI\n\tOR\tA\n\tRET\n");
        }
    }

    @Override
    public String[] getBasicTargetNames() {
        return Z9001KRTTarget.add(super.getBasicTargetNames(), BASIC_TARGET_NAME);
    }

    @Override
    public int getCompatibilityLevel(EmuSys emuSys) {
        int n = 0;
        if (emuSys != null && emuSys instanceof Z9001) {
            n = 1;
            if (((Z9001)emuSys).emulatesGraphicsKRT()) {
                n = 3;
            }
        }
        return n;
    }

    @Override
    public void preAppendLibraryCode(BasicCompiler basicCompiler) {
        super.preAppendLibraryCode(basicCompiler);
        if (basicCompiler.usesLibItem(BasicLibrary.LibItem.SCREEN) || basicCompiler.usesLibItem(BasicLibrary.LibItem.XSCREEN)) {
            this.usesScreens = true;
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.needsScreenSizeChar = false;
        this.needsScreenSizePixel = false;
        this.usesScreens = false;
        this.usesPaint = false;
    }

    @Override
    public boolean supportsGraphics() {
        return true;
    }

    @Override
    public boolean supportsXCLS() {
        return true;
    }

    @Override
    public boolean supportsXHLINE() {
        return true;
    }

    @Override
    public boolean supportsXPAINT_LEFT_RIGHT() {
        return true;
    }

    @Override
    public String toString() {
        return "KC85/1, KC87, Z9001 mit KRT-Grafik";
    }

    private void appendPixUtilTo(AsmCodeBuf asmCodeBuf, BasicCompiler basicCompiler) {
        if (!this.pixUtilAppended) {
            if (this.usesScreens) {
                asmCodeBuf.append("X_PST:\tLD\tA,(X_M_SCREEN)\n\tCP\t01H\n\tJR\tNZ,X_PST5\nX_PST1:\tLD\tA,D\n\tOR\tA\n\tJR\tZ,X_PST2\n\tCP\t02H\n\tCCF\n\tRET\tC\n\tLD\tA,3FH\n\tCP\tE\n\tRET\tC\nX_PST2:\tLD\tA,H\n\tOR\tA\n\tSCF\n\tRET\tNZ\n\tLD\tA,0BFH\n\tCP\tL\n\tRET\tC\n\tLD\tA,E\n\tAND\t07H\n\tLD\tB,A\n\tLD\tC,80H\n\tJR\tZ,X_PST4\nX_PST3:\tSRL\tC\n\tDJNZ\tX_PST3\nX_PST4:\tSRL\tD\n\tRR\tE\n\tSRL\tE\n\tSRL\tE\n\tLD\tA,L\n\tAND\t07H\n\tLD\tB,C\n\tLD\tC,A\n\tLD\tA,0FH\n\tSUB\tC\n\tLD\tC,A\n\tPUSH\tBC\n\tSRL\tL\n\tSRL\tL\n\tSRL\tL\n\tLD\tB,H\n\tLD\tC,L\n\tADD\tHL,HL\n\tADD\tHL,HL\n\tADD\tHL,BC\n\tADD\tHL,HL\n\tADD\tHL,HL\n\tADD\tHL,HL\n\tLD\tB,H\n\tLD\tC,L\n\tLD\tHL,0EF98H\n\tADD\tHL,DE\n\tOR\tA\n\tSBC\tHL,BC\n\tPOP\tBC\n\tOR\tA\n\tRET\nX_PST5:\n");
            } else {
                asmCodeBuf.append("X_PST:\n");
            }
            this.appendExitNoGraphicsScreenTo(asmCodeBuf, basicCompiler);
            this.pixUtilAppended = true;
        }
    }
}

