/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.programming.basic.target;

import jkcemu.base.EmuSys;
import jkcemu.emusys.Z1013;
import jkcemu.programming.basic.AbstractTarget;
import jkcemu.programming.basic.AsmCodeBuf;
import jkcemu.programming.basic.BasicCompiler;

public class Z1013Target
extends AbstractTarget {
    public static final String BASIC_TARGET_NAME = "TARGET_Z1013";
    protected boolean xptestAppended;
    private boolean pixUtilAppended;
    private boolean xpsetAppended;

    public Z1013Target() {
        this.setNamedValue("GRAPHICSCREEN", 0);
        this.setNamedValue("JOYST_LEFT", 1);
        this.setNamedValue("JOYST_RIGHT", 2);
        this.setNamedValue("JOYST_DOWN", 4);
        this.setNamedValue("JOYST_UP", 8);
        this.setNamedValue("JOYST_BUTTON1", 16);
    }

    @Override
    public void appendExitTo(AsmCodeBuf asmCodeBuf) {
        asmCodeBuf.append("\tJP\t0038H\n");
    }

    @Override
    public void appendHCharTo(AsmCodeBuf asmCodeBuf) {
        asmCodeBuf.append("\tLD\tHL,0020H\n");
    }

    @Override
    public void appendHPixelTo(AsmCodeBuf asmCodeBuf) {
        asmCodeBuf.append("\tLD\tHL,0040H\n");
    }

    @Override
    public void appendInputTo(AsmCodeBuf asmCodeBuf, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        if (bl) {
            asmCodeBuf.append("XCKBRK:\n");
        }
        if (bl || bl2) {
            asmCodeBuf.append("XINKEY:\tXOR\tA\n\tLD\t(0004H),A\n\tRST\t20H\n\tDB\t04H\n");
            if (bl4) {
                asmCodeBuf.append("\tCP\t03H\n\tJR\tZ,XBREAK\n");
            }
            asmCodeBuf.append("\tRET\n");
        }
        if (bl3) {
            asmCodeBuf.append("XINCH:\tRST\t20H\n\tDB\t01H\n");
            if (bl4) {
                asmCodeBuf.append("\tCP\t03H\n\tJR\tZ,XBREAK\n");
            }
            asmCodeBuf.append("\tRET\n");
        }
    }

    @Override
    public void appendWCharTo(AsmCodeBuf asmCodeBuf) {
        asmCodeBuf.append("\tLD\tHL,0020H\n");
    }

    @Override
    public void appendWPixelTo(AsmCodeBuf asmCodeBuf) {
        asmCodeBuf.append("\tLD\tHL,0040H\n");
    }

    @Override
    public void appendXCursTo(AsmCodeBuf asmCodeBuf) {
        asmCodeBuf.append("XCURS:\tLD\tA,H\n\tOR\tL\n\tJR\tZ,XCURS1\n\tLD\tHL,(002BH)\n\tLD\tA,(HL)\n\tCP\t0FFH\n\tRET\tZ\n\tLD\t(001FH),A\n\tLD\t(HL),0FFH\n\tRET\nXCURS1:\tLD\tA,(001FH)\n\tLD\tHL,(002BH)\n\tLD\t(HL),A\n\tRET\n");
    }

    @Override
    public void appendXJoyTo(AsmCodeBuf asmCodeBuf) {
        asmCodeBuf.append("XJOY:\tLD\tA,H\n\tOR\tA\n\tJR\tNZ,XJOY2\n\tLD\tA,(0FFBBH)\n\tCP\t0C3H\n\tJR\tNZ,XJOY2\n\tLD\tA,L\n\tOR\tA\n\tJR\tNZ,XJOY1\n\tCALL\t0FFBBH\n\tLD\tL,C\n\tLD\tH,00H\n\tRET\nXJOY1:\tCP\t01H\n\tJR\tNZ,XJOY2\n\tCALL\t0FFBBH\n\tLD\tL,B\n\tLD\tH,00H\n\tRET\nXJOY2:\tLD\tHL,0000H\n\tRET\n");
    }

    @Override
    public void appendXLocateTo(AsmCodeBuf asmCodeBuf) {
        asmCodeBuf.append("XLOCATE:\n\tLD\tA,1FH\n\tCP\tE\n\tRET\tC\n\tCP\tL\n\tRET\tC\n\tPUSH\tHL\n\tLD\tHL,(002BH)\n\tLD\tA,(001FH)\n\tLD\t(HL),A\n\tPOP\tHL\n\tEX\tDE,HL\n\tADD\tHL,HL\n\tADD\tHL,HL\n\tADD\tHL,HL\n\tADD\tHL,HL\n\tADD\tHL,HL\n\tADD\tHL,DE\n\tLD\tBC,0EC00H\n\tADD\tHL,BC\n\tLD\tA,(HL)\n\tLD\t(HL),0FFH\n\tLD\t(002BH),HL\n\tRET\n");
    }

    @Override
    public void appendXLPtchTo(AsmCodeBuf asmCodeBuf) {
        asmCodeBuf.append("XLPTCH:\tLD\tB,A\n\tLD\tA,(0FFE8H)\n\tCP\t0C3H\n\tRET\tNZ\n\tLD\tA,B\n\tJP\t0FFE8H\n");
    }

    @Override
    public void appendXOutchTo(AsmCodeBuf asmCodeBuf) {
        if (!this.xoutchAppended) {
            asmCodeBuf.append("XOUTCH:\tCP\t0AH\n\tRET\tZ\n\tRST\t20H\n\tDB\t00H\n\tRET\n");
            this.xoutchAppended = true;
        }
    }

    @Override
    public void appendXOutnlTo(AsmCodeBuf asmCodeBuf) {
        asmCodeBuf.append("XOUTNL:\tLD\tA,0DH\n");
        if (this.xoutchAppended) {
            asmCodeBuf.append("\tJR\tXOUTCH\n");
        } else {
            this.appendXOutchTo(asmCodeBuf);
        }
    }

    @Override
    public void appendXPaintTo(AsmCodeBuf asmCodeBuf, BasicCompiler basicCompiler) {
        asmCodeBuf.append("XPAINT:\tCALL\tX_PST\n\tRET\tC\n\tLD\tA,B\n\tAND\tC\n\tSCF\n\tRET\tNZ\n\tCALL\tXPSET2\n\tOR\tA\n\tRET\n");
        this.appendXPSetTo(asmCodeBuf, basicCompiler);
    }

    @Override
    public void appendXPointTo(AsmCodeBuf asmCodeBuf, BasicCompiler basicCompiler) {
        this.appendXPTestTo(asmCodeBuf, basicCompiler);
    }

    @Override
    public void appendXPResTo(AsmCodeBuf asmCodeBuf, BasicCompiler basicCompiler) {
        asmCodeBuf.append("XPRES:\tCALL\tX_PST\n\tRET\tC\n");
        if (this.usesX_M_PEN) {
            asmCodeBuf.append("\tJR\tXPSET1\n");
        } else {
            asmCodeBuf.append("\tLD\tA,C\n\tCPL\n\tAND\tB\n\tJR\tXPSET3\n");
        }
        this.appendXPSetTo(asmCodeBuf, basicCompiler);
    }

    @Override
    public void appendXPSetTo(AsmCodeBuf asmCodeBuf, BasicCompiler basicCompiler) {
        if (!this.xpsetAppended) {
            asmCodeBuf.append("XPSET:\tCALL\tX_PST\n\tRET\tC\n");
            if (this.usesX_M_PEN) {
                asmCodeBuf.append("\tLD\tA,(X_M_PEN)\n\tDEC\tA\n\tJR\tZ,XPSET2\n\tDEC\tA\n\tJR\tZ,XPSET1\n\tDEC\tA\n\tRET\tNZ\n\tLD\tA,B\n\tXOR\tC\n\tJR\tXPSET3\nXPSET1:\tLD\tA,C\n\tCPL\n\tAND\tB\n\tJR\tXPSET3\n");
            }
            asmCodeBuf.append("XPSET2:\tLD\tA,B\n\tOR\tC\nXPSET3:\tEX\tDE,HL\n\tLD\tB,0\n\tLD\tC,A\n\tLD\tHL,XPSET_TAB\n\tADD\tHL,BC\n\tLD\tA,(HL)\n\tLD\t(DE),A\n\tRET\nXPSET_TAB:\n\tDB\t20H,0B3H,0B2H,0B7H,0B0H,0B4H,0B8H,0BBH\n\tDB\t0B1H,0B9H,0B5H,0BAH,0B6H,0BCH,0BDH,0FFH\n");
            this.appendPixUtilTo(asmCodeBuf, basicCompiler);
            this.xpsetAppended = true;
        }
    }

    @Override
    public void appendXPTestTo(AsmCodeBuf asmCodeBuf, BasicCompiler basicCompiler) {
        if (!this.xptestAppended) {
            asmCodeBuf.append("XPOINT:\nXPTEST:\tCALL\tX_PST\n\tJR\tC,X_PTEST1\n\tLD\tA,B\n\tAND\tC\n\tLD\tHL,0000H\n\tRET\tZ\n\tINC\tHL\n\tRET\nX_PTEST1:\n\tLD\tHL,0FFFFH\n\tRET\n");
            this.appendPixUtilTo(asmCodeBuf, basicCompiler);
            this.xptestAppended = true;
        }
    }

    @Override
    public int get100msLoopCount() {
        return 55;
    }

    @Override
    public String[] getBasicTargetNames() {
        return new String[]{BASIC_TARGET_NAME};
    }

    @Override
    public int getCompatibilityLevel(EmuSys emuSys) {
        int n = 0;
        if (emuSys != null && emuSys instanceof Z1013) {
            n = 3;
        }
        return n;
    }

    @Override
    public int getDefaultBegAddr() {
        return 256;
    }

    @Override
    public String getStartCmd(EmuSys emuSys, String string, int n) {
        String string2 = null;
        if (emuSys != null && n >= 0 && emuSys instanceof Z1013) {
            string2 = String.format("J %04X", n);
        }
        return string2;
    }

    @Override
    public int[] getVdipBaseIOAddresses() {
        return new int[]{220, 252};
    }

    @Override
    public void reset() {
        super.reset();
        this.pixUtilAppended = false;
        this.xpsetAppended = false;
        this.xptestAppended = false;
    }

    @Override
    public boolean supportsGraphics() {
        return true;
    }

    @Override
    public boolean supportsXCURS() {
        return true;
    }

    @Override
    public boolean supportsXJOY() {
        return true;
    }

    @Override
    public boolean supportsXLOCAT() {
        return true;
    }

    @Override
    public boolean supportsXLPTCH() {
        return true;
    }

    public String toString() {
        return "Z1013";
    }

    protected void appendCheckGraphicScreenTo(AsmCodeBuf asmCodeBuf, BasicCompiler basicCompiler) {
    }

    protected void appendPixUtilTo(AsmCodeBuf asmCodeBuf, BasicCompiler basicCompiler) {
        if (!this.pixUtilAppended) {
            asmCodeBuf.append("X_PST:\n");
            this.appendCheckGraphicScreenTo(asmCodeBuf, basicCompiler);
            asmCodeBuf.append("X_PST1:\tLD\tA,D\n\tOR\tH\n\tJR\tNZ,X_PST4\n\tLD\tA,3FH\n\tCP\tE\n\tRET\tC\n\tCP\tL\n\tRET\tC\n\tLD\tA,01H\n\tSRL\tL\n\tJR\tNC,X_PST2\n\tSLA\tA\n\tSLA\tA\nX_PST2:\tSRL\tE\n\tJR\tNC,X_PST3\n\tSLA\tA\nX_PST3:\tADD\tHL,HL\n\tADD\tHL,HL\n\tADD\tHL,HL\n\tADD\tHL,HL\n\tADD\tHL,HL\n\tEX\tDE,HL\n\tLD\tBC,0EFE0H\n\tADD\tHL,BC\n\tLD\tC,A\n\tXOR\tA\n\tSBC\tHL,DE\n\tLD\tA,(HL)\n\tLD\tB,0FH\n\tCP\t0EH\n\tCCF\n\tRET\tNC\n\tCP\t0FFH\n\tRET\tZ\n\tLD\tB,0\n\tSUB\t0B0H\n\tCCF\n\tRET\tNC\n\tCP\t0EH\n\tRET\tNC\n\tPUSH\tHL\n\tLD\tHL,X_PST_TAB\n\tLD\tD,0\n\tLD\tE,A\n\tADD\tHL,DE\n\tLD\tA,(HL)\n\tPOP\tHL\n\tLD\tB,A\n\tOR\tA\n\tRET\nX_PST4:\tSCF\n\tRET\nX_PST_TAB:\n\tDB\t04H,08H,02H,01H,05H,0AH,0CH,03H\n\tDB\t06H,09H,0BH,07H,0DH,0EH\n");
            this.pixUtilAppended = true;
        }
    }
}

