/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.programming.basic.target;

import jkcemu.base.EmuSys;
import jkcemu.emusys.KramerMC;
import jkcemu.programming.basic.AbstractTarget;
import jkcemu.programming.basic.AsmCodeBuf;

public class KramerMCTarget
extends AbstractTarget {
    public static final String BASIC_TARGET_NAME = "TARGET_KRAMER";

    @Override
    public void appendExitTo(AsmCodeBuf asmCodeBuf) {
        asmCodeBuf.append("\tJP\t0000H\n");
    }

    @Override
    public void appendHCharTo(AsmCodeBuf asmCodeBuf) {
        asmCodeBuf.append("\tLD\tHL,0010H\n");
    }

    @Override
    public void appendInputTo(AsmCodeBuf asmCodeBuf, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        if (bl) {
            asmCodeBuf.append("XCKBRK:\n");
        }
        if (bl || bl2) {
            asmCodeBuf.append("XINKEY:\tCALL\t00EFH\n\tOR\tA\n\tRET\tZ\n");
        }
        if (bl || bl2 || bl3) {
            if (bl4) {
                asmCodeBuf.append("XINCH:\tCALL\t00E0H\n\tCP\t03H\n\tJR\tZ,XBREAK\n\tRET\n");
            } else {
                asmCodeBuf.append("XINCH:\tJP\t00E0H\n");
            }
        }
    }

    @Override
    public void appendWCharTo(AsmCodeBuf asmCodeBuf) {
        asmCodeBuf.append("\tLD\tHL,0040H\n");
    }

    @Override
    public void appendXLPtchTo(AsmCodeBuf asmCodeBuf) {
        asmCodeBuf.append("XLPTCH:\tLD\tC,A\n\tJP\t00ECH\n");
    }

    @Override
    public void appendXOutchTo(AsmCodeBuf asmCodeBuf) {
        if (!this.xoutchAppended) {
            asmCodeBuf.append("XOUTCH:\tLD\tC,A\n\tJP\t00E6H\n");
            this.xoutchAppended = true;
        }
    }

    @Override
    public void appendXOutnlTo(AsmCodeBuf asmCodeBuf) {
        asmCodeBuf.append("XOUTNL:\tLD\tC,0DH\n\tCALL\t00E6H\n\tLD\tC,0AH\n\tJP\t00E6H\n");
    }

    @Override
    public int get100msLoopCount() {
        return 42;
    }

    @Override
    public String[] getBasicTargetNames() {
        return new String[]{BASIC_TARGET_NAME};
    }

    @Override
    public int getCompatibilityLevel(EmuSys emuSys) {
        int n = 0;
        if (emuSys != null && emuSys instanceof KramerMC) {
            n = 3;
        }
        return n;
    }

    @Override
    public int getDefaultBegAddr() {
        return 4096;
    }

    @Override
    public String getStartCmd(EmuSys emuSys, String string, int n) {
        String string2 = null;
        if (emuSys != null && n >= 0 && emuSys instanceof KramerMC) {
            string2 = String.format("G%04X", n);
        }
        return string2;
    }

    @Override
    public boolean supportsXLPTCH() {
        return true;
    }

    public String toString() {
        return "Kramer-MC";
    }
}

