/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.programming.basic.target;

import jkcemu.base.EmuSys;
import jkcemu.emusys.KC85;
import jkcemu.programming.basic.AsmCodeBuf;
import jkcemu.programming.basic.BasicCompiler;
import jkcemu.programming.basic.BasicLibrary;
import jkcemu.programming.basic.target.KC85Target;

public class KC854Target
extends KC85Target {
    public static final String BASIC_TARGET_NAME = "TARGET_KC85_4";
    private boolean usesScreens;

    public KC854Target() {
        this.setNamedValue("LASTSCREEN", 1);
    }

    @Override
    public void appendBssTo(AsmCodeBuf asmCodeBuf) {
        super.appendBssTo(asmCodeBuf);
        if (this.usesScreens) {
            asmCodeBuf.append("X_M_SCRWIN:\n\tDS\t2\n");
        }
    }

    @Override
    public void appendInitTo(AsmCodeBuf asmCodeBuf) {
        super.appendInitTo(asmCodeBuf);
        if (this.usesScreens) {
            asmCodeBuf.append("\tLD\tA,(0B79BH)\n\tLD\tHL,X_M_SCRWIN\n\tLD\t(HL),A\n\tINC\tHL\n\tINC\tA\n\tCP\t0AH\n\tJR\tC,X_IWN3\n\tXOR\tA\nX_IWN3:\tLD\t(HL),A\n");
        }
    }

    @Override
    public void appendPreExitTo(AsmCodeBuf asmCodeBuf) {
        super.appendPreExitTo(asmCodeBuf);
        this.appendSwitchToTextScreenTo(asmCodeBuf);
    }

    @Override
    public void appendSwitchToTextScreenTo(AsmCodeBuf asmCodeBuf) {
        if (this.usesScreens) {
            asmCodeBuf.append("\tLD\tA,(X_M_SCRWIN)\n\tLD\tL,A\n\tCALL\tXSCREEN\n");
        }
    }

    @Override
    public void appendXHLineTo(AsmCodeBuf asmCodeBuf, BasicCompiler basicCompiler) {
        asmCodeBuf.append("XHLINE:\tBIT\t7,B\n\tRET\tNZ\n\tPUSH\tBC\n\tPUSH\tDE\n\tPUSH\tHL\n\tCALL\tX_PST\n\tEXX\n\tPOP\tHL\n\tPOP\tDE\n\tPOP\tBC\n\tRET\tC\n\tLD\tD,00H\nXHLINE1:\n\tOR\tD\n\tLD\tD,A\n\tSRL\tA\n\tJR\tNC,XHLINE2\n\tLD\tA,D\n\tEXX\n\tCALL\tXPSET_A\n\tINC\tH\n\tLD\tA,H\n\tCP\t0A8H\n\tRET\tNC\n\tEXX\n\tLD\tA,80H\n\tLD\tD,00H\nXHLINE2:\n\tDEC\tBC\n\tBIT\t7,B\n\tJR\tZ,XHLINE1\n\tLD\tA,D\n\tOR\tA\n\tRET\tZ\n\tEXX\n\tJR\tXPSET_A\n");
        this.appendXPSetTo(asmCodeBuf, basicCompiler);
    }

    @Override
    public void appendXPaintTo(AsmCodeBuf asmCodeBuf, BasicCompiler basicCompiler) {
        asmCodeBuf.append("XPAINT_LEFT:\n\tLD\tDE,(PAINT_M_X)\n\tLD\tA,D\n\tOR\tE\n\tJR\tZ,XPAINT_LEFT6\n\tLD\tHL,(PAINT_M_Y)\n\tDEC\tDE\n\tPUSH\tDE\n\tCALL\tX_PST\n\tPOP\tDE\n\tJR\tC,XPAINT_LEFT5\n\tLD\tC,A\n\tLD\tB,(HL)\nXPAINT_LEFT1:\n\tLD\tA,B\nXPAINT_LEFT2:\n\tAND\tC\n\tJR\tNZ,XPAINT_LEFT4\n\tLD\tA,B\n\tOR\tC\n\tLD\tB,A\n\tDEC\tDE\n\tSLA\tC\n\tJR\tNC,XPAINT_LEFT2\n\tLD\t(HL),B\n\tLD\tC,84H\n\tCALL\tXPSET_WR_COLOR\n\tDEC\tH\n\tBIT\t0,D\n\tJR\tZ,XPAINT_LEFT3\n\tLD\tA,E\n\tINC\tA\n\tJR\tZ,XPAINT_LEFT5\nXPAINT_LEFT3:\n\tLD\tB,(HL)\n\tLD\tC,01H\n\tJR\tXPAINT_LEFT1\nXPAINT_LEFT4:\n\tLD\t(HL),B\n\tLD\tC,84H\n\tCALL\tXPSET_WR_COLOR\nXPAINT_LEFT5:\n\tINC\tDE\nXPAINT_LEFT6:\n\tLD\t(PAINT_M_X1),DE\n\tRET\nXPAINT_RIGHT:\n\tLD\tDE,(PAINT_M_X)\n\tLD\tHL,(PAINT_M_Y)\n\tPUSH\tDE\n\tCALL\tX_PST\n\tPOP\tDE\n\tRET\tC\n\tLD\tC,A\n\tLD\tB,(HL)\n\tAND\tB\n\tSCF\n\tRET\tNZ\n\tJR\tXPAINT_RIGHT3\nXPAINT_RIGHT1:\n\tLD\tA,B\nXPAINT_RIGHT2:\n\tAND\tC\n\tJR\tNZ,XPAINT_RIGHT5\nXPAINT_RIGHT3:\n\tLD\tA,B\n\tOR\tC\n\tLD\tB,A\n\tINC\tDE\n\tSRL\tC\n\tJR\tNC,XPAINT_RIGHT2\n\tLD\t(HL),B\n\tLD\tC,84H\n\tCALL\tXPSET_WR_COLOR\n\tINC\tH\n\tLD\tA,E\n\tCP\t40H\n\tJR\tNZ,XPAINT_RIGHT4\n\tLD\tA,D\n\tDEC\tA\n\tJR\tZ,XPAINT_RIGHT6\nXPAINT_RIGHT4:\n\tLD\tB,(HL)\n\tLD\tC,80H\n\tJR\tXPAINT_RIGHT1\nXPAINT_RIGHT5:\n\tLD\t(HL),B\n\tLD\tC,84H\n\tCALL\tXPSET_WR_COLOR\nXPAINT_RIGHT6:\n\tDEC\tDE\n\tLD\t(PAINT_M_X2),DE\n\tOR\tA\n\tRET\n");
        this.appendXPSetTo(asmCodeBuf, basicCompiler);
    }

    @Override
    public void appendXPointTo(AsmCodeBuf asmCodeBuf, BasicCompiler basicCompiler) {
        asmCodeBuf.append("XPOINT:\tCALL\tX_PST\n\tJR\tC,XPOINT3\n\tDB\t0DDH,0CBH,01H,0C8H\t;SET 1,(IX+01H),B\n\tOUT\t(C),B\n\tLD\tD,(HL)\n\tDB\t0DDH,0CBH,01H,88H\t;RES 1,(IX+01H),B\n\tOUT\t(C),B\n\tAND\t(HL)\n\tLD\tA,D\n\tJR\tZ,XPOINT1\n\tSRL\tA\n\tSRL\tA\n\tSRL\tA\n\tAND\t1FH\n\tJR\tXPOINT2\nXPOINT1:\n\tAND\t07H\nXPOINT2:\n\tLD\tL,A\n\tLD\tH,00H\n\tRET\nXPOINT3:\n\tLD\tHL,0FFFFH\n\tRET\n");
        this.appendPixUtilTo(asmCodeBuf);
    }

    @Override
    public void appendXPSetTo(AsmCodeBuf asmCodeBuf, BasicCompiler basicCompiler) {
        if (!this.xpsetAppended) {
            asmCodeBuf.append("XPSET:\tCALL\tX_PST\n\tRET\tC\nXPSET_A:\n");
            if (this.usesX_M_PEN) {
                asmCodeBuf.append("\tLD\tD,A\n\tLD\tA,(X_M_PEN)\n\tDEC\tA\n\tJR\tZ,XPSET2\n\tDEC\tA\n\tJR\tZ,XPSET1\n\tDEC\tA\n\tRET\tNZ\n\tLD\tA,(HL)\n\tXOR\tD\n\tJR\tXPSET_WR_A\nXPSET1:\tLD\tA,D\n\tCPL\n\tAND\t(HL)\n\tJR\tXPSET_WR_A\nXPSET2:\tLD\tA,D\n");
            }
            asmCodeBuf.append("XPSET_OR_A:\n\tOR\t(HL)\nXPSET_WR_A:\n\tLD\t(HL),A\nXPSET_WR_COLOR:\n\tDB\t0DDH,0CBH,01H,0C8H\t;SET 1,(IX+01H),B\n\tOUT\t(C),B\n\tLD\tA,(0B7A3H)\n\tLD\t(HL),A\n\tDB\t0DDH,0CBH,01H,88H\t;RES 1,(IX+01H),B\n\tOUT\t(C),B\n\tRET\n");
            this.appendPixUtilTo(asmCodeBuf);
            this.needsFullWindow = true;
            this.xpsetAppended = true;
        }
    }

    @Override
    public void appendXScreenTo(AsmCodeBuf asmCodeBuf) {
        if (this.usesScreens) {
            asmCodeBuf.append("XSCREEN:\n\tLD\tA,L\n\tAND\t0FEH\n\tOR\tH\n\tJR\tNZ,XSCRN2\n\tLD\tB,(IX+01H)\n\tLD\tA,B\n\tXOR\tL\n\tAND\t01H\n\tRET\tZ\n\tLD\tA,B\n\tBIT\t0,L\n\tLD\tHL,X_M_SCRWIN\n\tJR\tZ,XSCRN1\n\tOR\t05H\n\tLD\t(IX+01),A\n\tOUT\t(84H),A\n\tINC\tHL\n\tLD\tA,(HL)\n\tBIT\t7,A\n\tJR\tZ,XSCRN2\n\tAND\t7FH\n\tLD\t(HL),A\n\tLD\tHL,0000H\n\tLD\tDE,2028H\n\tLD\tBC,0000H\n\tCALL\t0F003H\n\tDB\t3CH\n\tRET\nXSCRN1:\tAND\t0FAH\n\tLD\t(IX+01),A\n\tOUT\t(84H),A\n\tLD\tA,(HL)\nXSCRN2:\tCALL\t0F003H\n\tDB\t3DH\n\tRET\nXSCRN3:\tSCF\n\tRET\n");
        }
    }

    @Override
    public String[] getBasicTargetNames() {
        return KC854Target.add(super.getBasicTargetNames(), BASIC_TARGET_NAME);
    }

    @Override
    public int getCompatibilityLevel(EmuSys emuSys) {
        int n = 0;
        if (emuSys != null && emuSys instanceof KC85) {
            n = 1;
            if (((KC85)emuSys).getKCTypeNum() >= 4) {
                n = 3;
            }
        }
        return n;
    }

    @Override
    public void preAppendLibraryCode(BasicCompiler basicCompiler) {
        super.preAppendLibraryCode(basicCompiler);
        if (basicCompiler.usesLibItem(BasicLibrary.LibItem.SCREEN) || basicCompiler.usesLibItem(BasicLibrary.LibItem.XSCREEN)) {
            this.usesScreens = true;
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.usesScreens = false;
    }

    @Override
    public boolean supportsXHLINE() {
        return true;
    }

    @Override
    public boolean supportsXPAINT_LEFT_RIGHT() {
        return true;
    }

    @Override
    public String toString() {
        return "KC85/4..5 mit Unterst\u00fctzung beider Bildspeicher";
    }

    @Override
    protected void appendPixUtilTo(AsmCodeBuf asmCodeBuf) {
        if (!this.pixUtilAppended) {
            asmCodeBuf.append("X_PST:\tLD\tA,H\n\tOR\tA\n\tSCF\n\tRET\tNZ\n\tLD\tA,D\n\tOR\tA\n\tJR\tZ,X_PST1\n\tCP\t02H\n\tCCF\n\tRET\tC\n\tLD\tA,3FH\n\tCP\tE\n\tRET\tC\nX_PST1:\tLD\tA,L\n\tCPL\n\tLD\tL,A\n\tLD\tA,E\n\tAND\t07H\n\tLD\tB,A\n\tLD\tA,80H\n\tJR\tZ,X_PST3\nX_PST2:\tSRL\tA\n\tDJNZ\tX_PST2\nX_PST3:\tSRL\tD\n\tRR\tE\n\tSRL\tE\n\tSRL\tE\n\tLD\tD,E\n\tLD\tE,00H\n\tADD\tHL,DE\n\tSET\t7,H\n\tDB\t0DDH,0CBH,01H,88H\t;RES 1,(IX+01H),B\n\tLD\tC,84H\n\tOUT\t(C),B\n\tOR\tA\n\tRET\n");
            this.pixUtilAppended = true;
        }
    }
}

