/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.programming.basic;

import jkcemu.programming.PrgSource;
import jkcemu.programming.basic.BasicSourcePos;

public class VarDecl
extends BasicSourcePos {
    private String varName;
    private int dim1;
    private int dim2;
    private int nDims;
    private int size;
    private boolean used;
    private String label;
    private String infoText;

    public VarDecl(PrgSource prgSource, long l, String string, int n, int n2) {
        super(prgSource, l);
        this.varName = string;
        this.dim1 = n;
        this.dim2 = n2;
        this.nDims = 0;
        this.size = 2;
        this.used = false;
        if (n > 0) {
            ++this.nDims;
            this.size *= n + 1;
            if (n2 > 0) {
                ++this.nDims;
                this.size *= n2 + 1;
            }
        }
        this.label = string.endsWith("$") ? "VS_" + string.substring(0, string.length() - 1) : "VI_" + string;
        this.infoText = this.nDims > 0 ? "Feldvariable " : "Variable ";
        this.infoText = this.infoText + string;
    }

    public VarDecl(PrgSource prgSource, long l, String string, int n) {
        this(prgSource, l, string, n, 0);
    }

    public VarDecl(PrgSource prgSource, long l, String string) {
        this(prgSource, l, string, 0, 0);
    }

    public int getDim1() {
        return this.dim1;
    }

    public int getDim2() {
        return this.dim2;
    }

    public int getDimCount() {
        return this.nDims;
    }

    public String getLabel() {
        return this.label;
    }

    public int getSize() {
        return this.size;
    }

    public boolean isUsed() {
        return this.used;
    }

    public void setUsed() {
        this.used = true;
    }

    public String toString() {
        return this.infoText;
    }
}

