/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.programming.basic;

import jkcemu.programming.PrgException;
import jkcemu.programming.basic.AsmCodeBuf;
import jkcemu.programming.basic.BasicCompiler;

public class SimpleVarInfo {
    private BasicCompiler.DataType dataType;
    private String addrExpr;
    private Integer iyOffs;

    public SimpleVarInfo(BasicCompiler.DataType dataType, String string, Integer n) {
        this.dataType = dataType;
        this.addrExpr = string;
        this.iyOffs = n;
    }

    public void ensureAddrInHL(AsmCodeBuf asmCodeBuf) {
        if (this.addrExpr != null) {
            asmCodeBuf.append("\tLD\tHL,");
            asmCodeBuf.append(this.addrExpr);
            asmCodeBuf.append('\n');
        } else if (this.iyOffs != null) {
            int n = this.iyOffs & 0xFFFF;
            asmCodeBuf.append("\tPUSH\tIY\n\tPOP\tHL\n\tLD\tDE,");
            asmCodeBuf.appendHex4(n);
            asmCodeBuf.append("\n\tADD\tHL,DE\n");
        }
    }

    public void ensureStaticAddrInDE(AsmCodeBuf asmCodeBuf, boolean bl) throws PrgException {
        if (this.addrExpr != null) {
            asmCodeBuf.append("\tLD\tDE,");
            asmCodeBuf.append(this.addrExpr);
            asmCodeBuf.append('\n');
        } else if (this.iyOffs != null) {
            if (bl) {
                asmCodeBuf.append("\tPUSH\tHL\n");
            }
            int n = this.iyOffs & 0xFFFF;
            asmCodeBuf.append("\tPUSH\tIY\n\tPOP\tHL\n\tLD\tDE,");
            asmCodeBuf.appendHex4(n);
            asmCodeBuf.append("\n\tADD\tHL,DE\n\tEX\tDE,HL\n");
            if (bl) {
                asmCodeBuf.append("\tPOP\tHL\n");
            }
        } else {
            SimpleVarInfo.throwNonStaticVarNotAllowd();
        }
    }

    public void ensureValueInDE(AsmCodeBuf asmCodeBuf) {
        if (this.addrExpr != null) {
            asmCodeBuf.append("\tLD\tDE,(");
            asmCodeBuf.append(this.addrExpr);
            asmCodeBuf.append(")\n");
        } else if (this.iyOffs != null) {
            int n = this.iyOffs;
            if (n < 0) {
                n = -n & 0xFFFF;
                asmCodeBuf.append("\tLD\tD,(IY-");
                asmCodeBuf.append(n - 1);
                asmCodeBuf.append(")\n\tLD\tE,(IY-");
                asmCodeBuf.append(n);
                asmCodeBuf.append(")\n");
            } else {
                asmCodeBuf.append("\tLD\tD,(IY+");
                asmCodeBuf.append(n + 1);
                asmCodeBuf.append(")\n\tLD\tE,(IY+");
                asmCodeBuf.append(n);
                asmCodeBuf.append(")\n");
            }
        } else {
            asmCodeBuf.append("\tLD\tE,(HL)\n\tINC\tHL\n\tLD\tD,(HL)\n");
        }
    }

    public void ensureValueInHL(AsmCodeBuf asmCodeBuf) {
        if (this.addrExpr != null) {
            asmCodeBuf.append("\tLD\tHL,(");
            asmCodeBuf.append(this.addrExpr);
            asmCodeBuf.append(")\n");
        } else if (this.iyOffs != null) {
            int n = this.iyOffs;
            if (n < 0) {
                n = -n & 0xFFFF;
                asmCodeBuf.append("\tLD\tH,(IY-");
                asmCodeBuf.append(n - 1);
                asmCodeBuf.append(")\n\tLD\tL,(IY-");
                asmCodeBuf.append(n);
                asmCodeBuf.append(")\n");
            } else {
                asmCodeBuf.append("\tLD\tH,(IY+");
                asmCodeBuf.append(n + 1);
                asmCodeBuf.append(")\n\tLD\tL,(IY+");
                asmCodeBuf.append(n);
                asmCodeBuf.append(")\n");
            }
        } else {
            asmCodeBuf.append("\tLD\tA,(HL)\n\tINC\tHL\n\tLD\tH,(HL)\n\tLD\tL,A\n");
        }
    }

    public BasicCompiler.DataType getDataType() {
        return this.dataType;
    }

    public boolean hasStaticAddr() {
        return this.addrExpr != null || this.iyOffs != null;
    }

    public void writeCode_LD_Var_HL(AsmCodeBuf asmCodeBuf) throws PrgException {
        if (this.addrExpr != null) {
            asmCodeBuf.append("\tLD\t(");
            asmCodeBuf.append(this.addrExpr);
            asmCodeBuf.append("),HL\n");
        } else if (this.iyOffs != null) {
            int n = this.iyOffs;
            if (n < 0) {
                n = -n & 0xFFFF;
                asmCodeBuf.append("\tLD\t(IY-");
                asmCodeBuf.append(n - 1);
                asmCodeBuf.append("),H\n\tLD\t(IY-");
                asmCodeBuf.append(n);
                asmCodeBuf.append("),L\n");
            } else {
                asmCodeBuf.append("\tLD\t(IY+");
                asmCodeBuf.append(n + 1);
                asmCodeBuf.append("),H\n\tLD\t(IY+");
                asmCodeBuf.append(n);
                asmCodeBuf.append("),L\n");
            }
        } else {
            SimpleVarInfo.throwNonStaticVarNotAllowd();
        }
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object != null && object instanceof SimpleVarInfo) {
            SimpleVarInfo simpleVarInfo = (SimpleVarInfo)object;
            if (simpleVarInfo.addrExpr != null && this.addrExpr != null) {
                bl = simpleVarInfo.addrExpr.equals(this.addrExpr);
            } else if (simpleVarInfo.iyOffs != null && this.iyOffs != null) {
                bl = simpleVarInfo.iyOffs.equals(this.iyOffs);
            } else if (simpleVarInfo.addrExpr == null && this.addrExpr == null && simpleVarInfo.iyOffs == null && this.iyOffs == null) {
                bl = true;
            }
        }
        return bl;
    }

    private static void throwNonStaticVarNotAllowd() throws PrgException {
        throw new PrgException("Feldvariable mit variablen Indexangaben an der Stelle nicht erlaubt");
    }
}

