/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.programming.basic;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import jkcemu.programming.PrgSource;
import jkcemu.programming.basic.BasicCompiler;
import jkcemu.programming.basic.BasicSourcePos;

public abstract class CallableEntry
extends BasicSourcePos {
    private String name;
    private String label;
    private BasicSourcePos firstCallSourcePos;
    private List<String> args;
    private List<String> vars;
    private Map<String, BasicSourcePos> var2SourcePos;
    private Set<String> usedVars;
    private Map<String, Integer> name2iyOffs;
    private boolean implemented;
    private boolean stackFrame;

    protected CallableEntry(PrgSource prgSource, long l, String string, String string2) {
        super(prgSource, l);
        this.name = string;
        this.label = string2;
        this.firstCallSourcePos = null;
        this.args = new ArrayList<String>();
        this.vars = new ArrayList<String>();
        this.var2SourcePos = new HashMap<String, BasicSourcePos>();
        this.usedVars = new TreeSet<String>();
        this.name2iyOffs = new HashMap<String, Integer>();
        this.implemented = false;
        this.stackFrame = false;
    }

    public void addVar(PrgSource prgSource, long l, String string) {
        this.name2iyOffs.put(string, this.getVarIYOffs(this.vars.size()));
        this.var2SourcePos.put(string, new BasicSourcePos(prgSource, l));
        this.vars.add(string);
    }

    public boolean equalsArgType(int n, String string) {
        return n >= 0 && n < this.args.size() ? this.args.get(n).endsWith("$") == string.endsWith("$") : false;
    }

    public int getArgCount() {
        return this.args.size();
    }

    public int getArgIYOffs(int n, int n2) {
        return 4 + (n2 - n - 1) * 2;
    }

    public BasicCompiler.DataType getArgType(int n) {
        return this.args.get(n).endsWith("$") ? BasicCompiler.DataType.STRING : BasicCompiler.DataType.INTEGER;
    }

    public BasicSourcePos getFirstCallSourcePos() {
        return this.firstCallSourcePos;
    }

    public Integer getIYOffs(String string) {
        return this.name2iyOffs.get(string);
    }

    public String getLabel() {
        return this.label;
    }

    public String getName() {
        return this.name;
    }

    public int getTotalArgSize() {
        return this.args.size() * 2;
    }

    public int getTotalVarSize() {
        return this.vars.size() * 2;
    }

    public int getVarCount() {
        return this.vars.size();
    }

    public int getVarIYOffs(int n) {
        return -(n * 2) - 2;
    }

    public BasicSourcePos getVarSourcePos(String string) {
        return string != null ? this.var2SourcePos.get(string) : null;
    }

    public String getVarName(int n) {
        return n >= 0 && n < this.vars.size() ? this.vars.get(n) : null;
    }

    public BasicCompiler.DataType getVarType(int n) {
        return this.vars.get(n).endsWith("$") ? BasicCompiler.DataType.STRING : BasicCompiler.DataType.INTEGER;
    }

    public boolean hasStackFrame() {
        return this.stackFrame;
    }

    public boolean isCalled() {
        return this.firstCallSourcePos != null;
    }

    public boolean isImplemented() {
        return this.implemented;
    }

    public boolean isVarUsed(String string) {
        return string != null ? this.usedVars.contains(string) : false;
    }

    public void putCallPos(PrgSource prgSource, long l) {
        if (this.firstCallSourcePos == null) {
            this.firstCallSourcePos = new BasicSourcePos(prgSource, l);
        }
    }

    public void setArg(int n, String string) {
        if (n >= 0 && n < this.args.size()) {
            this.name2iyOffs.remove(this.args.get(n));
            this.name2iyOffs.put(string, this.getArgIYOffs(n, this.args.size()));
            this.args.set(n, string);
        }
    }

    public void setArgs(List<String> list) {
        int n;
        this.args.clear();
        if (list != null && (n = list.size()) > 0) {
            for (String string : list) {
                this.name2iyOffs.put(string, this.getArgIYOffs(this.args.size(), n));
                this.args.add(string);
            }
        }
    }

    public void setImplemented() {
        this.implemented = true;
    }

    public void setStackFrameCreated() {
        this.stackFrame = true;
    }

    public void setVarUsed(String string) {
        if (string != null) {
            this.usedVars.add(string);
        }
    }
}

