/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.programming.basic;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import jkcemu.programming.basic.AbstractTarget;
import jkcemu.programming.basic.AsmCodeBuf;
import jkcemu.programming.basic.BasicCompiler;
import jkcemu.programming.basic.BasicOptions;
import jkcemu.programming.basic.BasicUtil;
import jkcemu.programming.basic.VarDecl;
import jkcemu.programming.basic.VdipLibrary;

public class BasicLibrary {
    public static final int E_OK = 0;
    public static final int E_ERROR = -1;
    public static final int E_INVALID = -2;
    public static final int E_OVERFLOW = -3;
    public static final int E_CHANNEL_ALREADY_OPEN = -11;
    public static final int E_CHANNEL_CLOSED = -12;
    public static final int E_DEVICE_NOT_FOUND = -21;
    public static final int E_DEVICE_LOCKED = -22;
    public static final int E_HARDWARE = -23;
    public static final int E_NO_DISK = -24;
    public static final int E_FILE_NOT_FOUND = -25;
    public static final int E_PATH_NOT_FOUND = -26;
    public static final int E_IO_MODE = -27;
    public static final int E_IO_ERROR = -28;
    public static final int E_EOF = -29;
    public static final int E_READ_ONLY = -30;
    public static final int E_DIR_FULL = -31;
    public static final int E_DISK_FULL = -32;
    public static final int E_MEDIA_CHANGED = -33;
    public static final int IOCTB_EOF_OFFS = 2;
    public static final int IOCTB_READ_OFFS = 4;
    public static final int IOCTB_WRITE_OFFS = 6;
    public static final int IOCTB_BBUF_OFFS = 8;
    public static final int IOCTB_DRIVER_OFFS = 10;
    public static final int IOMODE_DEFAULT_MASK = 1;
    public static final int IOMODE_INPUT_MASK = 2;
    public static final int IOMODE_OUTPUT_MASK = 4;
    public static final int IOMODE_APPEND_MASK = 8;
    public static final int IOMODE_TXT_MASK = 16;
    public static final int IOMODE_BIN_MASK = 32;
    public static final int IOMODE_TXT_DEFAULT = 17;
    public static final int IOMODE_TXT_INPUT = 18;
    public static final int IOMODE_TXT_OUTPUT = 20;
    public static final int IOMODE_TXT_APPEND = 24;
    public static final int IOMODE_BIN_DEFAULT = 33;
    public static final int IOMODE_BIN_INPUT = 34;
    public static final int IOMODE_BIN_OUTPUT = 36;
    public static final int IOMODE_BIN_APPEND = 40;
    public static final String EMPTY_STRING_LABEL = "D_EMPT";

    public static void appendCodeTo(BasicCompiler basicCompiler) {
        AsmCodeBuf asmCodeBuf = basicCompiler.getCodeBuf();
        Set<LibItem> set = basicCompiler.getLibItems();
        BasicOptions basicOptions = basicCompiler.getBasicOptions();
        AbstractTarget abstractTarget = basicCompiler.getTarget();
        int n = basicOptions.getStackSize();
        if (basicOptions.getShowAssemblerText()) {
            asmCodeBuf.append("\n;Bibliotheksfunktionen\n");
        }
        if (set.contains((Object)LibItem.INIV)) {
            asmCodeBuf.append("INIV:\tPUSH\tHL\n\tCALL\tINLNB\n\tCALL\tF_VLI\n\tEX\tDE,HL\n\tPOP\tHL\n\tLD\tBC,(M_ERN)\n\tLD\tA,B\n\tOR\tC\n\tJR\tNZ,INIV1\n\tLD\t(HL),E\n\tINC\tHL\n\tLD\t(HL),D\n\tRET\nINIV1:");
            asmCodeBuf.append_LD_HL_nn(-3);
            asmCodeBuf.append("\tOR\tA\n\tSBC\tHL,BC\n\tJR\tNZ,INIV2\n\tCALL\tXOUTST\n");
            if (basicCompiler.isLangCode("DE")) {
                asmCodeBuf.append("\tDB\t'Tut mir leid!'\n");
            } else {
                asmCodeBuf.append("\tDB\t'Sorry!'\n");
            }
            asmCodeBuf.append("\tDB\t00H\n\tJR\tINIV3\nINIV2:\tCALL\tXOUTST\n");
            if (basicCompiler.isLangCode("DE")) {
                asmCodeBuf.append("\tDB\t'Wie bitte?'\n");
            } else {
                asmCodeBuf.append("\tDB\t'What?'\n");
            }
            asmCodeBuf.append("\tDB\t00H\nINIV3:\tCALL\tXOUTNL\n\tSCF\n\tRET\n");
            set.add(LibItem.INLNB);
            set.add(LibItem.F_VLI);
            set.add(LibItem.XOUTST);
            set.add(LibItem.XOUTNL);
            set.add(LibItem.M_ERN);
        }
        if (set.contains((Object)LibItem.INSV)) {
            asmCodeBuf.append("INSV:\tLD\tE,(HL)\n\tINC\tHL\n\tLD\tD,(HL)\n\tDEC\tHL\n\tPUSH\tDE\n\tPUSH\tHL\n\tCALL\tINLNB\n\tLD\tA,(HL)\n\tOR\tA\n\tJR\tNZ,INSV1\n");
            asmCodeBuf.append_LD_DE_xx(EMPTY_STRING_LABEL);
            asmCodeBuf.append("\tJR\tINSV3\nINSV1:\tPUSH\tHL\n\tCALL\tMFIND\n\tPOP\tHL\n\tPUSH\tDE\nINSV2:\tLD\tA,(HL)\n\tINC\tHL\n\tLD\t(DE),A\n\tINC\tDE\n\tOR\tA\n\tJR\tNZ,INSV2\n\tDEC\tDE\n\tPOP\tHL\n\tCALL\tMALLOC\n\tEX\tDE,HL\nINSV3:\tPOP\tHL\n\tLD\t(HL),E\n\tINC\tHL\n\tLD\t(HL),D\n\tPOP\tDE\n\tJP\tMFREE\n");
            set.add(LibItem.INLNB);
            set.add(LibItem.MFIND);
            set.add(LibItem.MALLOC);
            set.add(LibItem.MFREE);
            set.add(LibItem.EMPTY_STRING);
        }
        if (set.contains((Object)LibItem.INRSV)) {
            asmCodeBuf.append("INRSV:\tLD\tE,(HL)\n\tINC\tHL\n\tLD\tD,(HL)\n\tDEC\tHL\n\tPUSH\tDE\n\tPUSH\tHL\n\tCALL\tMFIND\n\tPUSH\tDE\n\tEX\tDE,HL\n\tLD\tC,0FFH\n\tCALL\tINLNR\n\tEX\tDE,HL\n\tPOP\tHL\n\tCALL\tMALLOC\n\tEX\tDE,HL\n\tPOP\tHL\n\tLD\t(HL),E\n\tINC\tHL\n\tLD\t(HL),D\n\tPOP\tDE\n\tJP\tMFREE\n");
            set.add(LibItem.INLNR);
            set.add(LibItem.MFIND);
            set.add(LibItem.MALLOC);
            set.add(LibItem.MFREE);
        }
        if (set.contains((Object)LibItem.INLNB)) {
            asmCodeBuf.append("INLNB:\tLD\tHL,M_STMP\n\tLD\tC,");
            asmCodeBuf.appendHex2(255);
            asmCodeBuf.append("\n\tCALL\tINLNR\n\tLD\tHL,M_STMP-1\nINLNB1:\tINC\tHL\n\tLD\tA,(HL)\n\tOR\tA\n\tRET\tZ\n\tCP\t21H\n\tJR\tC,INLNB1\n\tRET\n");
            set.add(LibItem.INLNR);
            set.add(LibItem.M_STMP);
        }
        if (set.contains((Object)LibItem.INLNR)) {
            asmCodeBuf.append("INLNR:\tPUSH\tHL\n\tLD\tB,C\nINLNR1:\tLD\t(HL),20H\n\tINC\tHL\n\tDJNZ\tINLNR1\n\tPOP\tHL\n\tLD\tB,00H\n\tJR\tINLNR3\nINLNR2:\tPUSH\tBC\n\tPUSH\tHL\n\tLD\tA,D\n\tCALL\tXOUTCH\n\tPOP\tHL\n\tPOP\tBC\nINLNR3:\tPUSH\tHL\n\tPUSH\tBC\n\tCALL\tXINCH\n\tPOP\tBC\n\tPOP\tHL\n\tLD\tD,A\n\tCP\t08H\n\tJR\tZ,INLNR5\n\tCP\t7FH\n\tJR\tZ,INLNR5\n\tCP\t09H,\n\tJR\tZ,INLNR6\n\tCP\t0DH\n\tJR\tZ,INLNR7\n\tCP\t20H\n\tJR\tC,INLNR3\nINLNR4:\tLD\tA,B\n\tCP\tC\n\tJR\tNC,INLNR3\n\tLD\t(HL),D\n\tINC\tHL\n\tINC\tB\n\tJR\tINLNR2\nINLNR5:\tLD\tA,B\n\tOR\tA\n\tJR\tZ,INLNR3\n\tDEC\tHL\n\tDEC\tB\n\tPUSH\tBC\n\tPUSH\tDE\n\tPUSH\tHL\n\tLD\tA,D\n\tCALL\tXOUTCH\n\tLD\tA,20H\n\tCALL\tXOUTCH\n\tPOP\tHL\n\tPOP\tDE\n\tPOP\tBC\n\tJR\tINLNR2\nINLNR6:\tLD\tA,B\n\tCP\tC\n\tJR\tNC,INLNR3\n\tINC\tHL\n\tINC\tB\n\tJR\tINLNR2\nINLNR7:\tLD\t(HL),00H\n\tJP\tXOUTNL\n");
            set.add(LibItem.XINCH);
            set.add(LibItem.XOUTNL);
            set.add(LibItem.XOUTCH);
        }
        if (set.contains((Object)LibItem.INPWV)) {
            asmCodeBuf.append("INPWV:\tLD\tE,(HL)\n\tINC\tHL\n\tLD\tD,(HL)\n\tDEC\tHL\n\tPUSH\tDE\n\tPUSH\tHL\n\tCALL\tMFIND\n\tPUSH\tDE\n\tEX\tDE,HL\n\tLD\tB,00H\nINPWV1:\tPUSH\tBC\n\tPUSH\tHL\n\tCALL\tXINCH\n\tPOP\tHL\n\tPOP\tBC\n\tCP\t08H\n\tJR\tZ,INPWV3\n\tCP\t7FH\n\tJR\tZ,INPWV3\n\tCP\t0DH\n\tJR\tZ,INPWV4\n\tCP\t20H\n\tJR\tC,INPWV1\n\tINC\tB\n\tJR\tZ,INPWV2\n\tLD\t(HL),A\n\tINC\tHL\n\tLD\tA,2AH\n\tPUSH\tBC\n\tPUSH\tHL\n\tCALL\tXOUTCH\n\tPOP\tHL\n\tPOP\tBC\n\tJR\tINPWV1\nINPWV2:\tDEC\tB\n\tJR\tINPWV1\nINPWV3:\tLD\tA,B\n\tOR\tA\n\tJR\tZ,INPWV1\n\tDEC\tB\n\tDEC\tHL\n\tXOR\tA\n\tLD\t(HL),A\n\tPUSH\tBC\n\tPUSH\tHL\n\tLD\tA,08H\n\tCALL\tXOUTCH\n\tLD\tA,20H\n\tCALL\tXOUTCH\n\tLD\tA,08H\n\tCALL\tXOUTCH\n\tPOP\tHL\n\tPOP\tBC\n\tJR\tINPWV1\nINPWV4:\tXOR\tA\n\tLD\t(HL),A\n\tPUSH\tHL\n\tCALL\tXOUTNL\n\tPOP\tDE\n\tPOP\tHL\n\tCALL\tMALLOC\n\tEX\tDE,HL\n\tPOP\tHL\n\tLD\t(HL),E\n\tINC\tHL\n\tLD\t(HL),D\n\tPOP\tDE\n\tJP\tMFREE\n");
            set.add(LibItem.MFIND);
            set.add(LibItem.MALLOC);
            set.add(LibItem.MFREE);
            set.add(LibItem.XINCH);
            set.add(LibItem.XOUTNL);
            set.add(LibItem.XOUTCH);
        }
        if (set.contains((Object)LibItem.P_I)) {
            asmCodeBuf.append("P_I:\tCALL\tS_STR\n\tJP\tXOUTS\n");
            set.add(LibItem.S_STR);
            set.add(LibItem.XOUTS);
        }
        if (set.contains((Object)LibItem.P_IF)) {
            asmCodeBuf.append("P_IF:\tCALL\tS_STR\n\tPUSH\tHL\n\tCALL\tF_LEN\n\tLD\tA,0EH\n\tSUB\tL\n\tJR\tC,P_IF2\n\tJR\tZ,P_IF2\nP_IF1:\tPUSH\tAF\n\tLD\tA,20H\n\tCALL\tXOUTCH\n\tPOP\tAF\n\tDEC\tA\n\tJR\tNZ,P_IF1\nP_IF2:\tPOP\tHL\n\tJP\tXOUTS\n");
            set.add(LibItem.S_STR);
            set.add(LibItem.F_LEN);
            set.add(LibItem.XOUTCH);
            set.add(LibItem.XOUTS);
        }
        if (set.contains((Object)LibItem.PS_I)) {
            asmCodeBuf.append("PS_I:\tCALL\tS_STR\n\tJP\tPS_S\n");
            set.add(LibItem.S_STR);
            set.add(LibItem.PS_S);
        }
        if (set.contains((Object)LibItem.PRINT_SPC)) {
            asmCodeBuf.append("PRINT_SPC:\n\tBIT\t7,H\n\tRET\tNZ\nPRINT_SPC1:\n\tLD\tA,H\n\tOR\tL\n\tRET\tZ\n\tPUSH\tHL\n\tLD\tA,20H\n\tCALL\tXOUTCH\n\tPOP\tHL\n\tDEC\tHL\n\tJR\tPRINT_SPC1\n");
            set.add(LibItem.XOUTCH);
        }
        if (set.contains((Object)LibItem.IO_PRINT_SPC)) {
            asmCodeBuf.append("IO_PRINT_SPC:\n\tBIT\t7,H\n\tRET\tNZ\nIO_PRINT_SPC1:\n\tLD\tA,H\n\tOR\tL\n\tRET\tZ\n\tPUSH\tHL\n\tLD\tA,20H\n\tCALL\tIO_COUT\n\tPOP\tHL\n\tDEC\tHL\n\tJR\tIO_PRINT_SPC1\n");
            set.add(LibItem.IO_COUT);
        }
        if (set.contains((Object)LibItem.PS_IF)) {
            asmCodeBuf.append("PS_IF:\tCALL\tS_STR\n\tPUSH\tHL\n\tCALL\tF_LEN\n\tLD\tA,0EH\n\tSUB\tL\n\tJR\tC,PS_IF2\n\tJR\tZ,PS_IF2\nPS_IF1:\tPUSH\tAF\n\tLD\tA,20H\n\tCALL\tIO_COUT\n\tPOP\tAF\n\tDEC\tA\n\tJR\tNZ,PS_IF1\nPS_IF2:\tPOP\tHL\n\tJP\tPS_S\n");
            set.add(LibItem.S_STR);
            set.add(LibItem.F_LEN);
            set.add(LibItem.PS_S);
            set.add(LibItem.IO_COUT);
        }
        if (set.contains((Object)LibItem.PS_ST)) {
            asmCodeBuf.append("PS_ST:\tEX\t(SP),HL\n\tCALL\tPS_S\n\tEX\t(SP),HL\n\tRET\n");
            set.add(LibItem.PS_S);
        }
        if (set.contains((Object)LibItem.PS_S)) {
            asmCodeBuf.append("PS_S:\tLD\tA,(HL)\n\tINC\tHL\n\tOR\tA\n\tRET\tZ\n\tPUSH\tHL\n\tCALL\tIO_COUT\n\tPOP\tHL\n\tJR\tPS_S\n");
            set.add(LibItem.IO_COUT);
        }
        if (set.contains((Object)LibItem.PS_SP)) {
            asmCodeBuf.append("PS_SP:\tLD\tA,20H\n\tJR\tIO_COUT\n");
            set.add(LibItem.IO_COUT);
        }
        if (set.contains((Object)LibItem.PS_NL)) {
            asmCodeBuf.append("PS_NL:\tLD\tA,0DH\n\tCALL\tIO_COUT\n\tLD\tA,0AH\n");
            set.add(LibItem.IO_COUT);
        }
        if (set.contains((Object)LibItem.IO_COUT)) {
            asmCodeBuf.append("IO_COUT:\n\tLD\tHL,(IO_M_COUT)\n\tJP\t(HL)\n");
            set.add(LibItem.IO_M_COUT);
        }
        if (set.contains((Object)LibItem.IO_SET_COUT)) {
            asmCodeBuf.append("IO_SET_COUT:\n\tLD\t(IO_M_COUT),HL\n");
            BasicLibrary.appendResetErrorUseBC(basicCompiler);
            asmCodeBuf.append("\tLD\tA,H\n\tOR\tL\n\tRET\tNZ\n");
            BasicLibrary.appendSetErrorChannelClosed(basicCompiler);
            asmCodeBuf.append("\tSCF\n\tRET\n");
            set.add(LibItem.IO_M_COUT);
        }
        if (set.contains((Object)LibItem.CIRCLE)) {
            asmCodeBuf.append("CIRCLE:\tLD\tDE,(CIRCLE_M_R)\n\tLD\tA,D\n\tOR\tA\n\tJP\tM,E_PARM\n\tOR\tE\n\tRET\tZ\n\tLD\tHL,0001\n\tSBC\tHL,DE\n\tLD\t(CIRCLE_M_ER),HL\n\tLD\tHL,0000H\n\tLD\t(CIRCLE_M_RX),HL\n\tLD\t(CIRCLE_M_RY),DE\n\tLD\tHL,(CIRCLE_M_X)\n\tLD\t(CIRCLE_M_XMX),HL\n\tLD\t(CIRCLE_M_XPX),HL\n\tOR\tA\n\tSBC\tHL,DE\n\tLD\t(CIRCLE_M_XMY),HL\n\tADD\tHL,DE\n\tADD\tHL,DE\n\tLD\t(CIRCLE_M_XPY),HL\n\tLD\tHL,(CIRCLE_M_Y)\n\tLD\t(CIRCLE_M_YMX),HL\n\tLD\t(CIRCLE_M_YPX),HL\n\tOR\tA\n\tSBC\tHL,DE\n\tLD\t(CIRCLE_M_YMY),HL\n\tADD\tHL,DE\n\tADD\tHL,DE\n\tLD\t(CIRCLE_M_YPY),HL\nCIRCLE1:\n\tLD\tHL,(CIRCLE_M_RY)\n\tLD\tB,H\n\tLD\tC,L\n\tLD\tDE,(CIRCLE_M_RX)\n\tOR\tA\n\tSBC\tHL,DE\n\tRET\tC\n\tPUSH\tAF\n\tPUSH\tDE\n\tCALL\tCIRCLE3\n\tPOP\tDE\n\tPOP\tAF\n\tRET\tZ\n\tINC\tDE\n\tLD\t(CIRCLE_M_RX),DE\n\tLD\tHL,(CIRCLE_M_XMX)\n\tDEC\tHL\n\tLD\t(CIRCLE_M_XMX),HL\n\tLD\tHL,(CIRCLE_M_XPX)\n\tINC\tHL\n\tLD\t(CIRCLE_M_XPX),HL\n\tLD\tHL,(CIRCLE_M_YMX)\n\tDEC\tHL\n\tLD\t(CIRCLE_M_YMX),HL\n\tLD\tHL,(CIRCLE_M_YPX)\n\tINC\tHL\n\tLD\t(CIRCLE_M_YPX),HL\n\tLD\tHL,(CIRCLE_M_ER)\n\tBIT\t7,H\n\tJR\tZ,CIRCLE2\n\tSLA\tE\n\tRL\tD\n\tADD\tHL,DE\n\tDEC\tHL\n\tLD\t(CIRCLE_M_ER),HL\n\tJR\tCIRCLE1\nCIRCLE2:\n\tLD\tB,H\n\tLD\tC,L\n\tLD\tHL,(CIRCLE_M_RY)\n\tEX\tDE,HL\n\tOR\tA\n\tSBC\tHL,DE\n\tADD\tHL,HL\n\tADD\tHL,BC\n\tLD\t(CIRCLE_M_ER),HL\n\tLD\tHL,(CIRCLE_M_RY)\n\tDEC\tHL\n\tLD\t(CIRCLE_M_RY),HL\n\tLD\tHL,(CIRCLE_M_XMY)\n\tINC\tHL\n\tLD\t(CIRCLE_M_XMY),HL\n\tLD\tHL,(CIRCLE_M_XPY)\n\tDEC\tHL\n\tLD\t(CIRCLE_M_XPY),HL\n\tLD\tHL,(CIRCLE_M_YMY)\n\tINC\tHL\n\tLD\t(CIRCLE_M_YMY),HL\n\tLD\tHL,(CIRCLE_M_YPY)\n\tDEC\tHL\n\tLD\t(CIRCLE_M_YPY),HL\n\tJP\tCIRCLE1\nCIRCLE3:\n\tJR\tZ,CIRCLE5\n\tLD\tA,D\n\tOR\tE\n\tEXX\n\tJR\tZ,CIRCLE4\n\tLD\tDE,(CIRCLE_M_XMX)\n\tCALL\tCIRCLE9\nCIRCLE4:\n\tLD\tDE,(CIRCLE_M_XPX)\n\tCALL\tCIRCLE9\n\tEXX\nCIRCLE5:\n\tLD\tA,B\n\tOR\tC\n\tEXX\n\tJR\tZ,CIRCLE6\n\tLD\tDE,(CIRCLE_M_XMY)\n\tCALL\tCIRCLE7\nCIRCLE6:\n\tLD\tDE,(CIRCLE_M_XPY)\nCIRCLE7:\n\tEXX\n\tLD\tA,D\n\tOR\tE\n\tEXX\n\tJR\tZ,CIRCLE8\n\tLD\tHL,(CIRCLE_M_YMX)\n\tPUSH\tDE\n\tCALL\tXPSET\n\tPOP\tDE\nCIRCLE8:\n\tLD\tHL,(CIRCLE_M_YPX)\n\tJP\tXPSET\nCIRCLE9:\n\tEXX\n\tLD\tA,B\n\tOR\tC\n\tEXX\n\tJR\tZ,CIRCLE10\n\tLD\tHL,(CIRCLE_M_YMY)\n\tPUSH\tDE\n\tCALL\tXPSET\n\tPOP\tDE\nCIRCLE10:\n\tLD\tHL,(CIRCLE_M_YPY)\n\tJP\tXPSET\n");
            set.add(LibItem.E_PARM);
            set.add(LibItem.XPSET);
        }
        if (set.contains((Object)LibItem.ONGOAD)) {
            asmCodeBuf.append("ONGOAD:\tLD\tA,H\n\tOR\tA\n\tJP\tM,E_PARM\n\tEX\tDE,HL\n\tEX\t(SP),HL\n\tLD\tA,(HL)\n\tINC\tHL\n\tPUSH\tHL\n\tLD\tB,0\n\tLD\tC,A\n\tADD\tHL,BC\n\tADD\tHL,BC\n\tPOP\tBC\n\tEX\t(SP),HL\n\tLD\tH,0\n\tLD\tL,A\n\tLD\tA,D\n\tOR\tA\n\tJR\tNZ,ONGOA1\n\tOR\tE\n\tJR\tZ,ONGOA1\n\tDEC\tDE\n\tLD\tA,L\n\tCP\tE\n\tJR\tZ,ONGOA1\n\tJR\tC,ONGOA1\n\tEX\tDE,HL\n\tADD\tHL,HL\n\tADD\tHL,BC\n\tLD\tA,(HL)\n\tINC\tHL\n\tLD\tH,(HL)\n\tLD\tL,A\n\tJR\tONGOA2\nONGOA1:\tLD\tHL,0000H\nONGOA2:\tLD\tA,H\n\tOR\tL\n\tRET\n");
            set.add(LibItem.E_PARM);
        }
        if (set.contains((Object)LibItem.LOCATE)) {
            asmCodeBuf.append("LOCATE:\tLD\tA,D\n\tOR\tH\n\tAND\t80H\n\tJP\tZ,XLOCATE\n\tJP\tE_PARM\n");
            set.add(LibItem.E_PARM);
            set.add(LibItem.XLOCATE);
        }
        if (set.contains((Object)LibItem.DRLBLT)) {
            asmCodeBuf.append("DRLBLT:\tEX\t(SP),HL\n\tCALL\tDRLBL\n\tEX\t(SP),HL\n\tRET\n");
            set.add(LibItem.DRLBL);
        }
        if (set.contains((Object)LibItem.DRLBL)) {
            asmCodeBuf.append("DRLBL:\tLD\tA,(HL)\n\tINC\tHL\n\tOR\tA\n\tRET\tZ\n\tCP\t20H\n\tJR\tZ,DRLBL5\n\tCP\t7FH\n\tJR\tNC,DRLBL\n\tSUB\t21H\n\tJR\tC,DRLBL\n\tPUSH\tHL\n\tLD\tB,00H\n\tLD\tC,A\n\tLD\tH,B\n\tLD\tL,C\n\tADD\tHL,HL\n\tADD\tHL,BC\n\tADD\tHL,HL\n\tLD\tBC,FONT_5X7\n\tADD\tHL,BC\n\tLD\tDE,(M_XPOS)\n\tLD\tA,(HL)\n\tINC\tHL\n\tLD\tC,A\nDRLBL1:\tLD\tA,(HL)\n\tPUSH\tHL\n\tLD\tHL,(M_YPOS)\n\tLD\tB,08H\nDRLBL2:\tSRL\tA\n\tJR\tNC,DRLBL3\n\tPUSH\tAF\n\tPUSH\tBC\n\tPUSH\tDE\n\tPUSH\tHL\n\tCALL\tXPSET\n\tPOP\tHL\n\tPOP\tDE\n\tPOP\tBC\n\tPOP\tAF\nDRLBL3:\tINC\tHL\n\tDJNZ\tDRLBL2\n\tINC\tDE\n\tPOP\tHL\n\tINC\tHL\n\tDEC\tC\n\tJR\tNZ,DRLBL1\n\tPOP\tHL\nDRLBL4:\tINC\tDE\n\tINC\tDE\n\tLD\t(M_XPOS),DE\n\tJR\tDRLBL\nDRLBL5:\tLD\tDE,(M_XPOS)\n\tINC\tDE\n\tINC\tDE\n\tJR\tDRLBL4\n");
            set.add(LibItem.FONT_5X7);
            set.add(LibItem.M_XYPO);
            set.add(LibItem.XPSET);
        }
        if (set.contains((Object)LibItem.DRAWST)) {
            asmCodeBuf.append("DRAWST:\tEX\t(SP),HL\n\tCALL\tDRAWS\n\tEX\tDE,HL\n\tEX\t(SP),HL\n\tRET\n");
            set.add(LibItem.DRAWS);
        }
        if (set.contains((Object)LibItem.DRAWS)) {
            asmCodeBuf.append("DRAWS:\tEX\tDE,HL\nDRAWS1:\tXOR\tA\n\tLD\t(M_DRSM),A\nDRAWS2:\tLD\tA,(DE)\n\tINC\tDE\n\tOR\tA\n\tRET\tZ\n\tCALL\tC_UPR\n\tCP\t42H\n\tJP\tZ,DRAWS_MOVE\n\tCP\t44H\n\tJR\tZ,DRAWS_DOWN\n\tCP\t45H\n\tJP\tZ,DRAWS_RIGHT_UP\n\tCP\t46H\n\tJR\tZ,DRAWS_RIGHT_DOWN\n\tCP\t47H\n\tJR\tZ,DRAWS_LEFT_DOWN\n\tCP\t48H\n\tJR\tZ,DRAWS_LEFT_UP\n\tCP\t4CH\n\tJR\tZ,DRAWS_LEFT\n\tCP\t4DH\n\tJP\tZ,DRAWS_TO\n\tCP\t52H\n\tJR\tZ,DRAWS_RIGHT\n\tCP\t55H\n\tJR\tZ,DRAWS_UP\n\tJP\tE_PARM\nDRAWS_DOWN:\n\tCALL\tDRAWS_NUM\n\tPUSH\tDE\n\tCALL\tNEGHL\n\tLD\tDE,0000H\n\tCALL\tDRAWS_REL\n\tPOP\tDE\n\tJR\tDRAWS1\nDRAWS_LEFT:\n\tCALL\tDRAWS_NUM\n\tPUSH\tDE\n\tCALL\tNEGHL\n\tEX\tDE,HL\n\tLD\tHL,0000H\n\tCALL\tDRAWS_REL\n\tPOP\tDE\n\tJR\tDRAWS1\nDRAWS_LEFT_DOWN:\n\tCALL\tDRAWS_NUM\n\tPUSH\tDE\n\tCALL\tNEGHL\n\tLD\tD,H\n\tLD\tE,L\n\tCALL\tDRAWS_REL\n\tPOP\tDE\n\tJR\tDRAWS1\nDRAWS_LEFT_UP:\n\tCALL\tDRAWS_NUM\n\tPUSH\tDE\n\tLD\tD,H\n\tLD\tE,L\n\tCALL\tNEGHL\n\tEX\tDE,HL\n\tCALL\tDRAWS_REL\n\tPOP\tDE\n\tJR\tDRAWS1\nDRAWS_RIGHT:\n\tCALL\tDRAWS_NUM\n\tPUSH\tDE\n\tEX\tDE,HL\n\tLD\tHL,0000H\n\tCALL\tDRAWS_REL\n\tPOP\tDE\n\tJP\tDRAWS1\nDRAWS_RIGHT_DOWN:\n\tCALL\tDRAWS_NUM\n\tPUSH\tDE\n\tLD\tD,H\n\tLD\tE,L\n\tCALL\tNEGHL\n\tCALL\tDRAWS_REL\n\tPOP\tDE\n\tJP\tDRAWS1\nDRAWS_RIGHT_UP:\n\tCALL\tDRAWS_NUM\n\tPUSH\tDE\n\tLD\tD,H\n\tLD\tE,L\n\tCALL\tDRAWS_REL\n\tPOP\tDE\n\tJP\tDRAWS1\nDRAWS_UP:\n\tCALL\tDRAWS_NUM\n\tPUSH\tDE\n\tLD\tDE,0000H\n\tCALL\tDRAWS_REL\n\tPOP\tDE\n\tJP\tDRAWS1\nDRAWS_TO:\n\tLD\tA,(DE)\n\tCP\t2BH\n\tJR\tZ,DRAWS_TO_REL\n\tCP\t2DH\n\tJR\tZ,DRAWS_TO_REL\n\tCALL\tDRAWS_PARSE_POINT\n\tLD\tA,(M_DRSM)\n\tOR\tA\n\tJR\tNZ,DRAWS_TO1\n\tPUSH\tDE\n\tLD\t(LINE_M_EX),BC\n\tLD\t(LINE_M_EY),HL\n\tCALL\tDRAW\n\tPOP\tDE\n\tJP\tDRAWS1\nDRAWS_TO1:\n\tLD\t(M_XPOS),BC\n\tLD\t(M_YPOS),HL\n\tJP\tDRAWS1\nDRAWS_TO_REL:\n\tCALL\tDRAWS_PARSE_POINT\n\tPUSH\tDE\n\tLD\tD,B\n\tLD\tE,C\n\tCALL\tDRAWS_REL\n\tPOP\tDE\n\tJP\tDRAWS1\nDRAWS_MOVE:\n\tLD\tA,01H\n\tLD\t(M_DRSM),A\n\tJP\tDRAWS2\nDRAWS_PARSE_POINT:\n\tCALL\tDRAWS_SIGNED_NUM\n\tPUSH\tHL\n\tLD\tA,(DE)\n\tCP\t2CH\n\tJP\tNZ,E_PARM\n\tINC\tDE\n\tCALL\tDRAWS_SIGNED_NUM\n\tPOP\tBC\n\tRET\nDRAWS_SIGNED_NUM:\n\tLD\tA,(DE)\n\tCP\t2BH\n\tJR\tNZ,DRAWS_SIGNED_NUM1\n\tINC\tDE\n\tJR\tDRAWS_SIGNED_NUM2\nDRAWS_SIGNED_NUM1:\n\tCP\t2DH\n\tJR\tNZ,DRAWS_SIGNED_NUM2\n\tINC\tDE\n\tCALL\tDRAWS_SIGNED_NUM2\n\tCALL\tNEGHL\n\tRET\nDRAWS_SIGNED_NUM2:\n\tLD\tA,(DE)\n\tSUB\t30H\n\tJP\tC,E_PARM\n\tCP\t0AH\n\tJP\tNC,E_PARM\n\tJR\tDRAWS_NUM1\nDRAWS_NUM:\n\tLD\tA,(DE)\n\tSUB\t30H\n\tJR\tC,DRAWS_NUM3\n\tCP\t0AH\n\tJR\tNC,DRAWS_NUM3\nDRAWS_NUM1:\n\tLD\tL,A\n\tLD\tH,00H\nDRAWS_NUM2:\n\tINC\tDE\n\tLD\tA,(DE)\n\tSUB\t30H\n\tRET\tC\n\tCP\t0AH\n\tRET\tNC\n\tLD\tB,H\n\tLD\tC,L\n\tADD\tHL,HL\n\tADD\tHL,HL\n\tADD\tHL,BC\n\tADD\tHL,HL\n\tLD\tC,A\n\tLD\tB,00H\n\tADD\tHL,BC\n\tBIT\t7,H\n\tJP\tNZ,E_NOV\n\tJR\tDRAWS_NUM2\nDRAWS_NUM3:\n\tLD\tHL,0001H\n\tRET\nDRAWS_REL:\n\tLD\tA,(M_DRSM)\n\tOR\tA\n\tJR\tZ,DRAWR\n\tJP\tMOVER\n");
            set.add(LibItem.C_UPR);
            set.add(LibItem.ABS_NEG_HL);
            set.add(LibItem.DRAW);
            set.add(LibItem.DRAWR);
            set.add(LibItem.MOVER);
            set.add(LibItem.E_NOV);
            set.add(LibItem.E_PARM);
        }
        if (set.contains((Object)LibItem.DRAWR)) {
            asmCodeBuf.append("DRAWR:\tPUSH\tHL\n\tLD\tHL,(M_XPOS)\n\tLD\t(LINE_M_BX),HL\n\tCALL\tO_ADD\n\tLD\t(LINE_M_EX),HL\n\tPOP\tDE\n\tLD\tHL,(M_YPOS)\n\tLD\t(LINE_M_BY),HL\n\tCALL\tO_ADD\n\tLD\t(LINE_M_EY),HL\n\tJR\tDRAW1\n");
            set.add(LibItem.M_XYPO);
            set.add(LibItem.O_ADD);
            set.add(LibItem.DRAW);
        }
        if (set.contains((Object)LibItem.DRAW)) {
            asmCodeBuf.append("DRAW:\tLD\tHL,(M_XPOS)\n\tLD\t(LINE_M_BX),HL\n\tLD\tHL,(M_YPOS)\n\tLD\t(LINE_M_BY),HL\nDRAW1:\tCALL\tDRAW_LINE2\n\tLD\tHL,(LINE_M_EX)\n\tLD\t(M_XPOS),HL\n\tLD\tHL,(LINE_M_EY)\n\tLD\t(M_YPOS),HL\n\tRET\n");
            set.add(LibItem.M_XYPO);
            set.add(LibItem.DRAW_LINE);
        }
        if (set.contains((Object)LibItem.DRAW_LINE)) {
            asmCodeBuf.append("DRAW_LINE:\n");
            if (abstractTarget.supportsXHLINE()) {
                asmCodeBuf.append("\tLD\tHL,(LINE_M_EY)\n\tLD\tDE,(LINE_M_BY)\n\tOR\tA\n\tSBC\tHL,DE\n\tJR\tNZ,DRAW_LINE1\n\tCALL\tH_BOX\n\tRET\tC\n\tJP\tDRAW_HLINE\nDRAW_LINE1:\n");
                set.add(LibItem.H_BOX);
                set.add(LibItem.DRAW_HLINE);
            }
            asmCodeBuf.append("\tLD\tDE,(LINE_M_BX)\n\tLD\tHL,(LINE_M_BY)\n\tCALL\tXPSET\nDRAW_LINE2:\n\tLD\tBC,0001H\n\tLD\tHL,(LINE_M_EX)\n\tLD\tDE,(LINE_M_BX)\n\tOR\tA\n\tSBC\tHL,DE\n\tBIT\t7,H\n\tJR\tZ,DRAW_LINE3\n\tCALL\tNEGHL\n\tLD\tBC,0FFFFH\nDRAW_LINE3:\n\tLD\t(LINE_M_SX),BC\n\tPUSH\tHL\n\tPUSH\tHL\n\tLD\tBC,0001H\n\tLD\tHL,(LINE_M_EY)\n\tLD\tDE,(LINE_M_BY)\n\tOR\tA\n\tSBC\tHL,DE\n\tBIT\t7,H\n\tJR\tZ,DRAW_LINE4\n\tCALL\tNEGHL\n\tLD\tBC,0FFFFH\nDRAW_LINE4:\n\tLD\t(LINE_M_SY),BC\n\tPUSH\tHL\n\tEXX\n\tPOP\tBC\n\tPOP\tDE\n\tEXX\n\tEX\tDE,HL\n\tPOP\tHL\n\tOR\tA\n\tSBC\tHL,DE\n\tJR\tC,DRAW_LINE7\n\tEXX\n\tLD\tH,D\n\tLD\tL,E\n\tSRA\tH\n\tRR\tL\n\tEXX\n\tLD\tDE,(LINE_M_BX)\nDRAW_LINE5:\n\tLD\tHL,(LINE_M_EX)\n\tOR\tA\n\tSBC\tHL,DE\n\tRET\tZ\n\tEXX\n\tOR\tA\n\tSBC\tHL,BC\n\tEXX\n\tJR\tNC,DRAW_LINE6\n\tEXX\n\tADD\tHL,DE\n\tEXX\n\tLD\tHL,(LINE_M_BY)\n\tLD\tDE,(LINE_M_SY)\n\tADD\tHL,DE\n\tLD\t(LINE_M_BY),HL\nDRAW_LINE6:\n\tLD\tHL,(LINE_M_BX)\n\tLD\tDE,(LINE_M_SX)\n\tADD\tHL,DE\n\tLD\t(LINE_M_BX),HL\n\tPUSH\tHL\n\tEX\tDE,HL\n\tLD\tHL,(LINE_M_BY)\n\tCALL\tXPSET\n\tPOP\tDE\n\tJR\tDRAW_LINE5\nDRAW_LINE7:\n\tEXX\n\tLD\tH,B\n\tLD\tL,C\n\tSRA\tH\n\tRR\tL\n\tEXX\n\tLD\tDE,(LINE_M_BY)\nDRAW_LINE8:\n\tLD\tHL,(LINE_M_EY)\n\tOR\tA\n\tSBC\tHL,DE\n\tRET\tZ\n\tEXX\n\tOR\tA\n\tSBC\tHL,DE\n\tEXX\n\tJR\tNC,DRAW_LINE9\n\tEXX\n\tADD\tHL,BC\n\tEXX\n\tLD\tHL,(LINE_M_BX)\n\tLD\tDE,(LINE_M_SX)\n\tADD\tHL,DE\n\tLD\t(LINE_M_BX),HL\nDRAW_LINE9:\n\tLD\tHL,(LINE_M_BY)\n\tLD\tDE,(LINE_M_SY)\n\tADD\tHL,DE\n\tLD\t(LINE_M_BY),HL\n\tPUSH\tHL\n\tLD\tDE,(LINE_M_BX)\n\tCALL\tXPSET\n\tPOP\tDE\n\tJR\tDRAW_LINE8\n");
            set.add(LibItem.ABS_NEG_HL);
            set.add(LibItem.M_XYPO);
            set.add(LibItem.XPSET);
        }
        if (set.contains((Object)LibItem.DRBOX)) {
            asmCodeBuf.append("DRBOX:\tCALL\tH_BOX\n\tRET\tC\n\tPUSH\tBC\n\tPUSH\tDE\n\tPUSH\tHL\n\tCALL\tDRAW_HLINE\n\tPOP\tHL\n\tPOP\tDE\n\tPOP\tBC\n\tLD\tA,(LINE_M_EY)\n\tCP\tL\n\tJR\tNZ,DRBOX1\n\tLD\tA,(LINE_M_EY+1)\n\tCP\tH\n\tRET\tZ\nDRBOX1:\tINC\tHL\n\tLD\tA,(LINE_M_EY)\n\tCP\tL\n\tJR\tNZ,DRBOX2\n\tLD\tA,(LINE_M_EY+1)\n\tCP\tH\n\tJP\tZ,DRAW_HLINE\nDRBOX2:\tPUSH\tBC\n\tPUSH\tDE\n\tPUSH\tHL\n\tCALL\tXPSET\n\tPOP\tHL\n\tLD\tDE,(LINE_M_EX)\n\tPUSH\tHL\n\tCALL\tXPSET\n\tPOP\tHL\n\tPOP\tDE\n\tPOP\tBC\n\tJR\tDRBOX1\n");
            set.add(LibItem.H_BOX);
            set.add(LibItem.DRAW_HLINE);
            set.add(LibItem.XPSET);
        }
        if (set.contains((Object)LibItem.DRBOXF)) {
            asmCodeBuf.append("DRBOXF:CALL\tH_BOX\n\tRET\tC\n\tCALL\tDRAW_HLINE_CHECK_X\nDRBXF1:\tPUSH\tBC\n\tPUSH\tDE\n\tPUSH\tHL\n");
            if (abstractTarget.supportsXHLINE()) {
                asmCodeBuf.append("\tCALL\tXHLINE\n");
                set.add(LibItem.XHLINE);
            } else {
                asmCodeBuf.append("\tCALL\tDRAW_HLINE1\n");
            }
            asmCodeBuf.append("\tPOP\tHL\n\tPOP\tDE\n\tPOP\tBC\n\tLD\tA,(LINE_M_EY)\n\tCP\tL\n\tJR\tNZ,DRFBX2\n\tLD\tA,(LINE_M_EY+1)\n\tCP\tH\n\tRET\tZ\nDRFBX2:\tINC\tHL\n\tJR\tDRBXF1\n");
            set.add(LibItem.H_BOX);
            set.add(LibItem.DRAW_HLINE);
        }
        if (set.contains((Object)LibItem.H_BOX)) {
            asmCodeBuf.append("H_BOX:\tLD\tHL,(LINE_M_EY)\n\tLD\tDE,(LINE_M_BY)\n\tCALL\tCPHLDE\n\tJR\tNC,H_BOX1\n\tEX\tDE,HL\n\tLD\t(LINE_M_BY),DE\n\tLD\t(LINE_M_EY),HL\nH_BOX1:\tBIT\t7,H\n\tJR\tNZ,H_BOX3\n\tLD\tHL,(LINE_M_EX)\n\tLD\tDE,(LINE_M_BX)\n\tCALL\tCPHLDE\n\tJR\tNC,H_BOX2\n\tEX\tDE,HL\n\tLD\t(LINE_M_BX),DE\n\tLD\t(LINE_M_EX),HL\nH_BOX2:\tBIT\t7,H\n\tJR\tNZ,H_BOX3\n\tOR\tA\n\tSBC\tHL,DE\n\tLD\tB,H\n\tLD\tC,L\n\tLD\tHL,(LINE_M_BY)\n\tOR\tA\n\tRET\nH_BOX3:\tSCF\n\tRET\n");
            set.add(LibItem.CPHLDE);
        }
        if (set.contains((Object)LibItem.DRAW_HLINE)) {
            asmCodeBuf.append("DRAW_HLINE:\n\tCALL\tDRAW_HLINE_CHECK_X\nDRAW_HLINE1:\n\tBIT\t7,H\n\tRET\tNZ\n\tBIT\t7,B\n\tRET\tNZ\n");
            if (abstractTarget.supportsXHLINE()) {
                asmCodeBuf.append("\tJP\tXHLINE\n");
                set.add(LibItem.XHLINE);
            } else {
                asmCodeBuf.append("DRAW_HLINE2:\n\tPUSH\tBC\n\tPUSH\tDE\n\tPUSH\tHL\n\tCALL\tXPSET\n\tPOP\tHL\n\tPOP\tDE\n\tPOP\tBC\n\tLD\tA,B\n\tOR\tC\n\tRET\tZ\n\tDEC\tBC\n\tINC\tDE\n\tJR\tDRAW_HLINE2\n");
            }
            asmCodeBuf.append("DRAW_HLINE_CHECK_X:\n\tBIT\t7,D\n\tRET\tZ\n\tEX\tDE,HL\n\tADD\tHL,BC\n\tLD\tB,H\n\tLD\tC,L\n\tEX\tDE,HL\n\tLD\tDE,0000H\n\tRET\n");
            set.add(LibItem.XPSET);
        }
        if (set.contains((Object)LibItem.MOVER)) {
            asmCodeBuf.append("MOVER:\tPUSH\tHL\n\tLD\tHL,(M_XPOS)\n\tCALL\tO_ADD\n\tLD\t(M_XPOS),HL\n\tPOP\tDE\n\tLD\tHL,(M_YPOS)\n\tCALL\tO_ADD\n\tLD\t(M_YPOS),HL\n\tRET\n");
            set.add(LibItem.O_ADD);
            set.add(LibItem.M_XYPO);
        }
        if (set.contains((Object)LibItem.PAINT)) {
            asmCodeBuf.append("PAINT:");
            int n2 = asmCodeBuf.length();
            abstractTarget.appendWPixelTo(asmCodeBuf);
            Object object = asmCodeBuf.cut(n2);
            if (!BasicUtil.isSingleInst_LD_HL_xx((String)object)) {
                asmCodeBuf.append((CharSequence)object);
                asmCodeBuf.append("\tLD\t(PAINT_M_WPIX),HL\n");
                object = "\tLD\tHL,(PAINT_M_WPIX)\n";
                set.add(LibItem.PAINT_M_WPIX);
            }
            n2 = asmCodeBuf.length();
            abstractTarget.appendHPixelTo(asmCodeBuf);
            String string = asmCodeBuf.cut(n2);
            if (!BasicUtil.isSingleInst_LD_HL_xx(string)) {
                asmCodeBuf.append(string);
                asmCodeBuf.append("\tLD\t(PAINT_M_HPIX),HL\n");
                string = "\tLD\tHL,(PAINT_M_HPIX)\n";
                set.add(LibItem.PAINT_M_HPIX);
            }
            if (abstractTarget.supportsXPAINT_LEFT_RIGHT()) {
                asmCodeBuf.append("\tCALL\tXPAINT_RIGHT\n\tRET\tC\n\tCALL\tXPAINT_LEFT\n");
            } else {
                asmCodeBuf.append("\tCALL\tPAINT_RIGHT\n\tRET\tC\n\tCALL\tPAINT_LEFT\n");
            }
            asmCodeBuf.append("\tCALL\tMFIND\n\tEX\tDE,HL\n\tLD\t(PAINT_M_TAD),HL\n\tDEC\tHL\n\tDEC\tHL\n\tLD\tD,(HL)\n\tDEC\tHL\n\tLD\tE,(HL)\n\tEX\tDE,HL\n\tLD\tDE,0005H\n\tCALL\tO_DIV\n\tLD\tA,H\n\tOR\tA\n\tJR\tZ,PAINT1\n\tLD\tL,00H\n\tJP\tM,PAINT1\n\tDEC\tL\nPAINT1:\tLD\tA,L\n\tOR\tA\n\tJP\tZ,E_OUT_OF_MEM\n\tLD\t(PAINT_M_TSZ),A\n\tXOR\tA\n\tLD\t(PAINT_M_TIX),A\n\tCALL\tPAINT_ADD\n\tLD\tA,80H\n\tCALL\tPAINT_ADD\nPAINT2:\tLD\tA,(PAINT_M_TIX)\n\tOR\tA\n\tRET\tZ\n\tDEC\tA\n\tLD\t(PAINT_M_TIX),A\n\tINC\tA\n\tCALL\tPAINT_GET_ENTRY_ADDR\n\tDEC\tHL\n\tLD\tE,(HL)\n\tLD\tD,00H\n\tLD\t(PAINT_M_Y),DE\n\tDEC\tHL\n\tLD\tD,(HL)\n\tDEC\tHL\n\tLD\tE,(HL)\n\tLD\t(PAINT_M_SX2),DE\n\tDEC\tHL\n\tLD\tA,(HL)\n\tLD\t(PAINT_M_SDIR),A\n\tDEC\tHL\n\tLD\tL,(HL)\n\tAND\t7FH\n\tLD\tH,A\n\tLD\t(PAINT_M_X),HL\n\tLD\tA,H\n\tOR\tL\n\tJR\tZ,PAINT3\n\tDEC\tHL\nPAINT3:\tLD\t(PAINT_M_CX1),HL\n\tINC\tDE\n");
            asmCodeBuf.append((CharSequence)object);
            asmCodeBuf.append("\tEX\tDE,HL\n\tOR\tA\n\tSBC\tHL,DE\n\tADD\tHL,DE\n\tJR\tC,PAINT4\n\tDEC\tHL\nPAINT4:\tLD\t(PAINT_M_CX2),HL\n");
            if (abstractTarget.supportsXPAINT_LEFT_RIGHT()) {
                asmCodeBuf.append("\tCALL\tXPAINT_RIGHT\n\tJR\tC,PAINT8\n\tCALL\tXPAINT_LEFT\n");
            } else {
                asmCodeBuf.append("\tCALL\tPAINT_RIGHT\n\tJR\tC,PAINT8\n\tCALL\tPAINT_LEFT\n");
            }
            asmCodeBuf.append("\tLD\tA,(PAINT_M_SDIR)\n\tCALL\tPAINT_ADD\n\tLD\tHL,(PAINT_M_X2)\n\tPUSH\tHL\n\tLD\tHL,(PAINT_M_X1)\n\tLD\tDE,(PAINT_M_CX1)\n\tOR\tA\n\tSBC\tHL,DE\n\tJR\tNC,PAINT5\n\tDEC\tDE\n\tLD\t(PAINT_M_X2),DE\n\tLD\tA,(PAINT_M_SDIR)\n\tXOR\t80H\n\tCALL\tPAINT_ADD\nPAINT5:\tPOP\tDE\nPAINT6:\tLD\tHL,(PAINT_M_CX2)\n\tOR\tA\n\tSBC\tHL,DE\n\tJR\tNC,PAINT7\n\tADD\tHL,DE\n\tINC\tHL\n\tLD\t(PAINT_M_X1),HL\n\tLD\t(PAINT_M_X1),DE\n\tLD\tA,(PAINT_M_SDIR)\n\tXOR\t80H\n\tCALL\tPAINT_ADD\nPAINT7:\tLD\tDE,(PAINT_M_X2)\n\tINC\tDE\n\tJR\tPAINT9\nPAINT8:\tLD\tDE,(PAINT_M_X)\nPAINT9:\tINC\tDE\n\tLD\tHL,(PAINT_M_SX2)\n\tOR\tA\n\tSBC\tHL,DE\n\tJP\tC,PAINT2\n\tLD\t(PAINT_M_X),DE\n");
            if (abstractTarget.supportsXPAINT_LEFT_RIGHT()) {
                asmCodeBuf.append("\tCALL\tXPAINT_RIGHT\n");
            } else {
                asmCodeBuf.append("\tCALL\tPAINT_RIGHT\n");
            }
            asmCodeBuf.append("\tJR\tC,PAINT8\n\tLD\tHL,(PAINT_M_X)\n\tLD\t(PAINT_M_X1),HL\n\tLD\tA,(PAINT_M_SDIR)\n\tCALL\tPAINT_ADD\n\tLD\tDE,(PAINT_M_X2)\n\tJR\tPAINT6\n");
            if (!abstractTarget.supportsXPAINT_LEFT_RIGHT()) {
                asmCodeBuf.append("PAINT_LEFT:\n\tLD\tDE,(PAINT_M_X)\nPAINT_LEFT1:\n\tLD\tA,D\n\tOR\tE\n\tJR\tZ,PAINT_LEFT2\n\tDEC\tDE\n\tPUSH\tDE\n\tLD\tHL,(PAINT_M_Y)\n\tCALL\tXPAINT\n\tPOP\tDE\n\tJR\tNC,PAINT_LEFT1\nPAINT_LEFT2:\n\tINC\tDE\n\tLD\t(PAINT_M_X1),DE\n\tRET\nPAINT_RIGHT:\n\tLD\tDE,(PAINT_M_X)\n\tLD\tHL,(PAINT_M_Y)\n\tPUSH\tDE\n\tCALL\tXPAINT\n\tPOP\tDE\n\tRET\tC\nPAINT_RIGHT1:\n\tINC\tDE\n");
                asmCodeBuf.append((CharSequence)object);
                asmCodeBuf.append("\tOR\tA\n\tSBC\tHL,DE\n\tJR\tZ,PAINT_RIGHT2\n\tJR\tC,PAINT_RIGHT2\n\tPUSH\tDE\n\tLD\tHL,(PAINT_M_Y)\n\tCALL\tXPAINT\n\tPOP\tDE\n\tJR\tNC,PAINT_RIGHT1\nPAINT_RIGHT2:\n\tDEC\tDE\n\tLD\t(PAINT_M_X2),DE\n\tOR\tA\n\tRET\n");
            }
            asmCodeBuf.append("PAINT_ADD:\n\tAND\t80H\n\tLD\tB,A\n\tLD\tHL,(PAINT_M_Y)\n\tBIT\t7,B\n\tJR\tNZ,PAINT_ADD1\n\tINC\tHL\n\tEX\tDE,HL\n");
            asmCodeBuf.append(string);
            asmCodeBuf.append("\tOR\tA\n\tSBC\tHL,DE\n\tRET\tZ\n\tRET\tC\n\tEX\tDE,HL\n\tJR\tPAINT_ADD2\nPAINT_ADD1:\n\tLD\tA,H\n\tOR\tL\n\tRET\tZ\n\tDEC\tHL\nPAINT_ADD2:\n\tLD\tA,(PAINT_M_TSZ)\n\tLD\tC,A\n\tLD\tA,(PAINT_M_TIX)\n\tCP\tC\n\tJP\tNC,E_OUT_OF_MEM\n\tLD\tC,A\n\tPUSH\tHL\n\tCALL\tPAINT_GET_ENTRY_ADDR\n\tLD\tDE,(PAINT_M_X1)\n\tLD\t(HL),E\n\tINC\tHL\n\tLD\tA,D\n\tOR\tB\n\tLD\t(HL),A\n\tINC\tHL\n\tLD\tDE,(PAINT_M_X2)\n\tLD\t(HL),E\n\tINC\tHL\n\tLD\t(HL),D\n\tINC\tHL\n\tPOP\tDE\n\tLD\t(HL),E\n\tLD\tA,C\n\tINC\tA\n\tLD\t(PAINT_M_TIX),A\n\tRET\nPAINT_GET_ENTRY_ADDR:\n\tLD\tL,A\n\tLD\tH,00H\n\tLD\tD,H\n\tLD\tE,L\n\tADD\tHL,HL\n\tADD\tHL,HL\n\tADD\tHL,DE\n\tLD\tDE,(PAINT_M_TAD)\n\tADD\tHL,DE\n\tRET\n");
            set.add(LibItem.MFIND);
            set.add(LibItem.O_DIV);
            set.add(LibItem.XPAINT);
        }
        if (set.contains((Object)LibItem.PAUSE)) {
            asmCodeBuf.append("PAUSE:\tCALL\tXINCH\n\tCP\t20H\n\tJR\tNZ,PAUSE\n\tRET\n");
            set.add(LibItem.XINCH);
        }
        if (set.contains((Object)LibItem.PAUSE_N)) {
            asmCodeBuf.append("PAUSE_N:\n\tBIT\t7,H\n\tRET\tNZ\nPAUSE_N1:\n\tLD\tA,H\n\tOR\tL\n\tRET\tZ\n\tDEC\tHL\n\tPUSH\tHL\n");
            asmCodeBuf.append_LD_DE_nn(abstractTarget.get100msLoopCount());
            asmCodeBuf.append("PAUSE_N2:\n\tLD\tB,0\nPAUSE_N3:\n\tDJNZ\tPAUSE_N3\n\tDEC\tDE\n\tLD\tA,D\n\tOR\tE\n\tJR\tNZ,PAUSE_N2\n\tCALL\tXINKEY\n\tPOP\tHL\n\tCP\t20H\n\tJR\tNZ,PAUSE_N1\n\tRET\n");
            set.add(LibItem.XINKEY);
        }
        if (set.contains((Object)LibItem.PEN)) {
            asmCodeBuf.append("PEN:\tLD\tA,H\n\tOR\tA\n\tJP\tNZ,E_PARM\n\tLD\tA,L\n\tCP\t04H\n\tJP\tNC,E_PARM\n\tLD\tA,L\n\tJP\tXPEN\n");
            set.add(LibItem.E_PARM);
            set.add(LibItem.XPEN);
        }
        if (set.contains((Object)LibItem.PLOTR)) {
            asmCodeBuf.append("PLOTR:\tPUSH\tHL\n\tLD\tHL,(M_XPOS)\n\tCALL\tO_ADD\n\tLD\t(LINE_M_EX),HL\n\tPOP\tDE\n\tLD\tHL,(M_YPOS)\n\tCALL\tO_ADD\n\tLD\t(LINE_M_EY),HL\n\tLD\tDE,(M_XPOS)\n\tJP\tXPSET\n");
            set.add(LibItem.M_XYPO);
            set.add(LibItem.O_ADD);
            set.add(LibItem.XPSET);
        }
        if (set.contains((Object)LibItem.CKSTK)) {
            asmCodeBuf.append("CKSTK:\tLD\tDE,0000H\nCKSTKN:");
            if (n <= 0) {
                asmCodeBuf.append("\tRET\n");
            } else {
                asmCodeBuf.append("\tLD\tHL,");
                asmCodeBuf.append("MTOP");
                asmCodeBuf.append('-');
                asmCodeBuf.appendHex4(n);
                asmCodeBuf.append("+10H");
                set.add(LibItem.MTOP);
                asmCodeBuf.append("\n\tADD\tHL,DE\n\tOR\tA\n\tSBC\tHL,SP\n\tRET\tC\n\tCALL\tXOUTST\n");
                if (basicCompiler.isLangCode("DE")) {
                    asmCodeBuf.append("\tDB\t'Stack-Ueberlauf'\n");
                } else {
                    asmCodeBuf.append("\tDB\t'Stack overflow'\n");
                }
                asmCodeBuf.append("\tDB\t00H\n\tJP\tE_EXIT\n");
                set.add(LibItem.E_EXIT);
                set.add(LibItem.XOUTST);
            }
        }
        if (set.contains((Object)LibItem.S_BIN)) {
            asmCodeBuf.append("S_BIN:\tLD\tDE,M_STMP\n\tLD\tB,10H\n\tLD\tA,31H\nS_BIN1:\tSLA\tL\n\tRL\tH\n\tJR\tC,S_BIN7\n\tDJNZ\tS_BIN1\n\tDEC\tA\n\tLD\t(DE),A\n\tINC\tDE\n\tJR\tS_BIN8\nS_BINN:\tLD\tA,B\n\tOR\tA\n\tJP\tM,E_PARM\n\tOR\tC\n\tJR\tZ,S_BIN\n\tLD\tDE,M_STMP\n\tPUSH\tHL\n\tLD\tHL,0010H\n\tOR\tA\n\tSBC\tHL,BC\n\tJR\tNC,S_BIN3\nS_BIN2:\tLD\tA,'0'\n\tLD\t(DE),A\n\tINC\tDE\n\tDEC\tBC\n\tINC\tHL\n\tLD\tA,H\n\tOR\tL\n\tJR\tNZ,S_BIN2\nS_BIN3:\tPOP\tHL\n\tLD\tA,10H\n\tSUB\tC\n\tJR\tZ,S_BIN5\n\tLD\tB,A\nS_BIN4:\tSLA\tL\n\tRL\tH\n\tDJNZ\tS_BIN4\nS_BIN5:\tLD\tB,C\nS_BIN6:\tLD\tA,30H\n\tSLA\tL\n\tRL\tH\n\tJR\tNC,S_BIN7\n\tINC\tA\nS_BIN7:\tLD\t(DE),A\n\tINC\tDE\n\tDJNZ\tS_BIN6\nS_BIN8:\tXOR\tA\n\tLD\t(DE),A\n\tLD\tHL,M_STMP\n\tRET\n");
            set.add(LibItem.E_PARM);
            set.add(LibItem.M_STMP);
        }
        if (set.contains((Object)LibItem.S_HEXN)) {
            asmCodeBuf.append("S_HEXN:\tLD\tA,B\n\tOR\tA\n\tJP\tM,E_PARM\n\tOR\tC\n\tJR\tZ,S_HEX\n\tLD\tDE,M_STMP\n\tPUSH\tHL\n\tLD\tHL,");
            asmCodeBuf.appendHex4(255);
            asmCodeBuf.append("\n\tOR\tA\n\tSBC\tHL,BC\n\tJR\tNC,S_HXN1\n\tLD\tBC,");
            asmCodeBuf.appendHex4(255);
            asmCodeBuf.append("\nS_HXN1:\tLD\tHL,0004H\n\tOR\tA\n\tSBC\tHL,BC\n\tJR\tNC,S_HXN3\nS_HXN2:\tLD\tA,'0'\n\tLD\t(DE),A\n\tINC\tDE\n\tDEC\tBC\n\tINC\tHL\n\tLD\tA,H\n\tOR\tL\n\tJR\tNZ,S_HXN2\nS_HXN3:\tPOP\tHL\n\tLD\tA,03H\n\tCP\tC\n\tJR\tC,S_HEX4\n\tDEC\tA\n\tCP\tC\n\tJR\tC,S_HEX3\n\tDEC\tA\n\tCP\tC\n\tJR\tC,S_HEX2\n\tJR\tS_HEX1\n");
            set.add(LibItem.E_PARM);
            set.add(LibItem.S_HEX);
            set.add(LibItem.M_STMP);
        }
        if (set.contains((Object)LibItem.S_HEX)) {
            asmCodeBuf.append("S_HEX:\tLD\tDE,M_STMP\n\tLD\tA,H\n\tAND\t0F0H\n\tJR\tZ,S_HXC1\nS_HEX4:\tCALL\tS_HXHL\n\tJR\tS_HEXE\nS_HXC1:\tLD\tA,H\n\tAND\t0FH\n\tJR\tZ,S_HXC2\nS_HEX3:\tLD\tA,H\n\tCALL\tS_HXAL\n\tLD\tA,L\n\tCALL\tS_HXA\n\tJR\tS_HEXE\nS_HXC2:\tLD\tA,L\n\tAND\t0F0H\n\tJR\tZ,S_HEX1\nS_HEX2:\tLD\tA,L\n\tCALL\tS_HXA\n\tJR\tS_HEXE\nS_HEX1:\tLD\tA,L\n\tCALL\tS_HXAL\nS_HEXE:\tXOR\tA\n\tLD\t(DE),A\n\tLD\tHL,M_STMP\n\tRET\n");
            set.add(LibItem.S_HXHL);
            set.add(LibItem.M_STMP);
        }
        if (set.contains((Object)LibItem.S_INP)) {
            asmCodeBuf.append("S_INP:\tLD\tA,H\n\tOR\tA\n\tJP\tNZ,E_PARM\n\tLD\tDE,M_STMP\n\tOR\tL\n\tJR\tZ,S_INP2\n\tLD\tB,L\nS_INP1:\tPUSH\tBC\n\tPUSH\tDE\n\tCALL\tXINCH\n\tPOP\tDE\n\tPOP\tBC\n\tLD\t(DE),A\n\tINC\tDE\n\tDJNZ\tS_INP1\nS_INP2:\tXOR\tA\n\tLD\t(DE),A\n\tLD\tHL,M_STMP\n\tRET\n");
            set.add(LibItem.E_PARM);
            set.add(LibItem.XINCH);
            set.add(LibItem.M_STMP);
        }
        if (set.contains((Object)LibItem.S_INCH)) {
            asmCodeBuf.append("S_INCH:\tCALL\tXINCH\n\tLD\tHL,M_INKB\n\tJR\tS_CHRX\n");
            set.add(LibItem.XINCH);
            set.add(LibItem.S_CHR);
            set.add(LibItem.M_INKB);
        }
        if (set.contains((Object)LibItem.S_INKY)) {
            asmCodeBuf.append("S_INKY:\tCALL\tXINKEY\n\tLD\tHL,M_INKB\n\tJR\tS_CHRX\n");
            set.add(LibItem.XINKEY);
            set.add(LibItem.S_CHR);
            set.add(LibItem.M_INKB);
        }
        if (set.contains((Object)LibItem.S_CHR)) {
            asmCodeBuf.append("S_CHRL:\tLD\tA,L\nS_CHRA:\tLD\tHL,M_STMP\nS_CHRX:\tLD\t(HL),A\n\tINC\tHL\n\tLD\t(HL),00H\n\tDEC\tHL\n\tRET\n");
            set.add(LibItem.M_STMP);
        }
        if (set.contains((Object)LibItem.S_LEFT)) {
            asmCodeBuf.append("S_LEFT:\tLD\tA,B\n\tOR\tA\n\tJP\tM,E_PARM\n\tLD\tDE,M_STMP\n\tPUSH\tDE\n\tCALL\tSTNCP\n\tPOP\tHL\n\tRET\n");
            set.add(LibItem.F_LEN);
            set.add(LibItem.E_PARM);
            set.add(LibItem.M_STMP);
            set.add(LibItem.STNCP);
        }
        if (set.contains((Object)LibItem.S_LWR)) {
            asmCodeBuf.append("S_LWR:\tLD\tDE,M_STMP-1\n\tLD\tBC,");
            asmCodeBuf.appendHex4(255);
            asmCodeBuf.append("\nS_LWR1:\tINC\tDE\n\tLD\tA,(HL)\n\tINC\tHL\n\tCP\t41H\n\tJR\tC,S_LWR2\n\tCP\t5BH\n\tJR\tNC,S_LWR2\n\tADD\tA,20H\nS_LWR2:\tLD\t(DE),A\n\tOR\tA\n\tJR\tZ,S_LWR3\n\tDEC\tBC\n\tLD\tA,B\n\tOR\tC\n\tJR\tNZ,S_LWR1\n\tLD\t(DE),A\nS_LWR3:\tLD\tHL,M_STMP\n\tRET\n");
            set.add(LibItem.M_STMP);
        }
        if (set.contains((Object)LibItem.S_TRIM)) {
            asmCodeBuf.append("S_TRIM:\tCALL\tS_LTRIM\n");
            set.add(LibItem.S_LTRIM);
            set.add(LibItem.S_RTRIM);
        }
        if (set.contains((Object)LibItem.S_RTRIM)) {
            asmCodeBuf.append("S_RTRIM:\n\tEXX\n\tLD\tHL,M_STMP\n\tLD\tD,H\n\tLD\tE,L\n\tDEC\tDE\n\tLD\tBC,");
            asmCodeBuf.appendHex4(255);
            asmCodeBuf.append("\nS_RTRIM1:\n\tEXX\n\tLD\tA,(HL)\n\tINC\tHL\n\tEXX\n\tOR\tA\n\tJR\tZ,S_RTRIM3\n\tCP\t21H\n\tJR\tC,S_RTRIM2\n\tLD\tD,H\n\tLD\tE,L\nS_RTRIM2:\n\tLD\t(HL),A\n\tINC\tHL\n\tDEC\tBC\n\tLD\tA,B\n\tOR\tC\n\tJR\tNZ,S_RTRIM1\nS_RTRIM3:\n\tINC\tDE\n\tLD\t(DE),A\n\tLD\tHL,M_STMP\n\tRET\n");
            set.add(LibItem.M_STMP);
        }
        if (set.contains((Object)LibItem.S_LTRIM)) {
            asmCodeBuf.append("S_LTRIM:\n\tDEC\tHL\nS_LTRIM1:\n\tINC\tHL\n\tLD\tA,(HL)\n\tOR\tA\n\tRET\tZ\n\tCP\t21H\n\tJR\tC,S_LTRIM1\n\tRET\n");
        }
        if (set.contains((Object)LibItem.S_MIDN)) {
            asmCodeBuf.append("S_MIDN:\tCALL\tS_MID\n\tLD\tA,B\n\tOR\tA\n\tJP\tM,E_PARM\n\tLD\tDE,M_STMP\n\tPUSH\tDE\n\tCALL\tSTNCP\n\tPOP\tHL\n\tRET\n");
            set.add(LibItem.E_PARM);
            set.add(LibItem.M_STMP);
            set.add(LibItem.S_MID);
            set.add(LibItem.STNCP);
        }
        if (set.contains((Object)LibItem.S_MID)) {
            asmCodeBuf.append("S_MID:\tLD\tA,D\n\tOR\tA\n\tJP\tM,E_PARM\n\tOR\tE\n\tJP\tZ,E_PARM\nS_MID1:\tDEC\tDE\n\tLD\tA,D\n\tOR\tE\n\tRET\tZ\n\tLD\tA,(HL)\n\tOR\tA\n\tRET\tZ\n\tINC\tHL\n\tJR\tS_MID1\n");
            set.add(LibItem.E_PARM);
        }
        if (set.contains((Object)LibItem.S_MIRR)) {
            asmCodeBuf.append("S_MIRR:\tLD\tBC,0FFFFH\n\tDEC\tHL\nS_MIR1:\tINC\tHL\n\tINC\tBC\n\tLD\tA,(HL)\n\tOR\tA\n\tJR\tNZ,S_MIR1\n\tLD\tA,B\n\tOR\tA\n\tJR\tZ,S_MIR2\n\tLD\tB,0FFH\n\tJR\tS_MIR3\nS_MIR2:\tOR\tC\n\tRET\tZ\n\tLD\tB,C\nS_MIR3:\tLD\tDE,M_STMP-1\nS_MIR4:\tINC\tDE\n\tDEC\tHL\n\tLD\tA,(HL)\n\tLD\t(DE),A\n\tDJNZ\tS_MIR4\n\tINC\tDE\n\tXOR\tA\n\tLD\t(DE),A\n\tLD\tHL,M_STMP\n\tRET\n");
            set.add(LibItem.M_STMP);
        }
        if (set.contains((Object)LibItem.S_RIGHT)) {
            asmCodeBuf.append("S_RIGHT:\n\tLD\tA,B\n\tOR\tA\n\tJP\tNZ,E_PARM\n\tPUSH\tHL\n\tCALL\tF_LEN\n\tOR\tA\n\tSBC\tHL,BC\n\tEX\tDE,HL\n\tPOP\tHL\n\tRET\tC\n\tRET\tZ\nS_RIGHT1:\n\tINC\tHL\n\tDEC\tDE\n\tLD\tA,D\n\tOR\tE\n\tJR\tNZ,S_RIGHT1\n\tRET\n");
            set.add(LibItem.F_LEN);
            set.add(LibItem.E_PARM);
        }
        if (set.contains((Object)LibItem.S_STC)) {
            asmCodeBuf.append("S_STC:\tLD\tA,B\n\tOR\tA\n\tJP\tM,E_PARM\n\tOR\tC\n\tJR\tNZ,S_STC1\n");
            asmCodeBuf.append_LD_HL_xx(EMPTY_STRING_LABEL);
            asmCodeBuf.append("\tRET\nS_STC1:\tLD\tE,L\n\tLD\tHL,");
            asmCodeBuf.appendHex4(255);
            asmCodeBuf.append("\n\tOR\tA\n\tSBC\tHL,BC\n\tJR\tNC,S_STC2\n\tLD\tBC,");
            asmCodeBuf.appendHex4(255);
            asmCodeBuf.append("\nS_STC2:\tLD\tHL,M_STMP\n\tPUSH\tHL\nS_STC3:\tLD\t(HL),E\n\tINC\tHL\n\tDEC\tBC\n\tLD\tA,B\n\tOR\tC\n\tJR\tNZ,S_STC3\n\tLD\t(HL),A\n\tPOP\tHL\n\tRET\n");
            set.add(LibItem.E_PARM);
            set.add(LibItem.EMPTY_STRING);
            set.add(LibItem.M_STMP);
        }
        if (set.contains((Object)LibItem.S_STS)) {
            asmCodeBuf.append("S_STS:\tLD\tA,B\n\tOR\tA\n\tJP\tM,E_PARM\n\tOR\tC\n\tJR\tNZ,S_STS1\n");
            asmCodeBuf.append_LD_HL_xx(EMPTY_STRING_LABEL);
            asmCodeBuf.append("\tRET\nS_STS1:\tPUSH\tBC\n\tPUSH\tHL\n\tEXX\n\tPOP\tHL\n\tPOP\tBC\n\tEXX\n\tLD\tBC,");
            asmCodeBuf.appendHex4(255);
            asmCodeBuf.append("\n\tLD\tDE,M_STMP\nS_STS2:\tCALL\tSTNCP\n\tLD\tA,B\n\tOR\tC\n\tJR\tZ,S_STS3\n\tEXX\n\tDEC\tBC\n\tLD\tA,B\n\tOR\tC\n\tPUSH\tHL\n\tEXX\n\tPOP\tHL\n\tJR\tNZ,S_STS2\nS_STS3:\tLD\tHL,M_STMP\n\tRET\n");
            set.add(LibItem.STNCP);
            set.add(LibItem.E_PARM);
            set.add(LibItem.EMPTY_STRING);
            set.add(LibItem.M_STMP);
        }
        if (set.contains((Object)LibItem.S_UPR)) {
            asmCodeBuf.append("S_UPR:\tLD\tDE,M_STMP-1\n\tLD\tBC,");
            asmCodeBuf.appendHex4(255);
            asmCodeBuf.append("\nS_UPR1:\tINC\tDE\n\tLD\tA,(HL)\n\tINC\tHL\n\tCALL\tC_UPR\n\tLD\t(DE),A\n\tOR\tA\n\tJR\tZ,S_UPR2\n\tDEC\tBC\n\tLD\tA,B\n\tOR\tC\n\tJR\tNZ,S_UPR1\n\tLD\t(DE),A\nS_UPR2:\tLD\tHL,M_STMP\n\tRET\n");
            set.add(LibItem.C_UPR);
            set.add(LibItem.M_STMP);
        }
        if (set.contains((Object)LibItem.F_INSTRN)) {
            asmCodeBuf.append("F_INSTRN:\n\tLD\tA,B\n\tOR\tA\n\tJP\tM,E_PARM\n\tOR\tC\n\tJP\tZ,E_PARM\n\tPUSH\tBC\nF_INSTRN1:\n\tDEC\tBC\n\tLD\tA,B\n\tOR\tC\n\tJR\tZ,F_INSTRN2\n\tLD\tA,(HL)\n\tINC\tHL\n\tOR\tA\n\tJR\tNZ,F_INSTRN1\n\tPOP\tBC\n\tJR\tF_INSTR5\nF_INSTRN2:\n\tPOP\tBC\n\tDEC\tBC\n\tJR\tF_INSTR1\n");
            set.add(LibItem.F_INSTR);
            set.add(LibItem.E_PARM);
        }
        if (set.contains((Object)LibItem.F_INSTR)) {
            asmCodeBuf.append("F_INSTR:\n\tLD\tBC,0000H\nF_INSTR1:\n\tLD\tA,(HL)\n\tOR\tA\n\tJR\tZ,F_INSTR5\n\tDEC\tHL\nF_INSTR2:\n\tINC\tHL\n\tINC\tBC\n\tPUSH\tHL\n\tPUSH\tDE\nF_INSTR3:\n\tLD\tA,(DE)\n\tINC\tDE\n\tOR\tA\n\tJR\tZ,F_INSTR4\n\tCP\t(HL)\n\tINC\tHL\n\tJR\tZ,F_INSTR3\n\tPOP\tDE\n\tPOP\tHL\n\tLD\tA,(HL)\n\tOR\tA\n\tJR\tNZ,F_INSTR2\n\tLD\tHL,0000H\n\tRET\nF_INSTR4:\n\tPOP\tDE\n\tPOP\tHL\n\tLD\tH,B\n\tLD\tL,C\n\tRET\nF_INSTR5:\n\tLD\tHL,0000H\n\tRET\n");
        }
        if (set.contains((Object)LibItem.F_IS_TARGET)) {
            asmCodeBuf.append("F_IS_TARGET:\n\tEX\tDE,HL\n");
            int[] nArray = basicCompiler.getTarget().getTargetIDs();
            if (nArray != null) {
                for (Object object : (Object)nArray) {
                    asmCodeBuf.append_LD_HL_nn((int)object);
                    asmCodeBuf.append("\tOR\tA\n\tSBC\tHL,DE\n\tJR\tZ,F_IS_TARGET1\n");
                }
            }
            asmCodeBuf.append("\tLD\tHL,0000H\n\tRET\nF_IS_TARGET1:\n\tDEC\tHL\n\tRET\n");
        }
        if (set.contains((Object)LibItem.F_JOY)) {
            asmCodeBuf.append("F_JOY:\tLD\tA,H\n\tOR\tA\n\tJP\tM,E_PARM\n");
            if (abstractTarget.supportsXJOY()) {
                asmCodeBuf.append("\tJP\tXJOY\n");
                set.add(LibItem.XJOY);
            } else {
                asmCodeBuf.append("\tHL,0000H\n\tRET\n");
            }
            set.add(LibItem.E_PARM);
        }
        if (set.contains((Object)LibItem.F_LEN)) {
            asmCodeBuf.append("F_LEN:\tLD\tDE,0FFFFH\n\tDEC\tHL\nF_LEN1:\tINC\tDE\n\tINC\tHL\n\tLD\tA,(HL)\n\tOR\tA\n\tJR\tNZ,F_LEN1\n\tEX\tDE,HL\n\tRET\n");
        }
        if (set.contains((Object)LibItem.F_RND)) {
            asmCodeBuf.append("F_RND:\tLD\tA,H\n\tOR\tA\n\tJP\tM,E_PARM\n\tOR\tL\n\tJP\tZ,E_PARM\n\tPUSH\tHL\n\tLD\tDE,(M_RNDA)\n\tLD\tHL,XEXIT\n\tSBC\tHL,DE\n\tJR\tNC,F_RND2\n");
            asmCodeBuf.append_LD_DE_xx("MSTART");
            asmCodeBuf.append("\tLD\tA,(M_RNDX)\n\tLD\tB,A\n\tAND\t8EH\n\tJP\tPE,F_RND1\n\tCCF\nF_RND1:\tRL\tB\n\tLD\tA,B\n\tLD\t(M_RNDX),A\nF_RND2:\tEX\tDE,HL\n\tLD\tA,(M_RNDX)\n\tXOR\t(HL)\n\tLD\tE,A\n\tINC\tHL\n\tLD\t(M_RNDA),HL\n\tLD\tA,R\n\tXOR\t(HL)\n\tJP\tP,F_RND3\n\tCPL\nF_RND3:\tLD\tH,A\n\tLD\tL,E\n\tPOP\tDE\n\tJP\tO_DIV2\n");
            set.add(LibItem.O_DIV);
            set.add(LibItem.E_PARM);
        }
        if (set.contains((Object)LibItem.F_SGN)) {
            asmCodeBuf.append("F_SGN:\tLD\tA,H\n\tOR\tL\n\tRET\tZ\n\tLD\tA,H\n\tOR\tA\n\tLD\tHL,0001H\n\tRET\tP\n\tDEC\tHL\n\tDEC\tHL\n\tRET\n");
        }
        if (set.contains((Object)LibItem.F_SQR)) {
            asmCodeBuf.append("F_SQR:\tBIT\t7,H\n\tJP\tNZ,E_PARM\n\tPUSH\tDE\n\tLD\tB,1\n\tLD\tDE,0001H\nF_SQR1:\tLD\tA,L\n\tSUB\tE\n\tLD\tL,A\n\tLD\tA,H\n\tSBC\tA,D\n\tLD\tH,A\n\tJR\tC,F_SQR2\n\tOR\tL\n\tJR\tZ,F_SQR3\n\tLD\tA,E\n\tADD\tA,2\n\tLD\tE,A\n\tLD\tA,D\n\tADC\tA,0\n\tLD\tD,A\n\tLD\tA,B\n\tINC\tA\n\tLD\tB,A\n\tJR\tF_SQR1\nF_SQR2:\tLD\tA,B\n\tDEC\tA\n\tLD\tB,A\nF_SQR3:\tLD\tL,B\n\tLD\tH,0\n\tPOP\tDE\n\tRET\n");
            set.add(LibItem.E_PARM);
        }
        if (set.contains((Object)LibItem.F_VAL)) {
            asmCodeBuf.append("F_VAL:\tLD\tA,D\n\tOR\tA\n\tJP\tNZ,E_PARM\n\tLD\tA,E\n\tCP\t02H\n\tJR\tZ,F_VLB\n\tCP\t0AH\n\tJP\tZ,F_VLI\n\tCP\t10H\n\tJP\tZ,F_VLH\n\tJP\tE_PARM\n");
            set.add(LibItem.F_VLB);
            set.add(LibItem.F_VLI);
            set.add(LibItem.F_VLH);
            set.add(LibItem.E_PARM);
        }
        if (set.contains((Object)LibItem.F_VLB)) {
            asmCodeBuf.append("F_VLB:\tLD\tD,H\n\tLD\tE,L\n");
            BasicLibrary.appendResetErrorUseHL(basicCompiler);
            asmCodeBuf.append("\tDEC\tDE\nF_VLB1:\tINC\tDE\n\tLD\tA,(DE)\n\tCP\t20H\n\tJR\tZ,F_VLB1\n\tLD\tC,00H\n\tLD\tHL,0000H\nF_VLB2:\tLD\tA,(DE)\n\tINC\tDE\n\tOR\tA\n\tJR\tNZ,F_VLB3\n\tOR\tC\n\tJR\tZ,F_VLB7\n\tRET\nF_VLB3:\tCP\t20H\n\tJR\tNZ,F_VLB5\n\tLD\tA,C\n\tOR\tA\n\tJR\tZ,F_VLB7\nF_VLB4:\tLD\tA,(DE)\n\tOR\tA\n\tRET\tZ\n\tCP\t20H\n\tJR\tNZ,F_VLB5\n\tINC\tDE\n\tJR\tF_VLB4\nF_VLB5:\tSUB\t30H\n\tJR\tC,F_VLB7\n\tCP\t02H\n\tJR\tNC,F_VLB7\n\tBIT\t7,H\n\tJR\tZ,F_VLB6\n");
            BasicLibrary.appendSetErrorNumericOverflow(basicCompiler);
            asmCodeBuf.append("\tLD\tHL,0000H\n\tRET\nF_VLB6:\tINC\tC\n\tADD\tHL,HL\n\tOR\tL\n\tLD\tL,A\n\tJR\tF_VLB2\nF_VLB7:");
            BasicLibrary.appendSetErrorInvalidChars(basicCompiler);
            asmCodeBuf.append("\tLD\tHL,0000H\n\tRET\n");
        }
        if (set.contains((Object)LibItem.F_VLH)) {
            asmCodeBuf.append("F_VLH:\tLD\tD,H\n\tLD\tE,L\n");
            BasicLibrary.appendResetErrorUseHL(basicCompiler);
            asmCodeBuf.append("\tDEC\tDE\nF_VLH1:\tINC\tDE\n\tLD\tA,(DE)\n\tCP\t20H\n\tJR\tZ,F_VLH1\n\tLD\tC,00H\n\tLD\tHL,0000H\nF_VLH2:\tLD\tA,(DE)\n\tINC\tDE\n\tOR\tA\n\tJR\tNZ,F_VLH3\n\tOR\tC\n\tJR\tZ,F_VLH8\n\tRET\nF_VLH3:\tCP\t20H\n\tJR\tNZ,F_VLH5\n\tLD\tA,C\n\tOR\tA\n\tJR\tZ,F_VLH8\nF_VLH4:\tLD\tA,(DE)\n\tOR\tA\n\tRET\tZ\n\tCP\t20H\n\tJR\tNZ,F_VLH5\n\tINC\tDE\n\tJR\tF_VLH4\nF_VLH5:\tSUB\t30H\n\tJR\tC,F_VLH8\n\tCP\t0AH\n\tJR\tC,F_VLH6\n\tSUB\t07H\n\tJR\tC,F_VLH8\n\tCP\t10H\n\tJR\tC,F_VLH6\n\tSUB\t20H\n\tJR\tC,F_VLH8\n\tCP\t10H\n\tJR\tNC,F_VLH8\nF_VLH6:\tLD\tB,A\n\tLD\tA,H\n\tAND\t0F0H\n\tJR\tZ,F_VLH7\n");
            BasicLibrary.appendSetErrorNumericOverflow(basicCompiler);
            asmCodeBuf.append("\tLD\tHL,0000H\n\tRET\nF_VLH7:\tINC\tC\n\tADD\tHL,HL\n\tADD\tHL,HL\n\tADD\tHL,HL\n\tADD\tHL,HL\n\tLD\tA,L\n\tOR\tB\n\tLD\tL,A\n\tJR\tF_VLH2\nF_VLH8:");
            BasicLibrary.appendSetErrorInvalidChars(basicCompiler);
            asmCodeBuf.append("\tLD\tHL,0000H\n\tRET\n");
        }
        if (set.contains((Object)LibItem.F_VLI)) {
            asmCodeBuf.append("F_VLI:\n");
            BasicLibrary.appendResetErrorUseBC(basicCompiler);
            asmCodeBuf.append("F_VLI1:\tLD\tB,H\n\tLD\tC,L\n\tDEC\tBC\nF_VLI2:\tINC\tBC\n\tLD\tA,(BC)\n\tCP\t20H\n\tJR\tZ,F_VLI2\n\tCP\t2DH\n\tJR\tNZ,F_VLI3\n\tINC\tBC\n\tCALL\tF_VLI3\n\tRET\tC\n\tLD\tDE,0000H\n\tEX\tDE,HL\n\tOR\tA\n\tSBC\tHL,DE\n\tOR\tA\n\tRET\nF_VLI3:\tLD\tA,(BC)\n\tINC\tBC\n\tSUB\t30H\n\tJR\tC,F_VLI6\n\tCP\t0AH\n\tJR\tNC,F_VLI6\n\tLD\tL,A\n\tLD\tH,00H\nF_VLI4:\tLD\tA,(BC)\n\tINC\tBC\n\tOR\tA\n\tRET\tZ\n\tCP\t20H\n\tJR\tZ,F_VLI5\n\tSUB\t30H\n\tJR\tC,F_VLI6\n\tCP\t0AH\n\tJR\tNC,F_VLI6\n\tLD\tD,H\n\tLD\tE,L\n\tADD\tHL,HL\n\tADD\tHL,HL\n\tADD\tHL,DE\n\tADD\tHL,HL\n\tADD\tA,L\n\tLD\tL,A\n\tLD\tA,0\n\tADC\tA,H\n\tLD\tH,A\n\tJP\tP,F_VLI4\n");
            BasicLibrary.appendSetErrorNumericOverflow(basicCompiler);
            asmCodeBuf.append("\tLD\tHL,0000H\n\tRET\nF_VLI5:\tLD\tA,(BC)\n\tINC\tBC\n\tOR\tA\n\tRET\tZ\n\tCP\t20H\n\tJR\tZ,F_VLI5\nF_VLI6:");
            BasicLibrary.appendSetErrorInvalidChars(basicCompiler);
            asmCodeBuf.append("\tLD\tHL,0000H\n\tRET\n");
        }
        if (set.contains((Object)LibItem.ARYADR)) {
            asmCodeBuf.append("ARYADR:\tLD\tA,H\n\tOR\tA\n\tJP\tM,E_IDX\n\tSBC\tHL,BC\n\tJP\tNC,E_IDX\n\tADD\tHL,BC\n\tADD\tHL,HL\n\tADD\tHL,DE\n\tRET\n");
            set.add(LibItem.E_IDX);
        }
        if (set.contains((Object)LibItem.CKIDX)) {
            asmCodeBuf.append("CKIDX:\tLD\tA,H\n\tOR\tA\n\tJP\tM,E_IDX\n\tSBC\tHL,BC\n\tJP\tNC,E_IDX\n\tADD\tHL,BC\n\tRET\n");
            set.add(LibItem.E_IDX);
        }
        if (set.contains((Object)LibItem.O_AND)) {
            asmCodeBuf.append("O_AND:\tLD\tA,H\n\tAND\tD\n\tLD\tH,A\n\tLD\tA,L\n\tAND\tE\n\tLD\tL,A\n\tRET\n");
        }
        if (set.contains((Object)LibItem.O_OR)) {
            asmCodeBuf.append("O_OR:\tLD\tA,H\n\tOR\tD\n\tLD\tH,A\n\tLD\tA,L\n\tOR\tE\n\tLD\tL,A\n\tRET\n");
        }
        if (set.contains((Object)LibItem.O_XOR)) {
            asmCodeBuf.append("O_XOR:\tLD\tA,H\n\tXOR\tD\n\tLD\tH,A\n\tLD\tA,L\n\tXOR\tE\n\tLD\tL,A\n\tRET\n");
        }
        if (set.contains((Object)LibItem.O_NOT)) {
            asmCodeBuf.append("O_NOT:\tLD\tA,H\n\tCPL\n\tLD\tH,A\n\tLD\tA,L\n\tCPL\n\tLD\tL,A\n\tRET\n");
        }
        if (set.contains((Object)LibItem.O_LT)) {
            asmCodeBuf.append("O_LT:\tCALL\tCPHLDE\n\tLD\tHL,0000H\n\tRET\tNC\n\tDEC\tHL\n\tRET\n");
            set.add(LibItem.CPHLDE);
        }
        if (set.contains((Object)LibItem.O_LE)) {
            asmCodeBuf.append("O_LE:\tCALL\tCPHLDE\n\tLD\tHL,0FFFFH\n\tRET\tC\n\tRET\tZ\n\tINC\tHL\n\tRET\n");
            set.add(LibItem.CPHLDE);
        }
        if (set.contains((Object)LibItem.O_GT)) {
            asmCodeBuf.append("O_GT:\tCALL\tCPHLDE\n\tLD\tHL,0000H\n\tRET\tC\n\tRET\tZ\n\tDEC\tHL\n\tRET\n");
            set.add(LibItem.CPHLDE);
        }
        if (set.contains((Object)LibItem.O_GE)) {
            asmCodeBuf.append("O_GE:\tCALL\tCPHLDE\n\tLD\tHL,0FFFFH\n\tRET\tNC\n\tINC\tHL\n\tRET\n");
            set.add(LibItem.CPHLDE);
        }
        if (set.contains((Object)LibItem.O_EQ)) {
            asmCodeBuf.append("O_EQ:\tOR\tA\n\tSBC\tHL,DE\n\tLD\tHL,0FFFFH\n\tRET\tZ\n\tINC\tHL\n\tRET\n");
        }
        if (set.contains((Object)LibItem.O_NE)) {
            asmCodeBuf.append("O_NE:\tOR\tA\n\tSBC\tHL,DE\n\tLD\tHL,0FFFFH\n\tRET\tNZ\n\tINC\tHL\n\tRET\n");
        }
        if (set.contains((Object)LibItem.CPHLDE)) {
            asmCodeBuf.append("CPHLDE:\tLD\tA,H\n\tXOR\tD\n\tJP\tP,CPHD1\n\tEX\tDE,HL\n\tCALL\tCPHD1\n\tEX\tDE,HL\n\tRET\nCPHD1:\tLD\tA,H\n\tCP\tD\n\tRET\tNZ\n\tLD\tA,L\n\tCP\tE\n\tRET\n");
        }
        if (set.contains((Object)LibItem.O_INC)) {
            asmCodeBuf.append("O_INC:\tINC\tHL\n\tLD\tA,80H\n\tXOR\tH\n\tOR\tL\n\tRET\tNZ\n\tJP\tE_NOV\n");
            set.add(LibItem.E_NOV);
        }
        if (set.contains((Object)LibItem.O_DEC)) {
            asmCodeBuf.append("O_DEC:\tLD\tA,80H\n\tXOR\tH\n\tOR\tL\n\tJP\tZ,E_NOV\n\tDEC\tHL\n\tRET\n");
            set.add(LibItem.E_NOV);
        }
        if (set.contains((Object)LibItem.O_SUB)) {
            asmCodeBuf.append("O_SUB:\tPUSH\tHL\n\tEX\tDE,HL\n\tCALL\tNEGHL\n\tEX\tDE,HL\n\tPOP\tHL\n");
            set.add(LibItem.O_ADD);
            set.add(LibItem.ABS_NEG_HL);
        }
        if (set.contains((Object)LibItem.O_ADD)) {
            asmCodeBuf.append("O_ADD:\tLD\tA,H\n\tADD\tHL,DE\n\tXOR\tD\n\tRET\tM\n\tLD\tA,D\n\tXOR\tH\n\tRET\tP\n\tJP\tE_NOV\n");
            set.add(LibItem.E_NOV);
        }
        if (set.contains((Object)LibItem.O_MUL)) {
            asmCodeBuf.append("O_MUL:\tLD\tB,0\n\tCALL\tABSHL\n\tEX\tDE,HL\n\tCALL\tABSHL\n\tEX\tDE,HL\n\tLD\tA,H\n\tOR\tA\n\tJR\tZ,O_MUL1\n\tLD\tA,D\n\tOR\tD\n\tEX\tDE,HL\n\tJP\tNZ,E_NOV\nO_MUL1:\tLD\tA,L\n\tLD\tHL,0000H\n\tOR\tA\n\tJR\tZ,O_MUL3\nO_MUL2:\tADD\tHL,DE\n\tJP\tC,E_NOV\n\tDEC\tA\n\tJR\tNZ,O_MUL2\nO_MUL3:\tLD\tA,H\n\tOR\tA\n\tJP\tM,E_NOV\n\tLD\tA,B\n\tOR\tA\n\tCALL\tM,NEGHL\n\tRET\n");
            set.add(LibItem.ABS_NEG_HL);
            set.add(LibItem.E_NOV);
        }
        if (set.contains((Object)LibItem.O_MOD)) {
            asmCodeBuf.append("O_MOD:\tLD\tA,D\n\tOR\tA\n\tJP\tM,O_MOD2\n\tOR\tE\n\tJR\tZ,E_DIV0\nO_MOD1:\tLD\tB,00H\n\tCALL\tABSHL\n\tPUSH\tBC\n\tCALL\tO_DIV2\n\tPOP\tBC\n\tJR\tO_DIV1\nO_MOD2:\tEX\tDE,HL\n\tCALL\tNEGHL\n\tEX\tDE,HL\n\tJR\tO_MOD1\n");
            set.add(LibItem.ABS_NEG_HL);
            set.add(LibItem.O_DIV);
        }
        if (set.contains((Object)LibItem.O_DIV)) {
            asmCodeBuf.append("O_DIV:\tLD\tB,00H\n\tCALL\tABSHL\n\tEX\tDE,HL\n\tCALL\tABSHL\n\tEX\tDE,HL\n\tLD\tA,D\n\tOR\tE\n\tJR\tZ,E_DIV0\n\tPUSH\tBC\n\tCALL\tO_DIV2\n\tEX\tDE,HL\n\tPOP\tBC\nO_DIV1:\tLD\tA,H\n\tOR\tA\n\tJP\tM,E_NOV\n\tLD\tA,B\n\tOR\tA\n\tCALL\tM,NEGHL\n\tRET\nO_DIV2:\tLD\tA,H\n\tLD\tC,L\n\tLD\tHL,0000H\n\tLD\tB,10H\nO_DIV3:\tRL\tC\n\tRLA\n\tADC\tHL,HL\n\tSBC\tHL,DE\n\tJR\tNC,O_DIV4\n\tADD\tHL,DE\nO_DIV4:\tDJNZ\tO_DIV3\n\tRL\tC\n\tRLA\n\tCPL\n\tLD\tD,A\n\tLD\tA,C\n\tCPL\n\tLD\tE,A\n\tRET\nE_DIV0:");
            abstractTarget.appendSwitchToTextScreenTo(asmCodeBuf);
            asmCodeBuf.append("\tCALL\tXOUTST\n");
            if (basicCompiler.isLangCode("DE")) {
                asmCodeBuf.append("\tDB\t'Division durch 0'\n");
            } else {
                asmCodeBuf.append("\tDB\t'Division by zero'\n");
            }
            asmCodeBuf.append("\tDB\t00H\n\tJP\tE_EXIT\n");
            set.add(LibItem.ABS_NEG_HL);
            set.add(LibItem.E_EXIT);
            set.add(LibItem.XOUTST);
        }
        if (set.contains((Object)LibItem.O_SHL)) {
            asmCodeBuf.append("O_SHL:\tLD\tA,D\n\tOR\tA\n\tJP\tM,E_PARM\n\tJR\tNZ,O_SHL2\n\tOR\tE\n\tRET\tZ\n\tLD\tB,E\nO_SHL1:\tSLA\tL\n\tRL\tH\n\tDJNZ\tO_SHL1\n\tRET\nO_SHL2:\tLD\tHL,0000H\n\tRET\n");
            set.add(LibItem.E_PARM);
        }
        if (set.contains((Object)LibItem.O_SHR)) {
            asmCodeBuf.append("O_SHR:\tLD\tA,D\n\tOR\tA\n\tJP\tM,E_PARM\n\tJR\tNZ,O_SHR2\n\tOR\tE\n\tRET\tZ\n\tLD\tB,E\nO_SHR1:\tSRL\tH\n\tRR\tL\n\tDJNZ\tO_SHR1\n\tRET\nO_SHR2:\tLD\tHL,0000H\n\tRET\n");
            set.add(LibItem.E_PARM);
        }
        if (set.contains((Object)LibItem.ABS_NEG_HL)) {
            asmCodeBuf.append("ABSHL:\tLD\tA,H\n\tOR\tA\n\tRET\tP\nNEGHL:\tLD\tA,H\n\tOR\tL\n\tRET\tZ\n\tLD\tA,H\n\tPUSH\tAF\n\tCPL\n\tLD\tH,A\n\tLD\tA,L\n\tCPL\n\tLD\tL,A\n\tINC\tHL\n\tPOP\tAF\n\tXOR\tH\n\tJP\tP,E_NOV\n\tLD\tA,B\n\tXOR\t80H\n\tLD\tB,A\n\tRET\n");
            set.add(LibItem.E_NOV);
        }
        if (set.contains((Object)LibItem.O_STEQ)) {
            asmCodeBuf.append("O_STEQ:\tCALL\tSTCMP\n\tLD\tHL,0FFFFH\n\tRET\tZ\n\tINC\tHL\n\tRET\n");
            set.add(LibItem.STCMP);
        }
        if (set.contains((Object)LibItem.O_STGE)) {
            asmCodeBuf.append("O_STGE:\tCALL\tSTCMP\n\tLD\tHL,0000H\n\tRET\tC\n\tDEC\tHL\n\tRET\n");
            set.add(LibItem.STCMP);
        }
        if (set.contains((Object)LibItem.O_STGT)) {
            asmCodeBuf.append("O_STGT:\tCALL\tSTCMP\n\tLD\tHL,0000H\n\tRET\tC\n\tRET\tZ\n\tDEC\tHL\n\tRET\n");
            set.add(LibItem.STCMP);
        }
        if (set.contains((Object)LibItem.O_STLE)) {
            asmCodeBuf.append("O_STLE:\tCALL\tSTCMP\n\tLD\tHL,0FFFFH\n\tRET\tC\n\tRET\tZ\n\tINC\tHL\n\tRET\n");
            set.add(LibItem.STCMP);
        }
        if (set.contains((Object)LibItem.O_STLT)) {
            asmCodeBuf.append("O_STLT:\tCALL\tSTCMP\n\tLD\tHL,0FFFFH\n\tRET\tC\n\tINC\tHL\n\tRET\n");
            set.add(LibItem.STCMP);
        }
        if (set.contains((Object)LibItem.O_STNE)) {
            asmCodeBuf.append("O_STNE:\tCALL\tSTCMP\n\tLD\tHL,0FFFFH\n\tRET\tNZ\n\tINC\tHL\n\tRET\n");
            set.add(LibItem.STCMP);
        }
        if (set.contains((Object)LibItem.DREADI)) {
            asmCodeBuf.append("DREADI:\tLD\tDE,(M_READ)\n\tLD\tA,(DE)\n\tOR\tA\n\tJP\tZ,E_DATA\n\tCP\t");
            asmCodeBuf.appendHex2(1);
            asmCodeBuf.append("\n\tJR\tZ,DRDI1\n\tCP\t");
            asmCodeBuf.appendHex2(2);
            asmCodeBuf.append("\n\tJP\tNZ,E_TYPE\n\tINC\tDE\n\tLD\tA,(DE)\n\tINC\tDE\n\tLD\tC,A\n\tLD\tA,(DE)\n\tINC\tDE\n\tLD\t(HL),C\n\tINC\tHL\n\tLD\t(HL),A\n\tLD\t(M_READ),DE\n\tRET\nDRDI1:\tINC\tDE\n\tLD\tA,(DE)\n\tINC\tDE\n\tLD\t(HL),A\n\tINC\tHL\n\tLD\t(HL),00H\n\tINC\tHL\n\tLD\t(M_READ),DE\n\tRET\n");
            set.add(LibItem.DATA);
            set.add(LibItem.E_DATA);
            set.add(LibItem.E_TYPE);
        }
        if (set.contains((Object)LibItem.DREADS)) {
            asmCodeBuf.append("DREADS:\tLD\tDE,(M_READ)\n\tLD\tA,(DE)\n\tOR\tA\n\tJP\tZ,E_DATA\n\tCP\t");
            asmCodeBuf.appendHex2(17);
            asmCodeBuf.append("\n\tJP\tNZ,E_TYPE\n\tINC\tDE\n\tLD\tC,(HL)\n\tINC\tHL\n\tLD\tB,(HL)\n\tLD\t(HL),D\n\tDEC\tHL\n\tLD\t(HL),E\nDRDS1:\tLD\tA,(DE)\n\tINC\tDE\n\tOR\tA\n\tJR\tNZ,DRDS1\n\tLD\t(M_READ),DE\n\tLD\tD,B\n\tLD\tE,C\n\tJP\tMFREE\n");
            set.add(LibItem.DATA);
            set.add(LibItem.MFREE);
            set.add(LibItem.E_DATA);
            set.add(LibItem.E_TYPE);
        }
        if (set.contains((Object)LibItem.SCREEN)) {
            asmCodeBuf.append("SCREEN:\tCALL\tXSCREEN\n\tJP\tC,E_PARM\n\tRET\n");
            set.add(LibItem.XSCREEN);
            set.add(LibItem.E_PARM);
        }
        if (set.contains((Object)LibItem.IOEOF)) {
            asmCodeBuf.append("IOEOF:\n\tLD\tD,H\n\tLD\tE,L\n\tLD\tA,(HL)\n\tINC\tHL\n\tOR\t(HL)\n\tJR\tNZ,IOEOF1\n");
            BasicLibrary.appendSetErrorChannelClosed(basicCompiler);
            asmCodeBuf.append("\tJR\tIOEOF2\nIOEOF1:");
            BasicLibrary.appendResetErrorUseBC(basicCompiler);
            for (int i = 1; i < 2; ++i) {
                asmCodeBuf.append("\tINC\tHL\n");
            }
            asmCodeBuf.append("\tLD\tA,(HL)\n\tINC\tHL\n\tLD\tH,(HL)\n\tLD\tL,A\n\tOR\tH\n\tJR\tNZ,IOEOF3\n");
            BasicLibrary.appendSetErrorIOMode(basicCompiler);
            asmCodeBuf.append("IOEOF2:\tLD\tHL,0FFFFH\n\tRET\nIOEOF3:\tJP\t(HL)\n");
        }
        if (set.contains((Object)LibItem.IOINL)) {
            asmCodeBuf.append("IOINL:\tLD\tA,(HL)\n\tINC\tHL\n\tOR\t(HL)\n\tJR\tNZ,IOINL1\n");
            BasicLibrary.appendSetErrorChannelClosed(basicCompiler);
            asmCodeBuf.append_LD_HL_xx(EMPTY_STRING_LABEL);
            asmCodeBuf.append("\tRET\nIOINL1:\tDEC\tHL\n");
            BasicLibrary.appendResetErrorUseDE(basicCompiler);
            asmCodeBuf.append("\tLD\tB,");
            asmCodeBuf.appendHex2(255);
            asmCodeBuf.append("\n\tLD\tDE,M_STMP\nIOINL2:\tPUSH\tBC\n\tPUSH\tDE\n\tPUSH\tHL\n\tCALL\tIORDB\n\tPOP\tHL\n\tPOP\tDE\n\tPOP\tBC\n\tOR\tA\n\tJR\tZ,IOINL3\n\tCP\tC\n\tJR\tZ,IOINL3\n\tCP\t0AH\n\tJR\tZ,IOINL3\n\tCP\t0DH\n\tJR\tZ,IOINL4\n\tLD\t(DE),A\n\tINC\tDE\n\tDJNZ\tIOINL2\nIOINL3:\tXOR\tA\n\tLD\t(DE),A\n\tLD\tHL,M_STMP\n\tRET\nIOINL4:\tPUSH\tBC\n\tPUSH\tDE\n\tPUSH\tHL\n\tCALL\tIORDB\n\tPOP\tHL\n\tPOP\tDE\n\tPOP\tBC\n\tCP\t0AH\n\tJR\tZ,IOINL3\n");
            asmCodeBuf.append_LD_BC_nn(9);
            asmCodeBuf.append("\tADD\tHL,BC\n\tLD\t(HL),A\n\tDEC\tHL\n\tLD\tA,0FFH\n\tLD\t(HL),A\n\tJR\tIOINL3\n");
            set.add(LibItem.IORDB);
            set.add(LibItem.EMPTY_STRING);
            set.add(LibItem.M_STMP);
        }
        if (set.contains((Object)LibItem.IOINX)) {
            asmCodeBuf.append("IOINX:\tLD\tA,B\n\tOR\tA\n\tJP\tNZ,E_PARM\n\tLD\tA,(HL)\n\tINC\tHL\n\tOR\t(HL)\n\tJR\tNZ,IOINX1\n");
            BasicLibrary.appendSetErrorChannelClosed(basicCompiler);
            asmCodeBuf.append_LD_HL_xx(EMPTY_STRING_LABEL);
            asmCodeBuf.append("\tRET\nIOINX1:\tDEC\tHL\n");
            BasicLibrary.appendResetErrorUseDE(basicCompiler);
            asmCodeBuf.append("\tLD\tDE,M_STMP\nIOINX2:\tLD\tA,B\n\tOR\tC\n\tJR\tZ,IOINX3\n\tDEC\tBC\n\tPUSH\tBC\n\tPUSH\tDE\n\tPUSH\tHL\n\tCALL\tIORDB\n\tPOP\tHL\n\tPOP\tDE\n\tPOP\tBC\n\tLD\t(DE),A\n\tINC\tDE\n\tJR\tIOINX2\nIOINX3:\tLD\t(DE),A\n\tLD\tHL,M_STMP\n\tRET\n");
            set.add(LibItem.IORDB);
            set.add(LibItem.E_PARM);
            set.add(LibItem.EMPTY_STRING);
            set.add(LibItem.M_STMP);
        }
        if (set.contains((Object)LibItem.IORDB)) {
            asmCodeBuf.append("IORDB:\tEX\tDE,HL\n");
            asmCodeBuf.append_LD_HL_nn(8);
            asmCodeBuf.append("\tADD\tHL,DE\n\tLD\tA,(HL)\n\tOR\tA\n\tJR\tZ,IORDB1\n\tLD\t(HL),00H\n\tINC\tHL\n\tLD\tA,(HL)\n\tRET\nIORDB1:");
            asmCodeBuf.append_LD_HL_nn(4);
            asmCodeBuf.append("\tADD\tHL,DE\n\tLD\tA,(HL)\n\tINC\tHL\n\tLD\tH,(HL)\n\tLD\tL,A\n\tOR\tH\n\tJR\tNZ,IORDB2\n");
            BasicLibrary.appendSetErrorIOMode(basicCompiler);
            asmCodeBuf.append("\tRET\nIORDB2:\tJP\t(HL)\n");
        }
        if (set.contains((Object)LibItem.IOCLOSE)) {
            asmCodeBuf.append("IOCLOSE:\n");
            BasicLibrary.appendResetErrorUseBC(basicCompiler);
            asmCodeBuf.append("\tLD\tE,(HL)\n\tINC\tHL\n\tLD\tD,(HL)\n\tDEC\tHL\n\tEX\tDE,HL\n\tLD\tA,H\n\tOR\tL\n\tJR\tZ,IOCLOSE1\n\tPUSH\tDE\n\tCALL\tJP_HL\n\tPOP\tDE\n\tJR\tIOCLOSE2\nIOCLOSE1:\n");
            BasicLibrary.appendSetErrorChannelClosed(basicCompiler);
            asmCodeBuf.append("IOCLOSE2:\n\tXOR\tA\n\tLD\tB,");
            asmCodeBuf.appendHex2(basicCompiler.getIOChannelSize());
            asmCodeBuf.append("\nIOCLOSE3:\n\tLD\t(DE),A\n\tINC\tDE\n\tDJNZ\tIOCLOSE3\n\tRET\n");
            set.add(LibItem.JP_HL);
        }
        if (set.contains((Object)LibItem.IOOPEN)) {
            int[] nArray;
            String string;
            asmCodeBuf.append("IOOPEN:\n\tLD\t(IO_M_CADDR),HL\n\tLD\tA,(HL)\n\tINC\tHL\n\tOR\t(HL)\n\tJR\tZ,IOOPEN1\n");
            BasicLibrary.appendSetErrorChannelAlreadyOpen(basicCompiler);
            asmCodeBuf.append("\tRET\nIOOPEN1:\n");
            BasicLibrary.appendResetErrorUseHL(basicCompiler);
            asmCodeBuf.append("\tLD\tHL,IO_HANDLER_TAB\nIOOPEN2:\n\tLD\tE,(HL)\n\tINC\tHL\n\tLD\tD,(HL)\n\tINC\tHL\n\tLD\tA,D\n\tOR\tE\n\tJR\tZ,IOOPEN3\n\tPUSH\tHL\n\tEX\tDE,HL\n\tCALL\tJP_HL\n\tPOP\tHL\n\tJR\tC,IOOPEN2\n");
            if (set.contains((Object)LibItem.M_ERN) || set.contains((Object)LibItem.M_ERT)) {
                asmCodeBuf.append("\tLD\tHL,(IO_M_CADDR)\n\tLD\tA,(HL)\n\tINC\tHL\n\tOR\t(HL)\n\tRET\tNZ\n");
                if (set.contains((Object)LibItem.M_ERN)) {
                    asmCodeBuf.append("\tLD\tHL,(M_ERN)\n\tLD\tA,H\n\tOR\tL\n\tRET\tNZ\n");
                } else if (set.contains((Object)LibItem.M_ERT)) {
                    asmCodeBuf.append("\tLD\tHL,(M_ERT)\n\tLD\tA,(HL)\n\tOR\tA\n\tRET\tNZ\n");
                }
                BasicLibrary.appendSetError(basicCompiler);
            }
            asmCodeBuf.append("\tRET\nIOOPEN3:\n");
            BasicLibrary.appendSetErrorDeviceNotFound(basicCompiler);
            asmCodeBuf.append("\tRET\n");
            if (basicCompiler.needsDriver(BasicCompiler.IODriver.CRT) && basicOptions.isOpenCrtEnabled()) {
                asmCodeBuf.append("IO_CRT_HANDLER:\n\tLD\tHL,D_IOCRT\n\tLD\tDE,XOUTCH\n\tJR\tIO_SIMPLE_OUT_HANDLER\n");
                set.add(LibItem.IO_CRT_HANDLER);
                set.add(LibItem.IO_SIMPLE_OUT_HANDLER);
                set.add(LibItem.XOUTCH);
            }
            if (basicCompiler.needsDriver(BasicCompiler.IODriver.LPT) && basicOptions.isOpenLptEnabled() && abstractTarget.supportsXLPTCH()) {
                asmCodeBuf.append("IO_LPT_HANDLER:\n\tLD\tHL,D_IOLPT\n\tLD\tDE,XLPTCH\n\tJR\tIO_SIMPLE_OUT_HANDLER\n");
                set.add(LibItem.IO_LPT_HANDLER);
                set.add(LibItem.IO_SIMPLE_OUT_HANDLER);
                set.add(LibItem.XLPTCH);
            }
            if (set.contains((Object)LibItem.IO_SIMPLE_OUT_HANDLER)) {
                asmCodeBuf.append("IO_SIMPLE_OUT_HANDLER:\n\tPUSH\tDE\n\tLD\tDE,(IO_M_NAME)\nIO_SIMPLE_OUT_H1:\n\tLD\tA,(DE)\n\tCALL\tC_UPR\n\tCP\t(HL)\n\tJR\tNZ,IO_SIMPLE_OUT_H5\n\tINC\tDE\n\tINC\tHL\n\tCP\t3AH\n\tJR\tNZ,IO_SIMPLE_OUT_H1\n\tLD\tA,(IO_M_ACCESS)\n\tAND\t");
                asmCodeBuf.appendHex2(-54);
                asmCodeBuf.append("\n\tJR\tZ,IO_SIMPLE_OUT_H2\n");
                BasicLibrary.appendSetErrorIOMode(basicCompiler);
                asmCodeBuf.append("\tPOP\tDE\n\tOR\tA\n\tRET\nIO_SIMPLE_OUT_H2:\n\tLD\tHL,(IO_M_CADDR)\n\tLD\tDE,IO_SIMPLE_CLOSE\n\tLD\t(HL),E\n\tINC\tHL\n\tLD\t(HL),D\n\tINC\tHL\n\tXOR\tA\n\tLD\tB,");
                asmCodeBuf.appendHex2(4);
                asmCodeBuf.append("\nIO_SIMPLE_OUT_H3:\n\tLD\t(HL),A\n\tINC\tHL\n\tDJNZ\tIO_SIMPLE_OUT_H3\n\tPOP\tDE\n\tLD\t(HL),E\n\tINC\tHL\n\tLD\t(HL),D\n\tINC\tHL\n\tLD\tB,");
                asmCodeBuf.appendHex2(basicCompiler.getIOChannelSize() - 6 - 2);
                asmCodeBuf.append("\nIO_SIMPLE_OUT_H4:\n\tLD\t(HL),A\n\tINC\tHL\n\tDJNZ\tIO_SIMPLE_OUT_H4\n\tRET\nIO_SIMPLE_OUT_H5:\n\tPOP\tDE\n\tSCF\nIO_SIMPLE_CLOSE:\n\tRET\n");
                set.add(LibItem.C_UPR);
            }
            if (basicCompiler.needsDriver(BasicCompiler.IODriver.FILE) && basicOptions.isOpenFileEnabled() && (string = basicCompiler.getTarget().getFileHandlerLabel()) != null && !string.isEmpty()) {
                basicCompiler.getTarget().appendFileHandler(basicCompiler);
                set.add(LibItem.IO_FILE_HANDLER);
            }
            if (basicCompiler.needsDriver(BasicCompiler.IODriver.VDIP) && basicOptions.isOpenVdipEnabled() && (nArray = abstractTarget.getVdipBaseIOAddresses()) != null && nArray.length > 0) {
                VdipLibrary.appendCodeTo(basicCompiler);
                set.add(LibItem.IO_VDIP_HANDLER);
            }
            set.add(LibItem.JP_HL);
        }
        if (set.contains((Object)LibItem.IOCADR)) {
            asmCodeBuf.append("IOCADR:\tLD\tA,H\n\tOR\tA\n\tJP\tNZ,E_PARM\n\tOR\tL\n\tJP\tZ,E_PARM\n\tDEC\tA\n\tCP\t04H\n\tJP\tNC,E_PARM\n\tADD\tA,A\n\tLD\tB,A\n\tADD\tA,A\n\tADD\tA,B\n\tADD\tA,A\n\tLD\tL,A\n\tLD\tDE,IOCTB1\n\tADD\tHL,DE\n\tRET\n");
            set.add(LibItem.E_PARM);
            set.add(LibItem.IOCTB1);
            set.add(LibItem.IOCTB2);
        }
        if (set.contains((Object)LibItem.S_HXHL)) {
            asmCodeBuf.append("S_HXHL:\tLD\tA,H\n\tCALL\tS_HXA\n\tLD\tA,L\n");
            set.add(LibItem.S_HXA);
        }
        if (set.contains((Object)LibItem.S_HXA)) {
            asmCodeBuf.append("S_HXA:\tPUSH\tAF\n\tRRCA\n\tRRCA\n\tRRCA\n\tRRCA\n\tCALL\tS_HXAL\n\tPOP\tAF\nS_HXAL:\tAND\t0FH\n\tADD\tA,90H\n\tDAA\n\tADC\tA,40H\n\tDAA\n\tLD\t(DE),A\n\tINC\tDE\n\tRET\n");
        }
        if (set.contains((Object)LibItem.C_UPR)) {
            asmCodeBuf.append("C_UPR:\tCP\t61H\n\tRET\tC\n\tCP\t7BH\n\tRET\tNC\n\tSUB\t20H\n\tRET\n");
        }
        if (set.contains((Object)LibItem.E_DATA)) {
            asmCodeBuf.append("E_DATA:");
            abstractTarget.appendSwitchToTextScreenTo(asmCodeBuf);
            asmCodeBuf.append("\tCALL\tXOUTST\n");
            if (basicCompiler.isLangCode("DE")) {
                asmCodeBuf.append("\tDB\t'Keine Daten mehr'\n");
            } else {
                asmCodeBuf.append("\tDB\t'Out of data'\n");
            }
            asmCodeBuf.append("\tDB\t00H\n\tJP\tE_EXIT\n");
            set.add(LibItem.E_EXIT);
            set.add(LibItem.XOUTST);
        }
        if (set.contains((Object)LibItem.E_IDX)) {
            asmCodeBuf.append("E_IDX:");
            abstractTarget.appendSwitchToTextScreenTo(asmCodeBuf);
            asmCodeBuf.append("\tCALL\tXOUTST\n");
            if (basicCompiler.isLangCode("DE")) {
                asmCodeBuf.append("\tDB\t'Index ausserhalb des Bereichs'\n");
            } else {
                asmCodeBuf.append("\tDB\t'Index out of range'\n");
            }
            asmCodeBuf.append("\tDB\t00H\n\tJP\tE_EXIT\n");
            set.add(LibItem.E_EXIT);
            set.add(LibItem.XOUTST);
        }
        if (set.contains((Object)LibItem.E_NOV)) {
            asmCodeBuf.append("E_NOV:");
            abstractTarget.appendSwitchToTextScreenTo(asmCodeBuf);
            asmCodeBuf.append("\tCALL\tXOUTST\n");
            if (basicCompiler.isLangCode("DE")) {
                asmCodeBuf.append("\tDB\t'Numerischer Ueberlauf'\n");
            } else {
                asmCodeBuf.append("\tDB\t'Numeric overflow'\n");
            }
            asmCodeBuf.append("\tDB\t00H\n\tJP\tE_EXIT\n");
            set.add(LibItem.E_EXIT);
            set.add(LibItem.XOUTST);
        }
        if (set.contains((Object)LibItem.E_NXWF)) {
            asmCodeBuf.append("E_NXWF:");
            abstractTarget.appendSwitchToTextScreenTo(asmCodeBuf);
            asmCodeBuf.append("\tCALL\tXOUTST\n");
            if (basicCompiler.isLangCode("DE")) {
                asmCodeBuf.append("\tDB\t'NEXT ohne FOR'\n");
            } else {
                asmCodeBuf.append("\tDB\t'NEXT without FOR'\n");
            }
            asmCodeBuf.append("\tDB\t00H\n\tJP\tE_EXIT\n");
            set.add(LibItem.E_EXIT);
            set.add(LibItem.XOUTST);
        }
        if (set.contains((Object)LibItem.E_PARM)) {
            asmCodeBuf.append("E_PARM:");
            abstractTarget.appendSwitchToTextScreenTo(asmCodeBuf);
            asmCodeBuf.append("\tCALL\tXOUTST\n");
            if (basicCompiler.isLangCode("DE")) {
                asmCodeBuf.append("\tDB\t'Ungueltiger Parameter'\n");
            } else {
                asmCodeBuf.append("\tDB\t'Invalid parameter'\n");
            }
            asmCodeBuf.append("\tDB\t00H\n\tJP\tE_EXIT\n");
            set.add(LibItem.E_EXIT);
            set.add(LibItem.XOUTST);
        }
        if (set.contains((Object)LibItem.E_REWG)) {
            asmCodeBuf.append("E_REWG:");
            abstractTarget.appendSwitchToTextScreenTo(asmCodeBuf);
            asmCodeBuf.append("\tCALL\tXOUTST\n");
            if (basicCompiler.isLangCode("DE")) {
                asmCodeBuf.append("\tDB\t'RETURN ohne GOSUB'\n");
            } else {
                asmCodeBuf.append("\tDB\t'RETURN without GOSUB'\n");
            }
            asmCodeBuf.append("\tDB\t00H\n\tJP\tE_EXIT\n");
            set.add(LibItem.E_EXIT);
            set.add(LibItem.XOUTST);
        }
        if (set.contains((Object)LibItem.E_TYPE)) {
            asmCodeBuf.append("E_TYPE:");
            abstractTarget.appendSwitchToTextScreenTo(asmCodeBuf);
            asmCodeBuf.append("\tCALL\tXOUTST\n");
            if (basicCompiler.isLangCode("DE")) {
                asmCodeBuf.append("\tDB\t'Falscher Datentyp'\n");
            } else {
                asmCodeBuf.append("\tDB\t'Type mismatch'\n");
            }
            asmCodeBuf.append("\tDB\t00H\n\tJP\tE_EXIT\n");
            set.add(LibItem.E_EXIT);
            set.add(LibItem.XOUTST);
        }
        if (set.contains((Object)LibItem.ASSIGN_STR_TO_NEW_MEM_VS)) {
            asmCodeBuf.append("ASSIGN_STR_TO_NEW_MEM_VS:\n\tPUSH\tDE\n\tCALL\tSMACP\n\tPOP\tDE\n");
            set.add(LibItem.SMACP);
            set.add(LibItem.ASSIGN_STR_TO_VS);
        }
        if (set.contains((Object)LibItem.ASSIGN_STR_TO_VS)) {
            asmCodeBuf.append("ASSIGN_STR_TO_VS:\n\tPUSH\tDE\n\tPUSH\tHL\n\tEX\tDE,HL\n\tLD\tE,(HL)\n\tINC\tHL\n\tLD\tD,(HL)\n\tCALL\tMFREE\n\tPOP\tDE\n\tPOP\tHL\n\tLD\t(HL),E\n\tINC\tHL\n\tLD\t(HL),D\n\tRET\n");
            set.add(LibItem.MFREE);
        }
        if (set.contains((Object)LibItem.ASSIGN_VS_TO_VS)) {
            asmCodeBuf.append("ASSIGN_VS_TO_VS:\n\tLD\tA,H\n\tCP\tD\n\tJR\tNZ,ASSIGN_VS_TO_VS1\n\tLD\tA,L\n\tCP\tE\n\tRET\tZ\nASSIGN_VS_TO_VS1:\n\tPUSH\tDE\n\tLD\tE,(HL)\n\tINC\tHL\n\tLD\tD,(HL)\n\tCALL\tSVDUP\n\tPOP\tHL\n\tLD\tC,(HL)\n\tINC\tHL\n\tLD\tB,(HL)\n\tLD\t(HL),D\n\tDEC\tHL\n\tLD\t(HL),E\n\tLD\tD,B\n\tLD\tE,C\n\tJP\tMFREE\n");
            set.add(LibItem.SVDUP);
            set.add(LibItem.MFREE);
        }
        if (set.contains((Object)LibItem.SMACP)) {
            asmCodeBuf.append("SMACP:\tLD\tA,(HL)\n\tOR\tA\n\tJR\tNZ,SMACP1\n");
            asmCodeBuf.append_LD_DE_xx(EMPTY_STRING_LABEL);
            asmCodeBuf.append("\tRET\nSMACP1:\tPUSH\tHL\n\tCALL\tMFIND\n\tPOP\tHL\n\tLD\tBC,");
            asmCodeBuf.appendHex4(255);
            asmCodeBuf.append("\n\tPUSH\tDE\n\tCALL\tSTNCP\n\tPOP\tHL\n\tCALL\tMALLOC\n\tRET\n");
            set.add(LibItem.MFIND);
            set.add(LibItem.MALLOC);
            set.add(LibItem.STNCP);
            set.add(LibItem.EMPTY_STRING);
        }
        if (set.contains((Object)LibItem.SVDUP)) {
            asmCodeBuf.append("SVDUP:\tCALL\tCHECK_DE_WITHIN_HEAP\n\tRET\tC\n\tJR\tSVDUP2\nSVDUP1:\tLD\tA,B\n\tOR\tC\n\tRET\tZ\n\tLD\tH,B\n\tLD\tL,C\nSVDUP2:\tLD\tC,(HL)\n\tINC\tHL\n\tLD\tB,(HL)\n\tINC\tHL\n\tINC\tHL\n\tINC\tHL\n\tINC\tHL\n\tOR\tA\n\tSBC\tHL,DE\n\tJR\tNZ,SVDUP1\n\tADD\tHL,DE\n\tDEC\tHL\n\tBIT\t7,(HL)\n\tJR\tNZ,SVDUP3\n\tINC\t(HL)\n\tRET\tP\n\tDEC\t(HL)\nSVDUP3:\tPUSH\tDE\n\tCALL\tMFIND\n\tPOP\tHL\n\tPUSH\tDE\n\tLD\tBC,");
            asmCodeBuf.appendHex4(255);
            asmCodeBuf.append("\n\tCALL\tSTNCP\n\tPOP\tHL\n\tCALL\tMALLOC\n\tEX\tDE,HL\n\tRET\n");
            set.add(LibItem.MFIND);
            set.add(LibItem.MALLOC);
            set.add(LibItem.CHECK_DE_WITHIN_HEAP);
            set.add(LibItem.HEAP);
            set.add(LibItem.STNCP);
        }
        if (set.contains((Object)LibItem.STCMP)) {
            asmCodeBuf.append("STCMP:\tLD\tA,(DE)\n\tCP\t(HL)\n\tRET\tNZ\n\tOR\tA\n\tRET\tZ\n\tINC\tDE\n\tINC\tHL\n\tJR\tSTCMP\n");
        }
        if (set.contains((Object)LibItem.STNCP)) {
            asmCodeBuf.append("STNCP:\tLD\tA,B\n\tOR\tC\n\tJR\tZ,STNCP2\n\tDEC\tDE\nSTNCP1:\tINC\tDE\n\tLD\tA,(HL)\n\tINC\tHL\n\tLD\t(DE),A\n\tOR\tA\n\tRET\tZ\n\tDEC\tBC\n\tLD\tA,B\n\tOR\tC\n\tJR\tNZ,STNCP1\n\tINC\tDE\nSTNCP2:\tLD\t(DE),A\n\tRET\n");
        }
        if (set.contains((Object)LibItem.MFIND)) {
            asmCodeBuf.append("MFIND:\tLD\tHL,HEAPB\nMFIND1:\tLD\tE,(HL)\n\tINC\tHL\n\tLD\tD,(HL)\n\tINC\tHL\n\tINC\tHL\n\tLD\tA,(HL)\n\tOR\tA\n\tJR\tZ,MFIND2\n\tINC\tHL\n\tLD\tA,(HL)\n\tOR\tA\n\tJR\tNZ,MFIND2\n\tINC\tHL\n\tEX\tDE,HL\n\tRET\nMFIND2:\tEX\tDE,HL\n\tLD\tA,H\n\tOR\tL\n\tJR\tNZ,MFIND1\nE_OUT_OF_MEM:\n");
            abstractTarget.appendSwitchToTextScreenTo(asmCodeBuf);
            asmCodeBuf.append("\tCALL\tXOUTST\n");
            if (basicCompiler.isLangCode("DE")) {
                asmCodeBuf.append("\tDB\t'Speicher voll'\n");
            } else {
                asmCodeBuf.append("\tDB\t'Out of memory'\n");
            }
            asmCodeBuf.append("\tDB\t00H\n\tJP\tE_EXIT\n");
            set.add(LibItem.HEAP);
            set.add(LibItem.E_EXIT);
            set.add(LibItem.XOUTST);
        }
        if (set.contains((Object)LibItem.MALLOC)) {
            asmCodeBuf.append("MALLOC:\tPUSH\tIY\n\tPUSH\tHL\n\tEX\tDE,HL\n\tINC\tHL\n\tOR\tA\n\tSBC\tHL,DE\n\tJR\tC,MALLO1\n\tJR\tZ,MALLO1\n\tLD\tB,H\n\tLD\tC,L\n\tLD\tIY,0FFFBH\n\tADD\tIY,DE\n\tLD\tL,(IY+2)\n\tLD\tH,(IY+3)\n\tOR\tA\n\tSBC\tHL,BC\n\tJR\tC,MALLO1\n\tJR\tZ,MALLO1\n\tLD\tDE,0010H\n\tSBC\tHL,DE\n\tJR\tC,MALLO1\n\tJR\tZ,MALLO1\n\tADD\tHL,DE\n\tLD\t(IY+2),C\n\tLD\t(IY+3),B\n\tLD\t(IY+4),01H\n\tLD\tE,(IY+0)\n\tLD\tD,(IY+1)\n\tPUSH\tIY\n\tADD\tIY,BC\n\tLD\tBC,0005H\n\tADD\tIY,BC\n\tLD\t(IY+0),E\n\tLD\t(IY+1),D\n\tLD\tDE,0005H\n\tOR\tA\n\tSBC\tHL,DE\n\tLD\t(IY+2),L\n\tLD\t(IY+3),H\n\tLD\t(IY+4),00H\n\tPUSH\tIY\n\tPOP\tDE\n\tPOP\tIY\n\tLD\t(IY+0),E\n\tLD\t(IY+1),D\nMALLO1:\tPOP\tHL\n\tPOP\tIY\n\tRET\n");
        }
        if (set.contains((Object)LibItem.MMGC)) {
            asmCodeBuf.append("MMGC:\tCALL\tCHECK_DE_WITHIN_HEAP\n\tRET\tC\n\tPUSH\tIY\n\tDEC\tDE\n\tDEC\tDE\n\tDEC\tDE\n\tDEC\tDE\n\tDEC\tDE\nMMGC1:\tLD\tA,H\n\tOR\tL\n\tJR\tZ,MMGC3\n\tSBC\tHL,DE\n\tJR\tZ,MMGC2\n\tADD\tHL,DE\n\tLD\tA,(HL)\n\tINC\tHL\n\tLD\tH,(HL)\n\tLD\tL,A\n\tJR\tMMGC1\nMMGC2:\tEX\tDE,HL\n\tINC\tHL\n\tINC\tHL\n\tINC\tHL\n\tINC\tHL\n\tSET\t7,(HL)\nMMGC3:\tPOP\tIY\n\tRET\n");
            set.add(LibItem.CHECK_DE_WITHIN_HEAP);
        }
        if (set.contains((Object)LibItem.MRGC)) {
            asmCodeBuf.append("MRGC:\tPUSH\tIY\n\tLD\tHL,0000H\n\tLD\tIY,HEAPB\nMRGC1:\tLD\tA,(IY+5)\n\tOR\tA\n\tJP\tP,MRGC3\n\tAND\t7FH\n\tJR\tZ,MRGC2\n\tDEC\tA\nMRGC2:\tLD\t(IY+5),A\n\tJR\tNZ,MRGC3\n\tPUSH\tHL\n\tCALL\tMFREE4\n\tPOP\tHL\n\tLD\tA,H\n\tOR\tL\n\tJR\tZ,MRGC3\n\tPUSH\tHL\n\tPOP\tIY\n\tCALL\tMFREE4\nMRGC3:\tPUSH\tIY\n\tPOP\tHL\n\tLD\tE,(IY+0)\n\tLD\tD,(IY+1)\n\tLD\tA,D\n\tOR\tE\n\tJR\tZ,MRGC4\n\tPUSH\tDE\n\tPOP\tIY\n\tJR\tMRGC1\nMRGC4:\tPOP\tIY\n\tRET\n");
            set.add(LibItem.HEAP);
            set.add(LibItem.MFREE);
        }
        if (set.contains((Object)LibItem.MFREE)) {
            asmCodeBuf.append("MFREE:\tCALL\tCHECK_DE_WITHIN_HEAP\n\tRET\tC\n\tPUSH\tIY\n\tDEC\tDE\n\tDEC\tDE\n\tDEC\tDE\n\tDEC\tDE\n\tDEC\tDE\n\tLD\tBC,0000H\n\tJR\tMFREE2\nMFREE1:\tADD\tHL,DE\n\tLD\tB,H\n\tLD\tC,L\n\tLD\tA,(HL)\n\tINC\tHL\n\tLD\tH,(HL)\n\tLD\tL,A\nMFREE2:\tLD\tA,H\n\tOR\tL\n\tJR\tZ,MFREE3\n\tSBC\tHL,DE\n\tJR\tNZ,MFREE1\n\tADD\tHL,DE\n\tPUSH\tHL\n\tPOP\tIY\n\tLD\tA,(IY+4)\n\tAND\t7FH\n\tLD\t(IY+4),A\n\tJR\tZ,MFREE3\n\tDEC\t(IY+4)\n\tJR\tNZ,MFREE3\n\tPUSH\tBC\n\tCALL\tMFREE4\n\tPOP\tBC\n\tLD\tA,B\n\tOR\tC\n\tJR\tZ,MFREE3\n\tPUSH\tBC\n\tPOP\tIY\n\tCALL\tMFREE4\nMFREE3:\tPOP\tIY\n\tRET\nMFREE4:\tLD\tA,(IY+4)\n\tOR\tA\n\tRET\tNZ\n\tLD\tL,(IY+0)\n\tLD\tH,(IY+1)\n\tLD\tA,H\n\tOR\tL\n\tRET\tZ\n\tLD\tE,(HL)\n\tINC\tHL\n\tLD\tD,(HL)\n\tINC\tHL\n\tLD\tC,(HL)\n\tINC\tHL\n\tLD\tB,(HL)\n\tINC\tHL\n\tLD\tA,(HL)\n\tOR\tA\n\tRET\tNZ\n\tLD\t(IY+0),E\n\tLD\t(IY+1),D\n\tLD\tL,(IY+2)\n\tLD\tH,(IY+3)\n\tADD\tHL,BC\n\tLD\tBC,0005\n\tADD\tHL,BC\n\tLD\t(IY+2),L\n\tLD\t(IY+3),H\n\tRET\n");
            set.add(LibItem.CHECK_DE_WITHIN_HEAP);
            set.add(LibItem.HEAP);
        }
        if (set.contains((Object)LibItem.CHECK_DE_WITHIN_HEAP)) {
            asmCodeBuf.append("CHECK_DE_WITHIN_HEAP:\n\tLD\tHL,HEAPB\n\tOR\tA\n\tSBC\tHL,DE\n\tJR\tZ,CHECK_DE_WITHIN_HEAP1\n\tCCF\n\tRET\tC\n\tLD\tHL,HEAPE\n\tOR\tA\n\tSBC\tHL,DE\nCHECK_DE_WITHIN_HEAP1:\n\tLD\tHL,HEAPB\n\tRET\n");
        }
        if (set.contains((Object)LibItem.E_USR)) {
            abstractTarget.appendSwitchToTextScreenTo(asmCodeBuf);
            asmCodeBuf.append("E_USR:\tCALL\tXOUTST\n");
            if (basicCompiler.isLangCode("DE")) {
                asmCodeBuf.append("\tDB\t'USR-Funktion nicht definiert'\n");
            } else {
                asmCodeBuf.append("\tDB\t'USR function not defined'\n");
            }
            asmCodeBuf.append("\tDB\t00H\n\tJP\tE_EXIT\n");
            set.add(LibItem.E_EXIT);
            set.add(LibItem.XOUTST);
        }
        if (set.contains((Object)LibItem.E_EXIT)) {
            asmCodeBuf.append("E_EXIT:");
            if (basicOptions.getPrintLineNumOnAbort()) {
                asmCodeBuf.append("\tLD\tHL,(M_SRLN)\n\tBIT\t7,H\n\tJR\tNZ,E_EXIT2\n\tPUSH\tHL\n\tCALL\tXOUTST\n");
                if (set.contains((Object)LibItem.M_SRNM)) {
                    asmCodeBuf.append("\tDB\t' in '\n\tDB\t00H\n\tLD\tHL,(M_SRNM)\n\tLD\tA,H\n\tOR\tL\n\tJR\tZ,E_EXIT1\n\tCALL\tXOUTS\n\tCALL\tXOUTST\n\tDB\t', '\n\tDB\t00H\nE_EXIT1:\n\tCALL\tXOUTST\n");
                    if (basicCompiler.isLangCode("DE")) {
                        asmCodeBuf.append("\tDB\t'Zeile'\n");
                    } else {
                        asmCodeBuf.append("\tDB\t'line'\n");
                    }
                } else if (basicCompiler.isLangCode("DE")) {
                    asmCodeBuf.append("\tDB\t' in Zeile'\n");
                } else {
                    asmCodeBuf.append("\tDB\t' in line'\n");
                }
                asmCodeBuf.append("\tDB\t00H\n\tPOP\tHL\n\tCALL\tS_STR\n\tCALL\tXOUTS\n");
                if (set.contains((Object)LibItem.M_BALN)) {
                    asmCodeBuf.append("\tLD\tHL,(M_BALN)\n\tBIT\t7,H\n\tJR\tNZ,E_EXIT2\n\tPUSH\tHL\n\tCALL\tXOUTST\n");
                    if (basicCompiler.isLangCode("DE")) {
                        asmCodeBuf.append("\tDB\t' (BASIC-Zeile'\n");
                    } else {
                        asmCodeBuf.append("\tDB\t' (BASIC line'\n");
                    }
                    asmCodeBuf.append("\tDB\t00H\n\tPOP\tHL\n\tCALL\tS_STR\n\tCALL\tXOUTS\n\tLD\tA,29H\n\tCALL\tXOUTCH\n");
                }
                asmCodeBuf.append("E_EXIT2:\n");
                set.add(LibItem.S_STR);
                set.add(LibItem.XOUTCH);
                set.add(LibItem.XOUTS);
                set.add(LibItem.XOUTST);
            }
            asmCodeBuf.append("\tCALL\tXOUTNL\n\tJP\tXEXIT\n");
            set.add(LibItem.XOUTNL);
        }
        if (set.contains((Object)LibItem.S_STR)) {
            asmCodeBuf.append("S_STR:\tLD\tA,H\n\tXOR\t80H\n\tOR\tL\n\tJR\tZ,S_STR4\n\tLD\tA,20H\n\tBIT\t7,H\n\tJR\tZ,S_STR1\n\tEX\tDE,HL\n\tLD\tHL,0000H\n\tSBC\tHL,DE\n\tLD\tA,2DH\nS_STR1:\tEXX\n\tLD\tHL,M_STR\n\tLD\t(HL),A\n\tINC\tHL\n\tEXX\n\tLD\tB,00H\n\tLD\tDE,2710H\n\tCALL\tS_STR2\n\tLD\tDE,03E8H\n\tCALL\tS_STR2\n\tLD\tDE,0064H\n\tCALL\tS_STR2\n\tLD\tDE,000AH\n\tCALL\tS_STR2\n\tLD\tDE,0001H\n\tLD\tB,01H\n\tCALL\tS_STR2\n\tEXX\n\tLD\t(HL),00H\n\tLD\tHL,M_STR\n\tRET\nS_STR2:\tLD\tA,0FFH\n\tOR\tA\nS_STR3:\tINC\tA\n\tSBC\tHL,DE\n\tJR\tNC,S_STR3\n\tADD\tHL,DE\n\tLD\tC,A\n\tOR\tB\n\tRET\tZ\n\tLD\tA,30H\n\tLD\tB,A\n\tADD\tA,C\n\tEXX\n\tLD\t(HL),A\n\tINC\tHL\n\tEXX\n\tRET\nS_STR4:\tLD\tHL,S_STR5\n\tRET\nS_STR5:\tDB\t'-32768'\n\tDB\t00H\n");
        }
        if (set.contains((Object)LibItem.JP_HL)) {
            asmCodeBuf.append("JP_HL:\tJP\t(HL)\n");
        }
        if (set.contains((Object)LibItem.OUTSP)) {
            asmCodeBuf.append("OUTSP:\tLD\tA,20H\n\tJP\tXOUTCH\n");
            set.add(LibItem.XOUTCH);
        }
        if (set.contains((Object)LibItem.DATA)) {
            asmCodeBuf.append("DINIT:\tLD\tHL,DBEG\n\tLD\t(M_READ),HL\n\tRET\n");
        }
        asmCodeBuf.append("XEXIT:");
        if (set.contains((Object)LibItem.IOCTB1)) {
            asmCodeBuf.append("\tLD\tHL,IOCTB1\n\tCALL\tCKCLOS\n");
        }
        if (set.contains((Object)LibItem.IOCTB2)) {
            asmCodeBuf.append("\tLD\tHL,IOCTB2\n\tCALL\tCKCLOS\n");
        }
        abstractTarget.appendPreExitTo(asmCodeBuf);
        asmCodeBuf.append("\tLD\tSP,(M_STCK)\n");
        abstractTarget.appendExitTo(asmCodeBuf);
        if (set.contains((Object)LibItem.IOCTB1) || set.contains((Object)LibItem.IOCTB2)) {
            asmCodeBuf.append("CKCLOS:\tLD\tE,(HL)\n\tINC\tHL\n\tLD\tD,(HL)\n\tDEC\tHL\n\tEX\tDE,HL\n\tLD\tA,L\n\tOR\tH\n\tRET\tZ\n\tJP\t(HL)\n");
        }
        abstractTarget.appendInputTo(asmCodeBuf, set.contains((Object)LibItem.XCKBRK), set.contains((Object)LibItem.XINKEY), set.contains((Object)LibItem.XINCH), basicOptions.canBreakOnInput());
        if (set.contains((Object)LibItem.XBREAK) || basicOptions.canBreakOnInput()) {
            asmCodeBuf.append("XBREAK:\tCALL\tXOUTNL\n\tJP\tXEXIT\n");
            set.add(LibItem.XOUTST);
            set.add(LibItem.XOUTNL);
        }
        if (set.contains((Object)LibItem.XSCREEN)) {
            abstractTarget.appendXScreenTo(asmCodeBuf);
        }
        if (set.contains((Object)LibItem.XBORDER)) {
            abstractTarget.appendXBorderTo(asmCodeBuf);
        }
        if (set.contains((Object)LibItem.XCOLOR)) {
            abstractTarget.appendXColorTo(asmCodeBuf);
        }
        if (set.contains((Object)LibItem.XINK)) {
            abstractTarget.appendXInkTo(asmCodeBuf);
        }
        if (set.contains((Object)LibItem.XPAPER)) {
            abstractTarget.appendXPaperTo(asmCodeBuf);
        }
        if (set.contains((Object)LibItem.XCLS)) {
            abstractTarget.appendXClsTo(asmCodeBuf);
        }
        if (set.contains((Object)LibItem.XLOCATE)) {
            abstractTarget.appendXLocateTo(asmCodeBuf);
        }
        if (set.contains((Object)LibItem.XCURS)) {
            abstractTarget.appendXCursTo(asmCodeBuf);
        }
        if (set.contains((Object)LibItem.XPEN)) {
            abstractTarget.appendXPenTo(asmCodeBuf);
        }
        if (set.contains((Object)LibItem.XHLINE)) {
            abstractTarget.appendXHLineTo(asmCodeBuf, basicCompiler);
        }
        if (set.contains((Object)LibItem.XPAINT)) {
            abstractTarget.appendXPaintTo(asmCodeBuf, basicCompiler);
        }
        if (set.contains((Object)LibItem.XPRES)) {
            abstractTarget.appendXPResTo(asmCodeBuf, basicCompiler);
        }
        if (set.contains((Object)LibItem.XPSET)) {
            abstractTarget.appendXPSetTo(asmCodeBuf, basicCompiler);
        }
        if (set.contains((Object)LibItem.XPTEST)) {
            abstractTarget.appendXPTestTo(asmCodeBuf, basicCompiler);
        }
        if (set.contains((Object)LibItem.XPOINT)) {
            abstractTarget.appendXPointTo(asmCodeBuf, basicCompiler);
        }
        if (set.contains((Object)LibItem.XJOY)) {
            abstractTarget.appendXJoyTo(asmCodeBuf);
        }
        abstractTarget.appendEtcPreXOutTo(asmCodeBuf);
        if (set.contains((Object)LibItem.XOUTST)) {
            asmCodeBuf.append("XOUTST:\tEX\t(SP),HL\n\tCALL\tXOUTS\n\tEX\t(SP),HL\n\tRET\n");
            set.add(LibItem.XOUTS);
        }
        if (set.contains((Object)LibItem.XOUTS)) {
            asmCodeBuf.append("XOUTS:\tLD\tA,(HL)\n\tINC\tHL\n\tOR\tA\n\tRET\tZ\n\tPUSH\tHL\n\tCALL\tXOUTCH\n\tPOP\tHL\n\tJR\tXOUTS\n");
            set.add(LibItem.XOUTCH);
        }
        if (set.contains((Object)LibItem.XOUTNL)) {
            abstractTarget.appendXOutnlTo(asmCodeBuf);
            set.add(LibItem.XOUTCH);
        }
        if (set.contains((Object)LibItem.XOUTCH)) {
            abstractTarget.appendXOutchTo(asmCodeBuf);
        }
        if (set.contains((Object)LibItem.XLPTCH)) {
            abstractTarget.appendXLPtchTo(asmCodeBuf);
        }
        abstractTarget.appendEtcPastXOutTo(asmCodeBuf);
    }

    public static void appendDataTo(BasicCompiler basicCompiler, Map<String, String> map, StringBuilder stringBuilder) {
        Object object;
        AsmCodeBuf asmCodeBuf = basicCompiler.getCodeBuf();
        Set<LibItem> set = basicCompiler.getLibItems();
        BasicOptions basicOptions = basicCompiler.getBasicOptions();
        AbstractTarget abstractTarget = basicCompiler.getTarget();
        if (basicOptions.getShowAssemblerText()) {
            asmCodeBuf.append("\n;Datenbereich\n");
        }
        if (set.contains((Object)LibItem.IOOPEN)) {
            asmCodeBuf.append("IO_HANDLER_TAB:\n");
            if (set.contains((Object)LibItem.IO_FILE_HANDLER) && (object = basicCompiler.getTarget().getFileHandlerLabel()) != null && !((String)object).isEmpty()) {
                asmCodeBuf.append("\tDW\t");
                asmCodeBuf.append((CharSequence)object);
                asmCodeBuf.newLine();
            }
            if (set.contains((Object)LibItem.IO_VDIP_HANDLER)) {
                asmCodeBuf.append("\tDW\tIO_VDIP_HANDLER\n");
            }
            if (set.contains((Object)LibItem.IO_CRT_HANDLER)) {
                asmCodeBuf.append("\tDW\tIO_CRT_HANDLER\n");
            }
            if (set.contains((Object)LibItem.IO_LPT_HANDLER)) {
                asmCodeBuf.append("\tDW\tIO_LPT_HANDLER\n");
            }
            asmCodeBuf.append("\tDW\t0000H\n");
        }
        if ((object = map.entrySet()) != null) {
            Iterator<Map.Entry<String, String>> iterator = object.iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, String> entry = iterator.next();
                String string = entry.getValue();
                if (string == null || string.isEmpty()) continue;
                asmCodeBuf.append(string);
                asmCodeBuf.append(':');
                if (string.length() > 6) {
                    asmCodeBuf.append('\n');
                }
                asmCodeBuf.appendStringLiteral(entry.getKey());
            }
        }
        if (set.contains((Object)LibItem.IO_CRT_HANDLER)) {
            asmCodeBuf.append("D_IOCRT:\n\tDB\t'CRT:'\n");
        }
        if (set.contains((Object)LibItem.IO_LPT_HANDLER)) {
            asmCodeBuf.append("D_IOLPT:\n\tDB\t'LPT:'\n");
        }
        if (set.contains((Object)LibItem.IO_VDIP_HANDLER)) {
            VdipLibrary.appendDataTo(basicCompiler);
        }
        if (set.contains((Object)LibItem.EMPTY_STRING)) {
            asmCodeBuf.append(EMPTY_STRING_LABEL);
            asmCodeBuf.append(':');
            if (EMPTY_STRING_LABEL.length() > 6) {
                asmCodeBuf.append('\n');
            }
            asmCodeBuf.append("\tDB\t00H\n");
        }
        if (set.contains((Object)LibItem.FONT_5X7)) {
            if (basicOptions.getShowAssemblerText()) {
                asmCodeBuf.append("\n;Zeichensatz\n");
            }
            asmCodeBuf.append("FONT_5X7:\n\tDB\t01H,0FAH,00H,00H,00H,00H\n\tDB\t03H,0E0H,00H,0E0H,00H,00H\n\tDB\t05H,28H,0FEH,28H,0FEH,28H\n\tDB\t05H,24H,54H,0FEH,54H,48H\n\tDB\t05H,0C4H,0C8H,10H,26H,46H\n\tDB\t05H,0CH,72H,9AH,64H,0AH\n\tDB\t02H,20H,0C0H,00H,00H,00H\n\tDB\t03H,38H,44H,82H,00H,00H\n\tDB\t03H,82H,44H,38H,00H,00H\n\tDB\t05H,28H,10H,7CH,10H,28H\n\tDB\t05H,10H,10H,7CH,10H,10H\n\tDB\t02H,02H,0CH,00H,00H,00H\n\tDB\t05H,10H,10H,10H,10H,10H\n\tDB\t01H,02H,00H,00H,00H,00H\n\tDB\t05H,04H,08H,10H,20H,40H\n\tDB\t05H,7CH,8AH,92H,0A2H,7CH\n\tDB\t03H,42H,0FEH,02H,00H,00H\n\tDB\t05H,46H,8AH,92H,92H,62H\n\tDB\t05H,84H,82H,92H,0B2H,0CCH\n\tDB\t05H,18H,28H,48H,0FEH,08H\n\tDB\t05H,0E4H,0A2H,0A2H,0A2H,9CH\n\tDB\t05H,0CH,32H,52H,92H,0CH\n\tDB\t05H,80H,8EH,90H,0A0H,0C0H\n\tDB\t05H,6CH,92H,92H,92H,6CH\n\tDB\t05H,60H,92H,94H,98H,60H\n\tDB\t01H,24H,00H,00H,00H,00H\n\tDB\t02H,02H,2CH,00H,00H,00H\n\tDB\t04H,10H,28H,44H,82H,00H\n\tDB\t05H,28H,28H,28H,28H,28H\n\tDB\t04H,82H,44H,28H,10H,00H\n\tDB\t05H,40H,80H,8AH,90H,60H\n\tDB\t05H,7CH,82H,9AH,0AAH,78H\n\tDB\t05H,3EH,48H,88H,48H,3EH\n\tDB\t05H,82H,0FEH,92H,92H,6CH\n\tDB\t05H,7CH,82H,82H,82H,44H\n\tDB\t05H,82H,0FEH,82H,82H,7CH\n\tDB\t04H,0FEH,92H,92H,82H,00H\n\tDB\t04H,0FEH,90H,90H,80H,00H\n\tDB\t05H,7CH,82H,82H,92H,5CH\n\tDB\t05H,0FEH,10H,10H,10H,0FEH\n\tDB\t03H,82H,0FEH,82H,00H,00H\n\tDB\t05H,04H,02H,82H,0FCH,80H\n\tDB\t05H,0FEH,10H,28H,44H,82H\n\tDB\t04H,0FEH,02H,02H,02H,00H\n\tDB\t05H,0FEH,40H,30H,40H,0FEH\n\tDB\t05H,0FEH,60H,10H,0CH,0FEH\n\tDB\t05H,7CH,82H,82H,82H,7CH\n\tDB\t05H,0FEH,90H,90H,90H,60H\n\tDB\t05H,7CH,82H,8AH,84H,7AH\n\tDB\t05H,0FEH,90H,98H,94H,62H\n\tDB\t05H,64H,92H,92H,92H,4CH\n\tDB\t05H,80H,80H,0FEH,80H,80H\n\tDB\t05H,0FCH,02H,02H,02H,0FCH\n\tDB\t05H,0E0H,18H,06H,18H,0E0H\n\tDB\t05H,0FCH,02H,1CH,02H,0FCH\n\tDB\t05H,0C6H,28H,10H,28H,0C6H\n\tDB\t05H,0E0H,10H,0EH,10H,0E0H\n\tDB\t05H,86H,8AH,92H,0A2H,0C2H\n\tDB\t03H,0FEH,82H,82H,00H,00H\n\tDB\t05H,40H,20H,10H,08H,04H\n\tDB\t03H,82H,82H,0FEH,00H,00H\n\tDB\t05H,20H,40H,80H,40H,20H\n\tDB\t05H,02H,02H,02H,02H,02H\n\tDB\t02H,80H,40H,00H,00H,00H\n\tDB\t05H,04H,2AH,2AH,2AH,1EH\n\tDB\t05H,0FEH,22H,22H,22H,1CH\n\tDB\t04H,1CH,22H,22H,22H,00H\n\tDB\t05H,1CH,22H,22H,22H,0FEH\n\tDB\t05H,1CH,2AH,2AH,2AH,18H\n\tDB\t04H,20H,7EH,0A0H,80H,00H\n\tDB\t05H,18H,25H,25H,25H,3EH\n\tDB\t04H,0FEH,20H,20H,1EH,00H\n\tDB\t03H,22H,0BEH,02H,00H,00H\n\tDB\t04H,02H,01H,21H,0BEH,00H\n\tDB\t05H,0FEH,04H,08H,14H,22H\n\tDB\t03H,0FCH,02H,00H,00H,00H\n\tDB\t05H,3EH,20H,1EH,20H,1EH\n\tDB\t05H,3EH,10H,20H,20H,1EH\n\tDB\t05H,1CH,22H,22H,22H,1CH\n\tDB\t05H,3FH,24H,24H,24H,18H\n\tDB\t05H,18H,24H,24H,24H,3FH\n\tDB\t04H,3EH,10H,20H,20H,00H\n\tDB\t05H,12H,2AH,2AH,2AH,24H\n\tDB\t03H,20H,0FCH,22H,00H,00H\n\tDB\t05H,3CH,02H,02H,04H,3EH\n\tDB\t05H,38H,04H,02H,04H,38H\n\tDB\t05H,3CH,02H,0CH,02H,3CH\n\tDB\t05H,22H,14H,08H,14H,22H\n\tDB\t05H,31H,0AH,04H,08H,30H\n\tDB\t05H,22H,26H,2AH,32H,22H\n\tDB\t03H,10H,6CH,82H,00H,00H\n\tDB\t01H,0FEH,00H,00H,00H,00H\n\tDB\t03H,82H,6CH,10H,00H,00H\n\tDB\t05H,10H,20H,10H,08H,10H\n\n");
        }
        abstractTarget.appendDataTo(asmCodeBuf);
        if (stringBuilder != null) {
            if (basicOptions.getShowAssemblerText()) {
                asmCodeBuf.append("\n;User DATA\n");
            }
            asmCodeBuf.append(stringBuilder);
        }
    }

    public static void appendBssTo(AsmCodeBuf asmCodeBuf, BasicCompiler basicCompiler, Map<String, VarDecl> map, Set<String> set, StringBuilder stringBuilder) {
        int n;
        BasicOptions basicOptions;
        Set<LibItem> set2;
        block47: {
            int n2;
            set2 = basicCompiler.getLibItems();
            basicOptions = basicCompiler.getBasicOptions();
            AbstractTarget abstractTarget = basicCompiler.getTarget();
            if (basicOptions.getShowAssemblerText()) {
                asmCodeBuf.append("\n;Speicherzellen\n");
            }
            if (set2.contains((Object)LibItem.M_SRNM)) {
                asmCodeBuf.append("M_SRNM:\tDS\t2\n");
            }
            if (basicOptions.getPrintLineNumOnAbort()) {
                asmCodeBuf.append("M_SRLN:\tDS\t2\n");
            }
            if (set2.contains((Object)LibItem.M_BALN)) {
                asmCodeBuf.append("M_BALN:\tDS\t2\n");
            }
            if (set2.contains((Object)LibItem.DATA)) {
                asmCodeBuf.append("M_READ:\tDS\t2\n");
            }
            if (set2.contains((Object)LibItem.F_RND)) {
                asmCodeBuf.append("M_RNDA:\tDS\t2\nM_RNDX:\tDS\t1\n");
            }
            if (set2.contains((Object)LibItem.IO_VDIP_HANDLER)) {
                VdipLibrary.appendBssTo(asmCodeBuf, basicCompiler);
            }
            if (set2.contains((Object)LibItem.IOOPEN) || set2.contains((Object)LibItem.IOCTB1) || set2.contains((Object)LibItem.IOCTB2)) {
                asmCodeBuf.append("IO_M_NAME:\tDS\t2\nIO_M_CADDR:\tDS\t2\nIO_M_ACCESS:\tDS\t1\n");
            }
            if (set2.contains((Object)LibItem.IO_M_COUT)) {
                asmCodeBuf.append("IO_M_COUT:\tDS\t2\n");
            }
            if (set2.contains((Object)LibItem.IOCTB1)) {
                asmCodeBuf.append("IOCTB1:\tDS\t");
                asmCodeBuf.appendHex2(basicCompiler.getIOChannelSize());
                asmCodeBuf.newLine();
            }
            if (set2.contains((Object)LibItem.IOCTB2)) {
                asmCodeBuf.append("IOCTB2:\tDS\t");
                asmCodeBuf.appendHex2(basicCompiler.getIOChannelSize());
                asmCodeBuf.newLine();
            }
            if (set2.contains((Object)LibItem.M_XYPO)) {
                asmCodeBuf.append("M_XPOS:\tDS\t2\nM_YPOS:\tDS\t2\n");
            }
            if (set2.contains((Object)LibItem.DRAWS)) {
                asmCodeBuf.append("M_DRSM:\tDS\t1\n");
            }
            if (set2.contains((Object)LibItem.DRBOX) || set2.contains((Object)LibItem.DRBOXF) || set2.contains((Object)LibItem.DRAW_LINE)) {
                asmCodeBuf.append("LINE_M_BX:\tDS\t2\nLINE_M_BY:\tDS\t2\nLINE_M_EX:\tDS\t2\nLINE_M_EY:\tDS\t2\nLINE_M_SX:\tDS\t2\nLINE_M_SY:\tDS\t2\n");
            }
            if (set2.contains((Object)LibItem.CIRCLE)) {
                asmCodeBuf.append("CIRCLE_M_X:\tDS\t2\nCIRCLE_M_Y:\tDS\t2\nCIRCLE_M_R:\tDS\t2\nCIRCLE_M_ER:\tDS\t2\nCIRCLE_M_RX:\tDS\t2\nCIRCLE_M_RY:\tDS\t2\nCIRCLE_M_XMX:\tDS\t2\nCIRCLE_M_XPX:\tDS\t2\nCIRCLE_M_XMY:\tDS\t2\nCIRCLE_M_XPY:\tDS\t2\nCIRCLE_M_YMX:\tDS\t2\nCIRCLE_M_YPX:\tDS\t2\nCIRCLE_M_YMY:\tDS\t2\nCIRCLE_M_YPY:\tDS\t2\n");
            }
            if (set2.contains((Object)LibItem.PAINT)) {
                asmCodeBuf.append("PAINT_M_X:\tDS\t2\nPAINT_M_Y:\tDS\t2\nPAINT_M_X1:\tDS\t2\nPAINT_M_X2:\tDS\t2\nPAINT_M_SX2:\tDS\t2\nPAINT_M_SDIR:\tDS\t1\nPAINT_M_CX1:\tDS\t2\nPAINT_M_CX2:\tDS\t2\nPAINT_M_TAD:\tDS\t2\nPAINT_M_TSZ:\tDS\t1\nPAINT_M_TIX:\tDS\t1\n");
            }
            if (set2.contains((Object)LibItem.PAINT_M_HPIX)) {
                asmCodeBuf.append("PAINT_M_HPIX:\tDS\t2\n");
            }
            if (set2.contains((Object)LibItem.PAINT_M_WPIX)) {
                asmCodeBuf.append("PAINT_M_WPIX:\tDS\t2\n");
            }
            if (set2.contains((Object)LibItem.M_FRET)) {
                asmCodeBuf.append("M_FRET:\tDS\t2\n");
            }
            if (set2.contains((Object)LibItem.M_INKB)) {
                asmCodeBuf.append("M_INKB:\tDS\t2\n");
            }
            if (set2.contains((Object)LibItem.M_HOST)) {
                asmCodeBuf.append("M_HOST:\tDS\t2\n");
            }
            if (set2.contains((Object)LibItem.M_PORT)) {
                asmCodeBuf.append("M_PORT:\tDS\t2\n");
            }
            if (set2.contains((Object)LibItem.M_STMP)) {
                asmCodeBuf.append("M_STMP:\tDS\t");
                asmCodeBuf.appendHex4(256);
                asmCodeBuf.append('\n');
            }
            if (set2.contains((Object)LibItem.S_STR)) {
                asmCodeBuf.append("M_STR:\tDS\t08H\n");
            }
            if (set2.contains((Object)LibItem.M_ERN)) {
                asmCodeBuf.append("M_ERN:\tDS\t2\n");
            }
            if (set2.contains((Object)LibItem.M_ERT)) {
                asmCodeBuf.append("M_ERT:\tDS\t2\n");
            }
            asmCodeBuf.append("M_STCK:\tDS\t2\n");
            abstractTarget.appendBssTo(asmCodeBuf);
            if (basicOptions.getShowAssemblerText() && !set.isEmpty()) {
                asmCodeBuf.append("\n;USR-Funktionen\n");
            }
            for (String string : set) {
                asmCodeBuf.append(string);
                asmCodeBuf.append(":\tDS\t2\n");
            }
            Set<String> set3 = map.keySet();
            if (set3 != null && (n2 = set3.size()) > 0) {
                try {
                    Object[] objectArray = set3.toArray(new String[n2]);
                    if (objectArray == null) break block47;
                    try {
                        Arrays.sort(objectArray);
                    }
                    catch (ClassCastException classCastException) {
                        // empty catch block
                    }
                    if (objectArray.length > 0) {
                        if (basicOptions.getShowAssemblerText()) {
                            asmCodeBuf.append("\n;BASIC-Variablen\n");
                        }
                        for (Object object : objectArray) {
                            VarDecl varDecl = map.get(object);
                            if (varDecl == null) continue;
                            String string = varDecl.getLabel();
                            asmCodeBuf.append(string);
                            asmCodeBuf.append(':');
                            if (string.length() > 6) {
                                asmCodeBuf.append('\n');
                            }
                            asmCodeBuf.append("\tDS\t");
                            int n3 = varDecl.getSize();
                            if (n3 > 2) {
                                if (n3 < 256) {
                                    asmCodeBuf.appendHex2(n3);
                                } else {
                                    asmCodeBuf.appendHex4(n3);
                                }
                            } else {
                                asmCodeBuf.append('2');
                            }
                            asmCodeBuf.append('\n');
                        }
                    }
                }
                catch (ArrayStoreException arrayStoreException) {
                    // empty catch block
                }
            }
        }
        if (stringBuilder != null) {
            if (basicOptions.getShowAssemblerText()) {
                asmCodeBuf.append("\n;User BSS\n");
            }
            asmCodeBuf.append(stringBuilder);
        }
        if (set2.contains((Object)LibItem.HEAP)) {
            if (basicOptions.getShowAssemblerText()) {
                asmCodeBuf.append("\n;Zeichenkettenspeicher\n");
            }
            asmCodeBuf.append("HEAPB:\tDS\t");
            asmCodeBuf.appendHex4(basicOptions.getHeapSize());
            asmCodeBuf.append("\nHEAPE:\n");
        }
        if ((n = basicOptions.getStackSize()) > 0) {
            if (basicOptions.getShowAssemblerText()) {
                asmCodeBuf.append("\n;Stack-Bereich\n");
            }
            asmCodeBuf.append("\tDS\t");
            asmCodeBuf.appendHex4(n);
            asmCodeBuf.newLine();
        }
        asmCodeBuf.append("MTOP");
        asmCodeBuf.append(":\n");
    }

    public static void appendInitTo(AsmCodeBuf asmCodeBuf, BasicCompiler basicCompiler, Map<String, VarDecl> map, SortedSet<String> sortedSet) {
        Set<LibItem> set;
        block35: {
            int n;
            Set<String> set2;
            Object object2;
            int n2;
            set = basicCompiler.getLibItems();
            BasicOptions basicOptions = basicCompiler.getBasicOptions();
            if (basicOptions.getShowAssemblerText()) {
                asmCodeBuf.append("\n;Initialisierungen\n");
            }
            asmCodeBuf.append("MSTART");
            asmCodeBuf.append(":\tLD\t(M_STCK),SP\n");
            if (basicOptions.getStackSize() > 0) {
                asmCodeBuf.append("\tLD\tSP,");
                asmCodeBuf.append("MTOP");
                asmCodeBuf.newLine();
                set.add(LibItem.MTOP);
            }
            if (basicOptions.getPrintLineNumOnAbort()) {
                asmCodeBuf.append("\tLD\tHL,0FFFFH\n\tLD\t(M_SRLN),HL\n");
                if (set.contains((Object)LibItem.M_BALN)) {
                    asmCodeBuf.append("\tLD\t(M_BALN),HL\n");
                }
            }
            if (set.contains((Object)LibItem.M_SRNM)) {
                asmCodeBuf.append("\tLD\tHL,0000H\n\tLD\t(M_SRNM),HL\n");
            }
            if (set.contains((Object)LibItem.F_RND)) {
                asmCodeBuf.append_LD_HL_xx("MSTART");
                asmCodeBuf.append("\tLD\t(M_RNDA),HL\n\tLD\tA,46H\n\tLD\t(M_RNDX),A\n");
            }
            if (set.contains((Object)LibItem.DATA)) {
                asmCodeBuf.append("\tCALL\tDINIT\n");
            }
            if (set.contains((Object)LibItem.E_USR) && sortedSet != null && (n2 = sortedSet.size()) > 0) {
                if (n2 > 4) {
                    object2 = sortedSet.first();
                    String object3 = basicCompiler.nextLabel();
                    asmCodeBuf.append("\tLD\tDE,E_USR\n\tLD\tHL,");
                    asmCodeBuf.append((CharSequence)object2);
                    asmCodeBuf.append("\n\tLD\tB,");
                    asmCodeBuf.appendHex2(n2);
                    asmCodeBuf.append('\n');
                    asmCodeBuf.append(object3);
                    asmCodeBuf.append(":\n\tLD\t(HL),E\n\tINC\tHL\n\tLD\t(HL),D\n\tINC\tHL\n\tDJNZ\t");
                    asmCodeBuf.append(object3);
                    asmCodeBuf.append('\n');
                } else {
                    asmCodeBuf.append("\tLD\tHL,E_USR\n");
                    for (String string : sortedSet) {
                        asmCodeBuf.append("\tLD\t(");
                        asmCodeBuf.append(string);
                        asmCodeBuf.append("),HL\n");
                    }
                }
            }
            if (set.contains((Object)LibItem.IO_VDIP_HANDLER)) {
                VdipLibrary.appendInitTo(asmCodeBuf);
            }
            n2 = 0;
            object2 = null;
            if (set.contains((Object)LibItem.IOCTB2)) {
                object2 = "IOCTB2";
                ++n2;
            }
            if (set.contains((Object)LibItem.IOCTB1)) {
                object2 = "IOCTB1";
                ++n2;
            }
            if (n2 > 0 && object2 != null) {
                asmCodeBuf.append("\tLD\tHL,");
                asmCodeBuf.append((CharSequence)object2);
                asmCodeBuf.append("\n\tXOR\tA\n\tLD\tB,");
                asmCodeBuf.appendHex2(n2 * basicCompiler.getIOChannelSize());
                asmCodeBuf.append("\nIOINIL:\tLD\t(HL),A\n\tINC\tHL\n\tDJNZ\tIOINIL\n");
            }
            if (set.contains((Object)LibItem.M_XYPO)) {
                asmCodeBuf.append("\tLD\tHL,0000H\n\tLD\t(M_XPOS),HL\n\tLD\t(M_YPOS),HL\n");
            }
            if (set.contains((Object)LibItem.M_ERN)) {
                if (!set.contains((Object)LibItem.M_XYPO)) {
                    asmCodeBuf.append("\tLD\tHL,0000H\n");
                }
                asmCodeBuf.append("\tLD\t(M_ERN),HL\n");
            }
            if (set.contains((Object)LibItem.M_ERT)) {
                asmCodeBuf.append_LD_HL_xx(EMPTY_STRING_LABEL);
                asmCodeBuf.append("\tLD\t(M_ERT),HL\n");
                set.add(LibItem.EMPTY_STRING);
            }
            if ((set2 = map.keySet()) != null && (n = set2.size()) > 0) {
                try {
                    VarDecl varDecl;
                    int n3;
                    Object[] objectArray = set2.toArray(new String[n]);
                    if (objectArray == null) break block35;
                    try {
                        Arrays.sort(objectArray);
                    }
                    catch (ClassCastException classCastException) {
                        // empty catch block
                    }
                    String string = null;
                    int n4 = 0;
                    for (n3 = 0; n3 < objectArray.length; ++n3) {
                        if (!((String)objectArray[n3]).endsWith("$") || (varDecl = map.get(objectArray[n3])) == null) continue;
                        n4 += varDecl.getSize() / 2;
                        if (string != null) continue;
                        string = varDecl.getLabel();
                    }
                    if (n4 > 0) {
                        if (n4 > 3) {
                            if (string != null) {
                                if (n4 > 256) {
                                    asmCodeBuf.append("\tLD\tBC,");
                                    asmCodeBuf.appendHex4(n4);
                                } else {
                                    asmCodeBuf.append("\tLD\tB,");
                                    asmCodeBuf.appendHex2(n4);
                                }
                                asmCodeBuf.append('\n');
                                asmCodeBuf.append_LD_HL_xx(EMPTY_STRING_LABEL);
                                asmCodeBuf.append("\tLD\tHL,");
                                asmCodeBuf.append(string);
                                asmCodeBuf.append("\nMINIST:\tLD\t(HL),E\n\tINC\tHL\n\tLD\t(HL),D\n\tINC\tHL\n");
                                if (n4 > 256) {
                                    asmCodeBuf.append("\tDEC\tBC\n\tLD\tA,B\n\tOR\tC\n\tJR\tNZ,MINIST\n");
                                } else {
                                    asmCodeBuf.append("\tDJNZ\tMINIST\n");
                                }
                                set.add(LibItem.EMPTY_STRING);
                            }
                        } else {
                            asmCodeBuf.append_LD_HL_xx(EMPTY_STRING_LABEL);
                            for (n3 = 0; n3 < objectArray.length; ++n3) {
                                if (!((String)objectArray[n3]).endsWith("$") || (varDecl = map.get(objectArray[n3])) == null) continue;
                                asmCodeBuf.append("\tLD\t(");
                                asmCodeBuf.append(varDecl.getLabel());
                                asmCodeBuf.append("),HL\n");
                            }
                            set.add(LibItem.EMPTY_STRING);
                        }
                    }
                }
                catch (ArrayStoreException arrayStoreException) {
                    // empty catch block
                }
            }
        }
        if (set.contains((Object)LibItem.HEAP)) {
            asmCodeBuf.append("\tLD\tDE,HEAPE-HEAPB-5\n\tLD\tHL,HEAPB\n\tXOR\tA\n\tLD\t(HL),A\n\tINC\tHL\n\tLD\t(HL),A\n\tINC\tHL\n\tLD\t(HL),E\n\tINC\tHL\n\tLD\t(HL),D\n\tINC\tHL\n\tLD\t(HL),A\n");
        }
        basicCompiler.getTarget().appendInitTo(asmCodeBuf);
    }

    public static void appendResetErrorUseBC(BasicCompiler basicCompiler) {
        if (basicCompiler.usesLibItem(LibItem.M_ERN)) {
            basicCompiler.getCodeBuf().append("\tLD\tBC,0000H\n\tLD\t(M_ERN),BC\n");
        }
        if (basicCompiler.usesLibItem(LibItem.M_ERT)) {
            AsmCodeBuf asmCodeBuf = basicCompiler.getCodeBuf();
            asmCodeBuf.append_LD_BC_xx(EMPTY_STRING_LABEL);
            asmCodeBuf.append("\tLD\t(M_ERT),BC\n");
            basicCompiler.getLibItems().add(LibItem.EMPTY_STRING);
        }
    }

    public static void appendResetErrorUseDE(BasicCompiler basicCompiler) {
        if (basicCompiler.usesLibItem(LibItem.M_ERN)) {
            basicCompiler.getCodeBuf().append("\tLD\tDE,0000H\n\tLD\t(M_ERN),DE\n");
        }
        if (basicCompiler.usesLibItem(LibItem.M_ERT)) {
            AsmCodeBuf asmCodeBuf = basicCompiler.getCodeBuf();
            asmCodeBuf.append_LD_DE_xx(EMPTY_STRING_LABEL);
            asmCodeBuf.append("\tLD\t(M_ERT),DE\n");
            basicCompiler.getLibItems().add(LibItem.EMPTY_STRING);
        }
    }

    public static void appendResetErrorUseHL(BasicCompiler basicCompiler) {
        if (basicCompiler.usesLibItem(LibItem.M_ERN)) {
            basicCompiler.getCodeBuf().append("\tLD\tHL,0000H\n\tLD\t(M_ERN),HL\n");
        }
        if (basicCompiler.usesLibItem(LibItem.M_ERT)) {
            AsmCodeBuf asmCodeBuf = basicCompiler.getCodeBuf();
            asmCodeBuf.append_LD_HL_xx(EMPTY_STRING_LABEL);
            asmCodeBuf.append("\tLD\t(M_ERT),HL\n");
            basicCompiler.getLibItems().add(LibItem.EMPTY_STRING);
        }
    }

    public static void appendSetError(BasicCompiler basicCompiler, int n, String string, String string2) {
        AsmCodeBuf asmCodeBuf = basicCompiler.getCodeBuf();
        if (basicCompiler.usesLibItem(LibItem.M_ERN)) {
            asmCodeBuf.append_LD_HL_nn(n);
            asmCodeBuf.append("\tLD\t(M_ERN),HL\n");
        }
        if (basicCompiler.usesLibItem(LibItem.M_ERT)) {
            asmCodeBuf.append_LD_HL_xx(basicCompiler.getStringLiteralLabel(basicCompiler.isLangCode("DE") ? string : string2));
            asmCodeBuf.append("\tLD\t(M_ERT),HL\n");
        }
    }

    public static void appendSetError(BasicCompiler basicCompiler) {
        BasicLibrary.appendSetError(basicCompiler, -1, "Fehler", "Error");
    }

    public static void appendSetErrorChannelAlreadyOpen(BasicCompiler basicCompiler) {
        BasicLibrary.appendSetError(basicCompiler, -12, "Kanal bereits geoeffnet", "Channel already open");
    }

    public static void appendSetErrorChannelClosed(BasicCompiler basicCompiler) {
        BasicLibrary.appendSetError(basicCompiler, -12, "Kanal geschlossen", "Channel closed");
    }

    public static void appendSetErrorDirFull(BasicCompiler basicCompiler) {
        BasicLibrary.appendSetError(basicCompiler, -31, "Directory voll", "Directory full");
    }

    public static void appendSetErrorDiskFull(BasicCompiler basicCompiler) {
        BasicLibrary.appendSetError(basicCompiler, -32, "Speichermedium voll", "Disk full");
    }

    public static void appendSetErrorDeviceLocked(BasicCompiler basicCompiler) {
        BasicLibrary.appendSetError(basicCompiler, -22, "Geraet bereits in Benutzung", "Device locked");
    }

    public static void appendSetErrorDeviceNotFound(BasicCompiler basicCompiler) {
        BasicLibrary.appendSetError(basicCompiler, -21, "Geraet nicht gefunden", "Device not found");
    }

    public static void appendSetErrorEOF(BasicCompiler basicCompiler) {
        BasicLibrary.appendSetError(basicCompiler, -29, "Dateiende erreicht", "End of file reached");
    }

    public static void appendSetErrorFileNotFound(BasicCompiler basicCompiler) {
        BasicLibrary.appendSetError(basicCompiler, -25, "Datei nicht gefunden", "File not found");
    }

    public static void appendSetErrorFileReadOnly(BasicCompiler basicCompiler) {
        BasicLibrary.appendSetError(basicCompiler, -30, "Datei schreibgeschuetzt", "File write protected");
    }

    public static void appendSetErrorHardware(BasicCompiler basicCompiler) {
        BasicLibrary.appendSetError(basicCompiler, -23, "Hardware-Fehler", "Hardware error");
    }

    public static void appendSetErrorIOError(BasicCompiler basicCompiler) {
        BasicLibrary.appendSetError(basicCompiler, -28, "Ein-/Ausgabefehler", "IO error");
    }

    public static void appendSetErrorInvalidChars(BasicCompiler basicCompiler) {
        BasicLibrary.appendSetError(basicCompiler, -2, "Ungueltige Zeichen", "Invalid characters");
    }

    public static void appendSetErrorInvalidFileName(BasicCompiler basicCompiler) {
        BasicLibrary.appendSetError(basicCompiler, -2, "Ungueltiger Dateiname", "Invalid filename");
    }

    public static void appendSetErrorIOMode(BasicCompiler basicCompiler) {
        BasicLibrary.appendSetError(basicCompiler, -27, "Ungueltige Betriebsart", "Invalid IO mode");
    }

    public static void appendSetErrorNoDisk(BasicCompiler basicCompiler) {
        BasicLibrary.appendSetError(basicCompiler, -24, "Kein Speichermedium vorhanden", "No disk");
    }

    public static void appendSetErrorMediaChanged(BasicCompiler basicCompiler) {
        BasicLibrary.appendSetError(basicCompiler, -33, "Medium gewechselt", "Media changed");
    }

    public static void appendSetErrorNumericOverflow(BasicCompiler basicCompiler) {
        BasicLibrary.appendSetError(basicCompiler, -3, "Numerischer Ueberlauf", "Numeric overflow");
    }

    public static enum LibItem {
        INIV,
        INSV,
        INRSV,
        INLNB,
        INLNR,
        INPWV,
        P_I,
        P_IF,
        PS_I,
        PS_IF,
        PS_S,
        PS_ST,
        PS_SP,
        PS_NL,
        CIRCLE,
        DATA,
        DREADI,
        DREADS,
        DRAW,
        DRAWR,
        DRAW_LINE,
        DRAWS,
        DRAWST,
        DRBOX,
        DRBOXF,
        H_BOX,
        DRAW_HLINE,
        DRLBL,
        DRLBLT,
        MOVER,
        LOCATE,
        ONGOAD,
        PAINT,
        PAINT_M_HPIX,
        PAINT_M_WPIX,
        PAUSE,
        PAUSE_N,
        PEN,
        PLOTR,
        PRINT_SPC,
        SCREEN,
        IO_PRINT_SPC,
        IOCLOSE,
        IOOPEN,
        IOEOF,
        IOINL,
        IOINX,
        IORDB,
        IO_SET_COUT,
        IO_CRT_HANDLER,
        IO_LPT_HANDLER,
        IO_SIMPLE_OUT_HANDLER,
        IO_FILE_HANDLER,
        IO_VDIP_HANDLER,
        IO_COUT,
        IO_M_COUT,
        IOCADR,
        IOCTB1,
        IOCTB2,
        CHECK_OPEN_NET_CHANNEL,
        VDIP_DATA_RDPTRS,
        VDIP_INIT,
        VDIP_M_IOADDR,
        F_INSTR,
        F_INSTRN,
        F_IS_TARGET,
        F_JOY,
        F_LEN,
        F_RND,
        F_SGN,
        F_SQR,
        F_VAL,
        F_VLB,
        F_VLH,
        F_VLI,
        S_BIN,
        S_CHR,
        S_HEX,
        S_HEXN,
        S_HXHL,
        S_HXA,
        S_INP,
        S_INCH,
        S_INKY,
        S_LEFT,
        S_LWR,
        S_LTRIM,
        S_MID,
        S_MIDN,
        S_MIRR,
        S_NETMASK,
        S_RIGHT,
        S_RTRIM,
        S_STC,
        S_STS,
        S_STR,
        S_TRIM,
        S_UPR,
        ARYADR,
        CKIDX,
        O_AND,
        O_NOT,
        O_OR,
        O_XOR,
        O_LT,
        O_LE,
        O_GT,
        O_GE,
        O_EQ,
        O_NE,
        O_ADD,
        O_SUB,
        O_MUL,
        O_MOD,
        O_DIV,
        O_INC,
        O_DEC,
        O_SHL,
        O_SHR,
        O_STEQ,
        O_STNE,
        O_STGE,
        O_STGT,
        O_STLE,
        O_STLT,
        ASSIGN_STR_TO_NEW_MEM_VS,
        ASSIGN_STR_TO_VS,
        ASSIGN_VS_TO_VS,
        MFIND,
        MALLOC,
        MMGC,
        MRGC,
        MFREE,
        CHECK_DE_WITHIN_HEAP,
        HEAP,
        ABS_NEG_HL,
        CPHLDE,
        CKSTK,
        JP_HL,
        SMACP,
        SVDUP,
        STCMP,
        STNCP,
        C_UPR,
        EMPTY_STRING,
        E_DATA,
        E_IDX,
        E_PARM,
        E_NOV,
        E_NXWF,
        E_REWG,
        E_USR,
        E_TYPE,
        E_EXIT,
        OUTSP,
        FONT_5X7,
        M_BALN,
        M_SRNM,
        M_ERN,
        M_ERT,
        M_FRET,
        M_INKB,
        M_HOST,
        M_PORT,
        M_STMP,
        M_XYPO,
        MTOP,
        XCKBRK,
        XINCH,
        XINKEY,
        XBREAK,
        XBORDER,
        XCLS,
        XCOLOR,
        XCURS,
        XHLINE,
        XINK,
        XPAPER,
        XOUTST,
        XOUTS,
        XOUTNL,
        XOUTCH,
        XLOCATE,
        XLPTCH,
        XPEN,
        XPAINT,
        XPOINT,
        XPSET,
        XPRES,
        XPTEST,
        XSCREEN,
        XJOY;

    }
}

