/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.programming;

import java.io.File;
import java.util.Properties;
import jkcemu.programming.assembler.Z80Assembler;
import jkcemu.programming.basic.BasicOptions;

public class PrgOptions {
    public static final String OPTION_PREFIX = "jkcemu.programming.";
    private static final String OPTION_ASM_ALLOW_UNDOC_INSTRUCTIONS = "jkcemu.programming.asm.allow_undocumented_instructions";
    private static final String OPTION_ASM_LABELS_CASE_SENSITIVE = "jkcemu.programming.asm.labels.case_sensitive";
    private static final String OPTION_ASM_LABELS_PRINT = "jkcemu.programming.asm.labels.print";
    private static final String OPTION_ASM_SYNTAX = "jkcemu.programming.asm.syntax";
    private static final String OPTION_CODE_FILENAME = "jkcemu.programming.code.file.name";
    private static final String OPTION_CODE_TO_EMULATOR = "jkcemu.programming.code.to_emulator";
    private static final String OPTION_CODE_TO_FILE = "jkcemu.programming.code.to_file";
    private static final String OPTION_CODE_TO_SECOND_SYSTEM = "jkcemu.programming.code.to_second_system";
    private static final String OPTION_FORMAT_SOURCE = "jkcemu.programming.format.source";
    private static final String OPTION_LABELS_TO_DEBUGGER = "jkcemu.programming.labels_to_debugger";
    private static final String OPTION_LABELS_TO_REASSEMBLER = "jkcemu.programming.labels_to_reassembler";
    private static final String OPTION_SUPPRESS_LABEL_RECREATE_IN_DEBUGGER = "jkcemu.programming.suppress_label_recreate_in_debugger";
    private static final String OPTION_WARN_NON_ASCII_CHARS = "jkcemu.programming.warn_non_ascii_chars";
    private static final String VALUE_ASM_SYNTAX_ALL = "all";
    private static final String VALUE_ASM_SYNTAX_ROBOTRON = "robotron";
    private static final String VALUE_ASM_SYNTAX_ZILOG = "zilog";
    private Z80Assembler.Syntax asmSyntax = Z80Assembler.Syntax.ALL;
    private boolean allowUndocInst = false;
    private boolean labelsCaseSensitive = false;
    private boolean printLabels = false;
    private boolean codeToEmu = false;
    private boolean codeToSecondSys = false;
    private boolean codeToFile = false;
    private File codeFile = null;
    private boolean forceRun = false;
    private boolean labelsToDebugger = false;
    private boolean suppressLabelRecreateInDebugger = false;
    private boolean labelsToReass = false;
    private boolean formatSource = false;
    private boolean warnNonAsciiChars = true;

    public boolean getAllowUndocInst() {
        return this.allowUndocInst;
    }

    public Z80Assembler.Syntax getAsmSyntax() {
        return this.asmSyntax;
    }

    public File getCodeFile() {
        return this.codeFile;
    }

    public boolean getCodeToEmu() {
        return this.codeToEmu;
    }

    public boolean getCodeToFile() {
        return this.codeToFile;
    }

    public boolean getCodeToSecondSystem() {
        return this.codeToSecondSys;
    }

    public boolean getCreateCode() {
        return this.codeToEmu || this.codeToFile || this.forceRun;
    }

    public boolean getForceRun() {
        return this.forceRun;
    }

    public boolean getFormatSource() {
        return this.formatSource;
    }

    public boolean getLabelsCaseSensitive() {
        return this.labelsCaseSensitive;
    }

    public boolean getLabelsToDebugger() {
        return this.labelsToDebugger;
    }

    public boolean getLabelsToReassembler() {
        return this.labelsToReass;
    }

    public boolean getPrintLabels() {
        return this.printLabels;
    }

    public static PrgOptions getPrgOptions(Properties properties) {
        PrgOptions prgOptions = BasicOptions.getBasicOptions(properties);
        if (properties != null) {
            String string = properties.getProperty(OPTION_ASM_SYNTAX);
            Boolean bl = PrgOptions.getBoolean(properties, OPTION_ASM_ALLOW_UNDOC_INSTRUCTIONS);
            Boolean bl2 = PrgOptions.getBoolean(properties, OPTION_ASM_LABELS_CASE_SENSITIVE);
            Boolean bl3 = PrgOptions.getBoolean(properties, OPTION_ASM_LABELS_PRINT);
            Boolean bl4 = PrgOptions.getBoolean(properties, OPTION_CODE_TO_EMULATOR);
            Boolean bl5 = PrgOptions.getBoolean(properties, OPTION_CODE_TO_SECOND_SYSTEM);
            Boolean bl6 = PrgOptions.getBoolean(properties, OPTION_CODE_TO_FILE);
            String string2 = properties.getProperty(OPTION_CODE_FILENAME);
            Boolean bl7 = PrgOptions.getBoolean(properties, OPTION_SUPPRESS_LABEL_RECREATE_IN_DEBUGGER);
            Boolean bl8 = PrgOptions.getBoolean(properties, OPTION_LABELS_TO_DEBUGGER);
            Boolean bl9 = PrgOptions.getBoolean(properties, OPTION_LABELS_TO_REASSEMBLER);
            Boolean bl10 = PrgOptions.getBoolean(properties, OPTION_FORMAT_SOURCE);
            Boolean bl11 = PrgOptions.getBoolean(properties, OPTION_WARN_NON_ASCII_CHARS);
            if (string != null || bl != null || bl2 != null || bl3 != null || bl4 != null || bl5 != null || bl6 != null || string2 != null || bl8 != null || bl7 != null || bl9 != null || bl10 != null || bl11 != null) {
                if (prgOptions == null) {
                    prgOptions = new PrgOptions();
                }
                if (string != null) {
                    prgOptions.asmSyntax = string.equals(VALUE_ASM_SYNTAX_ZILOG) ? Z80Assembler.Syntax.ZILOG_ONLY : (string.equals(VALUE_ASM_SYNTAX_ROBOTRON) ? Z80Assembler.Syntax.ROBOTRON_ONLY : Z80Assembler.Syntax.ALL);
                    if (bl != null) {
                        prgOptions.allowUndocInst = bl;
                    }
                    if (bl2 != null) {
                        prgOptions.labelsCaseSensitive = bl2;
                    }
                    if (bl3 != null) {
                        prgOptions.printLabels = bl3;
                    }
                    if (bl4 != null) {
                        prgOptions.codeToEmu = bl4;
                    }
                    if (bl5 != null) {
                        prgOptions.codeToSecondSys = bl5;
                    }
                    if (bl6 != null) {
                        prgOptions.codeToFile = bl6;
                    }
                    File file = null;
                    if (string2 != null && !string2.isEmpty()) {
                        file = new File(string2);
                    }
                    prgOptions.codeFile = file;
                    if (bl8 != null) {
                        prgOptions.labelsToDebugger = bl8;
                    }
                    if (bl7 != null) {
                        prgOptions.suppressLabelRecreateInDebugger = bl7;
                    }
                    if (bl9 != null) {
                        prgOptions.labelsToReass = bl9;
                    }
                    if (bl10 != null) {
                        prgOptions.formatSource = bl10;
                    }
                    if (bl11 != null) {
                        prgOptions.warnNonAsciiChars = bl11;
                    }
                }
            }
        }
        return prgOptions;
    }

    public boolean getSuppressLabelRecreateInDebugger() {
        return this.suppressLabelRecreateInDebugger;
    }

    public boolean getWarnNonAsciiChars() {
        return this.warnNonAsciiChars;
    }

    public void putOptionsTo(Properties properties) {
        if (properties != null) {
            if (this.asmSyntax != null) {
                switch (this.asmSyntax) {
                    case ZILOG_ONLY: {
                        properties.setProperty(OPTION_ASM_SYNTAX, VALUE_ASM_SYNTAX_ZILOG);
                        break;
                    }
                    case ROBOTRON_ONLY: {
                        properties.setProperty(OPTION_ASM_SYNTAX, VALUE_ASM_SYNTAX_ROBOTRON);
                        break;
                    }
                    default: {
                        properties.setProperty(OPTION_ASM_SYNTAX, VALUE_ASM_SYNTAX_ALL);
                    }
                }
            }
            properties.setProperty(OPTION_ASM_ALLOW_UNDOC_INSTRUCTIONS, Boolean.toString(this.allowUndocInst));
            properties.setProperty(OPTION_ASM_LABELS_CASE_SENSITIVE, Boolean.toString(this.labelsCaseSensitive));
            properties.setProperty(OPTION_ASM_LABELS_PRINT, Boolean.toString(this.printLabels));
            properties.setProperty(OPTION_CODE_TO_EMULATOR, Boolean.toString(this.codeToEmu));
            properties.setProperty(OPTION_CODE_TO_SECOND_SYSTEM, Boolean.toString(this.codeToSecondSys));
            properties.setProperty(OPTION_CODE_TO_FILE, Boolean.toString(this.codeToFile));
            String string = null;
            if (this.codeFile != null) {
                string = this.codeFile.getPath();
            }
            properties.setProperty(OPTION_CODE_FILENAME, string != null ? string : "");
            properties.setProperty(OPTION_LABELS_TO_DEBUGGER, Boolean.toString(this.labelsToDebugger));
            properties.setProperty(OPTION_SUPPRESS_LABEL_RECREATE_IN_DEBUGGER, Boolean.toString(this.suppressLabelRecreateInDebugger));
            properties.setProperty(OPTION_LABELS_TO_REASSEMBLER, Boolean.toString(this.labelsToReass));
            properties.setProperty(OPTION_FORMAT_SOURCE, Boolean.toString(this.formatSource));
            properties.setProperty(OPTION_WARN_NON_ASCII_CHARS, Boolean.toString(this.warnNonAsciiChars));
        }
    }

    public void setAllowUndocInst(boolean bl) {
        this.allowUndocInst = bl;
    }

    public void setAsmSyntax(Z80Assembler.Syntax syntax) {
        this.asmSyntax = syntax;
    }

    public void setCodeToEmu(boolean bl) {
        this.codeToEmu = bl;
    }

    public void setCodeToFile(boolean bl, File file) {
        this.codeToFile = bl;
        this.codeFile = file;
    }

    public void setCodeToSecondSystem(boolean bl) {
        this.codeToSecondSys = bl;
    }

    public void setFormatSource(boolean bl) {
        this.formatSource = bl;
    }

    public void setForceRun(boolean bl) {
        this.forceRun = bl;
    }

    public void setLabelsToDebugger(boolean bl) {
        this.labelsToDebugger = bl;
    }

    public void setLabelsToReassembler(boolean bl) {
        this.labelsToReass = bl;
    }

    public void setLabelsCaseSensitive(boolean bl) {
        this.labelsCaseSensitive = bl;
    }

    public void setPrintLabels(boolean bl) {
        this.printLabels = bl;
    }

    public void setSuppressLabelRecreateInDebugger(boolean bl) {
        this.suppressLabelRecreateInDebugger = bl;
    }

    public void setWarnNonAsciiChars(boolean bl) {
        this.warnNonAsciiChars = bl;
    }

    protected static Boolean getBoolean(Properties properties, String string) {
        String string2;
        Boolean bl = null;
        if (properties != null && (string2 = properties.getProperty(string)) != null && !string2.isEmpty()) {
            bl = Boolean.valueOf(string2);
        }
        return bl;
    }

    protected static Integer getInteger(Properties properties, String string) {
        String string2;
        Integer n = null;
        if (properties != null && (string2 = properties.getProperty(string)) != null && !string2.isEmpty()) {
            try {
                n = Integer.valueOf(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object != null && !(bl = super.equals(object)) && object instanceof PrgOptions) {
            PrgOptions prgOptions = (PrgOptions)object;
            if (prgOptions.asmSyntax.equals((Object)this.asmSyntax) && prgOptions.allowUndocInst == this.allowUndocInst && prgOptions.labelsCaseSensitive == this.labelsCaseSensitive && prgOptions.printLabels == this.printLabels && prgOptions.codeToEmu == this.codeToEmu && prgOptions.codeToSecondSys == this.codeToSecondSys && prgOptions.codeToFile == this.codeToFile && prgOptions.forceRun == this.forceRun && prgOptions.labelsToDebugger == this.labelsToDebugger && prgOptions.suppressLabelRecreateInDebugger == this.suppressLabelRecreateInDebugger && prgOptions.labelsToReass == this.labelsToReass && prgOptions.formatSource == this.formatSource && prgOptions.warnNonAsciiChars == this.warnNonAsciiChars) {
                if (prgOptions.codeFile != null && this.codeFile != null) {
                    bl = prgOptions.codeFile.equals(this.codeFile);
                } else if (prgOptions.codeFile == null && this.codeFile == null) {
                    bl = true;
                }
            }
        }
        return bl;
    }
}

