/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.print;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.Locale;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.OrientationRequested;
import jkcemu.Main;
import jkcemu.base.BaseDlg;

public class PrintUtil {
    public static boolean doPrint(Frame frame, Printable printable, String string) {
        boolean bl = false;
        try {
            PrintRequestAttributeSet printRequestAttributeSet = Main.getPrintRequestAttributeSet();
            if (printRequestAttributeSet == null) {
                printRequestAttributeSet = new HashPrintRequestAttributeSet();
                printRequestAttributeSet.add(MediaSizeName.ISO_A4);
                printRequestAttributeSet.add(OrientationRequested.PORTRAIT);
            }
            if (string == null) {
                string = "JKCEMU";
            }
            printRequestAttributeSet.add(new Copies(1));
            printRequestAttributeSet.add(new JobName(string, Locale.getDefault()));
            PrinterJob printerJob = PrinterJob.getPrinterJob();
            printerJob.setCopies(1);
            printerJob.setJobName(string);
            if (printerJob.printDialog(printRequestAttributeSet)) {
                printerJob.setPrintable(printable);
                printerJob.print(printRequestAttributeSet);
                Main.setPrintRequestAttributeSet(printRequestAttributeSet);
                bl = true;
            }
        }
        catch (PrinterException printerException) {
            BaseDlg.showErrorDlg((Component)frame, printerException.getMessage());
        }
        return bl;
    }

    public static String expandTabs(String string, int n) {
        String string2 = "";
        if (string != null) {
            if (string.indexOf(9) >= 0) {
                StringBuilder stringBuilder = new StringBuilder();
                int n2 = string.length();
                for (int i = 0; i < n2; ++i) {
                    char c = string.charAt(i);
                    if (c == '\t') {
                        int n3 = n - stringBuilder.length() % n;
                        for (int j = 0; j < n3; ++j) {
                            stringBuilder.append(' ');
                        }
                        continue;
                    }
                    stringBuilder.append(c);
                }
                string2 = stringBuilder.toString();
            } else {
                string2 = string;
            }
        }
        return string2;
    }

    public static void printCenteredPageNum(Graphics graphics, PageFormat pageFormat, int n, int n2) {
        String string = "- " + String.valueOf(n2) + " -";
        int n3 = graphics.getFontMetrics().stringWidth(string);
        graphics.setColor(Color.black);
        graphics.setFont(new Font("Monospaced", 0, n));
        graphics.drawString(string, (int)(pageFormat.getImageableX() + pageFormat.getImageableWidth() / 2.0) - graphics.getFontMetrics().stringWidth(string) / 2, (int)(pageFormat.getImageableY() + pageFormat.getImageableHeight()));
    }
}

